/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.MappingChange;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.Logging;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import com.sun.javafx.scene.control.SelectedCellsMap;
import com.sun.javafx.scene.control.TableColumnComparatorBase;
import com.sun.javafx.scene.control.behavior.TableCellBehavior;
import com.sun.javafx.scene.control.behavior.TableCellBehaviorBase;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.WeakHashMap;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.collections.transformation.SortedList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.SortEvent;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableUtil;
import javafx.scene.control.TableView$$Lambda$1;
import javafx.scene.control.TableView$$Lambda$2;
import javafx.scene.control.TableView$$Lambda$3;
import javafx.scene.control.TableView$$Lambda$4;
import javafx.scene.control.TableView$$Lambda$5;
import javafx.scene.control.TableView$$Lambda$6;
import javafx.scene.control.TableView$TableViewArrayListSelectionModel$$Lambda$1;
import javafx.scene.control.TableView$TableViewArrayListSelectionModel$$Lambda$2;
import javafx.scene.control.TableView$TableViewArrayListSelectionModel$$Lambda$3;
import javafx.scene.control.TableView$TableViewArrayListSelectionModel$$Lambda$4;
import javafx.scene.control.TableView$TableViewArrayListSelectionModel$$Lambda$5;
import javafx.scene.control.TableView$TableViewFocusModel$$Lambda$1;
import javafx.util.Callback;

@DefaultProperty(value="items")
public class TableView<S>
extends Control {
    static final String SET_CONTENT_WIDTH = "TableView.contentWidth";
    public static final Callback<ResizeFeatures, Boolean> UNCONSTRAINED_RESIZE_POLICY = new Callback<ResizeFeatures, Boolean>(){

        public String toString() {
            return "unconstrained-resize";
        }

        @Override
        public Boolean call(ResizeFeatures prop) {
            double result = TableUtil.resize(prop.getColumn(), prop.getDelta());
            return Double.compare(result, 0.0) == 0;
        }
    };
    public static final Callback<ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY = new Callback<ResizeFeatures, Boolean>(){
        private boolean isFirstRun = true;

        public String toString() {
            return "constrained-resize";
        }

        @Override
        public Boolean call(ResizeFeatures prop) {
            TableView table = prop.getTable();
            ObservableList visibleLeafColumns = table.getVisibleLeafColumns();
            Boolean result = TableUtil.constrainedResize(prop, this.isFirstRun, table.contentWidth, visibleLeafColumns);
            this.isFirstRun = !this.isFirstRun ? false : result == false;
            return result;
        }
    };
    public static final Callback<TableView, Boolean> DEFAULT_SORT_POLICY = new Callback<TableView, Boolean>(){

        @Override
        public Boolean call(TableView table) {
            try {
                ObservableList itemsList = table.getItems();
                if (itemsList instanceof SortedList) {
                    SortedList sortedList = (SortedList)itemsList;
                    boolean comparatorsBound = sortedList.comparatorProperty().isEqualTo(table.comparatorProperty()).get();
                    if (!comparatorsBound && Logging.getControlsLogger().isEnabled()) {
                        String s = "TableView items list is a SortedList, but the SortedList comparator should be bound to the TableView comparator for sorting to be enabled (e.g. sortedList.comparatorProperty().bind(tableView.comparatorProperty());).";
                        Logging.getControlsLogger().info(s);
                    }
                    return comparatorsBound;
                }
                Comparator comparator = table.getComparator();
                if (comparator == null) {
                    return true;
                }
                FXCollections.sort(itemsList, comparator);
                return true;
            }
            catch (UnsupportedOperationException e) {
                return false;
            }
        }
    };
    private final ObservableList<TableColumn<S, ?>> columns = FXCollections.observableArrayList();
    private final ObservableList<TableColumn<S, ?>> visibleLeafColumns = FXCollections.observableArrayList();
    private final ObservableList<TableColumn<S, ?>> unmodifiableVisibleLeafColumns = FXCollections.unmodifiableObservableList(this.visibleLeafColumns);
    private ObservableList<TableColumn<S, ?>> sortOrder = FXCollections.observableArrayList();
    private double contentWidth;
    private boolean isInited = false;
    private final ListChangeListener<TableColumn<S, ?>> columnsObserver = new ListChangeListener<TableColumn<S, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumn<S, ?>> c) {
            TableView.this.updateVisibleLeafColumns();
            ArrayList toRemove = new ArrayList();
            while (c.next()) {
                List removed = c.getRemoved();
                List added = c.getAddedSubList();
                if (c.wasRemoved()) {
                    toRemove.addAll(removed);
                    for (TableColumn tc : removed) {
                        tc.setTableView(null);
                    }
                }
                if (c.wasAdded()) {
                    toRemove.removeAll(added);
                    for (TableColumn tc : added) {
                        tc.setTableView(TableView.this);
                    }
                }
                TableUtil.removeColumnsListener(removed, TableView.this.weakColumnsObserver);
                TableUtil.addColumnsListener(added, TableView.this.weakColumnsObserver);
                TableUtil.removeTableColumnListener(c.getRemoved(), TableView.this.weakColumnVisibleObserver, TableView.this.weakColumnSortableObserver, TableView.this.weakColumnSortTypeObserver, TableView.this.weakColumnComparatorObserver);
                TableUtil.addTableColumnListener(c.getAddedSubList(), TableView.this.weakColumnVisibleObserver, TableView.this.weakColumnSortableObserver, TableView.this.weakColumnSortTypeObserver, TableView.this.weakColumnComparatorObserver);
            }
            TableView.this.sortOrder.removeAll(toRemove);
            TableViewFocusModel fm = TableView.this.getFocusModel();
            TableViewSelectionModel sm = TableView.this.getSelectionModel();
            c.reset();
            while (c.next()) {
                if (!c.wasRemoved()) continue;
                List removed = c.getRemoved();
                if (fm != null) {
                    TablePosition focusedCell = fm.getFocusedCell();
                    boolean match = false;
                    for (TableColumn tc : removed) {
                        match = focusedCell != null && focusedCell.getTableColumn() == tc;
                        if (!match) continue;
                        break;
                    }
                    if (match) {
                        Integer matchingColumnIndex = (Integer)TableView.this.lastKnownColumnIndex.get(focusedCell.getTableColumn());
                        if (matchingColumnIndex == null) {
                            matchingColumnIndex = 0;
                        }
                        int newFocusColumnIndex = matchingColumnIndex == 0 ? 0 : Math.min(TableView.this.getVisibleLeafColumns().size() - 1, matchingColumnIndex - 1);
                        fm.focus(focusedCell.getRow(), TableView.this.getVisibleLeafColumn(newFocusColumnIndex));
                    }
                }
                if (sm == null) continue;
                ArrayList<TablePosition> selectedCells = new ArrayList<TablePosition>(sm.getSelectedCells());
                for (TablePosition selectedCell : selectedCells) {
                    Integer matchingColumnIndex;
                    boolean match = false;
                    for (TableColumn tc : removed) {
                        match = selectedCell != null && selectedCell.getTableColumn() == tc;
                        if (!match) continue;
                        break;
                    }
                    if (!match || (matchingColumnIndex = (Integer)TableView.this.lastKnownColumnIndex.get(selectedCell.getTableColumn())) == null || matchingColumnIndex == -1) continue;
                    if (sm instanceof TableViewArrayListSelectionModel) {
                        TablePosition fixedTablePosition = new TablePosition(TableView.this, selectedCell.getRow(), selectedCell.getTableColumn());
                        fixedTablePosition.fixedColumnIndex = matchingColumnIndex;
                        ((TableViewArrayListSelectionModel)sm).clearSelection(fixedTablePosition);
                        continue;
                    }
                    sm.clearSelection(selectedCell.getRow(), selectedCell.getTableColumn());
                }
            }
            TableView.this.lastKnownColumnIndex.clear();
            for (TableColumn tc : TableView.this.getColumns()) {
                int index = TableView.this.getVisibleLeafIndex(tc);
                if (index <= -1) continue;
                TableView.this.lastKnownColumnIndex.put(tc, index);
            }
        }
    };
    private final WeakHashMap<TableColumn<S, ?>, Integer> lastKnownColumnIndex = new WeakHashMap();
    private final InvalidationListener columnVisibleObserver = TableView$$Lambda$1.lambdaFactory$(this);
    private final InvalidationListener columnSortableObserver = TableView$$Lambda$2.lambdaFactory$(this);
    private final InvalidationListener columnSortTypeObserver = TableView$$Lambda$3.lambdaFactory$(this);
    private final InvalidationListener columnComparatorObserver = TableView$$Lambda$4.lambdaFactory$(this);
    private final InvalidationListener cellSelectionModelInvalidationListener = TableView$$Lambda$5.lambdaFactory$(this);
    private final WeakInvalidationListener weakColumnVisibleObserver = new WeakInvalidationListener(this.columnVisibleObserver);
    private final WeakInvalidationListener weakColumnSortableObserver = new WeakInvalidationListener(this.columnSortableObserver);
    private final WeakInvalidationListener weakColumnSortTypeObserver = new WeakInvalidationListener(this.columnSortTypeObserver);
    private final WeakInvalidationListener weakColumnComparatorObserver = new WeakInvalidationListener(this.columnComparatorObserver);
    private final WeakListChangeListener<TableColumn<S, ?>> weakColumnsObserver = new WeakListChangeListener(this.columnsObserver);
    private final WeakInvalidationListener weakCellSelectionModelInvalidationListener = new WeakInvalidationListener(this.cellSelectionModelInvalidationListener);
    private ObjectProperty<ObservableList<S>> items = new SimpleObjectProperty<ObservableList<S>>(this, "items"){
        WeakReference<ObservableList<S>> oldItemsRef;

        @Override
        protected void invalidated() {
            ObservableList oldItems = this.oldItemsRef == null ? null : (ObservableList)this.oldItemsRef.get();
            ObservableList newItems = TableView.this.getItems();
            if (newItems != null && newItems == oldItems) {
                return;
            }
            if (!(newItems instanceof SortedList)) {
                TableView.this.getSortOrder().clear();
            }
            if (TableView.this.getSelectionModel() instanceof TableViewArrayListSelectionModel) {
                ((TableViewArrayListSelectionModel)TableView.this.getSelectionModel()).updateItemsObserver(oldItems, newItems);
            }
            if (TableView.this.getFocusModel() != null) {
                TableView.this.getFocusModel().updateItemsObserver(oldItems, newItems);
            }
            if (TableView.this.getSkin() instanceof TableViewSkin) {
                TableViewSkin skin = (TableViewSkin)TableView.this.getSkin();
                skin.updateTableItems(oldItems, newItems);
            }
            this.oldItemsRef = new WeakReference(newItems);
        }
    };
    private BooleanProperty tableMenuButtonVisible;
    private ObjectProperty<Callback<ResizeFeatures, Boolean>> columnResizePolicy;
    private ObjectProperty<Callback<TableView<S>, TableRow<S>>> rowFactory;
    private ObjectProperty<Node> placeholder;
    private ObjectProperty<TableViewSelectionModel<S>> selectionModel = new SimpleObjectProperty<TableViewSelectionModel<S>>(this, "selectionModel"){
        TableViewSelectionModel<S> oldValue;
        {
            this.oldValue = null;
        }

        @Override
        protected void invalidated() {
            if (this.oldValue != null) {
                this.oldValue.cellSelectionEnabledProperty().removeListener(TableView.this.weakCellSelectionModelInvalidationListener);
            }
            this.oldValue = (TableViewSelectionModel)this.get();
            if (this.oldValue != null) {
                this.oldValue.cellSelectionEnabledProperty().addListener(TableView.this.weakCellSelectionModelInvalidationListener);
                TableView.this.weakCellSelectionModelInvalidationListener.invalidated(this.oldValue.cellSelectionEnabledProperty());
            }
        }
    };
    private ObjectProperty<TableViewFocusModel<S>> focusModel;
    private BooleanProperty editable;
    private DoubleProperty fixedCellSize;
    private ReadOnlyObjectWrapper<TablePosition<S, ?>> editingCell;
    private ReadOnlyObjectWrapper<Comparator<S>> comparator;
    private ObjectProperty<Callback<TableView<S>, Boolean>> sortPolicy;
    private ObjectProperty<EventHandler<SortEvent<TableView<S>>>> onSort;
    private ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollTo;
    private ObjectProperty<EventHandler<ScrollToEvent<TableColumn<S, ?>>>> onScrollToColumn;
    private boolean sortLock = false;
    private TableUtil.SortEventType lastSortEventType = null;
    private Object[] lastSortEventSupportInfo = null;
    private static final String DEFAULT_STYLE_CLASS = "table-view";
    private static final PseudoClass PSEUDO_CLASS_CELL_SELECTION = PseudoClass.getPseudoClass("cell-selection");
    private static final PseudoClass PSEUDO_CLASS_ROW_SELECTION = PseudoClass.getPseudoClass("row-selection");

    public TableView() {
        this(FXCollections.observableArrayList());
    }

    public TableView(ObservableList<S> items) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TABLE_VIEW);
        this.setItems(items);
        this.setSelectionModel(new TableViewArrayListSelectionModel(this));
        this.setFocusModel(new TableViewFocusModel(this));
        this.getColumns().addListener(this.weakColumnsObserver);
        this.getSortOrder().addListener(TableView$$Lambda$6.lambdaFactory$(this));
        this.getProperties().addListener(new MapChangeListener<Object, Object>(){

            @Override
            public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> c) {
                if (c.wasAdded() && TableView.SET_CONTENT_WIDTH.equals(c.getKey())) {
                    if (c.getValueAdded() instanceof Number) {
                        TableView.this.setContentWidth((Double)c.getValueAdded());
                    }
                    TableView.this.getProperties().remove(TableView.SET_CONTENT_WIDTH);
                }
            }
        });
        this.isInited = true;
    }

    public final ObjectProperty<ObservableList<S>> itemsProperty() {
        return this.items;
    }

    public final void setItems(ObservableList<S> value) {
        this.itemsProperty().set(value);
    }

    public final ObservableList<S> getItems() {
        return (ObservableList)this.items.get();
    }

    public final BooleanProperty tableMenuButtonVisibleProperty() {
        if (this.tableMenuButtonVisible == null) {
            this.tableMenuButtonVisible = new SimpleBooleanProperty(this, "tableMenuButtonVisible");
        }
        return this.tableMenuButtonVisible;
    }

    public final void setTableMenuButtonVisible(boolean value) {
        this.tableMenuButtonVisibleProperty().set(value);
    }

    public final boolean isTableMenuButtonVisible() {
        return this.tableMenuButtonVisible == null ? false : this.tableMenuButtonVisible.get();
    }

    public final void setColumnResizePolicy(Callback<ResizeFeatures, Boolean> callback) {
        this.columnResizePolicyProperty().set(callback);
    }

    public final Callback<ResizeFeatures, Boolean> getColumnResizePolicy() {
        return this.columnResizePolicy == null ? UNCONSTRAINED_RESIZE_POLICY : (Callback)this.columnResizePolicy.get();
    }

    public final ObjectProperty<Callback<ResizeFeatures, Boolean>> columnResizePolicyProperty() {
        if (this.columnResizePolicy == null) {
            this.columnResizePolicy = new SimpleObjectProperty<Callback<ResizeFeatures, Boolean>>((Object)this, "columnResizePolicy", UNCONSTRAINED_RESIZE_POLICY){
                private Callback<ResizeFeatures, Boolean> oldPolicy;

                @Override
                protected void invalidated() {
                    if (TableView.this.isInited) {
                        PseudoClass state;
                        ((Callback)this.get()).call(new ResizeFeatures(TableView.this, null, 0.0));
                        TableView.this.refresh();
                        if (this.oldPolicy != null) {
                            state = PseudoClass.getPseudoClass(this.oldPolicy.toString());
                            TableView.this.pseudoClassStateChanged(state, false);
                        }
                        if (this.get() != null) {
                            state = PseudoClass.getPseudoClass(((Callback)this.get()).toString());
                            TableView.this.pseudoClassStateChanged(state, true);
                        }
                        this.oldPolicy = (Callback)this.get();
                    }
                }
            };
        }
        return this.columnResizePolicy;
    }

    public final ObjectProperty<Callback<TableView<S>, TableRow<S>>> rowFactoryProperty() {
        if (this.rowFactory == null) {
            this.rowFactory = new SimpleObjectProperty<Callback<TableView<S>, TableRow<S>>>(this, "rowFactory");
        }
        return this.rowFactory;
    }

    public final void setRowFactory(Callback<TableView<S>, TableRow<S>> value) {
        this.rowFactoryProperty().set(value);
    }

    public final Callback<TableView<S>, TableRow<S>> getRowFactory() {
        return this.rowFactory == null ? null : (Callback)this.rowFactory.get();
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty<Node>(this, "placeholder");
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node value) {
        this.placeholderProperty().set(value);
    }

    public final Node getPlaceholder() {
        return this.placeholder == null ? null : (Node)this.placeholder.get();
    }

    public final ObjectProperty<TableViewSelectionModel<S>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final void setSelectionModel(TableViewSelectionModel<S> value) {
        this.selectionModelProperty().set(value);
    }

    public final TableViewSelectionModel<S> getSelectionModel() {
        return (TableViewSelectionModel)this.selectionModel.get();
    }

    public final void setFocusModel(TableViewFocusModel<S> value) {
        this.focusModelProperty().set(value);
    }

    public final TableViewFocusModel<S> getFocusModel() {
        return this.focusModel == null ? null : (TableViewFocusModel)this.focusModel.get();
    }

    public final ObjectProperty<TableViewFocusModel<S>> focusModelProperty() {
        if (this.focusModel == null) {
            this.focusModel = new SimpleObjectProperty<TableViewFocusModel<S>>(this, "focusModel");
        }
        return this.focusModel;
    }

    public final void setEditable(boolean value) {
        this.editableProperty().set(value);
    }

    public final boolean isEditable() {
        return this.editable == null ? false : this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", false);
        }
        return this.editable;
    }

    public final void setFixedCellSize(double value) {
        this.fixedCellSizeProperty().set(value);
    }

    public final double getFixedCellSize() {
        return this.fixedCellSize == null ? -1.0 : this.fixedCellSize.get();
    }

    public final DoubleProperty fixedCellSizeProperty() {
        if (this.fixedCellSize == null) {
            this.fixedCellSize = new StyleableDoubleProperty(-1.0){

                @Override
                public CssMetaData<TableView<?>, Number> getCssMetaData() {
                    return StyleableProperties.FIXED_CELL_SIZE;
                }

                @Override
                public Object getBean() {
                    return TableView.this;
                }

                @Override
                public String getName() {
                    return "fixedCellSize";
                }
            };
        }
        return this.fixedCellSize;
    }

    private void setEditingCell(TablePosition<S, ?> value) {
        this.editingCellPropertyImpl().set(value);
    }

    public final TablePosition<S, ?> getEditingCell() {
        return this.editingCell == null ? null : (TablePosition)this.editingCell.get();
    }

    public final ReadOnlyObjectProperty<TablePosition<S, ?>> editingCellProperty() {
        return this.editingCellPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TablePosition<S, ?>> editingCellPropertyImpl() {
        if (this.editingCell == null) {
            this.editingCell = new ReadOnlyObjectWrapper(this, "editingCell");
        }
        return this.editingCell;
    }

    private void setComparator(Comparator<S> value) {
        this.comparatorPropertyImpl().set(value);
    }

    public final Comparator<S> getComparator() {
        return this.comparator == null ? null : (Comparator)this.comparator.get();
    }

    public final ReadOnlyObjectProperty<Comparator<S>> comparatorProperty() {
        return this.comparatorPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Comparator<S>> comparatorPropertyImpl() {
        if (this.comparator == null) {
            this.comparator = new ReadOnlyObjectWrapper(this, "comparator");
        }
        return this.comparator;
    }

    public final void setSortPolicy(Callback<TableView<S>, Boolean> callback) {
        this.sortPolicyProperty().set(callback);
    }

    public final Callback<TableView<S>, Boolean> getSortPolicy() {
        return this.sortPolicy == null ? DEFAULT_SORT_POLICY : (Callback)this.sortPolicy.get();
    }

    public final ObjectProperty<Callback<TableView<S>, Boolean>> sortPolicyProperty() {
        if (this.sortPolicy == null) {
            this.sortPolicy = new SimpleObjectProperty<Callback<TableView<S>, Boolean>>(this, "sortPolicy", DEFAULT_SORT_POLICY){

                @Override
                protected void invalidated() {
                    TableView.this.sort();
                }
            };
        }
        return this.sortPolicy;
    }

    public void setOnSort(EventHandler<SortEvent<TableView<S>>> value) {
        this.onSortProperty().set(value);
    }

    public EventHandler<SortEvent<TableView<S>>> getOnSort() {
        if (this.onSort != null) {
            return (EventHandler)this.onSort.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<SortEvent<TableView<S>>>> onSortProperty() {
        if (this.onSort == null) {
            this.onSort = new ObjectPropertyBase<EventHandler<SortEvent<TableView<S>>>>(){

                @Override
                protected void invalidated() {
                    EventType eventType = SortEvent.sortEvent();
                    EventHandler eventHandler = (EventHandler)this.get();
                    TableView.this.setEventHandler(eventType, eventHandler);
                }

                @Override
                public Object getBean() {
                    return TableView.this;
                }

                @Override
                public String getName() {
                    return "onSort";
                }
            };
        }
        return this.onSort;
    }

    public final ObservableList<TableColumn<S, ?>> getColumns() {
        return this.columns;
    }

    public final ObservableList<TableColumn<S, ?>> getSortOrder() {
        return this.sortOrder;
    }

    public void scrollTo(int index) {
        ControlUtils.scrollToIndex(this, index);
    }

    public void scrollTo(S object) {
        int idx;
        if (this.getItems() != null && (idx = this.getItems().indexOf(object)) >= 0) {
            ControlUtils.scrollToIndex(this, idx);
        }
    }

    public void setOnScrollTo(EventHandler<ScrollToEvent<Integer>> value) {
        this.onScrollToProperty().set(value);
    }

    public EventHandler<ScrollToEvent<Integer>> getOnScrollTo() {
        if (this.onScrollTo != null) {
            return (EventHandler)this.onScrollTo.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollToProperty() {
        if (this.onScrollTo == null) {
            this.onScrollTo = new ObjectPropertyBase<EventHandler<ScrollToEvent<Integer>>>(){

                @Override
                protected void invalidated() {
                    TableView.this.setEventHandler(ScrollToEvent.scrollToTopIndex(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return TableView.this;
                }

                @Override
                public String getName() {
                    return "onScrollTo";
                }
            };
        }
        return this.onScrollTo;
    }

    public void scrollToColumn(TableColumn<S, ?> column) {
        ControlUtils.scrollToColumn(this, column);
    }

    public void scrollToColumnIndex(int columnIndex) {
        if (this.getColumns() != null) {
            ControlUtils.scrollToColumn(this, (TableColumnBase)this.getColumns().get(columnIndex));
        }
    }

    public void setOnScrollToColumn(EventHandler<ScrollToEvent<TableColumn<S, ?>>> value) {
        this.onScrollToColumnProperty().set(value);
    }

    public EventHandler<ScrollToEvent<TableColumn<S, ?>>> getOnScrollToColumn() {
        if (this.onScrollToColumn != null) {
            return (EventHandler)this.onScrollToColumn.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<ScrollToEvent<TableColumn<S, ?>>>> onScrollToColumnProperty() {
        if (this.onScrollToColumn == null) {
            this.onScrollToColumn = new ObjectPropertyBase<EventHandler<ScrollToEvent<TableColumn<S, ?>>>>(){

                @Override
                protected void invalidated() {
                    EventType type = ScrollToEvent.scrollToColumn();
                    TableView.this.setEventHandler(type, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return TableView.this;
                }

                @Override
                public String getName() {
                    return "onScrollToColumn";
                }
            };
        }
        return this.onScrollToColumn;
    }

    public boolean resizeColumn(TableColumn<S, ?> column, double delta) {
        if (column == null || Double.compare(delta, 0.0) == 0) {
            return false;
        }
        boolean allowed = this.getColumnResizePolicy().call(new ResizeFeatures<S>(this, column, delta));
        if (!allowed) {
            return false;
        }
        this.refresh();
        return true;
    }

    public void edit(int row, TableColumn<S, ?> column) {
        if (!this.isEditable() || column != null && !column.isEditable()) {
            return;
        }
        if (row < 0 && column == null) {
            this.setEditingCell(null);
        } else {
            this.setEditingCell(new TablePosition(this, row, column));
        }
    }

    public ObservableList<TableColumn<S, ?>> getVisibleLeafColumns() {
        return this.unmodifiableVisibleLeafColumns;
    }

    public int getVisibleLeafIndex(TableColumn<S, ?> column) {
        return this.visibleLeafColumns.indexOf(column);
    }

    public TableColumn<S, ?> getVisibleLeafColumn(int column) {
        if (column < 0 || column >= this.visibleLeafColumns.size()) {
            return null;
        }
        return (TableColumn)this.visibleLeafColumns.get(column);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TableViewSkin(this);
    }

    public void sort() {
        ObservableList sortOrder = this.getSortOrder();
        Comparator<S> oldComparator = this.getComparator();
        this.setComparator(sortOrder.isEmpty() ? null : new TableColumnComparatorBase.TableColumnComparator(sortOrder));
        SortEvent<TableView> sortEvent = new SortEvent<TableView>(this, this);
        this.fireEvent(sortEvent);
        if (sortEvent.isConsumed()) {
            return;
        }
        ArrayList<TablePosition> prevState = new ArrayList<TablePosition>(this.getSelectionModel().getSelectedCells());
        int itemCount = prevState.size();
        this.getSelectionModel().startAtomic();
        Callback<TableView<S>, Boolean> sortPolicy = this.getSortPolicy();
        if (sortPolicy == null) {
            return;
        }
        Boolean success = sortPolicy.call(this);
        this.getSelectionModel().stopAtomic();
        if (success == null || !success.booleanValue()) {
            this.sortLock = true;
            TableUtil.handleSortFailure(sortOrder, this.lastSortEventType, this.lastSortEventSupportInfo);
            this.setComparator(oldComparator);
            this.sortLock = false;
        } else if (this.getSelectionModel() instanceof TableViewArrayListSelectionModel) {
            TableViewArrayListSelectionModel sm = (TableViewArrayListSelectionModel)this.getSelectionModel();
            ObservableList<TablePosition> newState = sm.getSelectedCells();
            ArrayList<TablePosition> removed = new ArrayList<TablePosition>();
            for (int i = 0; i < itemCount; ++i) {
                TablePosition prevItem = (TablePosition)prevState.get(i);
                if (newState.contains(prevItem)) continue;
                removed.add(prevItem);
            }
            if (!removed.isEmpty()) {
                NonIterableChange.GenericAddRemoveChange<TablePosition> c = new NonIterableChange.GenericAddRemoveChange<TablePosition>(0, itemCount, removed, newState);
                sm.handleSelectedCellsListChangeEvent(c);
            }
        }
    }

    private void doSort(TableUtil.SortEventType sortEventType, Object ... supportInfo) {
        if (this.sortLock) {
            return;
        }
        this.lastSortEventType = sortEventType;
        this.lastSortEventSupportInfo = supportInfo;
        this.sort();
        this.lastSortEventType = null;
        this.lastSortEventSupportInfo = null;
    }

    private void refresh() {
        this.getProperties().put("tableRefreshKey", Boolean.TRUE);
    }

    private void setContentWidth(double contentWidth) {
        this.contentWidth = contentWidth;
        if (this.isInited) {
            this.getColumnResizePolicy().call(new ResizeFeatures(this, null, 0.0));
            this.refresh();
        }
    }

    private void updateVisibleLeafColumns() {
        ArrayList cols = new ArrayList();
        this.buildVisibleLeafColumns(this.getColumns(), cols);
        this.visibleLeafColumns.setAll(cols);
        this.getColumnResizePolicy().call(new ResizeFeatures(this, null, 0.0));
        this.refresh();
    }

    private void buildVisibleLeafColumns(List<TableColumn<S, ?>> cols, List<TableColumn<S, ?>> vlc) {
        for (TableColumn<S, ?> c : cols) {
            boolean hasChildren;
            if (c == null) continue;
            boolean bl = hasChildren = !c.getColumns().isEmpty();
            if (hasChildren) {
                this.buildVisibleLeafColumns(c.getColumns(), vlc);
                continue;
            }
            if (!c.isVisible()) continue;
            vlc.add(c);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TableView.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case COLUMN_COUNT: {
                return this.getVisibleLeafColumns().size();
            }
            case ROW_COUNT: {
                return this.getItems().size();
            }
            case SELECTED_ITEMS: {
                ObservableList rows = (ObservableList)super.queryAccessibleAttribute(attribute, parameters);
                ArrayList selection = new ArrayList();
                for (TableRow row : rows) {
                    ObservableList cells = (ObservableList)row.queryAccessibleAttribute(attribute, parameters);
                    if (cells == null) continue;
                    selection.addAll(cells);
                }
                return FXCollections.observableArrayList(selection);
            }
            case FOCUS_ITEM: {
                Node row = (Node)super.queryAccessibleAttribute(attribute, parameters);
                if (row == null) {
                    return null;
                }
                Node cell = (Node)row.queryAccessibleAttribute(attribute, parameters);
                return cell != null ? cell : row;
            }
            case CELL_AT_ROW_COLUMN: {
                TableRow row = (TableRow)super.queryAccessibleAttribute(attribute, parameters);
                return row != null ? row.queryAccessibleAttribute(attribute, parameters) : null;
            }
            case MULTIPLE_SELECTION: {
                TableViewSelectionModel<S> sm = this.getSelectionModel();
                return sm != null && sm.getSelectionMode() == SelectionMode.MULTIPLE;
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    /* synthetic */ void lambda$new$42(Observable o) {
        boolean isCellSelection = ((BooleanProperty)o).get();
        this.pseudoClassStateChanged(PSEUDO_CLASS_CELL_SELECTION, isCellSelection);
        this.pseudoClassStateChanged(PSEUDO_CLASS_ROW_SELECTION, !isCellSelection);
    }

    /* synthetic */ void lambda$new$41(Observable valueModel) {
        Object col = ((Property)valueModel).getBean();
        if (!this.getSortOrder().contains(col)) {
            return;
        }
        this.doSort(TableUtil.SortEventType.COLUMN_COMPARATOR_CHANGE, col);
    }

    /* synthetic */ void lambda$new$40(Observable valueModel) {
        Object col = ((Property)valueModel).getBean();
        if (!this.getSortOrder().contains(col)) {
            return;
        }
        this.doSort(TableUtil.SortEventType.COLUMN_SORT_TYPE_CHANGE, col);
    }

    /* synthetic */ void lambda$new$39(Observable valueModel) {
        Object col = ((Property)valueModel).getBean();
        if (!this.getSortOrder().contains(col)) {
            return;
        }
        this.doSort(TableUtil.SortEventType.COLUMN_SORTABLE_CHANGE, col);
    }

    /* synthetic */ void lambda$new$38(Observable valueModel) {
        this.updateVisibleLeafColumns();
    }

    /* synthetic */ void lambda$new$37(ListChangeListener.Change c) {
        this.doSort(TableUtil.SortEventType.SORT_ORDER_CHANGE, c);
    }

    public static class TableViewFocusModel<S>
    extends TableFocusModel<S, TableColumn<S, ?>> {
        private final TableView<S> tableView;
        private final TablePosition<S, ?> EMPTY_CELL;
        private final ListChangeListener<S> itemsContentListener = TableView$TableViewFocusModel$$Lambda$1.lambdaFactory$(this);
        private WeakListChangeListener<S> weakItemsContentListener = new WeakListChangeListener<S>(this.itemsContentListener);
        private ReadOnlyObjectWrapper<TablePosition> focusedCell;

        public TableViewFocusModel(TableView<S> tableView) {
            if (tableView == null) {
                throw new NullPointerException("TableView can not be null");
            }
            this.tableView = tableView;
            if (tableView.getItems() != null) {
                this.tableView.getItems().addListener(this.weakItemsContentListener);
            }
            this.updateDefaultFocus();
            this.EMPTY_CELL = new TablePosition(tableView, -1, null);
        }

        private void updateItemsObserver(ObservableList<S> oldList, ObservableList<S> newList) {
            if (oldList != null) {
                oldList.removeListener(this.weakItemsContentListener);
            }
            if (newList != null) {
                newList.removeListener(this.weakItemsContentListener);
                newList.addListener(this.weakItemsContentListener);
            }
            this.updateDefaultFocus();
        }

        @Override
        protected int getItemCount() {
            if (this.tableView.getItems() == null) {
                return -1;
            }
            return this.tableView.getItems().size();
        }

        @Override
        protected S getModelItem(int index) {
            if (this.tableView.getItems() == null) {
                return null;
            }
            if (index < 0 || index >= this.getItemCount()) {
                return null;
            }
            return (S)this.tableView.getItems().get(index);
        }

        public final ReadOnlyObjectProperty<TablePosition> focusedCellProperty() {
            return this.focusedCellPropertyImpl().getReadOnlyProperty();
        }

        private void setFocusedCell(TablePosition value) {
            this.focusedCellPropertyImpl().set(value);
        }

        public final TablePosition getFocusedCell() {
            return this.focusedCell == null ? this.EMPTY_CELL : (TablePosition)this.focusedCell.get();
        }

        private ReadOnlyObjectWrapper<TablePosition> focusedCellPropertyImpl() {
            if (this.focusedCell == null) {
                this.focusedCell = new ReadOnlyObjectWrapper<TablePosition>(this.EMPTY_CELL){
                    private TablePosition old;

                    @Override
                    protected void invalidated() {
                        if (this.get() == null) {
                            return;
                        }
                        if (this.old == null || !this.old.equals(this.get())) {
                            TableViewFocusModel.this.setFocusedIndex(((TablePosition)this.get()).getRow());
                            TableViewFocusModel.this.setFocusedItem(TableViewFocusModel.this.getModelItem(((TablePosition)this.getValue()).getRow()));
                            this.old = (TablePosition)this.get();
                        }
                    }

                    @Override
                    public Object getBean() {
                        return TableViewFocusModel.this;
                    }

                    @Override
                    public String getName() {
                        return "focusedCell";
                    }
                };
            }
            return this.focusedCell;
        }

        @Override
        public void focus(int row, TableColumn<S, ?> column) {
            if (row < 0 || row >= this.getItemCount()) {
                this.setFocusedCell(this.EMPTY_CELL);
            } else {
                this.setFocusedCell(new TablePosition(this.tableView, row, column));
            }
        }

        public void focus(TablePosition pos) {
            if (pos == null) {
                return;
            }
            this.focus(pos.getRow(), (TableColumn<S, ?>)pos.getTableColumn());
        }

        @Override
        public boolean isFocused(int row, TableColumn<S, ?> column) {
            if (row < 0 || row >= this.getItemCount()) {
                return false;
            }
            TablePosition cell = this.getFocusedCell();
            boolean columnMatch = column == null || column.equals(cell.getTableColumn());
            return cell.getRow() == row && columnMatch;
        }

        @Override
        public void focus(int index) {
            if (index < 0 || index >= this.getItemCount()) {
                this.setFocusedCell(this.EMPTY_CELL);
            } else {
                this.setFocusedCell(new TablePosition(this.tableView, index, null));
            }
        }

        @Override
        public void focusAboveCell() {
            TablePosition cell = this.getFocusedCell();
            if (this.getFocusedIndex() == -1) {
                this.focus(this.getItemCount() - 1, (TableColumn<S, ?>)cell.getTableColumn());
            } else if (this.getFocusedIndex() > 0) {
                this.focus(this.getFocusedIndex() - 1, (TableColumn<S, ?>)cell.getTableColumn());
            }
        }

        @Override
        public void focusBelowCell() {
            TablePosition cell = this.getFocusedCell();
            if (this.getFocusedIndex() == -1) {
                this.focus(0, (TableColumn<S, ?>)cell.getTableColumn());
            } else if (this.getFocusedIndex() != this.getItemCount() - 1) {
                this.focus(this.getFocusedIndex() + 1, (TableColumn<S, ?>)cell.getTableColumn());
            }
        }

        @Override
        public void focusLeftCell() {
            TablePosition cell = this.getFocusedCell();
            if (cell.getColumn() <= 0) {
                return;
            }
            this.focus(cell.getRow(), this.getTableColumn((TableColumn<S, ?>)cell.getTableColumn(), -1));
        }

        @Override
        public void focusRightCell() {
            TablePosition cell = this.getFocusedCell();
            if (cell.getColumn() == this.getColumnCount() - 1) {
                return;
            }
            this.focus(cell.getRow(), this.getTableColumn((TableColumn<S, ?>)cell.getTableColumn(), 1));
        }

        @Override
        public void focusPrevious() {
            if (this.getFocusedIndex() == -1) {
                this.focus(0);
            } else if (this.getFocusedIndex() > 0) {
                this.focusAboveCell();
            }
        }

        @Override
        public void focusNext() {
            if (this.getFocusedIndex() == -1) {
                this.focus(0);
            } else if (this.getFocusedIndex() != this.getItemCount() - 1) {
                this.focusBelowCell();
            }
        }

        private void updateDefaultFocus() {
            TablePosition focusedCell;
            int newValueIndex = -1;
            if (this.tableView.getItems() != null) {
                Object focusedItem = this.getFocusedItem();
                if (focusedItem != null) {
                    newValueIndex = this.tableView.getItems().indexOf(focusedItem);
                }
                if (newValueIndex == -1) {
                    newValueIndex = this.tableView.getItems().size() > 0 ? 0 : -1;
                }
            }
            TableColumn<S, ?> focusColumn = (focusedCell = this.getFocusedCell()) != null ? focusedCell.getTableColumn() : this.tableView.getVisibleLeafColumn(0);
            this.focus(newValueIndex, focusColumn);
        }

        private int getColumnCount() {
            return this.tableView.getVisibleLeafColumns().size();
        }

        private TableColumn<S, ?> getTableColumn(TableColumn<S, ?> column, int offset) {
            int columnIndex = this.tableView.getVisibleLeafIndex(column);
            int newColumnIndex = columnIndex + offset;
            return this.tableView.getVisibleLeafColumn(newColumnIndex);
        }

        /* synthetic */ void lambda$new$48(ListChangeListener.Change c) {
            c.next();
            TablePosition focusedCell = this.getFocusedCell();
            int focusedIndex = focusedCell.getRow();
            if (focusedIndex == -1 || c.getFrom() > focusedIndex) {
                return;
            }
            c.reset();
            boolean added = false;
            boolean removed = false;
            int addedSize = 0;
            int removedSize = 0;
            while (c.next()) {
                added |= c.wasAdded();
                removed |= c.wasRemoved();
                addedSize += c.getAddedSize();
                removedSize += c.getRemovedSize();
            }
            if (added && !removed) {
                if (addedSize < c.getList().size()) {
                    int newFocusIndex = this.getFocusedIndex() + addedSize;
                    this.focus(newFocusIndex, (TableColumn<S, ?>)focusedCell.getTableColumn());
                }
            } else if (!added && removed) {
                int newFocusIndex = this.getFocusedIndex() - removedSize;
                if (newFocusIndex < 0) {
                    this.focus(0, (TableColumn<S, ?>)focusedCell.getTableColumn());
                } else {
                    this.focus(newFocusIndex, (TableColumn<S, ?>)focusedCell.getTableColumn());
                }
            }
        }
    }

    static class TableViewArrayListSelectionModel<S>
    extends TableViewSelectionModel<S> {
        private int itemCount = 0;
        private final MappingChange.Map<TablePosition<S, ?>, S> cellToItemsMap = TableView$TableViewArrayListSelectionModel$$Lambda$1.lambdaFactory$(this);
        private final MappingChange.Map<TablePosition<S, ?>, Integer> cellToIndicesMap = TableView$TableViewArrayListSelectionModel$$Lambda$2.lambdaFactory$();
        private final TableView<S> tableView;
        final ListChangeListener<S> itemsContentListener = TableView$TableViewArrayListSelectionModel$$Lambda$3.lambdaFactory$(this);
        final WeakListChangeListener<S> weakItemsContentListener = new WeakListChangeListener<S>(this.itemsContentListener);
        private final SelectedCellsMap<TablePosition<S, ?>> selectedCellsMap;
        private final ReadOnlyUnbackedObservableList<S> selectedItems;
        private final ReadOnlyUnbackedObservableList<TablePosition<S, ?>> selectedCellsSeq;
        private int previousModelSize = 0;

        public TableViewArrayListSelectionModel(TableView<S> tableView) {
            super(tableView);
            this.tableView = tableView;
            this.selectedCellsMap = new SelectedCellsMap<TablePosition<S, ?>>(TableView$TableViewArrayListSelectionModel$$Lambda$4.lambdaFactory$(this)){

                @Override
                public boolean isCellSelectionEnabled() {
                    return TableViewArrayListSelectionModel.this.isCellSelectionEnabled();
                }
            };
            this.selectedItems = new ReadOnlyUnbackedObservableList<S>(){

                @Override
                public S get(int i) {
                    return TableViewArrayListSelectionModel.this.getModelItem((Integer)TableViewArrayListSelectionModel.this.getSelectedIndices().get(i));
                }

                @Override
                public int size() {
                    return TableViewArrayListSelectionModel.this.getSelectedIndices().size();
                }
            };
            this.selectedCellsSeq = new ReadOnlyUnbackedObservableList<TablePosition<S, ?>>(){

                @Override
                public TablePosition<S, ?> get(int i) {
                    return (TablePosition)TableViewArrayListSelectionModel.this.selectedCellsMap.get(i);
                }

                @Override
                public int size() {
                    return TableViewArrayListSelectionModel.this.selectedCellsMap.size();
                }
            };
            ObservableList items = this.getTableView().getItems();
            if (items != null) {
                items.addListener(this.weakItemsContentListener);
            }
            this.updateItemCount();
            this.updateDefaultSelection();
            this.cellSelectionEnabledProperty().addListener(TableView$TableViewArrayListSelectionModel$$Lambda$5.lambdaFactory$(this, tableView));
        }

        @Override
        public ObservableList<S> getSelectedItems() {
            return this.selectedItems;
        }

        @Override
        public ObservableList<TablePosition> getSelectedCells() {
            return this.selectedCellsSeq;
        }

        private void updateSelection(ListChangeListener.Change<? extends S> c) {
            c.reset();
            while (c.next()) {
                if (c.wasReplaced()) {
                    if (c.getList().isEmpty()) {
                        this.clearSelection();
                        continue;
                    }
                    int index = this.getSelectedIndex();
                    if (this.previousModelSize == c.getRemovedSize()) {
                        this.clearSelection();
                        continue;
                    }
                    if (index < this.getItemCount() && index >= 0) {
                        this.startAtomic();
                        this.clearSelection(index);
                        this.stopAtomic();
                        this.select(index);
                        continue;
                    }
                    this.clearSelection();
                    continue;
                }
                if (c.wasAdded() || c.wasRemoved()) {
                    boolean isAnchorSelected;
                    int shift;
                    int startRow = c.getFrom();
                    int n = shift = c.wasAdded() ? c.getAddedSize() : -c.getRemovedSize();
                    if (startRow < 0) {
                        return;
                    }
                    if (shift == 0) {
                        return;
                    }
                    ArrayList newIndices = new ArrayList(this.selectedCellsMap.size());
                    for (int i = 0; i < this.selectedCellsMap.size(); ++i) {
                        TablePosition<S, ?> old = this.selectedCellsMap.get(i);
                        int oldRow = old.getRow();
                        int newRow = Math.max(0, oldRow < startRow ? oldRow : oldRow + shift);
                        if (oldRow < startRow) continue;
                        if (oldRow == 0 && shift == -1) {
                            newIndices.add(new TablePosition(this.getTableView(), 0, old.getTableColumn()));
                            continue;
                        }
                        newIndices.add(new TablePosition(this.getTableView(), newRow, old.getTableColumn()));
                    }
                    int newIndicesSize = newIndices.size();
                    if (!c.wasRemoved() && !c.wasAdded() || newIndicesSize <= 0) continue;
                    TablePosition anchor = TableCellBehavior.getAnchor(this.tableView, null);
                    if (anchor != null && (isAnchorSelected = this.isSelected(anchor.getRow(), (TableColumn<S, ?>)anchor.getTableColumn()))) {
                        TablePosition newAnchor = new TablePosition(this.tableView, anchor.getRow() + shift, anchor.getTableColumn());
                        TableCellBehavior.setAnchor(this.tableView, newAnchor, false);
                    }
                    this.quietClearSelection();
                    this.blockFocusCall = true;
                    for (int i = 0; i < newIndicesSize; ++i) {
                        TablePosition tp = (TablePosition)newIndices.get(i);
                        this.select(tp.getRow(), (TableColumn<S, ?>)tp.getTableColumn());
                    }
                    this.blockFocusCall = false;
                    continue;
                }
                if (!c.wasPermutated()) continue;
                this.startAtomic();
                int oldSelectedIndex = this.getSelectedIndex();
                int length = c.getTo() - c.getFrom();
                HashMap<Integer, Integer> pMap = new HashMap<Integer, Integer>(length);
                for (int i = c.getFrom(); i < c.getTo(); ++i) {
                    pMap.put(i, c.getPermutation(i));
                }
                ArrayList<TablePosition> selectedIndices = new ArrayList<TablePosition>(this.getSelectedCells());
                ArrayList newIndices = new ArrayList(selectedIndices.size());
                boolean selectionIndicesChanged = false;
                for (int i = 0; i < selectedIndices.size(); ++i) {
                    TablePosition oldIndex = (TablePosition)selectedIndices.get(i);
                    int oldRow = oldIndex.getRow();
                    if (!pMap.containsKey(oldRow)) continue;
                    int newIndex = (Integer)pMap.get(oldRow);
                    selectionIndicesChanged = selectionIndicesChanged || newIndex != oldRow;
                    newIndices.add(new TablePosition(oldIndex.getTableView(), newIndex, oldIndex.getTableColumn()));
                }
                if (selectionIndicesChanged) {
                    this.quietClearSelection();
                    this.stopAtomic();
                    this.selectedCellsMap.setAll(newIndices);
                    if (oldSelectedIndex < 0 || oldSelectedIndex >= this.itemCount) continue;
                    int newIndex = c.getPermutation(oldSelectedIndex);
                    this.setSelectedIndex(newIndex);
                    this.focus(newIndex);
                    continue;
                }
                this.stopAtomic();
            }
            this.previousModelSize = this.getItemCount();
        }

        @Override
        public void clearAndSelect(int row) {
            this.clearAndSelect(row, (TableColumn<S, ?>)null);
        }

        @Override
        public void clearAndSelect(int row, TableColumn<S, ?> column) {
            NonIterableChange.GenericAddRemoveChange change;
            if (row < 0 || row >= this.getItemCount()) {
                return;
            }
            TablePosition newTablePosition = new TablePosition(this.getTableView(), row, column);
            TableCellBehavior.setAnchor(this.tableView, newTablePosition, false);
            if (this.isCellSelectionEnabled() && column == null) {
                return;
            }
            boolean wasSelected = this.isSelected(row, column);
            ArrayList previousSelection = new ArrayList(this.selectedCellsMap.getSelectedCells());
            if (wasSelected && previousSelection.size() == 1) {
                TablePosition selectedCell = (TablePosition)this.getSelectedCells().get(0);
                if (this.getSelectedItem() == this.getModelItem(row) && selectedCell.getRow() == row && selectedCell.getTableColumn() == column) {
                    return;
                }
            }
            this.startAtomic();
            this.clearSelection();
            this.select(row, column);
            this.stopAtomic();
            previousSelection.remove(newTablePosition);
            if (wasSelected) {
                change = new NonIterableChange.GenericAddRemoveChange<TablePosition<S, ?>>(0, 0, previousSelection, this.selectedCellsSeq){

                    @Override
                    public boolean wasAdded() {
                        return false;
                    }

                    @Override
                    public boolean wasRemoved() {
                        return true;
                    }
                };
            } else {
                int changeIndex = this.selectedCellsSeq.indexOf(newTablePosition);
                change = new NonIterableChange.GenericAddRemoveChange(changeIndex, changeIndex + 1, previousSelection, this.selectedCellsSeq);
            }
            this.handleSelectedCellsListChangeEvent(change);
        }

        @Override
        public void select(int row) {
            this.select(row, (TableColumn<S, ?>)null);
        }

        @Override
        public void select(int row, TableColumn<S, ?> column) {
            if (row < 0 || row >= this.getItemCount()) {
                return;
            }
            if (this.isCellSelectionEnabled() && column == null) {
                ObservableList columns = this.getTableView().getVisibleLeafColumns();
                for (int i = 0; i < columns.size(); ++i) {
                    this.select(row, (TableColumn)columns.get(i));
                }
                return;
            }
            TablePosition pos = new TablePosition(this.getTableView(), row, column);
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.startAtomic();
                this.quietClearSelection();
                this.stopAtomic();
            }
            if (TableCellBehavior.hasDefaultAnchor(this.tableView)) {
                TableCellBehavior.removeAnchor(this.tableView);
            }
            this.selectedCellsMap.add(pos);
            this.updateSelectedIndex(row);
            this.focus(row, column);
        }

        @Override
        public void select(S obj) {
            if (obj == null && this.getSelectionMode() == SelectionMode.SINGLE) {
                this.clearSelection();
                return;
            }
            Object rowObj = null;
            for (int i = 0; i < this.getItemCount(); ++i) {
                rowObj = this.getModelItem(i);
                if (rowObj == null || !rowObj.equals(obj)) continue;
                if (this.isSelected(i)) {
                    return;
                }
                if (this.getSelectionMode() == SelectionMode.SINGLE) {
                    this.quietClearSelection();
                }
                this.select(i);
                return;
            }
            this.setSelectedIndex(-1);
            this.setSelectedItem(obj);
        }

        @Override
        public void selectIndices(int row, int ... rows) {
            if (rows == null) {
                this.select(row);
                return;
            }
            int rowCount = this.getItemCount();
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
                for (int i = rows.length - 1; i >= 0; --i) {
                    int index = rows[i];
                    if (index < 0 || index >= rowCount) continue;
                    this.select(index);
                    break;
                }
                if (this.selectedCellsMap.isEmpty() && row > 0 && row < rowCount) {
                    this.select(row);
                }
            } else {
                int lastIndex = -1;
                LinkedHashSet positions = new LinkedHashSet();
                if (row >= 0 && row < rowCount) {
                    if (this.isCellSelectionEnabled()) {
                        ObservableList columns = this.getTableView().getVisibleLeafColumns();
                        for (int column = 0; column < columns.size(); ++column) {
                            if (this.selectedCellsMap.isSelected(row, column)) continue;
                            positions.add(new TablePosition(this.getTableView(), row, (TableColumn)columns.get(column)));
                            lastIndex = row;
                        }
                    } else {
                        boolean match = this.selectedCellsMap.isSelected(row, -1);
                        if (!match) {
                            positions.add(new TablePosition(this.getTableView(), row, null));
                        }
                    }
                    lastIndex = row;
                }
                for (int i = 0; i < rows.length; ++i) {
                    int index = rows[i];
                    if (index < 0 || index >= rowCount) continue;
                    lastIndex = index;
                    if (this.isCellSelectionEnabled()) {
                        ObservableList columns = this.getTableView().getVisibleLeafColumns();
                        for (int column = 0; column < columns.size(); ++column) {
                            if (this.selectedCellsMap.isSelected(index, column)) continue;
                            positions.add(new TablePosition(this.getTableView(), index, (TableColumn)columns.get(column)));
                            lastIndex = index;
                        }
                        continue;
                    }
                    if (this.selectedCellsMap.isSelected(index, -1)) continue;
                    positions.add(new TablePosition(this.getTableView(), index, null));
                }
                this.selectedCellsMap.addAll(positions);
                if (lastIndex != -1) {
                    this.select(lastIndex);
                }
            }
        }

        @Override
        public void selectAll() {
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                return;
            }
            this.quietClearSelection();
            if (this.isCellSelectionEnabled()) {
                ArrayList indices = new ArrayList();
                TablePosition tp = null;
                for (int col = 0; col < this.getTableView().getVisibleLeafColumns().size(); ++col) {
                    TableColumn column = (TableColumn)this.getTableView().getVisibleLeafColumns().get(col);
                    for (int row = 0; row < this.getItemCount(); ++row) {
                        tp = new TablePosition(this.getTableView(), row, column);
                        indices.add(tp);
                    }
                }
                this.selectedCellsMap.setAll(indices);
                if (tp != null) {
                    this.select(tp.getRow(), (TableColumn<S, ?>)tp.getTableColumn());
                    this.focus(tp.getRow(), tp.getTableColumn());
                }
            } else {
                ArrayList indices = new ArrayList();
                for (int i = 0; i < this.getItemCount(); ++i) {
                    indices.add(new TablePosition(this.getTableView(), i, null));
                }
                this.selectedCellsMap.setAll(indices);
                int focusedIndex = this.getFocusedIndex();
                if (focusedIndex == -1) {
                    int itemCount = this.getItemCount();
                    if (itemCount > 0) {
                        this.select(itemCount - 1);
                        this.focus((TablePosition)indices.get(indices.size() - 1));
                    }
                } else {
                    this.select(focusedIndex);
                    this.focus(focusedIndex);
                }
            }
        }

        @Override
        public void selectRange(int minRow, TableColumnBase<S, ?> minColumn, int maxRow, TableColumnBase<S, ?> maxColumn) {
            this.startAtomic();
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
                ((TableViewSelectionModel)this).select(maxRow, maxColumn);
                return;
            }
            int itemCount = this.getItemCount();
            boolean isCellSelectionEnabled = this.isCellSelectionEnabled();
            int minColumnIndex = this.tableView.getVisibleLeafIndex((TableColumn)minColumn);
            int maxColumnIndex = this.tableView.getVisibleLeafIndex((TableColumn)maxColumn);
            int _minColumnIndex = Math.min(minColumnIndex, maxColumnIndex);
            int _maxColumnIndex = Math.max(minColumnIndex, maxColumnIndex);
            int _minRow = Math.min(minRow, maxRow);
            int _maxRow = Math.max(minRow, maxRow);
            ArrayList cellsToSelect = new ArrayList();
            for (int _row = _minRow; _row <= _maxRow; ++_row) {
                if (_row < 0 || _row >= itemCount) continue;
                if (!isCellSelectionEnabled) {
                    cellsToSelect.add(new TablePosition(this.tableView, _row, (TableColumn)minColumn));
                    continue;
                }
                for (int _col = _minColumnIndex; _col <= _maxColumnIndex; ++_col) {
                    TableColumn<S, ?> column = this.tableView.getVisibleLeafColumn(_col);
                    if (column == null && isCellSelectionEnabled) continue;
                    cellsToSelect.add(new TablePosition(this.tableView, _row, column));
                }
            }
            this.selectedCellsMap.addAll(cellsToSelect);
            this.stopAtomic();
            this.updateSelectedIndex(maxRow);
            this.focus(maxRow, (TableColumn)maxColumn);
            int startChangeIndex = this.selectedCellsMap.indexOf(new TablePosition(this.tableView, minRow, (TableColumn)minColumn));
            int endChangeIndex = this.selectedCellsMap.indexOf(new TablePosition(this.tableView, maxRow, (TableColumn)maxColumn));
            if (startChangeIndex > -1 && endChangeIndex > -1) {
                NonIterableChange.SimpleAddChange c = new NonIterableChange.SimpleAddChange(startChangeIndex, endChangeIndex + 1, this.selectedCellsSeq);
                this.handleSelectedCellsListChangeEvent(c);
            }
        }

        @Override
        public void clearSelection(int index) {
            this.clearSelection(index, (TableColumn<S, ?>)null);
        }

        @Override
        public void clearSelection(int row, TableColumn<S, ?> column) {
            this.clearSelection(new TablePosition(this.getTableView(), row, column));
        }

        private void clearSelection(TablePosition<S, ?> tp) {
            boolean csMode = this.isCellSelectionEnabled();
            int row = tp.getRow();
            for (TablePosition pos : this.getSelectedCells()) {
                if (!csMode) {
                    if (pos.getRow() != row) continue;
                    this.selectedCellsMap.remove(pos);
                    break;
                }
                if (!pos.equals(tp)) continue;
                this.selectedCellsMap.remove(tp);
                break;
            }
            if (this.isEmpty() && !this.isAtomic()) {
                this.updateSelectedIndex(-1);
                this.selectedCellsMap.clear();
            }
        }

        @Override
        public void clearSelection() {
            if (!this.isAtomic()) {
                this.updateSelectedIndex(-1);
                this.focus(-1);
            }
            this.selectedCellsMap.clear();
        }

        private void quietClearSelection() {
            this.startAtomic();
            this.selectedCellsMap.clear();
            this.stopAtomic();
        }

        @Override
        public boolean isSelected(int index) {
            return this.isSelected(index, (TableColumn<S, ?>)null);
        }

        @Override
        public boolean isSelected(int row, TableColumn<S, ?> column) {
            boolean isCellSelectionEnabled = this.isCellSelectionEnabled();
            if (isCellSelectionEnabled && column == null) {
                return false;
            }
            int columnIndex = !isCellSelectionEnabled || column == null ? -1 : this.tableView.getVisibleLeafIndex(column);
            return this.selectedCellsMap.isSelected(row, columnIndex);
        }

        @Override
        public boolean isEmpty() {
            return this.selectedCellsMap.isEmpty();
        }

        @Override
        public void selectPrevious() {
            if (this.isCellSelectionEnabled()) {
                TablePosition pos = this.getFocusedCell();
                if (pos.getColumn() - 1 >= 0) {
                    this.select(pos.getRow(), this.getTableColumn((TableColumn<S, ?>)pos.getTableColumn(), -1));
                } else if (pos.getRow() < this.getItemCount() - 1) {
                    this.select(pos.getRow() - 1, this.getTableColumn(this.getTableView().getVisibleLeafColumns().size() - 1));
                }
            } else {
                int focusIndex = this.getFocusedIndex();
                if (focusIndex == -1) {
                    this.select(this.getItemCount() - 1);
                } else if (focusIndex > 0) {
                    this.select(focusIndex - 1);
                }
            }
        }

        @Override
        public void selectNext() {
            if (this.isCellSelectionEnabled()) {
                TablePosition pos = this.getFocusedCell();
                if (pos.getColumn() + 1 < this.getTableView().getVisibleLeafColumns().size()) {
                    this.select(pos.getRow(), this.getTableColumn((TableColumn<S, ?>)pos.getTableColumn(), 1));
                } else if (pos.getRow() < this.getItemCount() - 1) {
                    this.select(pos.getRow() + 1, this.getTableColumn(0));
                }
            } else {
                int focusIndex = this.getFocusedIndex();
                if (focusIndex == -1) {
                    this.select(0);
                } else if (focusIndex < this.getItemCount() - 1) {
                    this.select(focusIndex + 1);
                }
            }
        }

        @Override
        public void selectAboveCell() {
            TablePosition pos = this.getFocusedCell();
            if (pos.getRow() == -1) {
                this.select(this.getItemCount() - 1);
            } else if (pos.getRow() > 0) {
                this.select(pos.getRow() - 1, (TableColumn<S, ?>)pos.getTableColumn());
            }
        }

        @Override
        public void selectBelowCell() {
            TablePosition pos = this.getFocusedCell();
            if (pos.getRow() == -1) {
                this.select(0);
            } else if (pos.getRow() < this.getItemCount() - 1) {
                this.select(pos.getRow() + 1, (TableColumn<S, ?>)pos.getTableColumn());
            }
        }

        @Override
        public void selectFirst() {
            TablePosition focusedCell = this.getFocusedCell();
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            if (this.getItemCount() > 0) {
                if (this.isCellSelectionEnabled()) {
                    this.select(0, (TableColumn<S, ?>)focusedCell.getTableColumn());
                } else {
                    this.select(0);
                }
            }
        }

        @Override
        public void selectLast() {
            int numItems;
            TablePosition focusedCell = this.getFocusedCell();
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            if ((numItems = this.getItemCount()) > 0 && this.getSelectedIndex() < numItems - 1) {
                if (this.isCellSelectionEnabled()) {
                    this.select(numItems - 1, (TableColumn<S, ?>)focusedCell.getTableColumn());
                } else {
                    this.select(numItems - 1);
                }
            }
        }

        @Override
        public void selectLeftCell() {
            if (!this.isCellSelectionEnabled()) {
                return;
            }
            TablePosition pos = this.getFocusedCell();
            if (pos.getColumn() - 1 >= 0) {
                this.select(pos.getRow(), this.getTableColumn((TableColumn<S, ?>)pos.getTableColumn(), -1));
            }
        }

        @Override
        public void selectRightCell() {
            if (!this.isCellSelectionEnabled()) {
                return;
            }
            TablePosition pos = this.getFocusedCell();
            if (pos.getColumn() + 1 < this.getTableView().getVisibleLeafColumns().size()) {
                this.select(pos.getRow(), this.getTableColumn((TableColumn<S, ?>)pos.getTableColumn(), 1));
            }
        }

        private void updateItemsObserver(ObservableList<S> oldList, ObservableList<S> newList) {
            if (oldList != null) {
                oldList.removeListener(this.weakItemsContentListener);
            }
            if (newList != null) {
                newList.removeListener(this.weakItemsContentListener);
                newList.addListener(this.weakItemsContentListener);
            }
            this.updateItemCount();
            this.updateDefaultSelection();
        }

        private void updateDefaultSelection() {
            int newSelectionIndex = -1;
            int newFocusIndex = -1;
            if (this.tableView.getItems() != null) {
                Object selectedItem = this.getSelectedItem();
                if (selectedItem != null) {
                    newSelectionIndex = this.tableView.getItems().indexOf(selectedItem);
                }
                if (newFocusIndex == -1) {
                    newFocusIndex = this.tableView.getItems().size() > 0 ? 0 : -1;
                }
            }
            this.clearSelection();
            this.select(newSelectionIndex, this.isCellSelectionEnabled() ? this.getTableColumn(0) : null);
            this.focus(newFocusIndex, this.isCellSelectionEnabled() ? this.getTableColumn(0) : null);
        }

        private TableColumn<S, ?> getTableColumn(int pos) {
            return this.getTableView().getVisibleLeafColumn(pos);
        }

        private TableColumn<S, ?> getTableColumn(TableColumn<S, ?> column, int offset) {
            int columnIndex = this.getTableView().getVisibleLeafIndex(column);
            int newColumnIndex = columnIndex + offset;
            return this.getTableView().getVisibleLeafColumn(newColumnIndex);
        }

        private void updateSelectedIndex(int row) {
            this.setSelectedIndex(row);
            this.setSelectedItem(this.getModelItem(row));
        }

        @Override
        protected int getItemCount() {
            return this.itemCount;
        }

        private void updateItemCount() {
            List items;
            this.itemCount = this.tableView == null ? -1 : ((items = this.getTableModel()) == null ? -1 : items.size());
        }

        private void handleSelectedCellsListChangeEvent(ListChangeListener.Change<? extends TablePosition<S, ?>> c) {
            boolean fireChangeEvent;
            ArrayList<Integer> newlyUnselectedRows;
            ArrayList<Integer> newlySelectedRows;
            block15: {
                int i;
                newlySelectedRows = new ArrayList<Integer>();
                newlyUnselectedRows = new ArrayList<Integer>();
                while (c.next()) {
                    int row;
                    TablePosition<S, ?> tp;
                    if (c.wasRemoved()) {
                        List<TablePosition<S, ?>> removed = c.getRemoved();
                        for (i = 0; i < removed.size(); ++i) {
                            tp = removed.get(i);
                            row = tp.getRow();
                            if (!this.selectedIndices.get(row)) continue;
                            this.selectedIndices.clear(row);
                            newlyUnselectedRows.add(row);
                        }
                    }
                    if (!c.wasAdded()) continue;
                    List<TablePosition<S, ?>> added = c.getAddedSubList();
                    for (i = 0; i < added.size(); ++i) {
                        tp = added.get(i);
                        row = tp.getRow();
                        if (this.selectedIndices.get(row)) continue;
                        this.selectedIndices.set(row);
                        newlySelectedRows.add(row);
                    }
                }
                c.reset();
                if (this.isAtomic()) {
                    return;
                }
                c.next();
                if (c.wasReplaced()) {
                    for (i = 0; i < c.getRemovedSize(); ++i) {
                        TablePosition<S, ?> removed = c.getRemoved().get(i);
                        S removedItem = removed.getItem();
                        boolean matchFound = false;
                        for (int j = 0; j < c.getAddedSize(); ++j) {
                            TablePosition<S, ?> added = c.getAddedSubList().get(j);
                            S addedItem = added.getItem();
                            if (!removedItem.equals(addedItem)) continue;
                            matchFound = true;
                            break;
                        }
                        if (matchFound) continue;
                        fireChangeEvent = true;
                        break block15;
                    }
                    fireChangeEvent = false;
                } else {
                    fireChangeEvent = true;
                }
            }
            if (fireChangeEvent) {
                if (this.selectedItemChange != null) {
                    this.selectedItems.callObservers(this.selectedItemChange);
                } else {
                    this.selectedItems.callObservers(new MappingChange(c, this.cellToItemsMap, this.selectedItems));
                }
            }
            c.reset();
            if (this.selectedItems.isEmpty() && this.getSelectedItem() != null) {
                this.setSelectedItem(null);
            }
            ReadOnlyUnbackedObservableList selectedIndicesSeq = (ReadOnlyUnbackedObservableList)this.getSelectedIndices();
            if (!newlySelectedRows.isEmpty() && newlyUnselectedRows.isEmpty()) {
                ListChangeListener.Change<Integer> change = TableViewArrayListSelectionModel.createRangeChange(selectedIndicesSeq, newlySelectedRows);
                selectedIndicesSeq.callObservers(change);
            } else {
                selectedIndicesSeq.callObservers(new MappingChange(c, this.cellToIndicesMap, selectedIndicesSeq));
                c.reset();
            }
            this.selectedCellsSeq.callObservers(new MappingChange(c, MappingChange.NOOP_MAP, this.selectedCellsSeq));
            c.reset();
        }

        /* synthetic */ void lambda$new$47(ListChangeListener.Change c) {
            this.updateItemCount();
            List items1 = this.getTableModel();
            while (c.next()) {
                int previousRow;
                Object newSelectedItem;
                if (c.wasReplaced() || c.getAddedSize() == this.getItemCount()) {
                    this.selectedItemChange = c;
                    this.updateDefaultSelection();
                    this.selectedItemChange = null;
                    return;
                }
                Object selectedItem = this.getSelectedItem();
                int selectedIndex = this.getSelectedIndex();
                if (items1 == null || items1.isEmpty()) {
                    this.clearSelection();
                    continue;
                }
                if (this.getSelectedIndex() == -1 && this.getSelectedItem() != null) {
                    int newIndex = items1.indexOf(this.getSelectedItem());
                    if (newIndex == -1) continue;
                    this.setSelectedIndex(newIndex);
                    continue;
                }
                if (!c.wasRemoved() || c.getRemovedSize() != 1 || c.wasAdded() || selectedItem == null || !selectedItem.equals(c.getRemoved().get(0)) || this.getSelectedIndex() >= this.getItemCount() || selectedItem.equals(newSelectedItem = this.getModelItem(previousRow = selectedIndex == 0 ? 0 : selectedIndex - 1))) continue;
                this.clearAndSelect(previousRow);
            }
            this.updateSelection(c);
        }

        /* synthetic */ void lambda$new$46(TableView tableView, Observable o) {
            this.updateDefaultSelection();
            TableCellBehaviorBase.setAnchor(tableView, this.getFocusedCell(), true);
        }

        /* synthetic */ void lambda$new$45(ListChangeListener.Change c) {
            this.handleSelectedCellsListChangeEvent(c);
        }

        static /* synthetic */ Integer lambda$new$44(TablePosition f) {
            return f.getRow();
        }

        /* synthetic */ Object lambda$new$43(TablePosition f) {
            return this.getModelItem(f.getRow());
        }
    }

    public static abstract class TableViewSelectionModel<S>
    extends TableSelectionModel<S> {
        private final TableView<S> tableView;
        boolean blockFocusCall = false;

        public TableViewSelectionModel(TableView<S> tableView) {
            if (tableView == null) {
                throw new NullPointerException("TableView can not be null");
            }
            this.tableView = tableView;
        }

        public abstract ObservableList<TablePosition> getSelectedCells();

        @Override
        public boolean isSelected(int row, TableColumnBase<S, ?> column) {
            return this.isSelected(row, (TableColumn)column);
        }

        @Override
        public abstract boolean isSelected(int var1, TableColumn<S, ?> var2);

        @Override
        public void select(int row, TableColumnBase<S, ?> column) {
            this.select(row, (TableColumn)column);
        }

        @Override
        public abstract void select(int var1, TableColumn<S, ?> var2);

        @Override
        public void clearAndSelect(int row, TableColumnBase<S, ?> column) {
            this.clearAndSelect(row, (TableColumn)column);
        }

        @Override
        public abstract void clearAndSelect(int var1, TableColumn<S, ?> var2);

        @Override
        public void clearSelection(int row, TableColumnBase<S, ?> column) {
            this.clearSelection(row, (TableColumn)column);
        }

        @Override
        public abstract void clearSelection(int var1, TableColumn<S, ?> var2);

        @Override
        public void selectRange(int minRow, TableColumnBase<S, ?> minColumn, int maxRow, TableColumnBase<S, ?> maxColumn) {
            int minColumnIndex = this.tableView.getVisibleLeafIndex((TableColumn)minColumn);
            int maxColumnIndex = this.tableView.getVisibleLeafIndex((TableColumn)maxColumn);
            for (int _row = minRow; _row <= maxRow; ++_row) {
                for (int _col = minColumnIndex; _col <= maxColumnIndex; ++_col) {
                    this.select(_row, this.tableView.getVisibleLeafColumn(_col));
                }
            }
        }

        public TableView<S> getTableView() {
            return this.tableView;
        }

        protected List<S> getTableModel() {
            return this.tableView.getItems();
        }

        @Override
        protected S getModelItem(int index) {
            if (index < 0 || index >= this.getItemCount()) {
                return null;
            }
            return (S)this.tableView.getItems().get(index);
        }

        @Override
        protected int getItemCount() {
            return this.getTableModel().size();
        }

        @Override
        public void focus(int row) {
            this.focus(row, null);
        }

        @Override
        public int getFocusedIndex() {
            return this.getFocusedCell().getRow();
        }

        void focus(int row, TableColumn<S, ?> column) {
            this.focus(new TablePosition(this.getTableView(), row, column));
            this.getTableView().notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
        }

        void focus(TablePosition<S, ?> pos) {
            if (this.blockFocusCall) {
                return;
            }
            if (this.getTableView().getFocusModel() == null) {
                return;
            }
            this.getTableView().getFocusModel().focus(pos.getRow(), (TableColumn<S, ?>)pos.getTableColumn());
        }

        TablePosition<S, ?> getFocusedCell() {
            if (this.getTableView().getFocusModel() == null) {
                return new TablePosition(this.getTableView(), -1, null);
            }
            return this.getTableView().getFocusModel().getFocusedCell();
        }
    }

    public static class ResizeFeatures<S>
    extends ResizeFeaturesBase<S> {
        private TableView<S> table;

        public ResizeFeatures(TableView<S> table, TableColumn<S, ?> column, Double delta) {
            super(column, delta);
            this.table = table;
        }

        @Override
        public TableColumn<S, ?> getColumn() {
            return (TableColumn)super.getColumn();
        }

        public TableView<S> getTable() {
            return this.table;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<TableView<?>, Number> FIXED_CELL_SIZE = new CssMetaData<TableView<?>, Number>("-fx-fixed-cell-size", SizeConverter.getInstance(), -1.0){

            @Override
            public Double getInitialValue(TableView<?> node) {
                return node.getFixedCellSize();
            }

            @Override
            public boolean isSettable(TableView<?> n) {
                return ((TableView)n).fixedCellSize == null || !((TableView)n).fixedCellSize.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TableView<?> n) {
                return (StyleableProperty)((Object)n.fixedCellSizeProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.add(FIXED_CELL_SIZE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

