/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.Utils;
import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.scene.control.FormatterAccessor;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.Control;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextInputControl$$Lambda$1;
import javafx.scene.control.TextInputControl$$Lambda$2;
import javafx.scene.control.TextInputControl$5$$Lambda$1;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.text.Font;
import javafx.util.StringConverter;

@DefaultProperty(value="text")
public abstract class TextInputControl
extends Control {
    private ObjectProperty<Font> font;
    private StringProperty promptText = new SimpleStringProperty(this, "promptText", ""){

        @Override
        protected void invalidated() {
            String txt = this.get();
            if (txt != null && txt.contains("\n")) {
                txt = txt.replace("\n", "");
                this.set(txt);
            }
        }
    };
    private final ObjectProperty<TextFormatter<?>> textFormatter = new ObjectPropertyBase<TextFormatter<?>>(){
        private TextFormatter<?> oldFormatter = null;

        @Override
        public Object getBean() {
            return TextInputControl.this;
        }

        @Override
        public String getName() {
            return "textFormatter";
        }

        @Override
        protected void invalidated() {
            TextFormatter formatter = (TextFormatter)this.get();
            try {
                if (formatter != null) {
                    try {
                        formatter.bindToControl(TextInputControl$5$$Lambda$1.lambdaFactory$(this));
                    }
                    catch (IllegalStateException e) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(null);
                        throw e;
                    }
                    if (!TextInputControl.this.isFocused()) {
                        TextInputControl.this.updateText((TextFormatter)this.get());
                    }
                }
                if (this.oldFormatter != null) {
                    this.oldFormatter.unbindFromControl();
                }
            }
            finally {
                this.oldFormatter = formatter;
            }
        }

        /* synthetic */ void lambda$invalidated$167(TextFormatter f) {
            TextInputControl.this.updateText(f);
        }
    };
    private final Content content;
    private TextProperty text = new TextProperty();
    private ReadOnlyIntegerWrapper length = new ReadOnlyIntegerWrapper(this, "length");
    private BooleanProperty editable = new SimpleBooleanProperty(this, "editable", true){

        @Override
        protected void invalidated() {
            TextInputControl.this.pseudoClassStateChanged(PSEUDO_CLASS_READONLY, !this.get());
        }
    };
    private ReadOnlyObjectWrapper<IndexRange> selection = new ReadOnlyObjectWrapper<IndexRange>(this, "selection", new IndexRange(0, 0));
    private ReadOnlyStringWrapper selectedText = new ReadOnlyStringWrapper(this, "selectedText");
    private ReadOnlyIntegerWrapper anchor = new ReadOnlyIntegerWrapper(this, "anchor", 0);
    private ReadOnlyIntegerWrapper caretPosition = new ReadOnlyIntegerWrapper(this, "caretPosition", 0);
    private UndoRedoChange undoChangeHead;
    private UndoRedoChange undoChange = this.undoChangeHead = new UndoRedoChange();
    private boolean createNewUndoRecord = false;
    private final ReadOnlyBooleanWrapper undoable = new ReadOnlyBooleanWrapper(this, "undoable", false);
    private final ReadOnlyBooleanWrapper redoable = new ReadOnlyBooleanWrapper(this, "redoable", false);
    private BreakIterator charIterator;
    private BreakIterator wordIterator;
    private FormatterAccessor accessor;
    private static final PseudoClass PSEUDO_CLASS_READONLY = PseudoClass.getPseudoClass("readonly");

    protected TextInputControl(Content content) {
        this.content = content;
        content.addListener(TextInputControl$$Lambda$1.lambdaFactory$(this, content));
        this.length.bind(new IntegerBinding(){
            {
                this.bind(TextInputControl.this.text);
            }

            @Override
            protected int computeValue() {
                String txt = TextInputControl.this.text.get();
                return txt == null ? 0 : txt.length();
            }
        });
        this.selectedText.bind(new StringBinding(){
            {
                this.bind(TextInputControl.this.selection, TextInputControl.this.text);
            }

            @Override
            protected String computeValue() {
                int length;
                String txt = TextInputControl.this.text.get();
                IndexRange sel = (IndexRange)TextInputControl.this.selection.get();
                if (txt == null || sel == null) {
                    return "";
                }
                int start = sel.getStart();
                int end = sel.getEnd();
                if (end > start + (length = txt.length())) {
                    end = length;
                }
                if (start > length - 1) {
                    end = 0;
                    start = 0;
                }
                return txt.substring(start, end);
            }
        });
        this.focusedProperty().addListener(TextInputControl$$Lambda$2.lambdaFactory$(this));
        this.getStyleClass().add("text-input");
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new StyleableObjectProperty<Font>(Font.getDefault()){
                private boolean fontSetByCss;
                {
                    this.fontSetByCss = false;
                }

                @Override
                public void applyStyle(StyleOrigin newOrigin, Font value) {
                    try {
                        this.fontSetByCss = true;
                        super.applyStyle(newOrigin, value);
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        this.fontSetByCss = false;
                    }
                }

                @Override
                public void set(Font value) {
                    Font oldValue = (Font)this.get();
                    if (value == null ? oldValue == null : value.equals(oldValue)) {
                        return;
                    }
                    super.set(value);
                }

                @Override
                protected void invalidated() {
                    if (!this.fontSetByCss) {
                        TextInputControl.this.impl_reapplyCSS();
                    }
                }

                @Override
                public CssMetaData<TextInputControl, Font> getCssMetaData() {
                    return StyleableProperties.FONT;
                }

                @Override
                public Object getBean() {
                    return TextInputControl.this;
                }

                @Override
                public String getName() {
                    return "font";
                }
            };
        }
        return this.font;
    }

    public final void setFont(Font value) {
        this.fontProperty().setValue(value);
    }

    public final Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.getValue();
    }

    public final StringProperty promptTextProperty() {
        return this.promptText;
    }

    public final String getPromptText() {
        return (String)this.promptText.get();
    }

    public final void setPromptText(String value) {
        this.promptText.set(value);
    }

    public final ObjectProperty<TextFormatter<?>> textFormatterProperty() {
        return this.textFormatter;
    }

    public final TextFormatter<?> getTextFormatter() {
        return (TextFormatter)this.textFormatter.get();
    }

    public final void setTextFormatter(TextFormatter<?> value) {
        this.textFormatter.set(value);
    }

    protected final Content getContent() {
        return this.content;
    }

    public final String getText() {
        return this.text.get();
    }

    public final void setText(String value) {
        this.text.set(value);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final int getLength() {
        return this.length.get();
    }

    public final ReadOnlyIntegerProperty lengthProperty() {
        return this.length.getReadOnlyProperty();
    }

    public final boolean isEditable() {
        return this.editable.getValue();
    }

    public final void setEditable(boolean value) {
        this.editable.setValue(value);
    }

    public final BooleanProperty editableProperty() {
        return this.editable;
    }

    public final IndexRange getSelection() {
        return (IndexRange)this.selection.getValue();
    }

    public final ReadOnlyObjectProperty<IndexRange> selectionProperty() {
        return this.selection.getReadOnlyProperty();
    }

    public final String getSelectedText() {
        return this.selectedText.get();
    }

    public final ReadOnlyStringProperty selectedTextProperty() {
        return this.selectedText.getReadOnlyProperty();
    }

    public final int getAnchor() {
        return this.anchor.get();
    }

    public final ReadOnlyIntegerProperty anchorProperty() {
        return this.anchor.getReadOnlyProperty();
    }

    public final int getCaretPosition() {
        return this.caretPosition.get();
    }

    public final ReadOnlyIntegerProperty caretPositionProperty() {
        return this.caretPosition.getReadOnlyProperty();
    }

    public final boolean isUndoable() {
        return this.undoable.get();
    }

    public final ReadOnlyBooleanProperty undoableProperty() {
        return this.undoable.getReadOnlyProperty();
    }

    public final boolean isRedoable() {
        return this.redoable.get();
    }

    public final ReadOnlyBooleanProperty redoableProperty() {
        return this.redoable.getReadOnlyProperty();
    }

    public String getText(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("The start must be <= the end");
        }
        if (start < 0 || end > this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        return this.getContent().get(start, end);
    }

    public void appendText(String text) {
        this.insertText(this.getLength(), text);
    }

    public void insertText(int index, String text) {
        this.replaceText(index, index, text);
    }

    public void deleteText(IndexRange range) {
        this.replaceText(range, "");
    }

    public void deleteText(int start, int end) {
        this.replaceText(start, end, "");
    }

    public void replaceText(IndexRange range, String text) {
        int start = range.getStart();
        int end = start + range.getLength();
        this.replaceText(start, end, text);
    }

    public void replaceText(int start, int end, String text) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        if (text == null) {
            throw new NullPointerException();
        }
        if (start < 0 || end > this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.text.isBound()) {
            int oldLength = this.getLength();
            TextFormatter<?> formatter = this.getTextFormatter();
            TextFormatter.Change change = new TextFormatter.Change(this, this.getFormatterAccessor(), start, end, text);
            if (formatter != null && formatter.getFilter() != null && (change = (TextFormatter.Change)formatter.getFilter().apply(change)) == null) {
                return;
            }
            this.updateContent(change, oldLength == 0);
        }
    }

    private void updateContent(TextFormatter.Change change, boolean forceNewUndoRecord) {
        boolean nonEmptySelection = this.getSelection().getLength() > 0;
        String oldText = this.getText(change.start, change.end);
        int adjustmentAmount = this.replaceText(change.start, change.end, change.text, change.getAnchor(), change.getCaretPosition());
        int endOfUndoChange = this.undoChange == this.undoChangeHead ? -1 : this.undoChange.start + this.undoChange.newText.length();
        String newText = this.getText(change.start, change.start + change.text.length() - adjustmentAmount);
        if (this.createNewUndoRecord || nonEmptySelection || endOfUndoChange == -1 || forceNewUndoRecord || endOfUndoChange != change.start && endOfUndoChange != change.end || change.start - change.end > 1) {
            this.undoChange = this.undoChange.add(change.start, oldText, newText);
        } else if (change.start != change.end && change.text.isEmpty()) {
            if (this.undoChange.newText.length() > 0) {
                this.undoChange.newText = this.undoChange.newText.substring(0, change.start - this.undoChange.start);
                if (this.undoChange.newText.isEmpty()) {
                    this.undoChange = this.undoChange.discard();
                }
            } else if (change.start == endOfUndoChange) {
                this.undoChange.oldText = this.undoChange.oldText + oldText;
            } else {
                this.undoChange.oldText = oldText + this.undoChange.oldText;
                --this.undoChange.start;
            }
        } else {
            this.undoChange.newText = this.undoChange.newText + newText;
        }
        this.updateUndoRedoState();
    }

    public void cut() {
        this.copy();
        IndexRange selection = this.getSelection();
        this.deleteText(selection.getStart(), selection.getEnd());
    }

    public void copy() {
        String selectedText = this.getSelectedText();
        if (selectedText.length() > 0) {
            ClipboardContent content = new ClipboardContent();
            content.putString(selectedText);
            Clipboard.getSystemClipboard().setContent(content);
        }
    }

    public void paste() {
        String text;
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.hasString() && (text = clipboard.getString()) != null) {
            this.createNewUndoRecord = true;
            try {
                this.replaceSelection(text);
            }
            finally {
                this.createNewUndoRecord = false;
            }
        }
    }

    public void selectBackward() {
        if (this.getCaretPosition() > 0 && this.getLength() > 0) {
            if (this.charIterator == null) {
                this.charIterator = BreakIterator.getCharacterInstance();
            }
            this.charIterator.setText(this.getText());
            this.selectRange(this.getAnchor(), this.charIterator.preceding(this.getCaretPosition()));
        }
    }

    public void selectForward() {
        int textLength = this.getLength();
        if (textLength > 0 && this.getCaretPosition() < textLength) {
            if (this.charIterator == null) {
                this.charIterator = BreakIterator.getCharacterInstance();
            }
            this.charIterator.setText(this.getText());
            this.selectRange(this.getAnchor(), this.charIterator.following(this.getCaretPosition()));
        }
    }

    public void previousWord() {
        this.previousWord(false);
    }

    public void nextWord() {
        this.nextWord(false);
    }

    public void endOfNextWord() {
        this.endOfNextWord(false);
    }

    public void selectPreviousWord() {
        this.previousWord(true);
    }

    public void selectNextWord() {
        this.nextWord(true);
    }

    public void selectEndOfNextWord() {
        this.endOfNextWord(true);
    }

    private void previousWord(boolean select) {
        int textLength = this.getLength();
        String text = this.getText();
        if (textLength <= 0) {
            return;
        }
        if (this.wordIterator == null) {
            this.wordIterator = BreakIterator.getWordInstance();
        }
        this.wordIterator.setText(text);
        int pos = this.wordIterator.preceding(Utils.clamp(0, this.getCaretPosition(), textLength));
        while (pos != -1 && !Character.isLetterOrDigit(text.charAt(Utils.clamp(0, pos, textLength - 1)))) {
            pos = this.wordIterator.preceding(Utils.clamp(0, pos, textLength));
        }
        this.selectRange(select ? this.getAnchor() : pos, pos);
    }

    private void nextWord(boolean select) {
        int textLength = this.getLength();
        String text = this.getText();
        if (textLength <= 0) {
            return;
        }
        if (this.wordIterator == null) {
            this.wordIterator = BreakIterator.getWordInstance();
        }
        this.wordIterator.setText(text);
        int last = this.wordIterator.following(Utils.clamp(0, this.getCaretPosition(), textLength - 1));
        int current = this.wordIterator.next();
        while (current != -1) {
            for (int p = last; p <= current; ++p) {
                char ch = text.charAt(Utils.clamp(0, p, textLength - 1));
                if (!Character.isLetterOrDigit(ch) && ch != '\n') continue;
                if (select) {
                    this.selectRange(this.getAnchor(), p);
                } else {
                    this.selectRange(p, p);
                }
                return;
            }
            last = current;
            current = this.wordIterator.next();
        }
        if (select) {
            this.selectRange(this.getAnchor(), textLength);
        } else {
            this.end();
        }
    }

    private void endOfNextWord(boolean select) {
        int textLength = this.getLength();
        String text = this.getText();
        if (textLength <= 0) {
            return;
        }
        if (this.wordIterator == null) {
            this.wordIterator = BreakIterator.getWordInstance();
        }
        this.wordIterator.setText(text);
        int last = this.wordIterator.following(Utils.clamp(0, this.getCaretPosition(), textLength));
        int current = this.wordIterator.next();
        while (current != -1) {
            for (int p = last; p <= current; ++p) {
                if (Character.isLetterOrDigit(text.charAt(Utils.clamp(0, p, textLength - 1)))) continue;
                if (select) {
                    this.selectRange(this.getAnchor(), p);
                } else {
                    this.selectRange(p, p);
                }
                return;
            }
            last = current;
            current = this.wordIterator.next();
        }
        if (select) {
            this.selectRange(this.getAnchor(), textLength);
        } else {
            this.end();
        }
    }

    public void selectAll() {
        this.selectRange(0, this.getLength());
    }

    public void home() {
        this.selectRange(0, 0);
    }

    public void end() {
        int textLength = this.getLength();
        if (textLength > 0) {
            this.selectRange(textLength, textLength);
        }
    }

    public void selectHome() {
        this.selectRange(this.getAnchor(), 0);
    }

    public void selectEnd() {
        int textLength = this.getLength();
        if (textLength > 0) {
            this.selectRange(this.getAnchor(), textLength);
        }
    }

    public boolean deletePreviousChar() {
        boolean failed = true;
        if (this.isEditable() && !this.isDisabled()) {
            int mark;
            String text = this.getText();
            int dot = this.getCaretPosition();
            if (dot != (mark = this.getAnchor())) {
                this.replaceSelection("");
                failed = false;
            } else if (dot > 0) {
                int p = Character.offsetByCodePoints(text, dot, -1);
                this.deleteText(p, dot);
                failed = false;
            }
        }
        return !failed;
    }

    public boolean deleteNextChar() {
        boolean failed = true;
        if (this.isEditable() && !this.isDisabled()) {
            int mark;
            String text = this.getText();
            int dot = this.getCaretPosition();
            if (dot != (mark = this.getAnchor())) {
                this.replaceSelection("");
                failed = false;
            } else if (text.length() > 0 && dot < text.length()) {
                if (this.charIterator == null) {
                    this.charIterator = BreakIterator.getCharacterInstance();
                }
                this.charIterator.setText(text);
                int p = this.charIterator.following(dot);
                this.deleteText(dot, p);
                failed = false;
            }
        }
        return !failed;
    }

    public void forward() {
        int mark;
        int textLength = this.getLength();
        int dot = this.getCaretPosition();
        if (dot != (mark = this.getAnchor())) {
            int pos = Math.max(dot, mark);
            this.selectRange(pos, pos);
        } else if (dot < textLength && textLength > 0) {
            if (this.charIterator == null) {
                this.charIterator = BreakIterator.getCharacterInstance();
            }
            this.charIterator.setText(this.getText());
            int pos = this.charIterator.following(dot);
            this.selectRange(pos, pos);
        }
        this.deselect();
    }

    public void backward() {
        int mark;
        int textLength = this.getLength();
        int dot = this.getCaretPosition();
        if (dot != (mark = this.getAnchor())) {
            int pos = Math.min(dot, mark);
            this.selectRange(pos, pos);
        } else if (dot > 0 && textLength > 0) {
            if (this.charIterator == null) {
                this.charIterator = BreakIterator.getCharacterInstance();
            }
            this.charIterator.setText(this.getText());
            int pos = this.charIterator.preceding(dot);
            this.selectRange(pos, pos);
        }
        this.deselect();
    }

    public void positionCaret(int pos) {
        int p = Utils.clamp(0, pos, this.getLength());
        this.selectRange(p, p);
    }

    public void selectPositionCaret(int pos) {
        this.selectRange(this.getAnchor(), Utils.clamp(0, pos, this.getLength()));
    }

    public void selectRange(int anchor, int caretPosition) {
        caretPosition = Utils.clamp(0, caretPosition, this.getLength());
        anchor = Utils.clamp(0, anchor, this.getLength());
        TextFormatter.Change change = new TextFormatter.Change(this, this.getFormatterAccessor(), anchor, caretPosition);
        TextFormatter<?> formatter = this.getTextFormatter();
        if (formatter != null && formatter.getFilter() != null && (change = (TextFormatter.Change)formatter.getFilter().apply(change)) == null) {
            return;
        }
        this.updateContent(change, false);
    }

    private void doSelectRange(int anchor, int caretPosition) {
        this.caretPosition.set(Utils.clamp(0, caretPosition, this.getLength()));
        this.anchor.set(Utils.clamp(0, anchor, this.getLength()));
        this.selection.set(IndexRange.normalize(this.getAnchor(), this.getCaretPosition()));
        this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_START);
    }

    public void extendSelection(int pos) {
        int p = Utils.clamp(0, pos, this.getLength());
        int dot = this.getCaretPosition();
        int mark = this.getAnchor();
        int start = Math.min(dot, mark);
        int end = Math.max(dot, mark);
        if (p < start) {
            this.selectRange(end, p);
        } else {
            this.selectRange(start, p);
        }
    }

    public void clear() {
        this.deselect();
        if (!this.text.isBound()) {
            this.setText("");
        }
    }

    public void deselect() {
        this.selectRange(this.getCaretPosition(), this.getCaretPosition());
    }

    public void replaceSelection(String replacement) {
        this.replaceText(this.getSelection(), replacement);
    }

    public final void undo() {
        if (this.isUndoable()) {
            int start = this.undoChange.start;
            String newText = this.undoChange.newText;
            String oldText = this.undoChange.oldText;
            if (newText != null) {
                this.getContent().delete(start, start + newText.length(), oldText.isEmpty());
            }
            if (oldText != null) {
                this.getContent().insert(start, oldText, true);
                this.doSelectRange(start, start + oldText.length());
            } else {
                this.doSelectRange(start, start + newText.length());
            }
            this.undoChange = this.undoChange.prev;
        }
        this.updateUndoRedoState();
    }

    public final void redo() {
        if (this.isRedoable()) {
            this.undoChange = this.undoChange.next;
            int start = this.undoChange.start;
            String newText = this.undoChange.newText;
            String oldText = this.undoChange.oldText;
            if (oldText != null) {
                this.getContent().delete(start, start + oldText.length(), newText.isEmpty());
            }
            if (newText != null) {
                this.getContent().insert(start, newText, true);
                this.doSelectRange(start + newText.length(), start + newText.length());
            } else {
                this.doSelectRange(start, start);
            }
        }
        this.updateUndoRedoState();
    }

    void textUpdated() {
    }

    private void resetUndoRedoState() {
        this.undoChange = this.undoChangeHead;
        this.undoChange.next = null;
        this.updateUndoRedoState();
    }

    private void updateUndoRedoState() {
        this.undoable.set(this.undoChange != this.undoChangeHead);
        this.redoable.set(this.undoChange.next != null);
    }

    private boolean filterAndSet(String value) {
        TextFormatter<?> formatter = this.getTextFormatter();
        int length = this.content.length();
        if (formatter != null && formatter.getFilter() != null && !this.text.isBound()) {
            TextFormatter.Change change = new TextFormatter.Change(this, this.getFormatterAccessor(), 0, length, value, 0, 0);
            change = (TextFormatter.Change)formatter.getFilter().apply(change);
            if (change == null) {
                return false;
            }
            this.replaceText(change.start, change.end, change.text, change.getAnchor(), change.getCaretPosition());
        } else {
            this.replaceText(0, length, value, 0, 0);
        }
        return true;
    }

    private int replaceText(int start, int end, String value, int anchor, int caretPosition) {
        int length = this.getLength();
        int adjustmentAmount = 0;
        if (end != start) {
            this.getContent().delete(start, end, value.isEmpty());
            length -= end - start;
        }
        if (value != null) {
            this.getContent().insert(start, value, true);
            adjustmentAmount = value.length() - (this.getLength() - length);
            anchor -= adjustmentAmount;
            caretPosition -= adjustmentAmount;
        }
        this.doSelectRange(anchor, caretPosition);
        return adjustmentAmount;
    }

    private <T> void updateText(TextFormatter<T> formatter) {
        T value = formatter.getValue();
        StringConverter<T> converter = formatter.getValueConverter();
        if (converter != null) {
            String text = converter.toString(value);
            this.replaceText(0, this.getLength(), text, text.length(), text.length());
        }
    }

    public final void commitValue() {
        if (this.getTextFormatter() != null) {
            this.getTextFormatter().updateValue(this.getText());
        }
    }

    public final void cancelEdit() {
        if (this.getTextFormatter() != null) {
            this.updateText(this.getTextFormatter());
        }
    }

    private FormatterAccessor getFormatterAccessor() {
        if (this.accessor == null) {
            this.accessor = new TextInputControlFromatterAccessor();
        }
        return this.accessor;
    }

    static String filterInput(String txt, boolean stripNewlines, boolean stripTabs) {
        if (TextInputControl.containsInvalidCharacters(txt, stripNewlines, stripTabs)) {
            StringBuilder s = new StringBuilder(txt.length());
            for (int i = 0; i < txt.length(); ++i) {
                char c = txt.charAt(i);
                if (TextInputControl.isInvalidCharacter(c, stripNewlines, stripTabs)) continue;
                s.append(c);
            }
            txt = s.toString();
        }
        return txt;
    }

    static boolean containsInvalidCharacters(String txt, boolean newlineIllegal, boolean tabIllegal) {
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (!TextInputControl.isInvalidCharacter(c, newlineIllegal, tabIllegal)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInvalidCharacter(char c, boolean newlineIllegal, boolean tabIllegal) {
        if (c == '\u007f') {
            return true;
        }
        if (c == '\n') {
            return newlineIllegal;
        }
        if (c == '\t') {
            return tabIllegal;
        }
        return c < ' ';
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TextInputControl.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case TEXT: {
                String accText = this.getAccessibleText();
                if (accText != null && !accText.isEmpty()) {
                    return accText;
                }
                String text = this.getText();
                if (text == null || text.isEmpty()) {
                    text = this.getPromptText();
                }
                return text;
            }
            case EDITABLE: {
                return this.isEditable();
            }
            case SELECTION_START: {
                return this.getSelection().getStart();
            }
            case SELECTION_END: {
                return this.getSelection().getEnd();
            }
            case CARET_OFFSET: {
                return this.getCaretPosition();
            }
            case FONT: {
                return this.getFont();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case SET_TEXT: {
                String value = (String)parameters[0];
                if (value != null) {
                    this.setText(value);
                }
            }
            case SET_TEXT_SELECTION: {
                Integer start = (Integer)parameters[0];
                Integer end = (Integer)parameters[1];
                if (start == null || end == null) break;
                this.selectRange(start, end);
                break;
            }
            default: {
                super.executeAccessibleAction(action, parameters);
            }
        }
    }

    /* synthetic */ void lambda$new$166(ObservableValue ob, Boolean o, Boolean n) {
        if (n.booleanValue()) {
            if (this.getTextFormatter() != null) {
                this.updateText(this.getTextFormatter());
            }
        } else {
            this.commitValue();
        }
    }

    /* synthetic */ void lambda$new$165(Content content, Observable observable) {
        if (content.length() > 0) {
            this.text.textIsNull = false;
        }
        this.text.controlContentHasChanged();
    }

    private class TextInputControlFromatterAccessor
    implements FormatterAccessor {
        private TextInputControlFromatterAccessor() {
        }

        @Override
        public int getTextLength() {
            return TextInputControl.this.getLength();
        }

        @Override
        public String getText(int begin, int end) {
            return TextInputControl.this.getText(begin, end);
        }

        @Override
        public int getCaret() {
            return TextInputControl.this.getCaretPosition();
        }

        @Override
        public int getAnchor() {
            return TextInputControl.this.getAnchor();
        }
    }

    private static class StyleableProperties {
        private static final FontCssMetaData<TextInputControl> FONT = new FontCssMetaData<TextInputControl>("-fx-font", Font.getDefault()){

            @Override
            public boolean isSettable(TextInputControl n) {
                return n.font == null || !n.font.isBound();
            }

            @Override
            public StyleableProperty<Font> getStyleableProperty(TextInputControl n) {
                return (StyleableProperty)((Object)n.fontProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.add(FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    static class UndoRedoChange {
        int start;
        String oldText;
        String newText;
        UndoRedoChange prev;
        UndoRedoChange next;

        UndoRedoChange() {
        }

        public UndoRedoChange add(int start, String oldText, String newText) {
            UndoRedoChange c = new UndoRedoChange();
            c.start = start;
            c.oldText = oldText;
            c.newText = newText;
            c.prev = this;
            this.next = c;
            return c;
        }

        public UndoRedoChange discard() {
            this.prev.next = this.next;
            return this.prev;
        }

        void debugPrint() {
            UndoRedoChange c = this;
            System.out.print("[");
            while (c != null) {
                System.out.print(c.toString());
                if (c.next != null) {
                    System.out.print(", ");
                }
                c = c.next;
            }
            System.out.println("]");
        }

        public String toString() {
            if (this.oldText == null && this.newText == null) {
                return "head";
            }
            if (this.oldText.isEmpty() && !this.newText.isEmpty()) {
                return "added '" + this.newText + "' at index " + this.start;
            }
            if (!this.oldText.isEmpty() && !this.newText.isEmpty()) {
                return "replaced '" + this.oldText + "' with '" + this.newText + "' at index " + this.start;
            }
            return "deleted '" + this.oldText + "' at index " + this.start;
        }
    }

    private class TextProperty
    extends StringProperty {
        private ObservableValue<? extends String> observable = null;
        private InvalidationListener listener = null;
        private ExpressionHelper<String> helper = null;
        private boolean textIsNull = false;

        private TextProperty() {
        }

        @Override
        public String get() {
            return this.textIsNull ? null : (String)TextInputControl.this.content.get();
        }

        @Override
        public void set(String value) {
            if (this.isBound()) {
                throw new RuntimeException("A bound value cannot be set.");
            }
            this.doSet(value);
            this.markInvalid();
        }

        private void controlContentHasChanged() {
            this.markInvalid();
            TextInputControl.this.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT);
        }

        @Override
        public void bind(ObservableValue<? extends String> observable) {
            if (observable == null) {
                throw new NullPointerException("Cannot bind to null");
            }
            if (!observable.equals(this.observable)) {
                this.unbind();
                this.observable = observable;
                if (this.listener == null) {
                    this.listener = new Listener();
                }
                this.observable.addListener(this.listener);
                this.markInvalid();
                this.doSet(observable.getValue());
            }
        }

        @Override
        public void unbind() {
            if (this.observable != null) {
                this.doSet(this.observable.getValue());
                this.observable.removeListener(this.listener);
                this.observable = null;
            }
        }

        @Override
        public boolean isBound() {
            return this.observable != null;
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(ChangeListener<? super String> listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(ChangeListener<? super String> listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public Object getBean() {
            return TextInputControl.this;
        }

        @Override
        public String getName() {
            return "text";
        }

        private void fireValueChangedEvent() {
            ExpressionHelper.fireValueChangedEvent(this.helper);
        }

        private void markInvalid() {
            this.fireValueChangedEvent();
        }

        private void doSet(String value) {
            boolean bl = this.textIsNull = value == null;
            if (value == null) {
                value = "";
            }
            if (!TextInputControl.this.filterAndSet(value)) {
                return;
            }
            if (TextInputControl.this.getTextFormatter() != null) {
                TextInputControl.this.getTextFormatter().updateValue(TextInputControl.this.getText());
            }
            TextInputControl.this.textUpdated();
            TextInputControl.this.resetUndoRedoState();
        }

        private class Listener
        implements InvalidationListener {
            private Listener() {
            }

            @Override
            public void invalidated(Observable valueModel) {
                TextProperty.this.doSet((String)TextProperty.this.observable.getValue());
            }
        }
    }

    protected static interface Content
    extends ObservableStringValue {
        public String get(int var1, int var2);

        public void insert(int var1, String var2, boolean var3);

        public void delete(int var1, int var2, boolean var3);

        public int length();
    }
}

