/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.event.EventHandlerManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.TreeItem$$Lambda$1;
import javafx.scene.control.TreeSortMode;

public class TreeItem<T>
implements EventTarget {
    private static final EventType<?> TREE_NOTIFICATION_EVENT = new EventType<Event>(Event.ANY, "TreeNotificationEvent");
    private static final EventType<?> EXPANDED_ITEM_COUNT_CHANGE_EVENT = new EventType(TreeItem.treeNotificationEvent(), "ExpandedItemCountChangeEvent");
    private static final EventType<?> BRANCH_EXPANDED_EVENT = new EventType(TreeItem.expandedItemCountChangeEvent(), "BranchExpandedEvent");
    private static final EventType<?> BRANCH_COLLAPSED_EVENT = new EventType(TreeItem.expandedItemCountChangeEvent(), "BranchCollapsedEvent");
    private static final EventType<?> CHILDREN_MODIFICATION_EVENT = new EventType(TreeItem.expandedItemCountChangeEvent(), "ChildrenModificationEvent");
    private static final EventType<?> VALUE_CHANGED_EVENT = new EventType(TreeItem.treeNotificationEvent(), "ValueChangedEvent");
    private static final EventType<?> GRAPHIC_CHANGED_EVENT = new EventType(TreeItem.treeNotificationEvent(), "GraphicChangedEvent");
    private final EventHandler<TreeModificationEvent<Object>> itemListener = new EventHandler<TreeModificationEvent<Object>>(){

        @Override
        public void handle(TreeModificationEvent<Object> event) {
            TreeItem.this.expandedDescendentCountDirty = true;
        }
    };
    private boolean ignoreSortUpdate = false;
    private boolean expandedDescendentCountDirty = true;
    ObservableList<TreeItem<T>> children;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager(this);
    private int expandedDescendentCount = 1;
    int previousExpandedDescendentCount = 1;
    Comparator<TreeItem<T>> lastComparator = null;
    TreeSortMode lastSortMode = null;
    private int parentLinkCount = 0;
    private ListChangeListener<TreeItem<T>> childrenListener = TreeItem$$Lambda$1.lambdaFactory$(this);
    private ObjectProperty<T> value;
    private ObjectProperty<Node> graphic;
    private BooleanProperty expanded;
    private ReadOnlyBooleanWrapper leaf;
    private ReadOnlyObjectWrapper<TreeItem<T>> parent = new ReadOnlyObjectWrapper(this, "parent");

    public static <T> EventType<TreeModificationEvent<T>> treeNotificationEvent() {
        return TREE_NOTIFICATION_EVENT;
    }

    public static <T> EventType<TreeModificationEvent<T>> expandedItemCountChangeEvent() {
        return EXPANDED_ITEM_COUNT_CHANGE_EVENT;
    }

    public static <T> EventType<TreeModificationEvent<T>> branchExpandedEvent() {
        return BRANCH_EXPANDED_EVENT;
    }

    public static <T> EventType<TreeModificationEvent<T>> branchCollapsedEvent() {
        return BRANCH_COLLAPSED_EVENT;
    }

    public static <T> EventType<TreeModificationEvent<T>> childrenModificationEvent() {
        return CHILDREN_MODIFICATION_EVENT;
    }

    public static <T> EventType<TreeModificationEvent<T>> valueChangedEvent() {
        return VALUE_CHANGED_EVENT;
    }

    public static <T> EventType<TreeModificationEvent<T>> graphicChangedEvent() {
        return GRAPHIC_CHANGED_EVENT;
    }

    public TreeItem() {
        this(null);
    }

    public TreeItem(T value) {
        this(value, null);
    }

    public TreeItem(T value, Node graphic) {
        this.setValue(value);
        this.setGraphic(graphic);
        this.addEventHandler(TreeItem.expandedItemCountChangeEvent(), this.itemListener);
    }

    public final void setValue(T value) {
        this.valueProperty().setValue(value);
    }

    public final T getValue() {
        return this.value == null ? null : (T)this.value.getValue();
    }

    public final ObjectProperty<T> valueProperty() {
        if (this.value == null) {
            this.value = new ObjectPropertyBase<T>(){

                @Override
                protected void invalidated() {
                    TreeItem.this.fireEvent(new TreeModificationEvent((EventType<? extends Event>)VALUE_CHANGED_EVENT, TreeItem.this, this.get()));
                }

                @Override
                public Object getBean() {
                    return TreeItem.this;
                }

                @Override
                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public final void setGraphic(Node value) {
        this.graphicProperty().setValue(value);
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.getValue();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new ObjectPropertyBase<Node>(){

                @Override
                protected void invalidated() {
                    TreeItem.this.fireEvent(new TreeModificationEvent(GRAPHIC_CHANGED_EVENT, TreeItem.this));
                }

                @Override
                public Object getBean() {
                    return TreeItem.this;
                }

                @Override
                public String getName() {
                    return "graphic";
                }
            };
        }
        return this.graphic;
    }

    public final void setExpanded(boolean value) {
        if (!value && this.expanded == null) {
            return;
        }
        this.expandedProperty().setValue(value);
    }

    public final boolean isExpanded() {
        return this.expanded == null ? false : this.expanded.getValue();
    }

    public final BooleanProperty expandedProperty() {
        if (this.expanded == null) {
            this.expanded = new BooleanPropertyBase(){

                @Override
                protected void invalidated() {
                    if (TreeItem.this.isLeaf()) {
                        return;
                    }
                    EventType evtType = TreeItem.this.isExpanded() ? BRANCH_EXPANDED_EVENT : BRANCH_COLLAPSED_EVENT;
                    TreeItem.this.fireEvent(new TreeModificationEvent((EventType<? extends Event>)evtType, TreeItem.this, TreeItem.this.isExpanded()));
                }

                @Override
                public Object getBean() {
                    return TreeItem.this;
                }

                @Override
                public String getName() {
                    return "expanded";
                }
            };
        }
        return this.expanded;
    }

    private void setLeaf(boolean value) {
        if (value && this.leaf == null) {
            return;
        }
        if (this.leaf == null) {
            this.leaf = new ReadOnlyBooleanWrapper(this, "leaf", true);
        }
        this.leaf.setValue(value);
    }

    public boolean isLeaf() {
        return this.leaf == null ? true : this.leaf.getValue();
    }

    public final ReadOnlyBooleanProperty leafProperty() {
        if (this.leaf == null) {
            this.leaf = new ReadOnlyBooleanWrapper(this, "leaf", true);
        }
        return this.leaf.getReadOnlyProperty();
    }

    private void setParent(TreeItem<T> value) {
        this.parent.setValue(value);
    }

    public final TreeItem<T> getParent() {
        return this.parent == null ? null : (TreeItem)this.parent.getValue();
    }

    public final ReadOnlyObjectProperty<TreeItem<T>> parentProperty() {
        return this.parent.getReadOnlyProperty();
    }

    public ObservableList<TreeItem<T>> getChildren() {
        if (this.children == null) {
            this.children = FXCollections.observableArrayList();
            this.children.addListener(this.childrenListener);
        }
        if (this.children.isEmpty()) {
            return this.children;
        }
        if (!this.ignoreSortUpdate) {
            this.checkSortState();
        }
        return this.children;
    }

    public TreeItem<T> previousSibling() {
        return this.previousSibling(this);
    }

    public TreeItem<T> previousSibling(TreeItem<T> beforeNode) {
        if (this.getParent() == null || beforeNode == null) {
            return null;
        }
        ObservableList<TreeItem<T>> parentChildren = this.getParent().getChildren();
        int childCount = parentChildren.size();
        int pos = -1;
        for (int i = 0; i < childCount; ++i) {
            if (!beforeNode.equals(parentChildren.get(i))) continue;
            pos = i - 1;
            return pos < 0 ? null : (TreeItem)parentChildren.get(pos);
        }
        return null;
    }

    public TreeItem<T> nextSibling() {
        return this.nextSibling(this);
    }

    public TreeItem<T> nextSibling(TreeItem<T> afterNode) {
        if (this.getParent() == null || afterNode == null) {
            return null;
        }
        ObservableList<TreeItem<T>> parentChildren = this.getParent().getChildren();
        int childCount = parentChildren.size();
        int pos = -1;
        for (int i = 0; i < childCount; ++i) {
            if (!afterNode.equals(parentChildren.get(i))) continue;
            pos = i + 1;
            return pos >= childCount ? null : (TreeItem)parentChildren.get(pos);
        }
        return null;
    }

    public String toString() {
        return "TreeItem [ value: " + this.getValue() + " ]";
    }

    private void fireEvent(TreeModificationEvent<T> evt) {
        Event.fireEvent(this, evt);
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        if (this.getParent() != null) {
            this.getParent().buildEventDispatchChain(tail);
        }
        return tail.append(this.eventHandlerManager);
    }

    public <E extends Event> void addEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    public <E extends Event> void removeEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    void sort() {
        this.sort(this.children, this.lastComparator, this.lastSortMode);
    }

    private void sort(ObservableList<TreeItem<T>> children, Comparator<TreeItem<T>> comparator, TreeSortMode sortMode) {
        if (comparator == null) {
            return;
        }
        this.runSort(children, comparator, sortMode);
        if (this.getParent() == null) {
            TreeModificationEvent e = new TreeModificationEvent(TreeItem.childrenModificationEvent(), this);
            e.wasPermutated = true;
            this.fireEvent(e);
        }
    }

    private void checkSortState() {
        TreeItem<T> rootNode = this.getRoot();
        TreeSortMode sortMode = rootNode.lastSortMode;
        Comparator<TreeItem<T>> comparator = rootNode.lastComparator;
        if (comparator != null && comparator != this.lastComparator) {
            this.lastComparator = comparator;
            this.runSort(this.children, comparator, sortMode);
        }
    }

    private void runSort(ObservableList<TreeItem<T>> children, Comparator<TreeItem<T>> comparator, TreeSortMode sortMode) {
        if (sortMode == TreeSortMode.ALL_DESCENDANTS) {
            this.doSort(children, comparator);
        } else if (sortMode == TreeSortMode.ONLY_FIRST_LEVEL && this.getParent() == null) {
            this.doSort(children, comparator);
        }
    }

    private TreeItem<T> getRoot() {
        TreeItem<T> parent = this.getParent();
        if (parent == null) {
            return this;
        }
        TreeItem<T> newParent;
        while ((newParent = parent.getParent()) != null) {
            parent = newParent;
        }
        return parent;
    }

    private void doSort(ObservableList<TreeItem<T>> children, Comparator<TreeItem<T>> comparator) {
        if (!this.isLeaf() && this.isExpanded()) {
            FXCollections.sort(children, comparator);
        }
    }

    int getExpandedDescendentCount(boolean reset) {
        if (reset || this.expandedDescendentCountDirty) {
            this.updateExpandedDescendentCount(reset);
            this.expandedDescendentCountDirty = false;
        }
        return this.expandedDescendentCount;
    }

    private void updateExpandedDescendentCount(boolean reset) {
        this.previousExpandedDescendentCount = this.expandedDescendentCount;
        this.expandedDescendentCount = 1;
        this.ignoreSortUpdate = true;
        if (!this.isLeaf() && this.isExpanded()) {
            for (TreeItem treeItem : this.getChildren()) {
                if (treeItem == null) continue;
                this.expandedDescendentCount += treeItem.isExpanded() ? treeItem.getExpandedDescendentCount(reset) : 1;
            }
        }
        this.ignoreSortUpdate = false;
    }

    private void updateChildren(ListChangeListener.Change<? extends TreeItem<T>> c) {
        this.setLeaf(this.children.isEmpty());
        List<? extends TreeItem<T>> added = c.getAddedSubList();
        List<? extends TreeItem<T>> removed = c.getRemoved();
        TreeItem.updateChildrenParent(removed, null);
        TreeItem.updateChildrenParent(added, this);
        this.fireEvent(new TreeModificationEvent(CHILDREN_MODIFICATION_EVENT, this, added, removed, c));
    }

    private static <T> void updateChildrenParent(List<? extends TreeItem<T>> treeItems, TreeItem<T> newParent) {
        if (treeItems == null) {
            return;
        }
        for (TreeItem<T> treeItem : treeItems) {
            boolean parentMatch;
            if (treeItem == null) continue;
            TreeItem<T> currentParent = treeItem.getParent();
            if (treeItem.parentLinkCount == 0) {
                super.setParent(newParent);
            }
            if (!(parentMatch = currentParent != null && currentParent.equals(newParent))) continue;
            if (newParent == null) {
                --treeItem.parentLinkCount;
                continue;
            }
            ++treeItem.parentLinkCount;
        }
    }

    /* synthetic */ void lambda$new$114(ListChangeListener.Change c) {
        this.expandedDescendentCountDirty = true;
        while (c.next()) {
            this.updateChildren(c);
        }
    }

    static /* synthetic */ EventType access$700() {
        return TREE_NOTIFICATION_EVENT;
    }

    public static class TreeModificationEvent<T>
    extends Event {
        private static final long serialVersionUID = 4741889985221719579L;
        public static final EventType<?> ANY = TreeItem.access$700();
        private final transient TreeItem<T> treeItem;
        private final T newValue;
        private final List<? extends TreeItem<T>> added;
        private final List<? extends TreeItem<T>> removed;
        private final ListChangeListener.Change<? extends TreeItem<T>> change;
        private final boolean wasExpanded;
        private final boolean wasCollapsed;
        private boolean wasPermutated;

        public TreeModificationEvent(EventType<? extends Event> eventType, TreeItem<T> treeItem) {
            this(eventType, treeItem, null);
        }

        public TreeModificationEvent(EventType<? extends Event> eventType, TreeItem<T> treeItem, T newValue) {
            super(eventType);
            this.treeItem = treeItem;
            this.newValue = newValue;
            this.added = null;
            this.removed = null;
            this.change = null;
            this.wasExpanded = false;
            this.wasCollapsed = false;
        }

        public TreeModificationEvent(EventType<? extends Event> eventType, TreeItem<T> treeItem, boolean expanded) {
            super(eventType);
            this.treeItem = treeItem;
            this.newValue = null;
            this.added = null;
            this.removed = null;
            this.change = null;
            this.wasExpanded = expanded;
            this.wasCollapsed = !expanded;
        }

        public TreeModificationEvent(EventType<? extends Event> eventType, TreeItem<T> treeItem, List<? extends TreeItem<T>> added, List<? extends TreeItem<T>> removed, ListChangeListener.Change<? extends TreeItem<T>> change) {
            super(eventType);
            this.treeItem = treeItem;
            this.newValue = null;
            this.added = added;
            this.removed = removed;
            this.change = change;
            this.wasExpanded = false;
            this.wasCollapsed = false;
            this.wasPermutated = added != null && removed != null && added.size() == removed.size() && added.containsAll(removed);
        }

        @Override
        public TreeItem<T> getSource() {
            return this.treeItem;
        }

        public TreeItem<T> getTreeItem() {
            return this.treeItem;
        }

        public T getNewValue() {
            return this.newValue;
        }

        public List<? extends TreeItem<T>> getAddedChildren() {
            return this.added == null ? Collections.emptyList() : this.added;
        }

        public List<? extends TreeItem<T>> getRemovedChildren() {
            return this.removed == null ? Collections.emptyList() : this.removed;
        }

        public int getRemovedSize() {
            return this.getRemovedChildren().size();
        }

        public int getAddedSize() {
            return this.getAddedChildren().size();
        }

        public boolean wasExpanded() {
            return this.wasExpanded;
        }

        public boolean wasCollapsed() {
            return this.wasCollapsed;
        }

        public boolean wasAdded() {
            return this.getAddedSize() > 0;
        }

        public boolean wasRemoved() {
            return this.getRemovedSize() > 0;
        }

        public boolean wasPermutated() {
            return this.wasPermutated;
        }

        int getFrom() {
            return this.change == null ? -1 : this.change.getFrom();
        }

        int getTo() {
            return this.change == null ? -1 : this.change.getTo();
        }
    }
}

