/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CellUtils;
import javafx.scene.control.cell.CheckBoxTreeCell$$Lambda$1;
import javafx.scene.control.cell.CheckBoxTreeCell$$Lambda$2;
import javafx.scene.control.cell.CheckBoxTreeCell$$Lambda$3;
import javafx.scene.control.cell.DefaultTreeCell;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class CheckBoxTreeCell<T>
extends DefaultTreeCell<T> {
    private final CheckBox checkBox;
    private ObservableValue<Boolean> booleanProperty;
    private BooleanProperty indeterminateProperty;
    private ObjectProperty<StringConverter<TreeItem<T>>> converter = new SimpleObjectProperty<StringConverter<TreeItem<T>>>(this, "converter");
    private ObjectProperty<Callback<TreeItem<T>, ObservableValue<Boolean>>> selectedStateCallback = new SimpleObjectProperty<Callback<TreeItem<T>, ObservableValue<Boolean>>>(this, "selectedStateCallback");

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView() {
        Callback getSelectedProperty = CheckBoxTreeCell$$Lambda$1.lambdaFactory$();
        return CheckBoxTreeCell.forTreeView(getSelectedProperty, CellUtils.defaultTreeItemStringConverter());
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(Callback<TreeItem<T>, ObservableValue<Boolean>> getSelectedProperty) {
        return CheckBoxTreeCell.forTreeView(getSelectedProperty, CellUtils.defaultTreeItemStringConverter());
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(Callback<TreeItem<T>, ObservableValue<Boolean>> getSelectedProperty, StringConverter<TreeItem<T>> converter) {
        return CheckBoxTreeCell$$Lambda$2.lambdaFactory$(getSelectedProperty, converter);
    }

    public CheckBoxTreeCell() {
        this(CheckBoxTreeCell$$Lambda$3.lambdaFactory$());
    }

    public CheckBoxTreeCell(Callback<TreeItem<T>, ObservableValue<Boolean>> getSelectedProperty) {
        this(getSelectedProperty, CellUtils.defaultTreeItemStringConverter(), null);
    }

    public CheckBoxTreeCell(Callback<TreeItem<T>, ObservableValue<Boolean>> getSelectedProperty, StringConverter<TreeItem<T>> converter) {
        this(getSelectedProperty, converter, null);
    }

    private CheckBoxTreeCell(Callback<TreeItem<T>, ObservableValue<Boolean>> getSelectedProperty, StringConverter<TreeItem<T>> converter, Callback<TreeItem<T>, ObservableValue<Boolean>> getIndeterminateProperty) {
        this.getStyleClass().add("check-box-tree-cell");
        this.setSelectedStateCallback(getSelectedProperty);
        this.setConverter(converter);
        this.checkBox = new CheckBox();
        this.checkBox.setAllowIndeterminate(false);
        this.setGraphic(null);
    }

    public final ObjectProperty<StringConverter<TreeItem<T>>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<TreeItem<T>> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<TreeItem<T>> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public final ObjectProperty<Callback<TreeItem<T>, ObservableValue<Boolean>>> selectedStateCallbackProperty() {
        return this.selectedStateCallback;
    }

    public final void setSelectedStateCallback(Callback<TreeItem<T>, ObservableValue<Boolean>> value) {
        this.selectedStateCallbackProperty().set(value);
    }

    public final Callback<TreeItem<T>, ObservableValue<Boolean>> getSelectedStateCallback() {
        return (Callback)this.selectedStateCallbackProperty().get();
    }

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            StringConverter c = this.getConverter();
            TreeItem treeItem = this.getTreeItem();
            this.setText(c != null ? c.toString(treeItem) : (treeItem == null ? "" : treeItem.toString()));
            this.checkBox.setGraphic(treeItem == null ? null : treeItem.getGraphic());
            this.setGraphic(this.checkBox);
            if (this.booleanProperty != null) {
                this.checkBox.selectedProperty().unbindBidirectional((BooleanProperty)this.booleanProperty);
            }
            if (this.indeterminateProperty != null) {
                this.checkBox.indeterminateProperty().unbindBidirectional(this.indeterminateProperty);
            }
            if (treeItem instanceof CheckBoxTreeItem) {
                CheckBoxTreeItem cbti = (CheckBoxTreeItem)treeItem;
                this.booleanProperty = cbti.selectedProperty();
                this.checkBox.selectedProperty().bindBidirectional((BooleanProperty)this.booleanProperty);
                this.indeterminateProperty = cbti.indeterminateProperty();
                this.checkBox.indeterminateProperty().bindBidirectional(this.indeterminateProperty);
            } else {
                Callback<TreeItem<T>, ObservableValue<Boolean>> callback = this.getSelectedStateCallback();
                if (callback == null) {
                    throw new NullPointerException("The CheckBoxTreeCell selectedStateCallbackProperty can not be null");
                }
                this.booleanProperty = callback.call(treeItem);
                if (this.booleanProperty != null) {
                    this.checkBox.selectedProperty().bindBidirectional((BooleanProperty)this.booleanProperty);
                }
            }
        }
    }

    @Override
    void updateDisplay(T item, boolean empty) {
    }

    static /* synthetic */ ObservableValue lambda$new$623(TreeItem item) {
        if (item instanceof CheckBoxTreeItem) {
            return ((CheckBoxTreeItem)item).selectedProperty();
        }
        return null;
    }

    static /* synthetic */ TreeCell lambda$forTreeView$622(Callback callback, StringConverter stringConverter, TreeView tree) {
        return new CheckBoxTreeCell(callback, stringConverter);
    }

    static /* synthetic */ ObservableValue lambda$forTreeView$621(TreeItem item) {
        if (item instanceof CheckBoxTreeItem) {
            return ((CheckBoxTreeItem)item).selectedProperty();
        }
        return null;
    }
}

