/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CellUtils;
import javafx.scene.control.cell.ChoiceBoxTreeCell$$Lambda$1;
import javafx.scene.control.cell.DefaultTreeCell;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ChoiceBoxTreeCell<T>
extends DefaultTreeCell<T> {
    private final ObservableList<T> items;
    private ChoiceBox<T> choiceBox;
    private HBox hbox;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>(this, "converter");

    @SafeVarargs
    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(T ... items) {
        return ChoiceBoxTreeCell.forTreeView(FXCollections.observableArrayList(items));
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(ObservableList<T> items) {
        return ChoiceBoxTreeCell.forTreeView(null, items);
    }

    @SafeVarargs
    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(StringConverter<T> converter, T ... items) {
        return ChoiceBoxTreeCell.forTreeView(converter, FXCollections.observableArrayList(items));
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(StringConverter<T> converter, ObservableList<T> items) {
        return ChoiceBoxTreeCell$$Lambda$1.lambdaFactory$(converter, items);
    }

    public ChoiceBoxTreeCell() {
        this(FXCollections.observableArrayList());
    }

    @SafeVarargs
    public ChoiceBoxTreeCell(T ... items) {
        this(FXCollections.observableArrayList(items));
    }

    @SafeVarargs
    public ChoiceBoxTreeCell(StringConverter<T> converter, T ... items) {
        this(converter, FXCollections.observableArrayList(items));
    }

    public ChoiceBoxTreeCell(ObservableList<T> items) {
        this((StringConverter<T>)null, items);
    }

    public ChoiceBoxTreeCell(StringConverter<T> converter, ObservableList<T> items) {
        this.getStyleClass().add("choice-box-tree-cell");
        this.items = items;
        this.setConverter(converter != null ? converter : CellUtils.defaultStringConverter());
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public ObservableList<T> getItems() {
        return this.items;
    }

    @Override
    public void startEdit() {
        if (!this.isEditable() || !this.getTreeView().isEditable()) {
            return;
        }
        TreeItem treeItem = this.getTreeItem();
        if (treeItem == null) {
            return;
        }
        if (this.choiceBox == null) {
            this.choiceBox = CellUtils.createChoiceBox(this, this.items, this.converterProperty());
        }
        if (this.hbox == null) {
            this.hbox = new HBox(CellUtils.TREE_VIEW_HBOX_GRAPHIC_PADDING);
        }
        this.choiceBox.getSelectionModel().select(treeItem.getValue());
        super.startEdit();
        if (this.isEditing()) {
            this.setText(null);
            Node graphic = this.getTreeItemGraphic();
            if (graphic != null) {
                this.hbox.getChildren().setAll((Node[])new Node[]{graphic, this.choiceBox});
                this.setGraphic(this.hbox);
            } else {
                this.setGraphic(this.choiceBox);
            }
        }
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.getConverter().toString(this.getItem()));
        this.setGraphic(null);
    }

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        CellUtils.updateItem(this, this.getConverter(), this.hbox, this.getTreeItemGraphic(), this.choiceBox);
    }

    private Node getTreeItemGraphic() {
        TreeItem treeItem = this.getTreeItem();
        return treeItem == null ? null : treeItem.getGraphic();
    }

    static /* synthetic */ TreeCell lambda$forTreeView$627(StringConverter stringConverter, ObservableList observableList, TreeView list) {
        return new ChoiceBoxTreeCell(stringConverter, observableList);
    }
}

