/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.Utils;
import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.scenario.effect.Blend;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Effect;

public class Blend
extends Effect {
    private ObjectProperty<BlendMode> mode;
    private DoubleProperty opacity;
    private ObjectProperty<Effect> bottomInput;
    private ObjectProperty<Effect> topInput;

    private static Blend.Mode toPGMode(BlendMode mode) {
        if (mode == null) {
            return Blend.Mode.SRC_OVER;
        }
        if (mode == BlendMode.SRC_OVER) {
            return Blend.Mode.SRC_OVER;
        }
        if (mode == BlendMode.SRC_ATOP) {
            return Blend.Mode.SRC_ATOP;
        }
        if (mode == BlendMode.ADD) {
            return Blend.Mode.ADD;
        }
        if (mode == BlendMode.MULTIPLY) {
            return Blend.Mode.MULTIPLY;
        }
        if (mode == BlendMode.SCREEN) {
            return Blend.Mode.SCREEN;
        }
        if (mode == BlendMode.OVERLAY) {
            return Blend.Mode.OVERLAY;
        }
        if (mode == BlendMode.DARKEN) {
            return Blend.Mode.DARKEN;
        }
        if (mode == BlendMode.LIGHTEN) {
            return Blend.Mode.LIGHTEN;
        }
        if (mode == BlendMode.COLOR_DODGE) {
            return Blend.Mode.COLOR_DODGE;
        }
        if (mode == BlendMode.COLOR_BURN) {
            return Blend.Mode.COLOR_BURN;
        }
        if (mode == BlendMode.HARD_LIGHT) {
            return Blend.Mode.HARD_LIGHT;
        }
        if (mode == BlendMode.SOFT_LIGHT) {
            return Blend.Mode.SOFT_LIGHT;
        }
        if (mode == BlendMode.DIFFERENCE) {
            return Blend.Mode.DIFFERENCE;
        }
        if (mode == BlendMode.EXCLUSION) {
            return Blend.Mode.EXCLUSION;
        }
        if (mode == BlendMode.RED) {
            return Blend.Mode.RED;
        }
        if (mode == BlendMode.GREEN) {
            return Blend.Mode.GREEN;
        }
        if (mode == BlendMode.BLUE) {
            return Blend.Mode.BLUE;
        }
        throw new AssertionError((Object)"Unrecognized blend mode: {mode}");
    }

    @Deprecated
    public static Blend.Mode impl_getToolkitMode(BlendMode mode) {
        return Blend.toPGMode(mode);
    }

    public Blend() {
    }

    public Blend(BlendMode mode) {
        this.setMode(mode);
    }

    public Blend(BlendMode mode, Effect bottomInput, Effect topInput) {
        this.setMode(mode);
        this.setBottomInput(bottomInput);
        this.setTopInput(topInput);
    }

    @Override
    com.sun.scenario.effect.Blend impl_createImpl() {
        return new com.sun.scenario.effect.Blend(Blend.toPGMode(BlendMode.SRC_OVER), com.sun.scenario.effect.Effect.DefaultInput, com.sun.scenario.effect.Effect.DefaultInput);
    }

    public final void setMode(BlendMode value) {
        this.modeProperty().set(value);
    }

    public final BlendMode getMode() {
        return this.mode == null ? BlendMode.SRC_OVER : (BlendMode)((Object)this.mode.get());
    }

    public final ObjectProperty<BlendMode> modeProperty() {
        if (this.mode == null) {
            this.mode = new ObjectPropertyBase<BlendMode>(BlendMode.SRC_OVER){

                @Override
                public void invalidated() {
                    Blend.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                @Override
                public Object getBean() {
                    return Blend.this;
                }

                @Override
                public String getName() {
                    return "mode";
                }
            };
        }
        return this.mode;
    }

    public final void setOpacity(double value) {
        this.opacityProperty().set(value);
    }

    public final double getOpacity() {
        return this.opacity == null ? 1.0 : this.opacity.get();
    }

    public final DoubleProperty opacityProperty() {
        if (this.opacity == null) {
            this.opacity = new DoublePropertyBase(1.0){

                @Override
                public void invalidated() {
                    Blend.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                @Override
                public Object getBean() {
                    return Blend.this;
                }

                @Override
                public String getName() {
                    return "opacity";
                }
            };
        }
        return this.opacity;
    }

    public final void setBottomInput(Effect value) {
        this.bottomInputProperty().set(value);
    }

    public final Effect getBottomInput() {
        return this.bottomInput == null ? null : (Effect)this.bottomInput.get();
    }

    public final ObjectProperty<Effect> bottomInputProperty() {
        if (this.bottomInput == null) {
            this.bottomInput = new Effect.EffectInputProperty(this, "bottomInput");
        }
        return this.bottomInput;
    }

    public final void setTopInput(Effect value) {
        this.topInputProperty().set(value);
    }

    public final Effect getTopInput() {
        return this.topInput == null ? null : (Effect)this.topInput.get();
    }

    public final ObjectProperty<Effect> topInputProperty() {
        if (this.topInput == null) {
            this.topInput = new Effect.EffectInputProperty(this, "topInput");
        }
        return this.topInput;
    }

    @Override
    boolean impl_checkChainContains(Effect e) {
        Effect localTopInput = this.getTopInput();
        Effect localBottomInput = this.getBottomInput();
        if (localTopInput == e || localBottomInput == e) {
            return true;
        }
        if (localTopInput != null && localTopInput.impl_checkChainContains(e)) {
            return true;
        }
        return localBottomInput != null && localBottomInput.impl_checkChainContains(e);
    }

    @Override
    void impl_update() {
        Effect localBottomInput = this.getBottomInput();
        Effect localTopInput = this.getTopInput();
        if (localTopInput != null) {
            localTopInput.impl_sync();
        }
        if (localBottomInput != null) {
            localBottomInput.impl_sync();
        }
        com.sun.scenario.effect.Blend peer = (com.sun.scenario.effect.Blend)this.impl_getImpl();
        peer.setTopInput(localTopInput == null ? null : localTopInput.impl_getImpl());
        peer.setBottomInput(localBottomInput == null ? null : localBottomInput.impl_getImpl());
        peer.setOpacity((float)Utils.clamp(0.0, this.getOpacity(), 1.0));
        peer.setMode(Blend.toPGMode(this.getMode()));
    }

    @Override
    @Deprecated
    public BaseBounds impl_getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        BaseBounds topBounds = new RectBounds();
        BaseBounds bottomBounds = new RectBounds();
        bottomBounds = Blend.getInputBounds(bottomBounds, tx, node, boundsAccessor, this.getBottomInput());
        topBounds = Blend.getInputBounds(topBounds, tx, node, boundsAccessor, this.getTopInput());
        BaseBounds ret = topBounds.deriveWithUnion(bottomBounds);
        return ret;
    }

    @Override
    @Deprecated
    public Effect impl_copy() {
        return new Blend(this.getMode(), this.getBottomInput(), this.getTopInput());
    }
}

