/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.Utils;
import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;

public class InnerShadow
extends Effect {
    private boolean changeIsLocal;
    private ObjectProperty<Effect> input;
    private DoubleProperty radius;
    private DoubleProperty width;
    private DoubleProperty height;
    private ObjectProperty<BlurType> blurType;
    private DoubleProperty choke;
    private ObjectProperty<Color> color;
    private DoubleProperty offsetX;
    private DoubleProperty offsetY;

    public InnerShadow() {
    }

    public InnerShadow(double radius, Color color) {
        this.setRadius(radius);
        this.setColor(color);
    }

    public InnerShadow(double radius, double offsetX, double offsetY, Color color) {
        this.setRadius(radius);
        this.setOffsetX(offsetX);
        this.setOffsetY(offsetY);
        this.setColor(color);
    }

    public InnerShadow(BlurType blurType, Color color, double radius, double choke, double offsetX, double offsetY) {
        this.setBlurType(blurType);
        this.setColor(color);
        this.setRadius(radius);
        this.setChoke(choke);
        this.setOffsetX(offsetX);
        this.setOffsetY(offsetY);
    }

    @Override
    com.sun.scenario.effect.InnerShadow impl_createImpl() {
        return new com.sun.scenario.effect.InnerShadow();
    }

    public final void setInput(Effect value) {
        this.inputProperty().set(value);
    }

    public final Effect getInput() {
        return this.input == null ? null : (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect.EffectInputProperty("input");
        }
        return this.input;
    }

    @Override
    boolean impl_checkChainContains(Effect e) {
        Effect localInput = this.getInput();
        if (localInput == null) {
            return false;
        }
        if (localInput == e) {
            return true;
        }
        return localInput.impl_checkChainContains(e);
    }

    public final void setRadius(double value) {
        this.radiusProperty().set(value);
    }

    public final double getRadius() {
        return this.radius == null ? 10.0 : this.radius.get();
    }

    public final DoubleProperty radiusProperty() {
        if (this.radius == null) {
            this.radius = new DoublePropertyBase(10.0){

                @Override
                public void invalidated() {
                    double localRadius = InnerShadow.this.getRadius();
                    if (!InnerShadow.this.changeIsLocal) {
                        InnerShadow.this.changeIsLocal = true;
                        InnerShadow.this.updateRadius(localRadius);
                        InnerShadow.this.changeIsLocal = false;
                        InnerShadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                        InnerShadow.this.effectBoundsChanged();
                    }
                }

                @Override
                public Object getBean() {
                    return InnerShadow.this;
                }

                @Override
                public String getName() {
                    return "radius";
                }
            };
        }
        return this.radius;
    }

    private void updateRadius(double value) {
        double newdim = value * 2.0 + 1.0;
        if (this.width != null && this.width.isBound()) {
            if (this.height == null || !this.height.isBound()) {
                this.setHeight(newdim * 2.0 - this.getWidth());
            }
        } else if (this.height != null && this.height.isBound()) {
            this.setWidth(newdim * 2.0 - this.getHeight());
        } else {
            this.setWidth(newdim);
            this.setHeight(newdim);
        }
    }

    public final void setWidth(double value) {
        this.widthProperty().set(value);
    }

    public final double getWidth() {
        return this.width == null ? 21.0 : this.width.get();
    }

    public final DoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new DoublePropertyBase(21.0){

                @Override
                public void invalidated() {
                    double localWidth = InnerShadow.this.getWidth();
                    if (!InnerShadow.this.changeIsLocal) {
                        InnerShadow.this.changeIsLocal = true;
                        InnerShadow.this.updateWidth(localWidth);
                        InnerShadow.this.changeIsLocal = false;
                        InnerShadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                        InnerShadow.this.effectBoundsChanged();
                    }
                }

                @Override
                public Object getBean() {
                    return InnerShadow.this;
                }

                @Override
                public String getName() {
                    return "width";
                }
            };
        }
        return this.width;
    }

    private void updateWidth(double value) {
        if (this.radius == null || !this.radius.isBound()) {
            double newrad = (value + this.getHeight()) / 2.0;
            if ((newrad = (newrad - 1.0) / 2.0) < 0.0) {
                newrad = 0.0;
            }
            this.setRadius(newrad);
        } else if (this.height == null || !this.height.isBound()) {
            double newdim = this.getRadius() * 2.0 + 1.0;
            this.setHeight(newdim * 2.0 - value);
        }
    }

    public final void setHeight(double value) {
        this.heightProperty().set(value);
    }

    public final double getHeight() {
        return this.height == null ? 21.0 : this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new DoublePropertyBase(21.0){

                @Override
                public void invalidated() {
                    double localHeight = InnerShadow.this.getHeight();
                    if (!InnerShadow.this.changeIsLocal) {
                        InnerShadow.this.changeIsLocal = true;
                        InnerShadow.this.updateHeight(localHeight);
                        InnerShadow.this.changeIsLocal = false;
                        InnerShadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                        InnerShadow.this.effectBoundsChanged();
                    }
                }

                @Override
                public Object getBean() {
                    return InnerShadow.this;
                }

                @Override
                public String getName() {
                    return "height";
                }
            };
        }
        return this.height;
    }

    private void updateHeight(double value) {
        if (this.radius == null || !this.radius.isBound()) {
            double newrad = (this.getWidth() + value) / 2.0;
            if ((newrad = (newrad - 1.0) / 2.0) < 0.0) {
                newrad = 0.0;
            }
            this.setRadius(newrad);
        } else if (this.width == null || !this.width.isBound()) {
            double newdim = this.getRadius() * 2.0 + 1.0;
            this.setWidth(newdim * 2.0 - value);
        }
    }

    public final void setBlurType(BlurType value) {
        this.blurTypeProperty().set(value);
    }

    public final BlurType getBlurType() {
        return this.blurType == null ? BlurType.THREE_PASS_BOX : (BlurType)((Object)this.blurType.get());
    }

    public final ObjectProperty<BlurType> blurTypeProperty() {
        if (this.blurType == null) {
            this.blurType = new ObjectPropertyBase<BlurType>(BlurType.THREE_PASS_BOX){

                @Override
                public void invalidated() {
                    InnerShadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                @Override
                public Object getBean() {
                    return InnerShadow.this;
                }

                @Override
                public String getName() {
                    return "blurType";
                }
            };
        }
        return this.blurType;
    }

    public final void setChoke(double value) {
        this.chokeProperty().set(value);
    }

    public final double getChoke() {
        return this.choke == null ? 0.0 : this.choke.get();
    }

    public final DoubleProperty chokeProperty() {
        if (this.choke == null) {
            this.choke = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    InnerShadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                @Override
                public Object getBean() {
                    return InnerShadow.this;
                }

                @Override
                public String getName() {
                    return "choke";
                }
            };
        }
        return this.choke;
    }

    public final void setColor(Color value) {
        this.colorProperty().set(value);
    }

    public final Color getColor() {
        return this.color == null ? Color.BLACK : (Color)this.color.get();
    }

    public final ObjectProperty<Color> colorProperty() {
        if (this.color == null) {
            this.color = new ObjectPropertyBase<Color>(Color.BLACK){

                @Override
                public void invalidated() {
                    InnerShadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                @Override
                public Object getBean() {
                    return InnerShadow.this;
                }

                @Override
                public String getName() {
                    return "color";
                }
            };
        }
        return this.color;
    }

    public final void setOffsetX(double value) {
        this.offsetXProperty().set(value);
    }

    public final double getOffsetX() {
        return this.offsetX == null ? 0.0 : this.offsetX.get();
    }

    public final DoubleProperty offsetXProperty() {
        if (this.offsetX == null) {
            this.offsetX = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    InnerShadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    InnerShadow.this.effectBoundsChanged();
                }

                @Override
                public Object getBean() {
                    return InnerShadow.this;
                }

                @Override
                public String getName() {
                    return "offsetX";
                }
            };
        }
        return this.offsetX;
    }

    public final void setOffsetY(double value) {
        this.offsetYProperty().set(value);
    }

    public final double getOffsetY() {
        return this.offsetY == null ? 0.0 : this.offsetY.get();
    }

    public final DoubleProperty offsetYProperty() {
        if (this.offsetY == null) {
            this.offsetY = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    InnerShadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    InnerShadow.this.effectBoundsChanged();
                }

                @Override
                public Object getBean() {
                    return InnerShadow.this;
                }

                @Override
                public String getName() {
                    return "offsetY";
                }
            };
        }
        return this.offsetY;
    }

    private Color getColorInternal() {
        Color c = this.getColor();
        return c == null ? Color.BLACK : c;
    }

    private BlurType getBlurTypeInternal() {
        BlurType bt = this.getBlurType();
        return bt == null ? BlurType.THREE_PASS_BOX : bt;
    }

    @Override
    void impl_update() {
        Effect localInput = this.getInput();
        if (localInput != null) {
            localInput.impl_sync();
        }
        com.sun.scenario.effect.InnerShadow peer = (com.sun.scenario.effect.InnerShadow)this.impl_getImpl();
        peer.setShadowSourceInput(localInput == null ? null : localInput.impl_getImpl());
        peer.setContentInput(localInput == null ? null : localInput.impl_getImpl());
        peer.setGaussianWidth((float)Utils.clamp(0.0, this.getWidth(), 255.0));
        peer.setGaussianHeight((float)Utils.clamp(0.0, this.getHeight(), 255.0));
        peer.setShadowMode(Toolkit.getToolkit().toShadowMode(this.getBlurTypeInternal()));
        peer.setColor(Toolkit.getToolkit().toColor4f(this.getColorInternal()));
        peer.setChoke((float)Utils.clamp(0.0, this.getChoke(), 1.0));
        peer.setOffsetX((int)this.getOffsetX());
        peer.setOffsetY((int)this.getOffsetY());
    }

    @Override
    @Deprecated
    public BaseBounds impl_getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        return InnerShadow.getInputBounds(bounds, tx, node, boundsAccessor, this.getInput());
    }

    @Override
    @Deprecated
    public Effect impl_copy() {
        InnerShadow is = new InnerShadow(this.getBlurType(), this.getColor(), this.getRadius(), this.getChoke(), this.getOffsetX(), this.getOffsetY());
        is.setInput(this.getInput());
        is.setWidth(this.getWidth());
        is.setHeight(this.getHeight());
        return is;
    }
}

