/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.WeakReferenceQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DataFormat {
    private static final WeakReferenceQueue<DataFormat> DATA_FORMAT_LIST = new WeakReferenceQueue();
    public static final DataFormat PLAIN_TEXT = new DataFormat("text/plain");
    public static final DataFormat HTML = new DataFormat("text/html");
    public static final DataFormat RTF = new DataFormat("text/rtf");
    public static final DataFormat URL = new DataFormat("text/uri-list");
    public static final DataFormat IMAGE = new DataFormat("application/x-java-rawimage");
    public static final DataFormat FILES = new DataFormat("application/x-java-file-list", "java.file-list");
    private static final DataFormat DRAG_IMAGE = new DataFormat("application/x-java-drag-image");
    private static final DataFormat DRAG_IMAGE_OFFSET = new DataFormat("application/x-java-drag-image-offset");
    private final Set<String> identifier;

    public DataFormat(String ... ids) {
        DATA_FORMAT_LIST.cleanup();
        if (ids != null) {
            for (String id : ids) {
                if (DataFormat.lookupMimeType(id) == null) continue;
                throw new IllegalArgumentException("DataFormat '" + id + "' already exists.");
            }
            this.identifier = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ids)));
        } else {
            this.identifier = Collections.emptySet();
        }
        DATA_FORMAT_LIST.add(this);
    }

    public final Set<String> getIdentifiers() {
        return this.identifier;
    }

    public String toString() {
        if (this.identifier.isEmpty()) {
            return "[]";
        }
        if (this.identifier.size() == 1) {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.identifier.iterator().next());
            return sb.append("]").toString();
        }
        StringBuilder b = new StringBuilder("[");
        Iterator<String> itr = this.identifier.iterator();
        while (itr.hasNext()) {
            b = b.append(itr.next());
            if (!itr.hasNext()) continue;
            b = b.append(", ");
        }
        b = b.append("]");
        return b.toString();
    }

    public int hashCode() {
        int hash = 7;
        for (String id : this.identifier) {
            hash = 31 * hash + id.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DataFormat)) {
            return false;
        }
        DataFormat otherDataFormat = (DataFormat)obj;
        return this.identifier.equals(otherDataFormat.identifier);
    }

    public static DataFormat lookupMimeType(String mimeType) {
        if (mimeType == null || mimeType.length() == 0) {
            return null;
        }
        Iterator<DataFormat> itr = DATA_FORMAT_LIST.iterator();
        while (itr.hasNext()) {
            DataFormat dataFormat = itr.next();
            if (!dataFormat.getIdentifiers().contains(mimeType)) continue;
            return dataFormat;
        }
        return null;
    }
}

