/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.converters.EnumConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane$$Lambda$1;
import javafx.scene.layout.StackPane$$Lambda$2;
import javafx.util.Callback;

public class StackPane
extends Pane {
    private boolean biasDirty = true;
    private boolean performingLayout = false;
    private Orientation bias;
    private static final String MARGIN_CONSTRAINT = "stackpane-margin";
    private static final String ALIGNMENT_CONSTRAINT = "stackpane-alignment";
    private static final Callback<Node, Insets> marginAccessor = StackPane$$Lambda$2.lambdaFactory$();
    private ObjectProperty<Pos> alignment;

    public static void setAlignment(Node child, Pos value) {
        StackPane.setConstraint(child, ALIGNMENT_CONSTRAINT, (Object)value);
    }

    public static Pos getAlignment(Node child) {
        return (Pos)((Object)StackPane.getConstraint(child, ALIGNMENT_CONSTRAINT));
    }

    public static void setMargin(Node child, Insets value) {
        StackPane.setConstraint(child, MARGIN_CONSTRAINT, value);
    }

    public static Insets getMargin(Node child) {
        return (Insets)StackPane.getConstraint(child, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node child) {
        StackPane.setAlignment(child, null);
        StackPane.setMargin(child, null);
    }

    public StackPane() {
    }

    public StackPane(Node ... children) {
        this.getChildren().addAll((Node[])children);
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.CENTER){

                @Override
                public void invalidated() {
                    StackPane.this.requestLayout();
                }

                @Override
                public CssMetaData<StackPane, Pos> getCssMetaData() {
                    return StyleableProperties.ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return StackPane.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos value) {
        this.alignmentProperty().set(value);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.CENTER : (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos localPos = this.getAlignment();
        return localPos == null ? Pos.CENTER : localPos;
    }

    @Override
    public Orientation getContentBias() {
        if (this.biasDirty) {
            this.bias = null;
            List children = this.getManagedChildren();
            for (Node child : children) {
                Orientation contentBias = child.getContentBias();
                if (contentBias == null) continue;
                this.bias = contentBias;
                if (contentBias != Orientation.HORIZONTAL) continue;
                break;
            }
            this.biasDirty = false;
        }
        return this.bias;
    }

    @Override
    protected double computeMinWidth(double height) {
        List<Node> managed = this.getManagedChildren();
        return this.getInsets().getLeft() + this.computeMaxMinAreaWidth(managed, marginAccessor, height, true) + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double width) {
        List<Node> managed = this.getManagedChildren();
        return this.getInsets().getTop() + this.computeMaxMinAreaHeight(managed, marginAccessor, this.getAlignmentInternal().getVpos(), width) + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double height) {
        List<Node> managed = this.getManagedChildren();
        Insets padding = this.getInsets();
        return padding.getLeft() + this.computeMaxPrefAreaWidth(managed, marginAccessor, height == -1.0 ? -1.0 : height - padding.getTop() - padding.getBottom(), true) + padding.getRight();
    }

    @Override
    protected double computePrefHeight(double width) {
        List<Node> managed = this.getManagedChildren();
        Insets padding = this.getInsets();
        return padding.getTop() + this.computeMaxPrefAreaHeight(managed, marginAccessor, width == -1.0 ? -1.0 : width - padding.getLeft() - padding.getRight(), this.getAlignmentInternal().getVpos()) + padding.getBottom();
    }

    @Override
    public void requestLayout() {
        if (this.performingLayout) {
            return;
        }
        this.biasDirty = true;
        this.bias = null;
        super.requestLayout();
    }

    @Override
    protected void layoutChildren() {
        this.performingLayout = true;
        List<Node> managed = this.getManagedChildren();
        Pos align = this.getAlignmentInternal();
        HPos alignHpos = align.getHpos();
        VPos alignVpos = align.getVpos();
        double width = this.getWidth();
        double height = this.getHeight();
        double top = this.getInsets().getTop();
        double right = this.getInsets().getRight();
        double left = this.getInsets().getLeft();
        double bottom = this.getInsets().getBottom();
        double contentWidth = width - left - right;
        double contentHeight = height - top - bottom;
        double baselineOffset = alignVpos == VPos.BASELINE ? this.getAreaBaselineOffset(managed, marginAccessor, StackPane$$Lambda$1.lambdaFactory$(width), contentHeight, true) : 0.0;
        int size = managed.size();
        for (int i = 0; i < size; ++i) {
            Node child = managed.get(i);
            Pos childAlignment = StackPane.getAlignment(child);
            this.layoutInArea(child, left, top, contentWidth, contentHeight, baselineOffset, StackPane.getMargin(child), childAlignment != null ? childAlignment.getHpos() : alignHpos, childAlignment != null ? childAlignment.getVpos() : alignVpos);
        }
        this.performingLayout = false;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StackPane.getClassCssMetaData();
    }

    static /* synthetic */ Double lambda$layoutChildren$502(double d, Integer i) {
        return d;
    }

    static /* synthetic */ Insets lambda$static$501(Node n) {
        return StackPane.getMargin(n);
    }

    private static class StyleableProperties {
        private static final CssMetaData<StackPane, Pos> ALIGNMENT = new CssMetaData<StackPane, Pos>("-fx-alignment", new EnumConverter<Pos>(Pos.class), Pos.CENTER){

            @Override
            public boolean isSettable(StackPane node) {
                return node.alignment == null || !node.alignment.isBound();
            }

            @Override
            public StyleableProperty<Pos> getStyleableProperty(StackPane node) {
                return (StyleableProperty)((Object)node.alignmentProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
            styleables.add(ALIGNMENT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

