/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.transform;

import com.sun.javafx.WeakReferenceQueue;
import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geometry.BoundsUtils;
import com.sun.javafx.scene.transform.TransformUtils;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import javafx.scene.transform.MatrixType;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Shear;
import javafx.scene.transform.TransformChangedEvent;
import javafx.scene.transform.Translate;

public abstract class Transform
implements Cloneable,
EventTarget {
    private SoftReference<Transform> inverseCache = null;
    private WeakReferenceQueue impl_nodes = new WeakReferenceQueue();
    private LazyBooleanProperty type2D;
    private LazyBooleanProperty identity;
    private EventHandlerManager internalEventDispatcher;
    private ObjectProperty<EventHandler<? super TransformChangedEvent>> onTransformChanged;

    public static Affine affine(double mxx, double myx, double mxy, double myy, double tx, double ty) {
        Affine affine = new Affine();
        affine.setMxx(mxx);
        affine.setMxy(mxy);
        affine.setTx(tx);
        affine.setMyx(myx);
        affine.setMyy(myy);
        affine.setTy(ty);
        return affine;
    }

    public static Affine affine(double mxx, double mxy, double mxz, double tx, double myx, double myy, double myz, double ty, double mzx, double mzy, double mzz, double tz) {
        Affine affine = new Affine();
        affine.setMxx(mxx);
        affine.setMxy(mxy);
        affine.setMxz(mxz);
        affine.setTx(tx);
        affine.setMyx(myx);
        affine.setMyy(myy);
        affine.setMyz(myz);
        affine.setTy(ty);
        affine.setMzx(mzx);
        affine.setMzy(mzy);
        affine.setMzz(mzz);
        affine.setTz(tz);
        return affine;
    }

    public static Translate translate(double x, double y) {
        Translate translate = new Translate();
        translate.setX(x);
        translate.setY(y);
        return translate;
    }

    public static Rotate rotate(double angle, double pivotX, double pivotY) {
        Rotate rotate = new Rotate();
        rotate.setAngle(angle);
        rotate.setPivotX(pivotX);
        rotate.setPivotY(pivotY);
        return rotate;
    }

    public static Scale scale(double x, double y) {
        Scale scale = new Scale();
        scale.setX(x);
        scale.setY(y);
        return scale;
    }

    public static Scale scale(double x, double y, double pivotX, double pivotY) {
        Scale scale = new Scale();
        scale.setX(x);
        scale.setY(y);
        scale.setPivotX(pivotX);
        scale.setPivotY(pivotY);
        return scale;
    }

    public static Shear shear(double x, double y) {
        Shear shear = new Shear();
        shear.setX(x);
        shear.setY(y);
        return shear;
    }

    public static Shear shear(double x, double y, double pivotX, double pivotY) {
        Shear shear = new Shear();
        shear.setX(x);
        shear.setY(y);
        shear.setPivotX(pivotX);
        shear.setPivotY(pivotY);
        return shear;
    }

    public double getMxx() {
        return 1.0;
    }

    public double getMxy() {
        return 0.0;
    }

    public double getMxz() {
        return 0.0;
    }

    public double getTx() {
        return 0.0;
    }

    public double getMyx() {
        return 0.0;
    }

    public double getMyy() {
        return 1.0;
    }

    public double getMyz() {
        return 0.0;
    }

    public double getTy() {
        return 0.0;
    }

    public double getMzx() {
        return 0.0;
    }

    public double getMzy() {
        return 0.0;
    }

    public double getMzz() {
        return 1.0;
    }

    public double getTz() {
        return 0.0;
    }

    public double getElement(MatrixType type, int row, int column) {
        if (row < 0 || row >= type.rows() || column < 0 || column >= type.columns()) {
            throw new IndexOutOfBoundsException("Index outside of affine matrix " + (Object)((Object)type) + ": [" + row + ", " + column + "]");
        }
        switch (type) {
            case MT_2D_2x3: 
            case MT_2D_3x3: {
                if (!this.isType2D()) {
                    throw new IllegalArgumentException("Cannot access 2D matrix of a 3D transform");
                }
                switch (row) {
                    case 0: {
                        switch (column) {
                            case 0: {
                                return this.getMxx();
                            }
                            case 1: {
                                return this.getMxy();
                            }
                            case 2: {
                                return this.getTx();
                            }
                        }
                    }
                    case 1: {
                        switch (column) {
                            case 0: {
                                return this.getMyx();
                            }
                            case 1: {
                                return this.getMyy();
                            }
                            case 2: {
                                return this.getTy();
                            }
                        }
                    }
                    case 2: {
                        switch (column) {
                            case 0: {
                                return 0.0;
                            }
                            case 1: {
                                return 0.0;
                            }
                            case 2: {
                                return 1.0;
                            }
                        }
                    }
                }
                break;
            }
            case MT_3D_3x4: 
            case MT_3D_4x4: {
                switch (row) {
                    case 0: {
                        switch (column) {
                            case 0: {
                                return this.getMxx();
                            }
                            case 1: {
                                return this.getMxy();
                            }
                            case 2: {
                                return this.getMxz();
                            }
                            case 3: {
                                return this.getTx();
                            }
                        }
                    }
                    case 1: {
                        switch (column) {
                            case 0: {
                                return this.getMyx();
                            }
                            case 1: {
                                return this.getMyy();
                            }
                            case 2: {
                                return this.getMyz();
                            }
                            case 3: {
                                return this.getTy();
                            }
                        }
                    }
                    case 2: {
                        switch (column) {
                            case 0: {
                                return this.getMzx();
                            }
                            case 1: {
                                return this.getMzy();
                            }
                            case 2: {
                                return this.getMzz();
                            }
                            case 3: {
                                return this.getTz();
                            }
                        }
                    }
                    case 3: {
                        switch (column) {
                            case 0: {
                                return 0.0;
                            }
                            case 1: {
                                return 0.0;
                            }
                            case 2: {
                                return 0.0;
                            }
                            case 3: {
                                return 1.0;
                            }
                        }
                    }
                }
            }
        }
        throw new InternalError("Unsupported matrix type " + (Object)((Object)type));
    }

    boolean computeIs2D() {
        return this.getMxz() == 0.0 && this.getMzx() == 0.0 && this.getMzy() == 0.0 && this.getMzz() == 1.0 && this.getTz() == 0.0;
    }

    boolean computeIsIdentity() {
        return this.getMxx() == 1.0 && this.getMxy() == 0.0 && this.getMxz() == 0.0 && this.getTx() == 0.0 && this.getMyx() == 0.0 && this.getMyy() == 1.0 && this.getMyz() == 0.0 && this.getTy() == 0.0 && this.getMzx() == 0.0 && this.getMzy() == 0.0 && this.getMzz() == 1.0 && this.getTz() == 0.0;
    }

    public double determinant() {
        double myx = this.getMyx();
        double myy = this.getMyy();
        double myz = this.getMyz();
        double mzx = this.getMzx();
        double mzy = this.getMzy();
        double mzz = this.getMzz();
        return this.getMxx() * (myy * mzz - mzy * myz) + this.getMxy() * (myz * mzx - mzz * myx) + this.getMxz() * (myx * mzy - mzx * myy);
    }

    public final boolean isType2D() {
        return this.type2D == null ? this.computeIs2D() : this.type2D.get();
    }

    public final ReadOnlyBooleanProperty type2DProperty() {
        if (this.type2D == null) {
            this.type2D = new LazyBooleanProperty(){

                @Override
                protected boolean computeValue() {
                    return Transform.this.computeIs2D();
                }

                @Override
                public Object getBean() {
                    return Transform.this;
                }

                @Override
                public String getName() {
                    return "type2D";
                }
            };
        }
        return this.type2D;
    }

    public final boolean isIdentity() {
        return this.identity == null ? this.computeIsIdentity() : this.identity.get();
    }

    public final ReadOnlyBooleanProperty identityProperty() {
        if (this.identity == null) {
            this.identity = new LazyBooleanProperty(){

                @Override
                protected boolean computeValue() {
                    return Transform.this.computeIsIdentity();
                }

                @Override
                public Object getBean() {
                    return Transform.this;
                }

                @Override
                public String getName() {
                    return "identity";
                }
            };
        }
        return this.identity;
    }

    private double transformDiff(Transform t, double x, double y) {
        Point2D byThis = this.transform(x, y);
        Point2D byOther = t.transform(x, y);
        return byThis.distance(byOther);
    }

    private double transformDiff(Transform t, double x, double y, double z) {
        Point3D byThis = this.transform(x, y, z);
        Point3D byOther = t.transform(x, y, z);
        return byThis.distance(byOther);
    }

    public boolean similarTo(Transform transform, Bounds range, double maxDelta) {
        double cornerZ;
        double cornerY;
        if (this.isType2D() && transform.isType2D()) {
            double cornerY2;
            double cornerX = range.getMinX();
            if (this.transformDiff(transform, cornerX, cornerY2 = range.getMinY()) > maxDelta) {
                return false;
            }
            cornerY2 = range.getMaxY();
            if (this.transformDiff(transform, cornerX, cornerY2) > maxDelta) {
                return false;
            }
            cornerX = range.getMaxX();
            if (this.transformDiff(transform, cornerX, cornerY2 = range.getMinY()) > maxDelta) {
                return false;
            }
            cornerY2 = range.getMaxY();
            return !(this.transformDiff(transform, cornerX, cornerY2) > maxDelta);
        }
        double cornerX = range.getMinX();
        if (this.transformDiff(transform, cornerX, cornerY = range.getMinY(), cornerZ = range.getMinZ()) > maxDelta) {
            return false;
        }
        cornerY = range.getMaxY();
        if (this.transformDiff(transform, cornerX, cornerY, cornerZ) > maxDelta) {
            return false;
        }
        cornerX = range.getMaxX();
        if (this.transformDiff(transform, cornerX, cornerY = range.getMinY(), cornerZ) > maxDelta) {
            return false;
        }
        cornerY = range.getMaxY();
        if (this.transformDiff(transform, cornerX, cornerY, cornerZ) > maxDelta) {
            return false;
        }
        if (range.getDepth() != 0.0) {
            cornerX = range.getMinX();
            if (this.transformDiff(transform, cornerX, cornerY = range.getMinY(), cornerZ = range.getMaxZ()) > maxDelta) {
                return false;
            }
            cornerY = range.getMaxY();
            if (this.transformDiff(transform, cornerX, cornerY, cornerZ) > maxDelta) {
                return false;
            }
            cornerX = range.getMaxX();
            if (this.transformDiff(transform, cornerX, cornerY = range.getMinY(), cornerZ) > maxDelta) {
                return false;
            }
            cornerY = range.getMaxY();
            if (this.transformDiff(transform, cornerX, cornerY, cornerZ) > maxDelta) {
                return false;
            }
        }
        return true;
    }

    void fill2DArray(double[] array) {
        array[0] = this.getMxx();
        array[1] = this.getMxy();
        array[2] = this.getTx();
        array[3] = this.getMyx();
        array[4] = this.getMyy();
        array[5] = this.getTy();
    }

    void fill3DArray(double[] array) {
        array[0] = this.getMxx();
        array[1] = this.getMxy();
        array[2] = this.getMxz();
        array[3] = this.getTx();
        array[4] = this.getMyx();
        array[5] = this.getMyy();
        array[6] = this.getMyz();
        array[7] = this.getTy();
        array[8] = this.getMzx();
        array[9] = this.getMzy();
        array[10] = this.getMzz();
        array[11] = this.getTz();
    }

    public double[] toArray(MatrixType type, double[] array) {
        this.checkRequestedMAT(type);
        if (array == null || array.length < type.elements()) {
            array = new double[type.elements()];
        }
        switch (type) {
            case MT_2D_3x3: {
                array[6] = 0.0;
                array[7] = 0.0;
                array[8] = 1.0;
            }
            case MT_2D_2x3: {
                this.fill2DArray(array);
                break;
            }
            case MT_3D_4x4: {
                array[12] = 0.0;
                array[13] = 0.0;
                array[14] = 0.0;
                array[15] = 1.0;
            }
            case MT_3D_3x4: {
                this.fill3DArray(array);
                break;
            }
            default: {
                throw new InternalError("Unsupported matrix type " + (Object)((Object)type));
            }
        }
        return array;
    }

    public double[] toArray(MatrixType type) {
        return this.toArray(type, null);
    }

    public double[] row(MatrixType type, int row, double[] array) {
        this.checkRequestedMAT(type);
        if (row < 0 || row >= type.rows()) {
            throw new IndexOutOfBoundsException("Cannot get row " + row + " from " + (Object)((Object)type));
        }
        if (array == null || array.length < type.columns()) {
            array = new double[type.columns()];
        }
        switch (type) {
            case MT_2D_2x3: 
            case MT_2D_3x3: {
                switch (row) {
                    case 0: {
                        array[0] = this.getMxx();
                        array[1] = this.getMxy();
                        array[2] = this.getTx();
                        break;
                    }
                    case 1: {
                        array[0] = this.getMyx();
                        array[1] = this.getMyy();
                        array[2] = this.getTy();
                        break;
                    }
                    case 2: {
                        array[0] = 0.0;
                        array[1] = 0.0;
                        array[2] = 1.0;
                    }
                }
                break;
            }
            case MT_3D_3x4: 
            case MT_3D_4x4: {
                switch (row) {
                    case 0: {
                        array[0] = this.getMxx();
                        array[1] = this.getMxy();
                        array[2] = this.getMxz();
                        array[3] = this.getTx();
                        break;
                    }
                    case 1: {
                        array[0] = this.getMyx();
                        array[1] = this.getMyy();
                        array[2] = this.getMyz();
                        array[3] = this.getTy();
                        break;
                    }
                    case 2: {
                        array[0] = this.getMzx();
                        array[1] = this.getMzy();
                        array[2] = this.getMzz();
                        array[3] = this.getTz();
                        break;
                    }
                    case 3: {
                        array[0] = 0.0;
                        array[1] = 0.0;
                        array[2] = 0.0;
                        array[3] = 1.0;
                    }
                }
                break;
            }
            default: {
                throw new InternalError("Unsupported row " + row + " of " + (Object)((Object)type));
            }
        }
        return array;
    }

    public double[] row(MatrixType type, int row) {
        return this.row(type, row, null);
    }

    public double[] column(MatrixType type, int column, double[] array) {
        this.checkRequestedMAT(type);
        if (column < 0 || column >= type.columns()) {
            throw new IndexOutOfBoundsException("Cannot get row " + column + " from " + (Object)((Object)type));
        }
        if (array == null || array.length < type.rows()) {
            array = new double[type.rows()];
        }
        switch (type) {
            case MT_2D_2x3: {
                switch (column) {
                    case 0: {
                        array[0] = this.getMxx();
                        array[1] = this.getMyx();
                        break;
                    }
                    case 1: {
                        array[0] = this.getMxy();
                        array[1] = this.getMyy();
                        break;
                    }
                    case 2: {
                        array[0] = this.getTx();
                        array[1] = this.getTy();
                    }
                }
                break;
            }
            case MT_2D_3x3: {
                switch (column) {
                    case 0: {
                        array[0] = this.getMxx();
                        array[1] = this.getMyx();
                        array[2] = 0.0;
                        break;
                    }
                    case 1: {
                        array[0] = this.getMxy();
                        array[1] = this.getMyy();
                        array[2] = 0.0;
                        break;
                    }
                    case 2: {
                        array[0] = this.getTx();
                        array[1] = this.getTy();
                        array[2] = 1.0;
                    }
                }
                break;
            }
            case MT_3D_3x4: {
                switch (column) {
                    case 0: {
                        array[0] = this.getMxx();
                        array[1] = this.getMyx();
                        array[2] = this.getMzx();
                        break;
                    }
                    case 1: {
                        array[0] = this.getMxy();
                        array[1] = this.getMyy();
                        array[2] = this.getMzy();
                        break;
                    }
                    case 2: {
                        array[0] = this.getMxz();
                        array[1] = this.getMyz();
                        array[2] = this.getMzz();
                        break;
                    }
                    case 3: {
                        array[0] = this.getTx();
                        array[1] = this.getTy();
                        array[2] = this.getTz();
                    }
                }
                break;
            }
            case MT_3D_4x4: {
                switch (column) {
                    case 0: {
                        array[0] = this.getMxx();
                        array[1] = this.getMyx();
                        array[2] = this.getMzx();
                        array[3] = 0.0;
                        break;
                    }
                    case 1: {
                        array[0] = this.getMxy();
                        array[1] = this.getMyy();
                        array[2] = this.getMzy();
                        array[3] = 0.0;
                        break;
                    }
                    case 2: {
                        array[0] = this.getMxz();
                        array[1] = this.getMyz();
                        array[2] = this.getMzz();
                        array[3] = 0.0;
                        break;
                    }
                    case 3: {
                        array[0] = this.getTx();
                        array[1] = this.getTy();
                        array[2] = this.getTz();
                        array[3] = 1.0;
                    }
                }
                break;
            }
            default: {
                throw new InternalError("Unsupported column " + column + " of " + (Object)((Object)type));
            }
        }
        return array;
    }

    public double[] column(MatrixType type, int column) {
        return this.column(type, column, null);
    }

    public Transform createConcatenation(Transform transform) {
        double txx = transform.getMxx();
        double txy = transform.getMxy();
        double txz = transform.getMxz();
        double ttx = transform.getTx();
        double tyx = transform.getMyx();
        double tyy = transform.getMyy();
        double tyz = transform.getMyz();
        double tty = transform.getTy();
        double tzx = transform.getMzx();
        double tzy = transform.getMzy();
        double tzz = transform.getMzz();
        double ttz = transform.getTz();
        return new Affine(this.getMxx() * txx + this.getMxy() * tyx + this.getMxz() * tzx, this.getMxx() * txy + this.getMxy() * tyy + this.getMxz() * tzy, this.getMxx() * txz + this.getMxy() * tyz + this.getMxz() * tzz, this.getMxx() * ttx + this.getMxy() * tty + this.getMxz() * ttz + this.getTx(), this.getMyx() * txx + this.getMyy() * tyx + this.getMyz() * tzx, this.getMyx() * txy + this.getMyy() * tyy + this.getMyz() * tzy, this.getMyx() * txz + this.getMyy() * tyz + this.getMyz() * tzz, this.getMyx() * ttx + this.getMyy() * tty + this.getMyz() * ttz + this.getTy(), this.getMzx() * txx + this.getMzy() * tyx + this.getMzz() * tzx, this.getMzx() * txy + this.getMzy() * tyy + this.getMzz() * tzy, this.getMzx() * txz + this.getMzy() * tyz + this.getMzz() * tzz, this.getMzx() * ttx + this.getMzy() * tty + this.getMzz() * ttz + this.getTz());
    }

    public Transform createInverse() throws NonInvertibleTransformException {
        return this.getInverseCache().clone();
    }

    public Transform clone() {
        return TransformUtils.immutableTransform(this);
    }

    public Point2D transform(double x, double y) {
        this.ensureCanTransform2DPoint();
        return new Point2D(this.getMxx() * x + this.getMxy() * y + this.getTx(), this.getMyx() * x + this.getMyy() * y + this.getTy());
    }

    public Point2D transform(Point2D point) {
        return this.transform(point.getX(), point.getY());
    }

    public Point3D transform(double x, double y, double z) {
        return new Point3D(this.getMxx() * x + this.getMxy() * y + this.getMxz() * z + this.getTx(), this.getMyx() * x + this.getMyy() * y + this.getMyz() * z + this.getTy(), this.getMzx() * x + this.getMzy() * y + this.getMzz() * z + this.getTz());
    }

    public Point3D transform(Point3D point) {
        return this.transform(point.getX(), point.getY(), point.getZ());
    }

    public Bounds transform(Bounds bounds) {
        if (this.isType2D() && bounds.getMinZ() == 0.0 && bounds.getMaxZ() == 0.0) {
            Point2D p1 = this.transform(bounds.getMinX(), bounds.getMinY());
            Point2D p2 = this.transform(bounds.getMaxX(), bounds.getMinY());
            Point2D p3 = this.transform(bounds.getMaxX(), bounds.getMaxY());
            Point2D p4 = this.transform(bounds.getMinX(), bounds.getMaxY());
            return BoundsUtils.createBoundingBox(p1, p2, p3, p4);
        }
        Point3D p1 = this.transform(bounds.getMinX(), bounds.getMinY(), bounds.getMinZ());
        Point3D p2 = this.transform(bounds.getMinX(), bounds.getMinY(), bounds.getMaxZ());
        Point3D p3 = this.transform(bounds.getMinX(), bounds.getMaxY(), bounds.getMinZ());
        Point3D p4 = this.transform(bounds.getMinX(), bounds.getMaxY(), bounds.getMaxZ());
        Point3D p5 = this.transform(bounds.getMaxX(), bounds.getMaxY(), bounds.getMinZ());
        Point3D p6 = this.transform(bounds.getMaxX(), bounds.getMaxY(), bounds.getMaxZ());
        Point3D p7 = this.transform(bounds.getMaxX(), bounds.getMinY(), bounds.getMinZ());
        Point3D p8 = this.transform(bounds.getMaxX(), bounds.getMinY(), bounds.getMaxZ());
        return BoundsUtils.createBoundingBox(p1, p2, p3, p4, p5, p6, p7, p8);
    }

    void transform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double xx = this.getMxx();
        double xy = this.getMxy();
        double tx = this.getTx();
        double yx = this.getMyx();
        double yy = this.getMyy();
        double ty = this.getTy();
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = xx * x + xy * y + tx;
            dstPts[dstOff++] = yx * x + yy * y + ty;
        }
    }

    void transform3DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double xx = this.getMxx();
        double xy = this.getMxy();
        double xz = this.getMxz();
        double tx = this.getTx();
        double yx = this.getMyx();
        double yy = this.getMyy();
        double yz = this.getMyz();
        double ty = this.getTy();
        double zx = this.getMzx();
        double zy = this.getMzy();
        double zz = this.getMzz();
        double tz = this.getTz();
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            double z = srcPts[srcOff++];
            dstPts[dstOff++] = xx * x + xy * y + xz * z + tx;
            dstPts[dstOff++] = yx * x + yy * y + yz * z + ty;
            dstPts[dstOff++] = zx * x + zy * y + zz * z + tz;
        }
    }

    public void transform2DPoints(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts == null || dstPts == null) {
            throw new NullPointerException();
        }
        if (!this.isType2D()) {
            throw new IllegalStateException("Cannot transform 2D points with a 3D transform");
        }
        srcOff = this.getFixedSrcOffset(srcPts, srcOff, dstPts, dstOff, numPts, 2);
        this.transform2DPointsImpl(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    public void transform3DPoints(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts == null || dstPts == null) {
            throw new NullPointerException();
        }
        srcOff = this.getFixedSrcOffset(srcPts, srcOff, dstPts, dstOff, numPts, 3);
        this.transform3DPointsImpl(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    public Point2D deltaTransform(double x, double y) {
        this.ensureCanTransform2DPoint();
        return new Point2D(this.getMxx() * x + this.getMxy() * y, this.getMyx() * x + this.getMyy() * y);
    }

    public Point2D deltaTransform(Point2D point) {
        return this.deltaTransform(point.getX(), point.getY());
    }

    public Point3D deltaTransform(double x, double y, double z) {
        return new Point3D(this.getMxx() * x + this.getMxy() * y + this.getMxz() * z, this.getMyx() * x + this.getMyy() * y + this.getMyz() * z, this.getMzx() * x + this.getMzy() * y + this.getMzz() * z);
    }

    public Point3D deltaTransform(Point3D point) {
        return this.deltaTransform(point.getX(), point.getY(), point.getZ());
    }

    public Point2D inverseTransform(double x, double y) throws NonInvertibleTransformException {
        this.ensureCanTransform2DPoint();
        return this.getInverseCache().transform(x, y);
    }

    public Point2D inverseTransform(Point2D point) throws NonInvertibleTransformException {
        return this.inverseTransform(point.getX(), point.getY());
    }

    public Point3D inverseTransform(double x, double y, double z) throws NonInvertibleTransformException {
        return this.getInverseCache().transform(x, y, z);
    }

    public Point3D inverseTransform(Point3D point) throws NonInvertibleTransformException {
        return this.inverseTransform(point.getX(), point.getY(), point.getZ());
    }

    public Bounds inverseTransform(Bounds bounds) throws NonInvertibleTransformException {
        if (this.isType2D() && bounds.getMinZ() == 0.0 && bounds.getMaxZ() == 0.0) {
            Point2D p1 = this.inverseTransform(bounds.getMinX(), bounds.getMinY());
            Point2D p2 = this.inverseTransform(bounds.getMaxX(), bounds.getMinY());
            Point2D p3 = this.inverseTransform(bounds.getMaxX(), bounds.getMaxY());
            Point2D p4 = this.inverseTransform(bounds.getMinX(), bounds.getMaxY());
            return BoundsUtils.createBoundingBox(p1, p2, p3, p4);
        }
        Point3D p1 = this.inverseTransform(bounds.getMinX(), bounds.getMinY(), bounds.getMinZ());
        Point3D p2 = this.inverseTransform(bounds.getMinX(), bounds.getMinY(), bounds.getMaxZ());
        Point3D p3 = this.inverseTransform(bounds.getMinX(), bounds.getMaxY(), bounds.getMinZ());
        Point3D p4 = this.inverseTransform(bounds.getMinX(), bounds.getMaxY(), bounds.getMaxZ());
        Point3D p5 = this.inverseTransform(bounds.getMaxX(), bounds.getMaxY(), bounds.getMinZ());
        Point3D p6 = this.inverseTransform(bounds.getMaxX(), bounds.getMaxY(), bounds.getMaxZ());
        Point3D p7 = this.inverseTransform(bounds.getMaxX(), bounds.getMinY(), bounds.getMinZ());
        Point3D p8 = this.inverseTransform(bounds.getMaxX(), bounds.getMinY(), bounds.getMaxZ());
        return BoundsUtils.createBoundingBox(p1, p2, p3, p4, p5, p6, p7, p8);
    }

    void inverseTransform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NonInvertibleTransformException {
        this.getInverseCache().transform2DPointsImpl(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    void inverseTransform3DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NonInvertibleTransformException {
        this.getInverseCache().transform3DPointsImpl(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    public void inverseTransform2DPoints(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NonInvertibleTransformException {
        if (srcPts == null || dstPts == null) {
            throw new NullPointerException();
        }
        if (!this.isType2D()) {
            throw new IllegalStateException("Cannot transform 2D points with a 3D transform");
        }
        srcOff = this.getFixedSrcOffset(srcPts, srcOff, dstPts, dstOff, numPts, 2);
        this.inverseTransform2DPointsImpl(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    public void inverseTransform3DPoints(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NonInvertibleTransformException {
        if (srcPts == null || dstPts == null) {
            throw new NullPointerException();
        }
        srcOff = this.getFixedSrcOffset(srcPts, srcOff, dstPts, dstOff, numPts, 3);
        this.inverseTransform3DPointsImpl(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    public Point2D inverseDeltaTransform(double x, double y) throws NonInvertibleTransformException {
        this.ensureCanTransform2DPoint();
        return this.getInverseCache().deltaTransform(x, y);
    }

    public Point2D inverseDeltaTransform(Point2D point) throws NonInvertibleTransformException {
        return this.inverseDeltaTransform(point.getX(), point.getY());
    }

    public Point3D inverseDeltaTransform(double x, double y, double z) throws NonInvertibleTransformException {
        return this.getInverseCache().deltaTransform(x, y, z);
    }

    public Point3D inverseDeltaTransform(Point3D point) throws NonInvertibleTransformException {
        return this.inverseDeltaTransform(point.getX(), point.getY(), point.getZ());
    }

    private int getFixedSrcOffset(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts, int dimensions) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * dimensions) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * dimensions);
            return dstOff;
        }
        return srcOff;
    }

    private EventHandlerManager getInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = new EventHandlerManager(this);
        }
        return this.internalEventDispatcher;
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return this.internalEventDispatcher == null ? tail : tail.append(this.getInternalEventDispatcher());
    }

    public final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().addEventHandler(eventType, eventHandler);
        this.validate();
    }

    public final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().removeEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.getInternalEventDispatcher().addEventFilter(eventType, eventFilter);
        this.validate();
    }

    public final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.getInternalEventDispatcher().removeEventFilter(eventType, eventFilter);
    }

    public final void setOnTransformChanged(EventHandler<? super TransformChangedEvent> value) {
        this.onTransformChangedProperty().set(value);
        this.validate();
    }

    public final EventHandler<? super TransformChangedEvent> getOnTransformChanged() {
        return this.onTransformChanged == null ? null : (EventHandler)this.onTransformChanged.get();
    }

    public final ObjectProperty<EventHandler<? super TransformChangedEvent>> onTransformChangedProperty() {
        if (this.onTransformChanged == null) {
            this.onTransformChanged = new SimpleObjectProperty<EventHandler<? super TransformChangedEvent>>((Object)this, "onTransformChanged"){

                @Override
                protected void invalidated() {
                    Transform.this.getInternalEventDispatcher().setEventHandler(TransformChangedEvent.TRANSFORM_CHANGED, (EventHandler)this.get());
                }
            };
        }
        return this.onTransformChanged;
    }

    void checkRequestedMAT(MatrixType type) throws IllegalArgumentException {
        if (type.is2D() && !this.isType2D()) {
            throw new IllegalArgumentException("Cannot access 2D matrix for a 3D transform");
        }
    }

    void ensureCanTransform2DPoint() throws IllegalStateException {
        if (!this.isType2D()) {
            throw new IllegalStateException("Cannot transform 2D point with a 3D transform");
        }
    }

    void validate() {
        this.getMxx();
        this.getMxy();
        this.getMxz();
        this.getTx();
        this.getMyx();
        this.getMyy();
        this.getMyz();
        this.getTy();
        this.getMzx();
        this.getMzy();
        this.getMzz();
        this.getTz();
    }

    @Deprecated
    public abstract void impl_apply(Affine3D var1);

    @Deprecated
    public abstract BaseTransform impl_derive(BaseTransform var1);

    @Deprecated
    public void impl_add(Node node) {
        this.impl_nodes.add(node);
    }

    @Deprecated
    public void impl_remove(Node node) {
        this.impl_nodes.remove(node);
    }

    protected void transformChanged() {
        this.inverseCache = null;
        Iterator iterator = this.impl_nodes.iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).impl_transformsChanged();
        }
        if (this.type2D != null) {
            this.type2D.invalidate();
        }
        if (this.identity != null) {
            this.identity.invalidate();
        }
        if (this.internalEventDispatcher != null) {
            this.validate();
            Event.fireEvent(this, new TransformChangedEvent(this, this));
        }
    }

    void appendTo(Affine a) {
        a.append(this.getMxx(), this.getMxy(), this.getMxz(), this.getTx(), this.getMyx(), this.getMyy(), this.getMyz(), this.getTy(), this.getMzx(), this.getMzy(), this.getMzz(), this.getTz());
    }

    void prependTo(Affine a) {
        a.prepend(this.getMxx(), this.getMxy(), this.getMxz(), this.getTx(), this.getMyx(), this.getMyy(), this.getMyz(), this.getTy(), this.getMzx(), this.getMzy(), this.getMzz(), this.getTz());
    }

    private Transform getInverseCache() throws NonInvertibleTransformException {
        if (this.inverseCache == null || this.inverseCache.get() == null) {
            Affine inv = new Affine(this.getMxx(), this.getMxy(), this.getMxz(), this.getTx(), this.getMyx(), this.getMyy(), this.getMyz(), this.getTy(), this.getMzx(), this.getMzy(), this.getMzz(), this.getTz());
            inv.invert();
            this.inverseCache = new SoftReference<Affine>(inv);
            return inv;
        }
        return this.inverseCache.get();
    }

    void clearInverseCache() {
        if (this.inverseCache != null) {
            this.inverseCache.clear();
        }
    }

    private static abstract class LazyBooleanProperty
    extends ReadOnlyBooleanProperty {
        private ExpressionHelper<Boolean> helper;
        private boolean valid;
        private boolean value;

        private LazyBooleanProperty() {
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(ChangeListener<? super Boolean> listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(ChangeListener<? super Boolean> listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public boolean get() {
            if (!this.valid) {
                this.value = this.computeValue();
                this.valid = true;
            }
            return this.value;
        }

        public void invalidate() {
            if (this.valid) {
                this.valid = false;
                ExpressionHelper.fireValueChangedEvent(this.helper);
            }
        }

        protected abstract boolean computeValue();
    }
}

