/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.stage.ScreenHelper;
import com.sun.javafx.tk.ScreenConfigurationAccessor;
import com.sun.javafx.tk.Toolkit;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen$$Lambda$1;

public final class Screen {
    private static final AtomicBoolean configurationDirty = new AtomicBoolean(true);
    private static final ScreenConfigurationAccessor accessor;
    private static Screen primary;
    private static final ObservableList<Screen> screens;
    private static final ObservableList<Screen> unmodifiableScreens;
    private Rectangle2D bounds = Rectangle2D.EMPTY;
    private Rectangle2D visualBounds = Rectangle2D.EMPTY;
    private double dpi;
    private float scale;

    private Screen() {
    }

    private static void checkDirty() {
        if (configurationDirty.compareAndSet(true, false)) {
            Screen.updateConfiguration();
        }
    }

    private static void updateConfiguration() {
        Object primaryScreen = Toolkit.getToolkit().getPrimaryScreen();
        Screen screenTmp = Screen.nativeToScreen(primaryScreen, primary);
        if (screenTmp != null) {
            primary = screenTmp;
        }
        List<?> screens = Toolkit.getToolkit().getScreens();
        ObservableList newScreens = FXCollections.observableArrayList();
        boolean canKeepOld = Screen.screens.size() == screens.size();
        for (int i = 0; i < screens.size(); ++i) {
            Screen newScreen;
            Object obj = screens.get(i);
            Screen origScreen = null;
            if (canKeepOld) {
                origScreen = (Screen)Screen.screens.get(i);
            }
            if ((newScreen = Screen.nativeToScreen(obj, origScreen)) == null) continue;
            if (canKeepOld) {
                canKeepOld = false;
                newScreens.clear();
                newScreens.addAll(Screen.screens.subList(0, i));
            }
            newScreens.add(newScreen);
        }
        if (!canKeepOld) {
            Screen.screens.clear();
            Screen.screens.addAll(newScreens);
        }
        configurationDirty.set(false);
    }

    private static Screen nativeToScreen(Object obj, Screen screen) {
        int minX = accessor.getMinX(obj);
        int minY = accessor.getMinY(obj);
        int width = accessor.getWidth(obj);
        int height = accessor.getHeight(obj);
        int visualMinX = accessor.getVisualMinX(obj);
        int visualMinY = accessor.getVisualMinY(obj);
        int visualWidth = accessor.getVisualWidth(obj);
        int visualHeight = accessor.getVisualHeight(obj);
        double dpi = accessor.getDPI(obj);
        float scale = accessor.getScale(obj);
        if (screen == null || screen.bounds.getMinX() != (double)minX || screen.bounds.getMinY() != (double)minY || screen.bounds.getWidth() != (double)width || screen.bounds.getHeight() != (double)height || screen.visualBounds.getMinX() != (double)visualMinX || screen.visualBounds.getMinY() != (double)visualMinY || screen.visualBounds.getWidth() != (double)visualWidth || screen.visualBounds.getHeight() != (double)visualHeight || screen.dpi != dpi || screen.scale != scale) {
            Screen s = new Screen();
            s.bounds = new Rectangle2D(minX, minY, width, height);
            s.visualBounds = new Rectangle2D(visualMinX, visualMinY, visualWidth, visualHeight);
            s.dpi = dpi;
            s.scale = scale;
            return s;
        }
        return null;
    }

    public static Screen getPrimary() {
        Screen.checkDirty();
        return primary;
    }

    public static ObservableList<Screen> getScreens() {
        Screen.checkDirty();
        return unmodifiableScreens;
    }

    public static ObservableList<Screen> getScreensForRectangle(double x, double y, double width, double height) {
        Screen.checkDirty();
        ObservableList<Screen> results = FXCollections.observableArrayList();
        for (Screen screen : screens) {
            if (!screen.bounds.intersects(x, y, width, height)) continue;
            results.add(screen);
        }
        return results;
    }

    public static ObservableList<Screen> getScreensForRectangle(Rectangle2D r) {
        Screen.checkDirty();
        return Screen.getScreensForRectangle(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    public final Rectangle2D getBounds() {
        return this.bounds;
    }

    public final Rectangle2D getVisualBounds() {
        return this.visualBounds;
    }

    public final double getDpi() {
        return this.dpi;
    }

    private float getScale() {
        return this.scale;
    }

    public int hashCode() {
        long bits = 7L;
        bits = 37L * bits + (long)this.bounds.hashCode();
        bits = 37L * bits + (long)this.visualBounds.hashCode();
        bits = 37L * bits + Double.doubleToLongBits(this.dpi);
        bits = 37L * bits + (long)Float.floatToIntBits(this.scale);
        return (int)(bits ^ bits >> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Screen) {
            Screen other = (Screen)obj;
            return (this.bounds == null ? other.bounds == null : this.bounds.equals(other.bounds)) && (this.visualBounds == null ? other.visualBounds == null : this.visualBounds.equals(other.visualBounds)) && other.dpi == this.dpi && other.scale == this.scale;
        }
        return false;
    }

    public String toString() {
        return super.toString() + "bounds:" + this.bounds + " visualBounds:" + this.visualBounds + " dpi:" + this.dpi + " scale:" + this.scale;
    }

    static /* synthetic */ void lambda$static$24() {
        Screen.updateConfiguration();
    }

    static {
        screens = FXCollections.observableArrayList();
        unmodifiableScreens = FXCollections.unmodifiableObservableList(screens);
        ScreenHelper.setScreenAccessor(new ScreenHelper.ScreenAccessor(){

            @Override
            public float getScale(Screen screen) {
                return screen.getScale();
            }
        });
        accessor = Toolkit.getToolkit().setScreenConfigurationListener(Screen$$Lambda$1.lambdaFactory$());
    }
}

