/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dalvik;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javafxports.android.FXActivity;

public class InternalWebView {
    public static final int PAGE_STARTED = 0;
    public static final int PAGE_FINISHED = 1;
    public static final int PAGE_REDIRECTED = 2;
    public static final int LOAD_FAILED = 5;
    public static final int LOAD_STOPPED = 6;
    public static final int CONTENT_RECEIVED = 10;
    public static final int TITLE_RECEIVED = 11;
    public static final int ICON_RECEIVED = 12;
    public static final int CONTENTTYPE_RECEIVED = 13;
    public static final int DOCUMENT_AVAILABLE = 14;
    public static final int RESOURCE_STARTED = 20;
    public static final int RESOURCE_REDIRECTED = 21;
    public static final int RESOURCE_FINISHED = 22;
    public static final int RESOURCE_FAILED = 23;
    public static final int PROGRESS_CHANGED = 30;
    private static final String TAG = "InternalWebView";
    private static List<InternalWebView> views = new ArrayList<InternalWebView>();
    private static int idcounter = 0;
    private boolean isLayedOut = false;
    private boolean initialized = false;
    private int internalID = ++idcounter;
    private int x;
    private int y;
    private int width;
    private int height;
    private WebView nativeWebView;
    private String url;
    private String content;
    private String contentType = "text/html";
    private String encoding = null;
    private String htmlContent;
    private boolean visible;
    private boolean pageFinished = false;

    public InternalWebView() {
        views.add(0, this);
    }

    public int getInternalID() {
        return this.internalID;
    }

    private void initialize() {
        this.nativeWebView = new WebView((Context)FXActivity.getInstance()){

            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                this.setMeasuredDimension(InternalWebView.this.width, InternalWebView.this.height);
            }
        };
        this.nativeWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                InternalWebView.this.pageFinished = false;
                InternalWebView.this.fireLoadEvent(0, 0, url, InternalWebView.this.contentType, -1, -1);
            }

            public void onPageFinished(WebView view, String url) {
                System.out.println("[JVDBG] OPF called, pf = " + InternalWebView.this.pageFinished);
                if (!InternalWebView.this.pageFinished) {
                    InternalWebView.this.nativeWebView.loadUrl("javascript:window.HTMLOUT.processHTML('<head>'+document.getElementsByTagName('html')[0].innerHTML+'</head>');");
                }
                InternalWebView.this.pageFinished = true;
                InternalWebView.this.fireLoadEvent(0, 1, url, InternalWebView.this.contentType, -1, -1);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                InternalWebView.this.fireLoadEvent(0, 5, failingUrl, InternalWebView.this.contentType, -1, errorCode);
            }
        });
        this.nativeWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                InternalWebView.this.fireLoadEvent(0, 30, InternalWebView.this.url, InternalWebView.this.contentType, newProgress, -1);
            }
        });
        WebSettings settings = this.nativeWebView.getSettings();
        settings.setSupportZoom(true);
        settings.setJavaScriptEnabled(true);
        this.nativeWebView.addJavascriptInterface((Object)new MyJavaScriptInterface(), "HTMLOUT");
        this.initialized = true;
    }

    public String getHtmlContent() {
        return this.htmlContent;
    }

    private void fireLoadEvent(int frameID, int state, String url, String content_type, int progress, int errorCode) {
        this._fireLoadEvent(this.internalID, frameID, state, url == null ? "" : url, content_type == null ? "" : content_type, progress, errorCode);
    }

    private static int indexOf(long id) {
        int i = 0;
        for (InternalWebView wvp : views) {
            if (id == (long)wvp.internalID) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static InternalWebView getViewByID(int id) {
        for (InternalWebView wvp : views) {
            if (id != wvp.internalID) continue;
            return wvp;
        }
        throw new RuntimeException("No InternalWebView with id: " + id);
    }

    static void createNew() {
        FXActivity.getInstance().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                new InternalWebView().getInternalID();
            }
        });
    }

    public static void loadUrl(int id, String url) {
        final InternalWebView iwv = InternalWebView.getViewByID(id);
        iwv.setContent(null, null);
        iwv.setUrl(url);
        if (iwv.initialized && iwv.isLayedOut) {
            FXActivity.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    int c = FXActivity.getViewGroup().getChildCount();
                    iwv.nativeWebView.loadUrl(iwv.url);
                }
            });
        }
    }

    public static String getHtmlContent(int id) {
        InternalWebView iwv = InternalWebView.getViewByID(id);
        return iwv.getHtmlContent();
    }

    public static void loadContent(int id, String content, String contentType) {
        final InternalWebView iwv = InternalWebView.getViewByID(id);
        iwv.setUrl(null);
        iwv.setContent(content, contentType);
        if (iwv.initialized && iwv.isLayedOut) {
            FXActivity.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    iwv.nativeWebView.loadData(iwv.content, iwv.contentType, iwv.encoding);
                }
            });
        }
    }

    static void setEncoding(int id, String encoding) {
        InternalWebView iwv = InternalWebView.getViewByID(id);
        iwv.setEncoding(encoding);
    }

    public static void moveAndResize(int id, int x, int y, int w, int h) {
        boolean resize;
        boolean move;
        if (w == 0 || h == 0) {
            return;
        }
        final InternalWebView iwv = InternalWebView.getViewByID(id);
        if (iwv == null) {
            return;
        }
        if (iwv.x == x && iwv.y == y && iwv.width == w && iwv.height == h) {
            return;
        }
        boolean bl = move = iwv.x != x || iwv.y != y;
        if (move) {
            iwv.x = x;
            iwv.y = y;
        }
        boolean bl2 = resize = iwv.width != w || iwv.height != h;
        if (resize) {
            iwv.width = w;
            iwv.height = h;
        }
        if (!iwv.visible) {
            return;
        }
        if (!iwv.isLayedOut) {
            iwv.isLayedOut = true;
            FXActivity.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!iwv.initialized) {
                        iwv.initialize();
                    }
                    FrameLayout.LayoutParams layout = new FrameLayout.LayoutParams(-2, -2, 0);
                    layout.leftMargin = iwv.x;
                    layout.topMargin = iwv.y;
                    FXActivity.getViewGroup().addView((View)iwv.nativeWebView, (ViewGroup.LayoutParams)layout);
                    Log.v((String)InternalWebView.TAG, (String)String.format("WebView added to ViewGroup [x: %d, y: %d , w: %d h: %d]", iwv.x, iwv.y, iwv.width, iwv.height));
                    if (iwv.contentType == null || iwv.contentType.length() == 0) {
                        iwv.contentType = "text/html";
                    }
                    if (iwv.url != null && iwv.url.length() > 0) {
                        Log.v((String)InternalWebView.TAG, (String)("Loading url: " + iwv.url));
                        iwv.nativeWebView.loadUrl(iwv.url);
                    } else if (iwv.content != null) {
                        Log.v((String)InternalWebView.TAG, (String)String.format("Loading content: %s\ncontent type: %s\nencoding: %s", iwv.content, iwv.contentType, iwv.encoding));
                        iwv.nativeWebView.loadData(iwv.content, iwv.contentType, iwv.encoding);
                    }
                }
            });
        } else {
            FXActivity.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (move) {
                        FrameLayout.LayoutParams layout = (FrameLayout.LayoutParams)iwv.nativeWebView.getLayoutParams();
                        layout.leftMargin = iwv.x;
                        layout.topMargin = iwv.y;
                        FXActivity.getViewGroup().updateViewLayout((View)iwv.nativeWebView, (ViewGroup.LayoutParams)layout);
                    }
                    if (move || resize) {
                        iwv.nativeWebView.invalidate();
                    }
                }
            });
        }
    }

    public static void setVisible(int id, final boolean visible) {
        final InternalWebView iwv = InternalWebView.getViewByID(id);
        if (iwv == null) {
            return;
        }
        if (!iwv.initialized) {
            iwv.visible = visible;
            return;
        }
        FXActivity.getInstance().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                iwv.nativeWebView.setVisibility(visible ? 0 : 8);
                if (visible) {
                    iwv.nativeWebView.invalidate();
                }
            }
        });
    }

    public static void dispose(int id) {
        final InternalWebView iwv = InternalWebView.getViewByID(id);
        InternalWebView.setVisible(id, false);
        FXActivity.getInstance().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                iwv.nativeWebView.stopLoading();
                iwv.nativeWebView.destroy();
            }
        });
        views.remove(iwv);
    }

    private void setUrl(String url) {
        this.url = url;
    }

    private void setContent(String content, String contentType) {
        this.content = content;
        this.contentType = contentType;
    }

    private void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private void _fireLoadEvent(int id, int frameID, int state, String url, String contentType, int progress, int errorCode) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName("com.sun.webkit.NativeWebView", true, cl);
            Method m = clazz.getMethod("fire_load_event", Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class, Integer.TYPE, Integer.TYPE);
            m.invoke(null, id, frameID, state, url, contentType, progress, errorCode);
        }
        catch (Exception e) {
            System.out.println("[JVDBG] Error firing event");
            e.printStackTrace();
        }
    }

    class MyJavaScriptInterface {
        MyJavaScriptInterface() {
        }

        @JavascriptInterface
        public void processHTML(String html) {
            InternalWebView.this.htmlContent = html;
            InternalWebView.this.fireLoadEvent(0, 14, InternalWebView.this.url, InternalWebView.this.contentType, -1, -1);
            System.out.println("[JVDBG] THIS IS THE HTML: " + html);
        }
    }
}

