/*
 * Decompiled with CFR 0.152.
 */
package javafxports.android;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Debug;
import android.os.Process;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Properties;
import javafxports.android.FXDalvikEntity;
import javafxports.android.Launcher;

public class FXActivity
extends Activity {
    private static final String TAG = "FXActivity";
    private static final String JFX_BUILD = "8u60-b2-SNAPSHOT";
    private static final String ACTIVITY_LIB = "activity";
    private static final String META_DATA_LAUNCHER_CLASS = "launcher.class";
    private static final String DEFAULT_LAUNCHER_CLASS = "javafxports.android.DalvikLauncher";
    private static final String META_DATA_MAIN_CLASS = "main.class";
    private static final String META_DATA_PRELOADER_CLASS = "preloader.class";
    private static final String META_DATA_DEBUG_PORT = "debug.port";
    private static final String APPLICATION_DEX_NAME = "Application_dex.jar";
    private static final String APPLICATION_RESOURCES_NAME = "Application_resources.jar";
    private static final String CLASSLOADER_PROPERTIES_NAME = "classloader.properties";
    private static final String BUILD_TIME_NAME = "buildtime";
    private static final int BUF_SIZE = 8192;
    public static String dexClassPath = new String();
    private static FXActivity instance;
    private static Launcher launcher;
    private static FrameLayout mViewGroup;
    private static SurfaceView mView;
    private static String appDataDir;
    private static DeviceConfiguration configuration;
    private Method onKeyEventMethod;
    private Method onSurfaceChangedNativeMethod1;
    private Method onSurfaceChangedNativeMethod2;
    private Method onSurfaceRedrawNeededNativeMethod;
    private Method onConfigurationChangedNativeMethod;
    private int SCREEN_ORIENTATION = 1;
    private String launcherClassName;
    private String mainClassName;
    private String preloaderClassName;
    private String currentBuildStamp;
    private Properties classLoaderProperties;
    private File dexInternalStoragePath;
    private static final Bundle metadata;
    private FXDalvikEntity fxDalvikEntity;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.fxDalvikEntity = new FXDalvikEntity(metadata, this);
        Log.v((String)TAG, (String)"onCreate called, Using 8u60-b2-SNAPSHOT");
        if (launcher != null) {
            Log.v((String)TAG, (String)"JavaFX application is already running");
            return;
        }
        this.getWindow().requestFeature(1);
        this.getWindow().setSoftInputMode(0);
        this.getWindow().setFormat(1);
        mView = this.fxDalvikEntity.createView();
        mViewGroup = new FrameLayout((Context)this);
        mViewGroup.addView((View)mView);
        this.setContentView((View)mViewGroup);
        instance = this;
        configuration = new DeviceConfiguration();
        configuration.setConfiguration(this.getResources().getConfiguration());
        Log.v((String)TAG, (String)String.format("Confiuration orientation: %s", configuration.orientation == 2 ? "LANDSCAPE" : (configuration.orientation == 1 ? "PORTRAIT" : "UNDEFINED")));
        appDataDir = this.getApplicationInfo().dataDir;
        instance = this;
        this._setDataDir(appDataDir);
        try {
            ApplicationInfo appi = this.getPackageManager().getApplicationInfo(this.getPackageName(), 128);
            if (appi != null && appi.metaData != null) {
                metadata.putAll(appi.metaData);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)"Error getting Application info.");
        }
        try {
            ActivityInfo ai = this.getPackageManager().getActivityInfo(this.getIntent().getComponent(), 128);
            if (ai != null && ai.metaData != null) {
                metadata.putAll(ai.metaData);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)"Error getting Activity info.");
        }
        int dport = metadata.getInt(META_DATA_DEBUG_PORT);
        if (dport > 0) {
            Debug.waitForDebugger();
        }
    }

    protected void onDestroy() {
        Log.v((String)TAG, (String)"onDestroy");
        super.onDestroy();
        Process.killProcess((int)Process.myPid());
    }

    protected void onPause() {
        Log.v((String)TAG, (String)"onPause");
        super.onPause();
    }

    protected void onResume() {
        Log.v((String)TAG, (String)"onResume");
        super.onResume();
    }

    protected void onStart() {
        Log.v((String)TAG, (String)"onStart");
        super.onStart();
    }

    protected void onRestart() {
        Log.v((String)TAG, (String)"onRestart");
        super.onRestart();
    }

    protected void onStop() {
        Log.v((String)TAG, (String)"onStop");
        super.onStop();
    }

    public static FXActivity getInstance() {
        return instance;
    }

    public static ViewGroup getViewGroup() {
        return mViewGroup;
    }

    public static String getDataDir() {
        return appDataDir;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.v((String)TAG, (String)"Called onConfigurationChanged");
        configuration.setConfiguration(this.getResources().getConfiguration());
    }

    private native void _jfxEventsLoop();

    private native void _setDataDir(String var1);

    private native void _setSurface(Surface var1);

    static {
        metadata = new Bundle();
        Log.v((String)TAG, (String)"Initializing JavaFX Platform, Using 8u60-b2-SNAPSHOT");
        System.loadLibrary(ACTIVITY_LIB);
    }

    class DeviceConfiguration {
        private static final int ORIENTATION_CHANGE = 1;
        private int change = 0;
        private int orientation;

        DeviceConfiguration() {
        }

        void setConfiguration(Configuration config) {
            if (this.orientation != config.orientation) {
                this.orientation = config.orientation;
                this.change |= 1;
            }
        }

        int getOrientation() {
            return this.orientation;
        }

        boolean isChanged() {
            return this.change > 0;
        }

        void dispatch() {
            if ((this.change & 1) > 0) {
                Log.v((String)FXActivity.TAG, (String)"Dispatching orientation change to");
                try {
                    FXActivity.this.onConfigurationChangedNativeMethod.invoke(null, FXActivity.this.SCREEN_ORIENTATION);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to invoke com.sun.glass.ui.android.DalvikInput.onConfigurationChangedNative method by reflection", e);
                }
            }
            this.change = 0;
        }
    }
}

