/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;

public class ScriptEngineManager {
    private static final boolean DEBUG = false;
    private HashSet<ScriptEngineFactory> engineSpis;
    private HashMap<String, ScriptEngineFactory> nameAssociations;
    private HashMap<String, ScriptEngineFactory> extensionAssociations;
    private HashMap<String, ScriptEngineFactory> mimeTypeAssociations;
    private Bindings globalScope;

    public ScriptEngineManager() {
        ClassLoader ctxtLoader = Thread.currentThread().getContextClassLoader();
        this.init(ctxtLoader);
    }

    public ScriptEngineManager(ClassLoader loader) {
        this.init(loader);
    }

    private void init(final ClassLoader loader) {
        this.globalScope = new SimpleBindings();
        this.engineSpis = new HashSet();
        this.nameAssociations = new HashMap();
        this.extensionAssociations = new HashMap();
        this.mimeTypeAssociations = new HashMap();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ScriptEngineManager.this.initEngines(loader);
                return null;
            }
        });
    }

    private void initEngines(ClassLoader loader) {
        Iterator<ScriptEngineFactory> itr = null;
        try {
            ServiceLoader<ScriptEngineFactory> sl = loader != null ? ServiceLoader.load(ScriptEngineFactory.class, loader) : ServiceLoader.loadInstalled(ScriptEngineFactory.class);
            itr = sl.iterator();
        }
        catch (ServiceConfigurationError err) {
            System.err.println("Can't find ScriptEngineFactory providers: " + err.getMessage());
            return;
        }
        try {
            while (itr.hasNext()) {
                try {
                    ScriptEngineFactory fact = itr.next();
                    this.engineSpis.add(fact);
                }
                catch (ServiceConfigurationError err) {
                    System.err.println("ScriptEngineManager providers.next(): " + err.getMessage());
                }
            }
        }
        catch (ServiceConfigurationError err) {
            System.err.println("ScriptEngineManager providers.hasNext(): " + err.getMessage());
            return;
        }
    }

    public void setBindings(Bindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException("Global scope cannot be null.");
        }
        this.globalScope = bindings;
    }

    public Bindings getBindings() {
        return this.globalScope;
    }

    public void put(String key, Object value) {
        this.globalScope.put(key, value);
    }

    public Object get(String key) {
        return this.globalScope.get(key);
    }

    public ScriptEngine getEngineByName(String shortName) {
        if (shortName == null) {
            throw new NullPointerException();
        }
        ScriptEngineFactory obj = this.nameAssociations.get(shortName);
        if (null != obj) {
            ScriptEngineFactory spi = obj;
            try {
                ScriptEngine engine = spi.getScriptEngine();
                engine.setBindings(this.getBindings(), 200);
                return engine;
            }
            catch (Exception engine) {
                // empty catch block
            }
        }
        for (ScriptEngineFactory spi : this.engineSpis) {
            List<String> names = null;
            try {
                names = spi.getNames();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (names == null) continue;
            for (String name : names) {
                if (!shortName.equals(name)) continue;
                try {
                    ScriptEngine engine = spi.getScriptEngine();
                    engine.setBindings(this.getBindings(), 200);
                    return engine;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public ScriptEngine getEngineByExtension(String extension) {
        if (extension == null) {
            throw new NullPointerException();
        }
        ScriptEngineFactory obj = this.extensionAssociations.get(extension);
        if (null != obj) {
            ScriptEngineFactory spi = obj;
            try {
                ScriptEngine engine = spi.getScriptEngine();
                engine.setBindings(this.getBindings(), 200);
                return engine;
            }
            catch (Exception engine) {
                // empty catch block
            }
        }
        for (ScriptEngineFactory spi : this.engineSpis) {
            List<String> exts = null;
            try {
                exts = spi.getExtensions();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (exts == null) continue;
            for (String ext : exts) {
                if (!extension.equals(ext)) continue;
                try {
                    ScriptEngine engine = spi.getScriptEngine();
                    engine.setBindings(this.getBindings(), 200);
                    return engine;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException();
        }
        ScriptEngineFactory obj = this.mimeTypeAssociations.get(mimeType);
        if (null != obj) {
            ScriptEngineFactory spi = obj;
            try {
                ScriptEngine engine = spi.getScriptEngine();
                engine.setBindings(this.getBindings(), 200);
                return engine;
            }
            catch (Exception engine) {
                // empty catch block
            }
        }
        for (ScriptEngineFactory spi : this.engineSpis) {
            List<String> types = null;
            try {
                types = spi.getMimeTypes();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (types == null) continue;
            for (String type : types) {
                if (!mimeType.equals(type)) continue;
                try {
                    ScriptEngine engine = spi.getScriptEngine();
                    engine.setBindings(this.getBindings(), 200);
                    return engine;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        ArrayList<ScriptEngineFactory> res = new ArrayList<ScriptEngineFactory>(this.engineSpis.size());
        for (ScriptEngineFactory spi : this.engineSpis) {
            res.add(spi);
        }
        return Collections.unmodifiableList(res);
    }

    public void registerEngineName(String name, ScriptEngineFactory factory) {
        if (name == null || factory == null) {
            throw new NullPointerException();
        }
        this.nameAssociations.put(name, factory);
    }

    public void registerEngineMimeType(String type, ScriptEngineFactory factory) {
        if (type == null || factory == null) {
            throw new NullPointerException();
        }
        this.mimeTypeAssociations.put(type, factory);
    }

    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        if (extension == null || factory == null) {
            throw new NullPointerException();
        }
        this.extensionAssociations.put(extension, factory);
    }
}

