/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.lens;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.lens.LensLogger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

final class LensPixels
extends Pixels {
    protected LensPixels(int width, int height, ByteBuffer data) {
        super(width, height, data);
    }

    protected LensPixels(int width, int height, IntBuffer data) {
        super(width, height, data);
    }

    protected LensPixels(int width, int height, IntBuffer data, float scale) {
        super(width, height, data, scale);
    }

    static int getNativeFormat_impl() {
        LensLogger.getLogger().config("Querying native format");
        return 1;
    }

    private native void _copyPixels(Buffer var1, Buffer var2, int var3);

    @Override
    protected void _fillDirectByteBuffer(ByteBuffer bb) {
        if (this.bytes != null) {
            this.bytes.rewind();
            if (this.bytes.isDirect()) {
                this._copyPixels(bb, this.bytes, this.getWidth() * this.getHeight());
            } else {
                bb.put(this.bytes);
            }
            this.bytes.rewind();
        } else {
            this.ints.rewind();
            if (this.ints.isDirect()) {
                this._copyPixels(bb, this.ints, this.getWidth() * this.getHeight());
            } else {
                for (int i = 0; i < this.ints.capacity(); ++i) {
                    int data = this.ints.get();
                    bb.put((byte)(data & 0xFF));
                    bb.put((byte)(data >> 8 & 0xFF));
                    bb.put((byte)(data >> 16 & 0xFF));
                    bb.put((byte)(data >> 24 & 0xFF));
                }
            }
            this.ints.rewind();
        }
        bb.rewind();
    }

    @Override
    protected void _attachInt(long nativeWindowPointer, int w, int h, IntBuffer ints, int[] array, int offset) {
        LensLogger.getLogger().severe("Not implemented");
        throw new UnsupportedOperationException("not implmented");
    }

    @Override
    protected void _attachByte(long ptr, int w, int h, ByteBuffer bytes, byte[] array, int offset) {
        LensLogger.getLogger().severe("Not implemented");
        throw new UnsupportedOperationException("not implmented");
    }
}

