/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontConstants;
import com.sun.javafx.font.FontFileWriter$$Lambda$1;
import com.sun.javafx.font.FontFileWriter$$Lambda$2;
import com.sun.javafx.font.FontFileWriter$$Lambda$3;
import com.sun.javafx.font.FontFileWriter$FontTracker$TempFileDeletionHook$$Lambda$1;
import com.sun.javafx.font.FontFileWriter$FontTracker$TempFileDeletionHook$$Lambda$2;
import com.sun.javafx.font.PrismFontFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class FontFileWriter
implements FontConstants {
    byte[] header;
    int pos;
    int headerPos;
    int writtenBytes;
    FontTracker tracker;
    File file;
    RandomAccessFile raFile;

    public FontFileWriter() {
        if (!FontFileWriter.hasTempPermission()) {
            this.tracker = FontTracker.getTracker();
        }
    }

    protected void setLength(int size) throws IOException {
        if (this.raFile == null) {
            throw new IOException("File not open");
        }
        this.checkTracker(size);
        this.raFile.setLength(size);
    }

    public void seek(int pos) throws IOException {
        if (this.raFile == null) {
            throw new IOException("File not open");
        }
        if (pos != this.pos) {
            this.raFile.seek(pos);
            this.pos = pos;
        }
    }

    public File getFile() {
        return this.file;
    }

    public File openFile() throws PrivilegedActionException {
        this.pos = 0;
        this.writtenBytes = 0;
        this.file = (File)AccessController.doPrivileged(FontFileWriter$$Lambda$1.lambdaFactory$());
        if (this.tracker != null) {
            this.tracker.add(this.file);
        }
        this.raFile = (RandomAccessFile)AccessController.doPrivileged(FontFileWriter$$Lambda$2.lambdaFactory$(this));
        if (this.tracker != null) {
            this.tracker.set(this.file, this.raFile);
        }
        if (PrismFontFactory.debugFonts) {
            System.err.println("Temp file created: " + this.file.getPath());
        }
        return this.file;
    }

    public void closeFile() throws IOException {
        if (this.header != null) {
            this.raFile.seek(0L);
            this.raFile.write(this.header);
            this.header = null;
        }
        if (this.raFile != null) {
            this.raFile.close();
            this.raFile = null;
        }
        if (this.tracker != null) {
            this.tracker.remove(this.file);
        }
    }

    public void deleteFile() {
        if (this.file != null) {
            if (this.tracker != null) {
                this.tracker.subBytes(this.writtenBytes);
            }
            try {
                this.closeFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                AccessController.doPrivileged(FontFileWriter$$Lambda$3.lambdaFactory$(this));
                if (PrismFontFactory.debugFonts) {
                    System.err.println("Temp file delete: " + this.file.getPath());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.file = null;
            this.raFile = null;
        }
    }

    public boolean isTracking() {
        return this.tracker != null;
    }

    private void checkTracker(int size) throws IOException {
        if (this.tracker != null) {
            if (size < 0 || this.pos > 0x2000000 - size) {
                throw new IOException("File too big.");
            }
            if (this.tracker.getNumBytes() > 0x14000000 - size) {
                throw new IOException("Total files too big.");
            }
        }
    }

    private void checkSize(int size) throws IOException {
        if (this.tracker != null) {
            this.checkTracker(size);
            this.tracker.addBytes(size);
            this.writtenBytes += size;
        }
    }

    private void setHeaderPos(int pos) {
        this.headerPos = pos;
    }

    public void writeHeader(int format, short numTables) throws IOException {
        int size = 12 + 16 * numTables;
        this.checkSize(size);
        this.header = new byte[size];
        short maxPower2 = numTables;
        maxPower2 = (short)(maxPower2 | maxPower2 >> 1);
        maxPower2 = (short)(maxPower2 | maxPower2 >> 2);
        maxPower2 = (short)(maxPower2 | maxPower2 >> 4);
        maxPower2 = (short)(maxPower2 | maxPower2 >> 8);
        short searchRange = (short)(maxPower2 * 16);
        short entrySelector = 0;
        for (maxPower2 = (short)(maxPower2 & (maxPower2 >> 1 ^ 0xFFFFFFFF)); maxPower2 > 1; maxPower2 = (short)(maxPower2 >> 1)) {
            entrySelector = (short)(entrySelector + 1);
        }
        short rangeShift = (short)(numTables * 16 - searchRange);
        this.setHeaderPos(0);
        this.writeInt(format);
        this.writeShort(numTables);
        this.writeShort(searchRange);
        this.writeShort(entrySelector);
        this.writeShort(rangeShift);
    }

    public void writeDirectoryEntry(int index, int tag, int checksum, int offset, int length) throws IOException {
        this.setHeaderPos(12 + 16 * index);
        this.writeInt(tag);
        this.writeInt(checksum);
        this.writeInt(offset);
        this.writeInt(length);
    }

    private void writeInt(int value) throws IOException {
        this.header[this.headerPos++] = (byte)((value & 0xFF000000) >> 24);
        this.header[this.headerPos++] = (byte)((value & 0xFF0000) >> 16);
        this.header[this.headerPos++] = (byte)((value & 0xFF00) >> 8);
        this.header[this.headerPos++] = (byte)(value & 0xFF);
    }

    private void writeShort(short value) throws IOException {
        this.header[this.headerPos++] = (byte)((value & 0xFF00) >> 8);
        this.header[this.headerPos++] = (byte)(value & 0xFF);
    }

    public void writeBytes(byte[] buffer) throws IOException {
        this.writeBytes(buffer, 0, buffer.length);
    }

    public void writeBytes(byte[] buffer, int startPos, int length) throws IOException {
        this.checkSize(length);
        this.raFile.write(buffer, startPos, length);
        this.pos += length;
    }

    static boolean hasTempPermission() {
        if (System.getSecurityManager() == null) {
            return true;
        }
        File f = null;
        boolean hasPerm = false;
        try {
            f = Files.createTempFile("+JXF", ".tmp", new FileAttribute[0]).toFile();
            f.delete();
            f = null;
            hasPerm = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hasPerm;
    }

    /* synthetic */ Void lambda$deleteFile$233() throws Exception {
        this.file.delete();
        return null;
    }

    /* synthetic */ RandomAccessFile lambda$openFile$232() throws Exception {
        return new RandomAccessFile(this.file, "rw");
    }

    static /* synthetic */ File lambda$openFile$231() throws Exception {
        try {
            return Files.createTempFile("+JXF", ".tmp", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IOException("Unable to create temporary file");
        }
    }

    static class FontTracker {
        public static final int MAX_FILE_SIZE = 0x2000000;
        public static final int MAX_TOTAL_BYTES = 0x14000000;
        static int numBytes;
        static FontTracker tracker;
        private static Semaphore cs;

        FontTracker() {
        }

        public static synchronized FontTracker getTracker() {
            if (tracker == null) {
                tracker = new FontTracker();
            }
            return tracker;
        }

        public synchronized int getNumBytes() {
            return numBytes;
        }

        public synchronized void addBytes(int sz) {
            numBytes += sz;
        }

        public synchronized void subBytes(int sz) {
            numBytes -= sz;
        }

        private static synchronized Semaphore getCS() {
            if (cs == null) {
                cs = new Semaphore(5, true);
            }
            return cs;
        }

        public boolean acquirePermit() throws InterruptedException {
            return FontTracker.getCS().tryAcquire(120L, TimeUnit.SECONDS);
        }

        public void releasePermit() {
            FontTracker.getCS().release();
        }

        public void add(File file) {
            TempFileDeletionHook.add(file);
        }

        public void set(File file, RandomAccessFile raf) {
            TempFileDeletionHook.set(file, raf);
        }

        public void remove(File file) {
            TempFileDeletionHook.remove(file);
        }

        static {
            cs = null;
        }

        private static class TempFileDeletionHook {
            private static HashMap<File, RandomAccessFile> files = new HashMap();
            private static Thread t = null;

            static void init() {
                if (t == null) {
                    AccessController.doPrivileged(FontFileWriter$FontTracker$TempFileDeletionHook$$Lambda$1.lambdaFactory$());
                }
            }

            private TempFileDeletionHook() {
            }

            static synchronized void add(File file) {
                TempFileDeletionHook.init();
                files.put(file, null);
            }

            static synchronized void set(File file, RandomAccessFile raf) {
                files.put(file, raf);
            }

            static synchronized void remove(File file) {
                files.remove(file);
            }

            static synchronized void runHooks() {
                if (files.isEmpty()) {
                    return;
                }
                for (Map.Entry<File, RandomAccessFile> entry : files.entrySet()) {
                    try {
                        if (entry.getValue() != null) {
                            entry.getValue().close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    entry.getKey().delete();
                }
            }

            static /* synthetic */ Object lambda$init$235() {
                t = new Thread(FontFileWriter$FontTracker$TempFileDeletionHook$$Lambda$2.lambdaFactory$());
                Runtime.getRuntime().addShutdownHook(t);
                return null;
            }

            static /* synthetic */ void lambda$null$234() {
                TempFileDeletionHook.runHooks();
            }
        }
    }
}

