/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.font.MacFontFinder$$Lambda$1;
import com.sun.javafx.font.PrismFontFactory;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

class MacFontFinder {
    private static final int SystemFontType = 2;
    private static final int MonospacedFontType = 1;

    MacFontFinder() {
    }

    private static native String getFont(int var0);

    public static String getSystemFont() {
        return MacFontFinder.getFont(2);
    }

    public static String getMonospacedFont() {
        return MacFontFinder.getFont(1);
    }

    static native float getSystemFontSize();

    public static boolean populateFontFileNameMap(HashMap<String, String> fontToFileMap, HashMap<String, String> fontToFamilyNameMap, HashMap<String, ArrayList<String>> familyToFontListMap, Locale locale) {
        String[] fontData;
        if (fontToFileMap == null || fontToFamilyNameMap == null || familyToFontListMap == null) {
            return false;
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        if ((fontData = MacFontFinder.getFontData()) == null) {
            return false;
        }
        int i = 0;
        while (i < fontData.length) {
            String name = fontData[i++];
            String family = fontData[i++];
            String file = fontData[i++];
            if (!PrismFontFactory.useNativeRasterizer && file.endsWith(".otf") && (name.indexOf(" Pro W") != -1 || name.indexOf(" ProN W") != -1 || name.indexOf(" Std W") != -1 || name.indexOf(" StdN W") != -1 || name.indexOf("Hiragino") != -1)) continue;
            if (PrismFontFactory.debugFonts) {
                System.err.println("[MacFontFinder] Name=" + name);
                System.err.println("\tFamily=" + family);
                System.err.println("\tFile=" + file);
            }
            String lcName = name.toLowerCase(locale);
            String lcFamily = family.toLowerCase(locale);
            fontToFileMap.put(lcName, file);
            fontToFamilyNameMap.put(lcName, family);
            ArrayList<String> list = familyToFontListMap.get(lcFamily);
            if (list == null) {
                list = new ArrayList();
                familyToFontListMap.put(lcFamily, list);
            }
            list.add(name);
        }
        return true;
    }

    private static native String[] getFontData();

    static /* synthetic */ Void lambda$static$241() {
        NativeLibLoader.loadLibrary("javafx_font");
        return null;
    }

    static {
        AccessController.doPrivileged(MacFontFinder$$Lambda$1.lambdaFactory$());
    }
}

