/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.SelectedCellsMap$$Lambda$1;
import com.sun.javafx.scene.control.SelectedCellsMap$$Lambda$2;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.TablePositionBase;

public abstract class SelectedCellsMap<T extends TablePositionBase> {
    private final ObservableList<T> selectedCells = FXCollections.observableArrayList();
    private final ObservableList<T> sortedSelectedCells = new SortedList<T>(this.selectedCells, SelectedCellsMap$$Lambda$1.lambdaFactory$());
    private final Map<Integer, BitSet> selectedCellBitSetMap;

    public SelectedCellsMap(ListChangeListener<T> listener) {
        this.sortedSelectedCells.addListener(listener);
        this.selectedCellBitSetMap = new TreeMap<Integer, BitSet>(SelectedCellsMap$$Lambda$2.lambdaFactory$());
    }

    public abstract boolean isCellSelectionEnabled();

    public int size() {
        return this.selectedCells.size();
    }

    public T get(int i) {
        if (i < 0) {
            return null;
        }
        return (T)((TablePositionBase)this.sortedSelectedCells.get(i));
    }

    public void add(T tp) {
        BitSet bitset;
        int row = ((TablePositionBase)tp).getRow();
        int columnIndex = ((TablePositionBase)tp).getColumn();
        boolean isNewBitSet = false;
        if (!this.selectedCellBitSetMap.containsKey(row)) {
            bitset = new BitSet();
            this.selectedCellBitSetMap.put(row, bitset);
            isNewBitSet = true;
        } else {
            bitset = this.selectedCellBitSetMap.get(row);
        }
        boolean cellSelectionModeEnabled = this.isCellSelectionEnabled();
        if (cellSelectionModeEnabled) {
            if (columnIndex >= 0) {
                boolean isAlreadySet = bitset.get(columnIndex);
                if (!isAlreadySet) {
                    bitset.set(columnIndex);
                    this.selectedCells.add(tp);
                }
            } else if (!this.selectedCells.contains(tp)) {
                this.selectedCells.add(tp);
            }
        } else if (isNewBitSet) {
            if (columnIndex >= 0) {
                bitset.set(columnIndex);
            }
            this.selectedCells.add(tp);
        }
    }

    public void addAll(Collection<T> cells) {
        for (TablePositionBase tp : cells) {
            BitSet bitset;
            int row = tp.getRow();
            int columnIndex = tp.getColumn();
            if (!this.selectedCellBitSetMap.containsKey(row)) {
                bitset = new BitSet();
                this.selectedCellBitSetMap.put(row, bitset);
            } else {
                bitset = this.selectedCellBitSetMap.get(row);
            }
            if (columnIndex < 0) continue;
            bitset.set(columnIndex);
        }
        this.selectedCells.addAll(cells);
    }

    public void setAll(Collection<T> cells) {
        this.selectedCellBitSetMap.clear();
        for (TablePositionBase tp : cells) {
            BitSet bitset;
            int row = tp.getRow();
            int columnIndex = tp.getColumn();
            if (!this.selectedCellBitSetMap.containsKey(row)) {
                bitset = new BitSet();
                this.selectedCellBitSetMap.put(row, bitset);
            } else {
                bitset = this.selectedCellBitSetMap.get(row);
            }
            if (columnIndex < 0) continue;
            bitset.set(columnIndex);
        }
        this.selectedCells.setAll(cells);
    }

    public void remove(T tp) {
        int row = ((TablePositionBase)tp).getRow();
        int columnIndex = ((TablePositionBase)tp).getColumn();
        if (this.selectedCellBitSetMap.containsKey(row)) {
            BitSet bitset = this.selectedCellBitSetMap.get(row);
            if (columnIndex >= 0) {
                bitset.clear(columnIndex);
            }
            if (bitset.isEmpty()) {
                this.selectedCellBitSetMap.remove(row);
            }
        }
        this.selectedCells.remove(tp);
    }

    public void clear() {
        this.selectedCellBitSetMap.clear();
        this.selectedCells.clear();
    }

    public boolean isSelected(int row, int columnIndex) {
        if (columnIndex < 0) {
            return this.selectedCellBitSetMap.containsKey(row);
        }
        return this.selectedCellBitSetMap.containsKey(row) ? this.selectedCellBitSetMap.get(row).get(columnIndex) : false;
    }

    public int indexOf(T tp) {
        return this.sortedSelectedCells.indexOf(tp);
    }

    public boolean isEmpty() {
        return this.selectedCells.isEmpty();
    }

    public ObservableList<T> getSelectedCells() {
        return this.selectedCells;
    }

    static /* synthetic */ int lambda$new$22(Integer o1, Integer o2) {
        return o1.compareTo(o2);
    }

    static /* synthetic */ int lambda$new$21(TablePositionBase o1, TablePositionBase o2) {
        int result = o1.getRow() - o2.getRow();
        return result == 0 ? o1.getColumn() - o2.getColumn() : result;
    }
}

