/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.skin.DatePickerSkin;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.DatePicker;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class DatePickerBehavior
extends ComboBoxBaseBehavior<LocalDate> {
    protected static final String OPEN_ACTION = "Open";
    protected static final String CLOSE_ACTION = "Close";
    protected static final List<KeyBinding> DATE_PICKER_BINDINGS = new ArrayList<KeyBinding>();

    public DatePickerBehavior(DatePicker datePicker) {
        super(datePicker, DATE_PICKER_BINDINGS);
    }

    @Override
    protected void callAction(String name) {
        switch (name) {
            case "Open": {
                this.show();
                break;
            }
            case "Close": {
                this.hide();
                break;
            }
            case "togglePopup": {
                if (((ComboBoxBase)this.getControl()).isShowing()) {
                    this.hide();
                    break;
                }
                this.show();
                break;
            }
            default: {
                super.callAction(name);
            }
        }
    }

    @Override
    public void onAutoHide() {
        DatePicker datePicker = (DatePicker)this.getControl();
        DatePickerSkin cpSkin = (DatePickerSkin)datePicker.getSkin();
        cpSkin.syncWithAutoUpdate();
        if (!datePicker.isShowing()) {
            super.onAutoHide();
        }
    }

    static {
        DATE_PICKER_BINDINGS.add(new KeyBinding(KeyCode.F4, KeyEvent.KEY_RELEASED, "togglePopup"));
        DATE_PICKER_BINDINGS.add(new KeyBinding(KeyCode.UP, "togglePopup").alt());
        DATE_PICKER_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "togglePopup").alt());
    }
}

