/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.ButtonBarSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.ButtonBarSkin$$Lambda$2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class ButtonBarSkin
extends BehaviorSkinBase<ButtonBar, BehaviorBase<ButtonBar>> {
    private static final double GAP_SIZE = 10.0;
    private static final String CATEGORIZED_TYPES = "LRHEYNXBIACO";
    public static final String BUTTON_DATA_PROPERTY = "javafx.scene.control.ButtonBar.ButtonData";
    public static final String BUTTON_SIZE_INDEPENDENCE = "javafx.scene.control.ButtonBar.independentSize";
    private static final double DO_NOT_CHANGE_SIZE = Double.MAX_VALUE;
    private HBox layout;
    private InvalidationListener buttonDataListener = ButtonBarSkin$$Lambda$1.lambdaFactory$(this);

    public ButtonBarSkin(ButtonBar control) {
        super(control, new BehaviorBase<ButtonBar>(control, Collections.emptyList()));
        this.layout = new HBox(10.0){

            @Override
            protected void layoutChildren() {
                ButtonBarSkin.this.resizeButtons();
                super.layoutChildren();
            }
        };
        this.layout.setAlignment(Pos.CENTER);
        this.layout.getStyleClass().add("container");
        this.getChildren().add(this.layout);
        this.layoutButtons();
        this.updateButtonListeners(control.getButtons(), true);
        control.getButtons().addListener(ButtonBarSkin$$Lambda$2.lambdaFactory$(this));
        this.registerChangeListener(control.buttonOrderProperty(), "BUTTON_ORDER");
        this.registerChangeListener(control.buttonMinWidthProperty(), "BUTTON_MIN_WIDTH");
    }

    private void updateButtonListeners(List<? extends Node> list, boolean buttonsAdded) {
        if (list != null) {
            for (Node node : list) {
                ObjectProperty property;
                ObservableMap<Object, Object> properties = node.getProperties();
                if (!properties.containsKey(BUTTON_DATA_PROPERTY) || (property = (ObjectProperty)properties.get(BUTTON_DATA_PROPERTY)) == null) continue;
                if (buttonsAdded) {
                    property.addListener(this.buttonDataListener);
                    continue;
                }
                property.removeListener(this.buttonDataListener);
            }
        }
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("BUTTON_ORDER".equals(p)) {
            this.layoutButtons();
        } else if ("BUTTON_MIN_WIDTH".equals(p)) {
            this.resizeButtons();
        }
    }

    private void layoutButtons() {
        ButtonBar buttonBar = (ButtonBar)this.getSkinnable();
        ObservableList<Node> buttons = buttonBar.getButtons();
        double buttonMinWidth = buttonBar.getButtonMinWidth();
        String buttonOrder = ((ButtonBar)this.getSkinnable()).getButtonOrder();
        this.layout.getChildren().clear();
        if (buttonOrder == null) {
            throw new IllegalStateException("ButtonBar buttonOrder string can not be null");
        }
        if (buttonOrder == "") {
            Spacer.DYNAMIC.add(this.layout, true);
            for (Node btn : buttons) {
                this.sizeButton(btn, buttonMinWidth, Double.MAX_VALUE, Double.MAX_VALUE);
                this.layout.getChildren().add(btn);
                HBox.setHgrow(btn, Priority.NEVER);
            }
        } else {
            this.doButtonOrderLayout(buttonOrder);
        }
    }

    private void doButtonOrderLayout(String buttonOrder) {
        int i;
        ButtonBar buttonBar = (ButtonBar)this.getSkinnable();
        ObservableList<Node> buttons = buttonBar.getButtons();
        double buttonMinWidth = buttonBar.getButtonMinWidth();
        Map<String, List<Node>> buttonMap = this.buildButtonMap(buttons);
        char[] buttonOrderArr = buttonOrder.toCharArray();
        int buttonIndex = 0;
        Spacer spacer = Spacer.NONE;
        for (int i2 = 0; i2 < buttonOrderArr.length; ++i2) {
            boolean hasChildren;
            char type = buttonOrderArr[i2];
            boolean edgeCase = buttonIndex <= 0 && buttonIndex >= buttons.size() - 1;
            boolean bl = hasChildren = !this.layout.getChildren().isEmpty();
            if (type == '+') {
                spacer = spacer.replace(Spacer.DYNAMIC);
                continue;
            }
            if (type == '_' && hasChildren) {
                spacer = spacer.replace(Spacer.FIXED);
                continue;
            }
            List<Node> buttonList = buttonMap.get(String.valueOf(type).toUpperCase());
            if (buttonList == null) continue;
            spacer.add(this.layout, edgeCase);
            for (Node btn : buttonList) {
                this.sizeButton(btn, buttonMinWidth, Double.MAX_VALUE, Double.MAX_VALUE);
                this.layout.getChildren().add(btn);
                HBox.setHgrow(btn, Priority.NEVER);
                ++buttonIndex;
            }
            spacer = spacer.replace(Spacer.NONE);
        }
        boolean isDefaultSet = false;
        int childrenCount = buttons.size();
        for (i = 0; i < childrenCount; ++i) {
            Node btn = (Node)buttons.get(i);
            if (!(btn instanceof Button) || !((Button)btn).isDefaultButton()) continue;
            btn.requestFocus();
            isDefaultSet = true;
            break;
        }
        if (!isDefaultSet) {
            for (i = 0; i < childrenCount; ++i) {
                Node btn = (Node)buttons.get(i);
                ButtonBar.ButtonData btnData = ButtonBar.getButtonData(btn);
                if (btnData == null || !btnData.isDefaultButton()) continue;
                btn.requestFocus();
                isDefaultSet = true;
                break;
            }
        }
    }

    private void resizeButtons() {
        ButtonBar buttonBar = (ButtonBar)this.getSkinnable();
        double buttonMinWidth = buttonBar.getButtonMinWidth();
        ObservableList<Node> buttons = buttonBar.getButtons();
        double widest = buttonMinWidth;
        for (Node button : buttons) {
            if (!ButtonBar.isButtonUniformSize(button)) continue;
            widest = Math.max(button.prefWidth(-1.0), widest);
        }
        for (Node button : buttons) {
            if (!ButtonBar.isButtonUniformSize(button)) continue;
            this.sizeButton(button, Double.MAX_VALUE, widest, Double.MAX_VALUE);
        }
    }

    private void sizeButton(Node btn, double min, double pref, double max) {
        if (btn instanceof Region) {
            Region regionBtn = (Region)btn;
            if (min != Double.MAX_VALUE) {
                regionBtn.setMinWidth(min);
            }
            if (pref != Double.MAX_VALUE) {
                regionBtn.setPrefWidth(pref);
            }
            if (max != Double.MAX_VALUE) {
                regionBtn.setMaxWidth(max);
            }
        }
    }

    private String getButtonType(Node btn) {
        String typeCode;
        ButtonBar.ButtonData buttonType = ButtonBar.getButtonData(btn);
        if (buttonType == null) {
            buttonType = ButtonBar.ButtonData.OTHER;
        }
        typeCode = (typeCode = buttonType.getTypeCode()).length() > 0 ? typeCode.substring(0, 1) : "";
        return CATEGORIZED_TYPES.contains(typeCode.toUpperCase()) ? typeCode : ButtonBar.ButtonData.OTHER.getTypeCode();
    }

    private Map<String, List<Node>> buildButtonMap(List<? extends Node> buttons) {
        HashMap<String, List<Node>> buttonMap = new HashMap<String, List<Node>>();
        for (Node node : buttons) {
            if (node == null) continue;
            String type = this.getButtonType(node);
            ArrayList<Node> typedButtons = (ArrayList<Node>)buttonMap.get(type);
            if (typedButtons == null) {
                typedButtons = new ArrayList<Node>();
                buttonMap.put(type, typedButtons);
            }
            typedButtons.add(node);
        }
        return buttonMap;
    }

    /* synthetic */ void lambda$new$276(ListChangeListener.Change c) {
        while (c.next()) {
            this.updateButtonListeners(c.getRemoved(), false);
            this.updateButtonListeners(c.getAddedSubList(), true);
        }
        this.layoutButtons();
    }

    /* synthetic */ void lambda$new$275(Observable o) {
        this.layoutButtons();
    }

    private static enum Spacer {
        FIXED{

            @Override
            protected Node create(boolean edgeCase) {
                if (edgeCase) {
                    return null;
                }
                Region spacer = new Region();
                ButtonBar.setButtonData(spacer, ButtonBar.ButtonData.SMALL_GAP);
                spacer.setMinWidth(10.0);
                HBox.setHgrow(spacer, Priority.NEVER);
                return spacer;
            }
        }
        ,
        DYNAMIC{

            @Override
            protected Node create(boolean edgeCase) {
                Region spacer = new Region();
                ButtonBar.setButtonData(spacer, ButtonBar.ButtonData.BIG_GAP);
                spacer.setMinWidth(edgeCase ? 0.0 : 10.0);
                HBox.setHgrow(spacer, Priority.ALWAYS);
                return spacer;
            }

            @Override
            public Spacer replace(Spacer spacer) {
                return FIXED == spacer ? this : spacer;
            }
        }
        ,
        NONE;


        protected Node create(boolean edgeCase) {
            return null;
        }

        public Spacer replace(Spacer spacer) {
            return spacer;
        }

        public void add(Pane pane, boolean edgeCase) {
            Node spacer = this.create(edgeCase);
            if (spacer != null) {
                pane.getChildren().add(spacer);
            }
        }
    }
}

