/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.control.GlobalMenuAdapter;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$10;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$11;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$12;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$13;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$14;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$15;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$16;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$17;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$18;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$19;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$20;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$21;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$22;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$23;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$24;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$25;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$26;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$27;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$5;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$6;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$7;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$8;
import com.sun.javafx.scene.control.skin.MenuBarSkin$$Lambda$9;
import com.sun.javafx.scene.control.skin.MenuBarSkin$MenuBarButton$$Lambda$1;
import com.sun.javafx.scene.control.skin.MenuBarSkin$MenuBarButton$$Lambda$2;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import com.sun.javafx.stage.StageHelper;
import com.sun.javafx.tk.Toolkit;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.Window;

public class MenuBarSkin
extends BehaviorSkinBase<MenuBar, BehaviorBase<MenuBar>>
implements TraverseListener {
    private final HBox container;
    private Menu openMenu;
    private MenuBarButton openMenuButton;
    private int focusedMenuIndex = -1;
    private static WeakHashMap<Stage, Reference<MenuBarSkin>> systemMenuMap;
    private static List<MenuBase> wrappedDefaultMenus;
    private static Stage currentMenuBarStage;
    private List<MenuBase> wrappedMenus;
    private WeakEventHandler<KeyEvent> weakSceneKeyEventHandler;
    private WeakEventHandler<MouseEvent> weakSceneMouseEventHandler;
    private WeakChangeListener<Boolean> weakWindowFocusListener;
    private WeakChangeListener<Window> weakWindowSceneListener;
    private EventHandler<KeyEvent> keyEventHandler;
    private EventHandler<MouseEvent> mouseEventHandler;
    private ChangeListener<Boolean> menuBarFocusedPropertyListener;
    private ChangeListener<Scene> sceneChangeListener;
    Runnable firstMenuRunnable = new Runnable(){

        @Override
        public void run() {
            if (MenuBarSkin.this.container.getChildren().size() > 0 && MenuBarSkin.this.container.getChildren().get(0) instanceof MenuButton) {
                if (MenuBarSkin.this.focusedMenuIndex != 0) {
                    MenuBarSkin.this.unSelectMenus();
                    MenuBarSkin.this.menuModeStart(0);
                    MenuBarSkin.this.openMenuButton = (MenuBarButton)MenuBarSkin.this.container.getChildren().get(0);
                    MenuBarSkin.this.openMenu = (Menu)((MenuBar)MenuBarSkin.this.getSkinnable()).getMenus().get(0);
                    MenuBarSkin.this.openMenuButton.setHover();
                } else {
                    MenuBarSkin.this.unSelectMenus();
                }
            }
        }
    };
    private boolean pendingDismiss = false;
    private EventHandler<ActionEvent> menuActionEventHandler = MenuBarSkin$$Lambda$4.lambdaFactory$(this);
    private ListChangeListener<MenuItem> menuItemListener = MenuBarSkin$$Lambda$5.lambdaFactory$(this);
    private DoubleProperty spacing;
    private ObjectProperty<Pos> containerAlignment;
    private static final CssMetaData<MenuBar, Number> SPACING;
    private static final CssMetaData<MenuBar, Pos> ALIGNMENT;
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public static void setDefaultSystemMenuBar(MenuBar menuBar) {
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            wrappedDefaultMenus.clear();
            for (Menu menu : menuBar.getMenus()) {
                wrappedDefaultMenus.add(GlobalMenuAdapter.adapt(menu));
            }
            menuBar.getMenus().addListener(MenuBarSkin$$Lambda$1.lambdaFactory$(menuBar));
        }
    }

    private static MenuBarSkin getMenuBarSkin(Stage stage) {
        if (systemMenuMap == null) {
            return null;
        }
        Reference<MenuBarSkin> skinRef = systemMenuMap.get(stage);
        return skinRef == null ? null : skinRef.get();
    }

    private static void setSystemMenu(Stage stage) {
        if (stage != null && stage.isFocused()) {
            MenuBarSkin skin;
            while (stage != null && stage.getOwner() instanceof Stage && ((skin = MenuBarSkin.getMenuBarSkin(stage)) == null || skin.wrappedMenus == null)) {
                stage = (Stage)stage.getOwner();
            }
        } else {
            stage = null;
        }
        if (stage != currentMenuBarStage) {
            MenuBarSkin skin;
            List<MenuBase> menuList = null;
            if (stage != null && (skin = MenuBarSkin.getMenuBarSkin(stage)) != null) {
                menuList = skin.wrappedMenus;
            }
            if (menuList == null) {
                menuList = wrappedDefaultMenus;
            }
            Toolkit.getToolkit().getSystemMenu().setMenus(menuList);
            currentMenuBarStage = stage;
        }
    }

    private static void initSystemMenuBar() {
        systemMenuMap = new WeakHashMap();
        InvalidationListener focusedStageListener = MenuBarSkin$$Lambda$2.lambdaFactory$();
        ObservableList<Stage> stages = StageHelper.getStages();
        for (Stage stage : stages) {
            stage.focusedProperty().addListener(focusedStageListener);
        }
        stages.addListener(MenuBarSkin$$Lambda$3.lambdaFactory$(focusedStageListener));
    }

    EventHandler<KeyEvent> getKeyEventHandler() {
        return this.keyEventHandler;
    }

    public MenuBarSkin(MenuBar control) {
        super(control, new BehaviorBase<MenuBar>(control, Collections.emptyList()));
        this.container = new HBox();
        this.container.getStyleClass().add("container");
        this.getChildren().add(this.container);
        this.keyEventHandler = MenuBarSkin$$Lambda$6.lambdaFactory$(this, control);
        this.menuBarFocusedPropertyListener = MenuBarSkin$$Lambda$7.lambdaFactory$(this);
        this.weakSceneKeyEventHandler = new WeakEventHandler<KeyEvent>(this.keyEventHandler);
        Utils.executeOnceWhenPropertyIsNonNull(control.sceneProperty(), MenuBarSkin$$Lambda$8.lambdaFactory$(this));
        this.mouseEventHandler = MenuBarSkin$$Lambda$9.lambdaFactory$(this);
        this.weakSceneMouseEventHandler = new WeakEventHandler<MouseEvent>(this.mouseEventHandler);
        Utils.executeOnceWhenPropertyIsNonNull(control.sceneProperty(), MenuBarSkin$$Lambda$10.lambdaFactory$(this));
        this.weakWindowFocusListener = new WeakChangeListener(MenuBarSkin$$Lambda$11.lambdaFactory$(this));
        Utils.executeOnceWhenPropertyIsNonNull(control.sceneProperty(), MenuBarSkin$$Lambda$12.lambdaFactory$(this));
        this.rebuildUI();
        control.getMenus().addListener(MenuBarSkin$$Lambda$13.lambdaFactory$(this));
        for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
            menu.visibleProperty().addListener(MenuBarSkin$$Lambda$14.lambdaFactory$(this));
        }
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            control.useSystemMenuBarProperty().addListener(MenuBarSkin$$Lambda$15.lambdaFactory$(this));
        }
        KeyCombination acceleratorKeyCombo = com.sun.javafx.util.Utils.isMac() ? KeyCombination.keyCombination("ctrl+F10") : KeyCombination.keyCombination("F10");
        Utils.executeOnceWhenPropertyIsNonNull(control.sceneProperty(), MenuBarSkin$$Lambda$16.lambdaFactory$(this, acceleratorKeyCombo));
        ParentTraversalEngine engine = new ParentTraversalEngine((Parent)((Object)this.getSkinnable()));
        engine.addTraverseListener(this);
        ((MenuBar)this.getSkinnable()).setImpl_traversalEngine(engine);
        control.sceneProperty().addListener(MenuBarSkin$$Lambda$17.lambdaFactory$(this, acceleratorKeyCombo));
    }

    MenuButton getNodeForMenu(int i) {
        if (i < this.container.getChildren().size()) {
            return (MenuBarButton)this.container.getChildren().get(i);
        }
        return null;
    }

    int getFocusedMenuIndex() {
        return this.focusedMenuIndex;
    }

    private boolean menusContainCustomMenuItem() {
        for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
            if (!this.menuContainsCustomMenuItem(menu)) continue;
            System.err.println("Warning: MenuBar ignored property useSystemMenuBar because menus contain CustomMenuItem");
            return true;
        }
        return false;
    }

    private boolean menuContainsCustomMenuItem(Menu menu) {
        for (MenuItem mi : menu.getItems()) {
            if (mi instanceof CustomMenuItem && !(mi instanceof SeparatorMenuItem)) {
                return true;
            }
            if (!(mi instanceof Menu) || !this.menuContainsCustomMenuItem((Menu)mi)) continue;
            return true;
        }
        return false;
    }

    private int getMenuBarButtonIndex(MenuBarButton m) {
        for (int i = 0; i < this.container.getChildren().size(); ++i) {
            MenuBarButton menuButton = (MenuBarButton)this.container.getChildren().get(i);
            if (m != menuButton) continue;
            return i;
        }
        return -1;
    }

    private void updateActionListeners(Menu m, boolean add) {
        if (add) {
            m.getItems().addListener(this.menuItemListener);
        } else {
            m.getItems().removeListener(this.menuItemListener);
        }
        for (MenuItem mi : m.getItems()) {
            if (mi instanceof Menu) {
                this.updateActionListeners((Menu)mi, add);
                continue;
            }
            if (add) {
                mi.addEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
                continue;
            }
            mi.removeEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
        }
    }

    private void rebuildUI() {
        MenuBarButton menuButton;
        ((MenuBar)this.getSkinnable()).focusedProperty().removeListener(this.menuBarFocusedPropertyListener);
        for (Menu m : ((MenuBar)this.getSkinnable()).getMenus()) {
            this.updateActionListeners(m, false);
        }
        for (Node n : this.container.getChildren()) {
            menuButton = (MenuBarButton)n;
            menuButton.hide();
            menuButton.menu.showingProperty().removeListener(menuButton.menuListener);
            menuButton.disableProperty().unbind();
            menuButton.textProperty().unbind();
            menuButton.graphicProperty().unbind();
            menuButton.styleProperty().unbind();
            menuButton.dispose();
            menuButton.setSkin(null);
            menuButton = null;
        }
        this.container.getChildren().clear();
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            MenuBarSkin curMBSkin;
            Scene scene = ((MenuBar)this.getSkinnable()).getScene();
            if (scene != null) {
                if (this.sceneChangeListener == null) {
                    this.sceneChangeListener = MenuBarSkin$$Lambda$18.lambdaFactory$(this);
                    ((MenuBar)this.getSkinnable()).sceneProperty().addListener(this.sceneChangeListener);
                }
                this.sceneChangeListener.changed(((MenuBar)this.getSkinnable()).sceneProperty(), scene, scene);
                if (currentMenuBarStage != null ? MenuBarSkin.getMenuBarSkin(currentMenuBarStage) == this : ((MenuBar)this.getSkinnable()).isUseSystemMenuBar()) {
                    return;
                }
            } else if (currentMenuBarStage != null && (curMBSkin = MenuBarSkin.getMenuBarSkin(currentMenuBarStage)) == this) {
                MenuBarSkin.setSystemMenu(null);
            }
        }
        ((MenuBar)this.getSkinnable()).focusedProperty().addListener(this.menuBarFocusedPropertyListener);
        for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
            if (!menu.isVisible()) continue;
            menuButton = new MenuBarButton(this, menu);
            menuButton.setFocusTraversable(false);
            menuButton.getStyleClass().add("menu");
            menuButton.setStyle(menu.getStyle());
            menuButton.getItems().setAll((Collection<MenuItem>)menu.getItems());
            this.container.getChildren().add(menuButton);
            menuButton.menuListener = MenuBarSkin$$Lambda$19.lambdaFactory$(this, menu, menuButton);
            menuButton.menu = menu;
            menu.showingProperty().addListener(menuButton.menuListener);
            menuButton.disableProperty().bindBidirectional(menu.disableProperty());
            menuButton.textProperty().bind(menu.textProperty());
            menuButton.graphicProperty().bind(menu.graphicProperty());
            menuButton.styleProperty().bind(menu.styleProperty());
            menuButton.getProperties().addListener(MenuBarSkin$$Lambda$20.lambdaFactory$(menuButton, menu));
            menuButton.showingProperty().addListener(MenuBarSkin$$Lambda$21.lambdaFactory$(this, menuButton, menu));
            menuButton.setOnMousePressed(MenuBarSkin$$Lambda$22.lambdaFactory$(this, menuButton, menu));
            menuButton.setOnMouseReleased(MenuBarSkin$$Lambda$23.lambdaFactory$(this, menuButton));
            menuButton.setOnMouseEntered(MenuBarSkin$$Lambda$24.lambdaFactory$(this, menuButton, menu));
            this.updateActionListeners(menu, true);
        }
        ((MenuBar)this.getSkinnable()).requestLayout();
    }

    public final void setSpacing(double value) {
        this.spacingProperty().set(this.snapSpace(value));
    }

    public final double getSpacing() {
        return this.spacing == null ? 0.0 : this.snapSpace(this.spacing.get());
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new StyleableDoubleProperty(){

                @Override
                protected void invalidated() {
                    double value = this.get();
                    MenuBarSkin.this.container.setSpacing(value);
                }

                @Override
                public Object getBean() {
                    return MenuBarSkin.this;
                }

                @Override
                public String getName() {
                    return "spacing";
                }

                @Override
                public CssMetaData<MenuBar, Number> getCssMetaData() {
                    return SPACING;
                }
            };
        }
        return this.spacing;
    }

    public final void setContainerAlignment(Pos value) {
        this.containerAlignmentProperty().set(value);
    }

    public final Pos getContainerAlignment() {
        return this.containerAlignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.containerAlignment.get());
    }

    public final ObjectProperty<Pos> containerAlignmentProperty() {
        if (this.containerAlignment == null) {
            this.containerAlignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    Pos value = (Pos)((Object)this.get());
                    MenuBarSkin.this.container.setAlignment(value);
                }

                @Override
                public Object getBean() {
                    return MenuBarSkin.this;
                }

                @Override
                public String getName() {
                    return "containerAlignment";
                }

                @Override
                public CssMetaData<MenuBar, Pos> getCssMetaData() {
                    return ALIGNMENT;
                }
            };
        }
        return this.containerAlignment;
    }

    @Override
    public void dispose() {
        this.cleanUpSystemMenu();
        super.dispose();
    }

    private void cleanUpSystemMenu() {
        if (this.sceneChangeListener != null && this.getSkinnable() != null) {
            ((MenuBar)this.getSkinnable()).sceneProperty().removeListener(this.sceneChangeListener);
            this.sceneChangeListener = null;
        }
        if (currentMenuBarStage != null && MenuBarSkin.getMenuBarSkin(currentMenuBarStage) == this) {
            MenuBarSkin.setSystemMenu(null);
        }
        if (systemMenuMap != null) {
            Iterator<Map.Entry<Stage, Reference<MenuBarSkin>>> iterator = systemMenuMap.entrySet().iterator();
            while (iterator.hasNext()) {
                MenuBarSkin skin;
                Map.Entry<Stage, Reference<MenuBarSkin>> entry = iterator.next();
                Reference<MenuBarSkin> ref = entry.getValue();
                MenuBarSkin menuBarSkin = skin = ref != null ? ref.get() : null;
                if (skin != null && skin != this) continue;
                iterator.remove();
            }
        }
    }

    private boolean isMenuEmpty(Menu menu) {
        boolean retVal = true;
        if (menu != null) {
            for (MenuItem m : menu.getItems()) {
                if (m == null || !m.isVisible()) continue;
                retVal = false;
            }
        }
        return retVal;
    }

    private void resetOpenMenu() {
        if (this.openMenu != null) {
            this.openMenu.hide();
            this.openMenu = null;
            this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
            this.openMenuButton.clearHover();
            this.openMenuButton = null;
            this.menuModeEnd();
        }
    }

    private void unSelectMenus() {
        this.clearMenuButtonHover();
        if (this.focusedMenuIndex == -1) {
            return;
        }
        if (this.openMenu != null) {
            this.openMenu.hide();
            this.openMenu = null;
        }
        if (this.openMenuButton != null) {
            this.openMenuButton.clearHover();
            this.openMenuButton = null;
        }
        this.menuModeEnd();
    }

    private void menuModeStart(int newIndex) {
        if (this.focusedMenuIndex == -1) {
            SceneHelper.getSceneAccessor().setTransientFocusContainer(((MenuBar)this.getSkinnable()).getScene(), (Node)((Object)this.getSkinnable()));
        }
        this.focusedMenuIndex = newIndex;
    }

    private void menuModeEnd() {
        if (this.focusedMenuIndex != -1) {
            SceneHelper.getSceneAccessor().setTransientFocusContainer(((MenuBar)this.getSkinnable()).getScene(), null);
            ((MenuBar)this.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_NODE);
        }
        this.focusedMenuIndex = -1;
    }

    private void selectNextMenu() {
        Menu nextMenu = this.findNextSibling();
        if (nextMenu != null && this.focusedMenuIndex != -1) {
            this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
            this.openMenuButton.setHover();
            this.openMenu = nextMenu;
        }
    }

    private void selectPrevMenu() {
        Menu prevMenu = this.findPreviousSibling();
        if (prevMenu != null && this.focusedMenuIndex != -1) {
            this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
            this.openMenuButton.setHover();
            this.openMenu = prevMenu;
        }
    }

    private void showNextMenu() {
        Menu nextMenu = this.findNextSibling();
        if (this.openMenu != null) {
            this.openMenu.hide();
        }
        this.openMenu = nextMenu;
        if (!this.isMenuEmpty(nextMenu)) {
            this.openMenu.show();
        }
    }

    private void showPrevMenu() {
        Menu prevMenu = this.findPreviousSibling();
        if (this.openMenu != null) {
            this.openMenu.hide();
        }
        this.openMenu = prevMenu;
        if (!this.isMenuEmpty(prevMenu)) {
            this.openMenu.show();
        }
    }

    private Menu findPreviousSibling() {
        if (this.focusedMenuIndex == -1) {
            return null;
        }
        this.focusedMenuIndex = this.focusedMenuIndex == 0 ? this.container.getChildren().size() - 1 : --this.focusedMenuIndex;
        if (((Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex)).isDisable()) {
            return this.findPreviousSibling();
        }
        this.clearMenuButtonHover();
        return (Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex);
    }

    private Menu findNextSibling() {
        if (this.focusedMenuIndex == -1) {
            return null;
        }
        this.focusedMenuIndex = this.focusedMenuIndex == this.container.getChildren().size() - 1 ? 0 : ++this.focusedMenuIndex;
        if (((Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex)).isDisable()) {
            return this.findNextSibling();
        }
        this.clearMenuButtonHover();
        return (Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex);
    }

    private void updateFocusedIndex() {
        int index = 0;
        for (Node n : this.container.getChildren()) {
            if (n.isHover()) {
                this.focusedMenuIndex = index;
                return;
            }
            ++index;
        }
        this.menuModeEnd();
    }

    private void clearMenuButtonHover() {
        for (Node n : this.container.getChildren()) {
            if (!n.isHover()) continue;
            ((MenuBarButton)n).clearHover();
            return;
        }
    }

    @Override
    public void onTraverse(Node node, Bounds bounds) {
        if (this.openMenu != null) {
            this.openMenu.hide();
        }
        this.focusedMenuIndex = 0;
    }

    @Override
    protected double snappedTopInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedTopInset();
    }

    @Override
    protected double snappedBottomInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedBottomInset();
    }

    @Override
    protected double snappedLeftInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedLeftInset();
    }

    @Override
    protected double snappedRightInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedRightInset();
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        this.container.resizeRelocate(x, y, w, h);
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.container.minWidth(height) + this.snappedLeftInset() + this.snappedRightInset();
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.container.prefWidth(height) + this.snappedLeftInset() + this.snappedRightInset();
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.container.minHeight(width) + this.snappedTopInset() + this.snappedBottomInset();
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.container.prefHeight(width) + this.snappedTopInset() + this.snappedBottomInset();
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MenuBar)this.getSkinnable()).prefHeight(-1.0);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return MenuBarSkin.getClassCssMetaData();
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case FOCUS_NODE: {
                return this.openMenuButton;
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    /* synthetic */ void lambda$rebuildUI$404(MenuBarButton menuBarButton, Menu menu, MouseEvent event) {
        if (menuBarButton.getScene() != null && menuBarButton.getScene().getWindow() != null && menuBarButton.getScene().getWindow().isFocused()) {
            if (this.openMenuButton != null && this.openMenuButton != menuBarButton) {
                this.openMenuButton.clearHover();
                this.openMenuButton = null;
                this.openMenuButton = menuBarButton;
            }
            this.updateFocusedIndex();
            if (this.openMenu != null && this.openMenu != menu) {
                this.openMenu.hide();
                this.openMenu = menu;
                this.updateFocusedIndex();
                if (!this.isMenuEmpty(menu)) {
                    this.openMenu.show();
                }
            }
        }
    }

    /* synthetic */ void lambda$rebuildUI$403(MenuBarButton menuBarButton, MouseEvent event) {
        if (menuBarButton.getScene().getWindow().isFocused() && this.pendingDismiss) {
            this.resetOpenMenu();
        }
        this.pendingDismiss = false;
    }

    /* synthetic */ void lambda$rebuildUI$402(MenuBarButton menuBarButton, Menu menu, MouseEvent event) {
        this.pendingDismiss = menuBarButton.isShowing();
        if (menuBarButton.getScene().getWindow().isFocused()) {
            this.openMenu = menu;
            if (!this.isMenuEmpty(menu)) {
                this.openMenu.show();
            }
            this.menuModeStart(this.getMenuBarButtonIndex(menuBarButton));
        }
    }

    /* synthetic */ void lambda$rebuildUI$401(MenuBarButton menuBarButton, Menu menu, ObservableValue observable, Boolean oldValue, Boolean isShowing) {
        if (isShowing.booleanValue()) {
            if (this.openMenuButton != null && this.openMenuButton != menuBarButton) {
                this.openMenuButton.hide();
            }
            this.openMenuButton = menuBarButton;
            this.openMenu = menu;
            if (!menu.isShowing()) {
                menu.show();
            }
        }
    }

    static /* synthetic */ void lambda$rebuildUI$400(MenuBarButton menuBarButton, Menu menu, MapChangeListener.Change c) {
        if (c.wasAdded() && "autoHide".equals(c.getKey())) {
            menuBarButton.getProperties().remove("autoHide");
            menu.hide();
        }
    }

    /* synthetic */ void lambda$rebuildUI$399(Menu menu, MenuBarButton menuBarButton, ObservableValue observable, Boolean oldValue, Boolean newValue) {
        if (menu.isShowing()) {
            menuBarButton.show();
            this.menuModeStart(this.container.getChildren().indexOf(menuBarButton));
        } else {
            menuBarButton.hide();
        }
    }

    /* synthetic */ void lambda$rebuildUI$398(ObservableValue observable, Scene oldValue, Scene newValue) {
        Stage stage;
        MenuBarSkin curMBSkin;
        if (oldValue != null && oldValue.getWindow() instanceof Stage && (curMBSkin = MenuBarSkin.getMenuBarSkin(stage = (Stage)oldValue.getWindow())) == this) {
            curMBSkin.wrappedMenus = null;
            systemMenuMap.remove(stage);
            if (currentMenuBarStage == stage) {
                currentMenuBarStage = null;
                MenuBarSkin.setSystemMenu(stage);
            }
        }
        if (newValue != null && ((MenuBar)this.getSkinnable()).isUseSystemMenuBar() && !this.menusContainCustomMenuItem() && newValue.getWindow() instanceof Stage) {
            stage = (Stage)newValue.getWindow();
            if (systemMenuMap == null) {
                MenuBarSkin.initSystemMenuBar();
            }
            if (this.wrappedMenus == null) {
                this.wrappedMenus = new ArrayList<MenuBase>();
                systemMenuMap.put(stage, new WeakReference<MenuBarSkin>(this));
            } else {
                this.wrappedMenus.clear();
            }
            for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
                this.wrappedMenus.add(GlobalMenuAdapter.adapt(menu));
            }
            currentMenuBarStage = null;
            MenuBarSkin.setSystemMenu(stage);
            ((MenuBar)this.getSkinnable()).requestLayout();
            Platform.runLater(MenuBarSkin$$Lambda$25.lambdaFactory$(this));
        }
    }

    /* synthetic */ void lambda$null$397() {
        ((MenuBar)this.getSkinnable()).requestLayout();
    }

    /* synthetic */ void lambda$new$396(ListChangeListener.Change c) {
        while (c.next()) {
            for (MenuItem mi : c.getAddedSubList()) {
                mi.addEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
            }
            for (MenuItem mi : c.getRemoved()) {
                mi.removeEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
            }
        }
    }

    /* synthetic */ void lambda$new$395(ActionEvent t) {
        CustomMenuItem cmi;
        if (t.getSource() instanceof CustomMenuItem && !(cmi = (CustomMenuItem)t.getSource()).isHideOnClick()) {
            return;
        }
        this.unSelectMenus();
    }

    /* synthetic */ void lambda$new$394(KeyCombination keyCombination, ObservableValue ov, Scene t, Scene t1) {
        if (this.weakSceneKeyEventHandler != null && t != null) {
            t.removeEventFilter(KeyEvent.KEY_PRESSED, this.weakSceneKeyEventHandler);
        }
        if (this.weakSceneMouseEventHandler != null && t != null) {
            t.removeEventFilter(MouseEvent.MOUSE_CLICKED, this.weakSceneMouseEventHandler);
        }
        if (t != null) {
            t.getAccelerators().remove(keyCombination);
        }
        if (t1 != null) {
            t1.getAccelerators().put(keyCombination, this.firstMenuRunnable);
        }
    }

    /* synthetic */ void lambda$new$393(KeyCombination keyCombination, Scene scene) {
        scene.getAccelerators().put(keyCombination, this.firstMenuRunnable);
        scene.addEventHandler(KeyEvent.KEY_PRESSED, MenuBarSkin$$Lambda$26.lambdaFactory$(this));
    }

    /* synthetic */ void lambda$null$392(KeyEvent e) {
        if (e.isAltDown() && !e.isConsumed()) {
            this.firstMenuRunnable.run();
        }
    }

    /* synthetic */ void lambda$new$391(Observable valueModel) {
        this.rebuildUI();
    }

    /* synthetic */ void lambda$new$390(ObservableValue ov, Boolean t, Boolean t1) {
        this.rebuildUI();
    }

    /* synthetic */ void lambda$new$389(ListChangeListener.Change c) {
        this.rebuildUI();
    }

    /* synthetic */ void lambda$new$388(Scene scene) {
        if (scene.getWindow() != null) {
            scene.getWindow().focusedProperty().addListener(this.weakWindowFocusListener);
        } else {
            ChangeListener sceneWindowListener = MenuBarSkin$$Lambda$27.lambdaFactory$(this);
            this.weakWindowSceneListener = new WeakChangeListener(sceneWindowListener);
            scene.windowProperty().addListener(this.weakWindowSceneListener);
        }
    }

    /* synthetic */ void lambda$null$387(ObservableValue observable, Window oldValue, Window newValue) {
        if (oldValue != null) {
            oldValue.focusedProperty().removeListener(this.weakWindowFocusListener);
        }
        if (newValue != null) {
            newValue.focusedProperty().addListener(this.weakWindowFocusListener);
        }
    }

    /* synthetic */ void lambda$new$386(ObservableValue ov, Boolean t, Boolean t1) {
        if (!t1.booleanValue()) {
            this.unSelectMenus();
        }
    }

    /* synthetic */ void lambda$new$385(Scene scene) {
        scene.addEventFilter(MouseEvent.MOUSE_CLICKED, this.weakSceneMouseEventHandler);
    }

    /* synthetic */ void lambda$new$384(MouseEvent t) {
        if (!this.container.localToScreen(this.container.getLayoutBounds()).contains(t.getScreenX(), t.getScreenY())) {
            this.unSelectMenus();
        }
    }

    /* synthetic */ void lambda$new$383(Scene scene) {
        scene.addEventFilter(KeyEvent.KEY_PRESSED, this.weakSceneKeyEventHandler);
    }

    /* synthetic */ void lambda$new$382(ObservableValue ov, Boolean t, Boolean t1) {
        if (t1.booleanValue()) {
            this.unSelectMenus();
            this.menuModeStart(0);
            this.openMenuButton = (MenuBarButton)this.container.getChildren().get(0);
            this.openMenu = (Menu)((MenuBar)this.getSkinnable()).getMenus().get(0);
            this.openMenuButton.setHover();
        } else {
            this.unSelectMenus();
        }
    }

    /* synthetic */ void lambda$new$381(MenuBar menuBar, KeyEvent event) {
        if (this.openMenu != null) {
            switch (event.getCode()) {
                case LEFT: {
                    boolean isRTL;
                    boolean bl = isRTL = menuBar.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
                    if (menuBar.getScene().getWindow().isFocused()) {
                        if (this.openMenu == null) {
                            return;
                        }
                        if (!this.openMenu.isShowing()) {
                            if (isRTL) {
                                this.selectNextMenu();
                            } else {
                                this.selectPrevMenu();
                            }
                            event.consume();
                            return;
                        }
                        if (isRTL) {
                            this.showNextMenu();
                        } else {
                            this.showPrevMenu();
                        }
                    }
                    event.consume();
                    break;
                }
                case RIGHT: {
                    boolean isRTL;
                    boolean bl = isRTL = menuBar.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
                    if (menuBar.getScene().getWindow().isFocused()) {
                        if (this.openMenu == null) {
                            return;
                        }
                        if (!this.openMenu.isShowing()) {
                            if (isRTL) {
                                this.selectPrevMenu();
                            } else {
                                this.selectNextMenu();
                            }
                            event.consume();
                            return;
                        }
                        if (isRTL) {
                            this.showPrevMenu();
                        } else {
                            this.showNextMenu();
                        }
                    }
                    event.consume();
                    break;
                }
                case DOWN: {
                    if (!menuBar.getScene().getWindow().isFocused() || this.focusedMenuIndex == -1 || this.openMenu == null) break;
                    this.openMenu = (Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex);
                    if (!this.isMenuEmpty((Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex))) {
                        this.openMenu.show();
                    }
                    event.consume();
                    break;
                }
                case ESCAPE: {
                    this.unSelectMenus();
                    event.consume();
                    break;
                }
            }
        }
    }

    static /* synthetic */ void lambda$initSystemMenuBar$380(InvalidationListener invalidationListener, ListChangeListener.Change c) {
        while (c.next()) {
            for (Stage stage : c.getRemoved()) {
                stage.focusedProperty().removeListener(invalidationListener);
            }
            for (Stage stage : c.getAddedSubList()) {
                stage.focusedProperty().addListener(invalidationListener);
                MenuBarSkin.setSystemMenu(stage);
            }
        }
    }

    static /* synthetic */ void lambda$initSystemMenuBar$379(Observable ov) {
        MenuBarSkin.setSystemMenu((Stage)((ReadOnlyProperty)ov).getBean());
    }

    static /* synthetic */ void lambda$setDefaultSystemMenuBar$378(MenuBar menuBar, ListChangeListener.Change c) {
        wrappedDefaultMenus.clear();
        for (Menu menu : menuBar.getMenus()) {
            wrappedDefaultMenus.add(GlobalMenuAdapter.adapt(menu));
        }
    }

    static {
        wrappedDefaultMenus = new ArrayList<MenuBase>();
        SPACING = new CssMetaData<MenuBar, Number>("-fx-spacing", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(MenuBar n) {
                MenuBarSkin skin = (MenuBarSkin)n.getSkin();
                return skin.spacing == null || !skin.spacing.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(MenuBar n) {
                MenuBarSkin skin = (MenuBarSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.spacingProperty());
            }
        };
        ALIGNMENT = new CssMetaData<MenuBar, Pos>("-fx-alignment", new EnumConverter<Pos>(Pos.class), Pos.TOP_LEFT){

            @Override
            public boolean isSettable(MenuBar n) {
                MenuBarSkin skin = (MenuBarSkin)n.getSkin();
                return skin.containerAlignment == null || !skin.containerAlignment.isBound();
            }

            @Override
            public StyleableProperty<Pos> getStyleableProperty(MenuBar n) {
                MenuBarSkin skin = (MenuBarSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.containerAlignmentProperty());
            }
        };
        ArrayList styleables = new ArrayList(SkinBase.getClassCssMetaData());
        String alignmentProperty = ALIGNMENT.getProperty();
        int nMax = styleables.size();
        for (int n = 0; n < nMax; ++n) {
            CssMetaData prop = (CssMetaData)styleables.get(n);
            if (!alignmentProperty.equals(prop.getProperty())) continue;
            styleables.remove(prop);
        }
        styleables.add(SPACING);
        styleables.add(ALIGNMENT);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    static class MenuBarButton
    extends MenuButton {
        private ChangeListener<Boolean> menuListener;
        private MenuBarSkin menuBarSkin;
        private Menu menu;
        private final ListChangeListener<MenuItem> itemsListener;
        private final ListChangeListener<String> styleClassListener;

        public MenuBarButton(MenuBarSkin menuBarSkin, Menu menu) {
            super(menu.getText(), menu.getGraphic());
            this.menuBarSkin = menuBarSkin;
            this.setAccessibleRole(AccessibleRole.MENU);
            this.itemsListener = MenuBarSkin$MenuBarButton$$Lambda$1.lambdaFactory$(this);
            menu.getItems().addListener(this.itemsListener);
            this.styleClassListener = MenuBarSkin$MenuBarButton$$Lambda$2.lambdaFactory$(this, menu);
            menu.getStyleClass().addListener(this.styleClassListener);
            this.idProperty().bind(menu.idProperty());
        }

        public MenuBarSkin getMenuBarSkin() {
            return this.menuBarSkin;
        }

        private void clearHover() {
            this.setHover(false);
        }

        private void setHover() {
            this.setHover(true);
            ((MenuBar)this.menuBarSkin.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_NODE);
        }

        void dispose() {
            this.menu.getItems().removeListener(this.itemsListener);
            this.menu.getStyleClass().removeListener(this.styleClassListener);
            this.idProperty().unbind();
        }

        @Override
        public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
            switch (attribute) {
                case FOCUS_ITEM: {
                    return this;
                }
            }
            return super.queryAccessibleAttribute(attribute, parameters);
        }

        /* synthetic */ void lambda$new$406(Menu menu, ListChangeListener.Change c) {
            while (c.next()) {
                for (int i = c.getFrom(); i < c.getTo(); ++i) {
                    this.getStyleClass().add((String)menu.getStyleClass().get(i));
                }
                for (String str : c.getRemoved()) {
                    this.getStyleClass().remove(str);
                }
            }
        }

        /* synthetic */ void lambda$new$405(ListChangeListener.Change c) {
            while (c.next()) {
                this.getItems().removeAll(c.getRemoved());
                this.getItems().addAll(c.getFrom(), c.getAddedSubList());
            }
        }
    }
}

