/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.ControlAcceleratorSupport;
import com.sun.javafx.scene.control.behavior.MenuButtonBehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.ContextMenuContent;
import com.sun.javafx.scene.control.skin.LabeledImpl;
import com.sun.javafx.scene.control.skin.MenuButtonSkinBase$$Lambda$1;
import com.sun.javafx.scene.control.skin.MenuButtonSkinBase$$Lambda$2;
import com.sun.javafx.scene.control.skin.MenuButtonSkinBase$$Lambda$3;
import com.sun.javafx.scene.control.skin.MenuButtonSkinBase$$Lambda$4;
import com.sun.javafx.scene.control.skin.MenuButtonSkinBase$MenuLabeledImpl$$Lambda$1;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public abstract class MenuButtonSkinBase<C extends MenuButton, B extends MenuButtonBehaviorBase<C>>
extends BehaviorSkinBase<C, B> {
    protected final LabeledImpl label;
    protected final StackPane arrow;
    protected final StackPane arrowButton;
    protected ContextMenu popup;
    protected boolean behaveLikeButton = false;
    private ListChangeListener<MenuItem> itemsChangedListener;

    public MenuButtonSkinBase(C control, B behavior) {
        super(control, behavior);
        if (((Node)control).getOnMousePressed() == null) {
            ((Node)control).addEventHandler(MouseEvent.MOUSE_PRESSED, MenuButtonSkinBase$$Lambda$1.lambdaFactory$(this));
        }
        if (((Node)control).getOnMouseReleased() == null) {
            ((Node)control).addEventHandler(MouseEvent.MOUSE_RELEASED, MenuButtonSkinBase$$Lambda$2.lambdaFactory$(this));
        }
        this.label = new MenuLabeledImpl((MenuButton)this.getSkinnable());
        this.label.setMnemonicParsing(((Labeled)control).isMnemonicParsing());
        this.label.setLabelFor((Node)control);
        this.arrow = new StackPane();
        this.arrow.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.arrow.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.arrow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.arrowButton = new StackPane();
        this.arrowButton.getStyleClass().setAll((String[])new String[]{"arrow-button"});
        this.arrowButton.getChildren().add(this.arrow);
        this.popup = new ContextMenu();
        this.popup.getItems().clear();
        this.popup.getItems().addAll((Collection<MenuItem>)((MenuButton)this.getSkinnable()).getItems());
        this.getChildren().clear();
        this.getChildren().addAll((Node[])new Node[]{this.label, this.arrowButton});
        ((MenuButton)this.getSkinnable()).requestLayout();
        this.itemsChangedListener = MenuButtonSkinBase$$Lambda$3.lambdaFactory$(this);
        ((MenuButton)control).getItems().addListener(this.itemsChangedListener);
        if (((MenuButton)this.getSkinnable()).getScene() != null) {
            ControlAcceleratorSupport.addAcceleratorsIntoScene(((MenuButton)this.getSkinnable()).getItems(), (Node)((Object)this.getSkinnable()));
        }
        ((Node)control).sceneProperty().addListener(MenuButtonSkinBase$$Lambda$4.lambdaFactory$(this));
        this.registerChangeListener(((MenuButton)control).showingProperty(), "SHOWING");
        this.registerChangeListener(((Node)control).focusedProperty(), "FOCUSED");
        this.registerChangeListener(((Labeled)control).mnemonicParsingProperty(), "MNEMONIC_PARSING");
        this.registerChangeListener(this.popup.showingProperty(), "POPUP_VISIBLE");
    }

    @Override
    public void dispose() {
        ((MenuButton)this.getSkinnable()).getItems().removeListener(this.itemsChangedListener);
        super.dispose();
        if (this.popup != null) {
            if (this.popup.getSkin() != null && this.popup.getSkin().getNode() != null) {
                ContextMenuContent cmContent = (ContextMenuContent)this.popup.getSkin().getNode();
                cmContent.dispose();
                Object var1_1 = null;
            }
            this.popup.setSkin(null);
            this.popup = null;
        }
    }

    private void show() {
        if (!this.popup.isShowing()) {
            this.popup.show((Node)((Object)this.getSkinnable()), ((MenuButton)this.getSkinnable()).getPopupSide(), 0.0, 0.0);
        }
    }

    private void hide() {
        if (this.popup.isShowing()) {
            this.popup.hide();
        }
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("SHOWING".equals(p)) {
            if (((MenuButton)this.getSkinnable()).isShowing()) {
                this.show();
            } else {
                this.hide();
            }
        } else if ("FOCUSED".equals(p)) {
            if (!((MenuButton)this.getSkinnable()).isFocused() && ((MenuButton)this.getSkinnable()).isShowing()) {
                this.hide();
            }
            if (!((MenuButton)this.getSkinnable()).isFocused() && this.popup.isShowing()) {
                this.hide();
            }
        } else if ("POPUP_VISIBLE".equals(p)) {
            if (!this.popup.isShowing() && ((MenuButton)this.getSkinnable()).isShowing()) {
                ((MenuButton)this.getSkinnable()).hide();
            }
            if (this.popup.isShowing()) {
                Utils.addMnemonics(this.popup, ((MenuButton)this.getSkinnable()).getScene(), ((MenuButton)this.getSkinnable()).impl_isShowMnemonics());
            } else {
                Utils.removeMnemonics(this.popup, ((MenuButton)this.getSkinnable()).getScene());
            }
        } else if ("MNEMONIC_PARSING".equals(p)) {
            this.label.setMnemonicParsing(((MenuButton)this.getSkinnable()).isMnemonicParsing());
            ((MenuButton)this.getSkinnable()).requestLayout();
        }
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.label.minWidth(height) + this.snapSize(this.arrowButton.minWidth(height)) + rightInset;
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + Math.max(this.label.minHeight(width), this.snapSize(this.arrowButton.minHeight(-1.0))) + bottomInset;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.label.prefWidth(height) + this.snapSize(this.arrowButton.prefWidth(height)) + rightInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + Math.max(this.label.prefHeight(width), this.snapSize(this.arrowButton.prefHeight(-1.0))) + bottomInset;
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MenuButton)this.getSkinnable()).prefWidth(height);
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MenuButton)this.getSkinnable()).prefHeight(width);
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double arrowButtonWidth = this.snapSize(this.arrowButton.prefWidth(-1.0));
        this.label.resizeRelocate(x, y, w - arrowButtonWidth, h);
        this.arrowButton.resizeRelocate(x + (w - arrowButtonWidth), y, arrowButtonWidth, h);
    }

    /* synthetic */ void lambda$new$410(ObservableValue scene, Scene oldValue, Scene newValue) {
        if (this.getSkinnable() != null && ((MenuButton)this.getSkinnable()).getScene() != null) {
            ControlAcceleratorSupport.addAcceleratorsIntoScene(((MenuButton)this.getSkinnable()).getItems(), (Node)((Object)this.getSkinnable()));
        }
    }

    /* synthetic */ void lambda$new$409(ListChangeListener.Change c) {
        while (c.next()) {
            this.popup.getItems().removeAll(c.getRemoved());
            this.popup.getItems().addAll(c.getFrom(), c.getAddedSubList());
        }
    }

    /* synthetic */ void lambda$new$408(MouseEvent e) {
        ((MenuButtonBehaviorBase)this.getBehavior()).mouseReleased(e, this.behaveLikeButton);
    }

    /* synthetic */ void lambda$new$407(MouseEvent e) {
        ((MenuButtonBehaviorBase)this.getBehavior()).mousePressed(e, this.behaveLikeButton);
    }

    private class MenuLabeledImpl
    extends LabeledImpl {
        MenuButton button;

        public MenuLabeledImpl(MenuButton b) {
            super(b);
            this.button = b;
            this.addEventHandler(ActionEvent.ACTION, MenuButtonSkinBase$MenuLabeledImpl$$Lambda$1.lambdaFactory$(this));
        }

        /* synthetic */ void lambda$new$411(ActionEvent e) {
            this.button.fireEvent(new ActionEvent());
            e.consume();
        }
    }
}

