/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.behavior.PaginationBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.PaginationSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.PaginationSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.PaginationSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.PaginationSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.PaginationSkin$$Lambda$5;
import com.sun.javafx.scene.control.skin.PaginationSkin$$Lambda$6;
import com.sun.javafx.scene.control.skin.PaginationSkin$IndicatorButton$$Lambda$1;
import com.sun.javafx.scene.control.skin.PaginationSkin$IndicatorButton$$Lambda$2;
import com.sun.javafx.scene.control.skin.PaginationSkin$NavigationControl$$Lambda$1;
import com.sun.javafx.scene.control.skin.PaginationSkin$NavigationControl$$Lambda$2;
import com.sun.javafx.scene.control.skin.PaginationSkin$NavigationControl$$Lambda$3;
import com.sun.javafx.scene.control.skin.PaginationSkin$NavigationControl$$Lambda$4;
import com.sun.javafx.scene.control.skin.PaginationSkin$NavigationControl$$Lambda$5;
import com.sun.javafx.scene.control.skin.PaginationSkin$NavigationControl$$Lambda$6;
import com.sun.javafx.scene.control.skin.PaginationSkin$NavigationControl$$Lambda$7;
import com.sun.javafx.scene.control.skin.PaginationSkin$NavigationControl$$Lambda$8;
import com.sun.javafx.scene.control.skin.PaginationSkin$NavigationControl$$Lambda$9;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Pagination;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.util.Duration;

public class PaginationSkin
extends BehaviorSkinBase<Pagination, PaginationBehavior> {
    private static final Duration DURATION = new Duration(125.0);
    private static final double SWIPE_THRESHOLD = 0.3;
    private static final double TOUCH_THRESHOLD = 15.0;
    private Pagination pagination;
    private StackPane currentStackPane;
    private StackPane nextStackPane;
    private Timeline timeline;
    private Rectangle clipRect;
    private NavigationControl navigation;
    private int fromIndex;
    private int previousIndex;
    private int currentIndex;
    private int toIndex;
    private int pageCount;
    private int maxPageIndicatorCount;
    private boolean animate = true;
    private double startTouchPos;
    private double lastTouchPos;
    private long startTouchTime;
    private long lastTouchTime;
    private double touchVelocity;
    private boolean touchThresholdBroken;
    private int touchEventId = -1;
    private boolean nextPageReached = false;
    private boolean setInitialDirection = false;
    private int direction;
    private static final Interpolator interpolator = Interpolator.SPLINE(0.4829, 0.5709, 0.6803, 0.9928);
    private int currentAnimatedIndex;
    private boolean hasPendingAnimation = false;
    private EventHandler<ActionEvent> swipeAnimationEndEventHandler = new EventHandler<ActionEvent>(){

        @Override
        public void handle(ActionEvent t) {
            PaginationSkin.this.swapPanes();
            PaginationSkin.this.timeline = null;
            if (PaginationSkin.this.hasPendingAnimation) {
                PaginationSkin.this.animateSwitchPage();
                PaginationSkin.this.hasPendingAnimation = false;
            }
        }
    };
    private EventHandler<ActionEvent> clampAnimationEndEventHandler = new EventHandler<ActionEvent>(){

        @Override
        public void handle(ActionEvent t) {
            PaginationSkin.this.currentStackPane.setTranslateX(0.0);
            PaginationSkin.this.nextStackPane.setTranslateX(0.0);
            PaginationSkin.this.nextStackPane.setVisible(false);
            PaginationSkin.this.timeline = null;
        }
    };
    private final DoubleProperty arrowButtonGap = new StyleableDoubleProperty(60.0){

        @Override
        public Object getBean() {
            return PaginationSkin.this;
        }

        @Override
        public String getName() {
            return "arrowButtonGap";
        }

        @Override
        public CssMetaData<Pagination, Number> getCssMetaData() {
            return StyleableProperties.ARROW_BUTTON_GAP;
        }
    };
    private BooleanProperty arrowsVisible;
    private BooleanProperty pageInformationVisible;
    private ObjectProperty<Side> pageInformationAlignment;
    private BooleanProperty tooltipVisible;
    private static final Boolean DEFAULT_ARROW_VISIBLE = Boolean.FALSE;
    private static final Boolean DEFAULT_PAGE_INFORMATION_VISIBLE = Boolean.FALSE;
    private static final Side DEFAULT_PAGE_INFORMATION_ALIGNMENT = Side.BOTTOM;
    private static final Boolean DEFAULT_TOOLTIP_VISIBLE = Boolean.FALSE;

    public PaginationSkin(Pagination pagination) {
        super(pagination, new PaginationBehavior(pagination));
        this.clipRect = new Rectangle();
        ((Pagination)this.getSkinnable()).setClip(this.clipRect);
        this.pagination = pagination;
        this.currentStackPane = new StackPane();
        this.currentStackPane.getStyleClass().add("page");
        this.nextStackPane = new StackPane();
        this.nextStackPane.getStyleClass().add("page");
        this.nextStackPane.setVisible(false);
        this.resetIndexes(true);
        this.navigation = new NavigationControl();
        this.getChildren().addAll((Node[])new Node[]{this.currentStackPane, this.nextStackPane, this.navigation});
        pagination.maxPageIndicatorCountProperty().addListener(PaginationSkin$$Lambda$1.lambdaFactory$(this));
        this.registerChangeListener(pagination.widthProperty(), "WIDTH");
        this.registerChangeListener(pagination.heightProperty(), "HEIGHT");
        this.registerChangeListener(pagination.pageCountProperty(), "PAGE_COUNT");
        this.registerChangeListener(pagination.pageFactoryProperty(), "PAGE_FACTORY");
        this.initializeSwipeAndTouchHandlers();
    }

    protected void resetIndiciesAndNav() {
        this.resetIndexes(false);
        this.navigation.initializePageIndicators();
        this.navigation.updatePageIndicators();
    }

    public void selectNext() {
        if (this.getCurrentPageIndex() < this.getPageCount() - 1) {
            this.pagination.setCurrentPageIndex(this.getCurrentPageIndex() + 1);
        }
    }

    public void selectPrevious() {
        if (this.getCurrentPageIndex() > 0) {
            this.pagination.setCurrentPageIndex(this.getCurrentPageIndex() - 1);
        }
    }

    private void initializeSwipeAndTouchHandlers() {
        Pagination control = (Pagination)this.getSkinnable();
        ((Pagination)this.getSkinnable()).addEventHandler(TouchEvent.TOUCH_PRESSED, PaginationSkin$$Lambda$2.lambdaFactory$(this));
        ((Pagination)this.getSkinnable()).addEventHandler(TouchEvent.TOUCH_MOVED, PaginationSkin$$Lambda$3.lambdaFactory$(this, control));
        ((Pagination)this.getSkinnable()).addEventHandler(TouchEvent.TOUCH_RELEASED, PaginationSkin$$Lambda$4.lambdaFactory$(this, control));
    }

    private void resetIndexes(boolean usePageIndex) {
        boolean isAnimate;
        this.maxPageIndicatorCount = this.getMaxPageIndicatorCount();
        this.pageCount = this.getPageCount();
        if (this.pageCount > this.maxPageIndicatorCount) {
            this.pageCount = this.maxPageIndicatorCount;
        }
        this.fromIndex = 0;
        this.previousIndex = 0;
        this.currentIndex = usePageIndex ? this.getCurrentPageIndex() : 0;
        this.toIndex = this.pageCount - 1;
        if (this.pageCount == Integer.MAX_VALUE && this.maxPageIndicatorCount == Integer.MAX_VALUE) {
            this.toIndex = 0;
        }
        if (isAnimate = this.animate) {
            this.animate = false;
        }
        this.currentStackPane.getChildren().clear();
        this.nextStackPane.getChildren().clear();
        this.pagination.setCurrentPageIndex(this.currentIndex);
        this.createPage(this.currentStackPane, this.currentIndex);
        if (isAnimate) {
            this.animate = true;
        }
    }

    private boolean createPage(StackPane pane, int index) {
        if (this.pagination.getPageFactory() != null && pane.getChildren().isEmpty()) {
            Node content = this.pagination.getPageFactory().call(index);
            if (content != null) {
                pane.getChildren().setAll((Node[])new Node[]{content});
                return true;
            }
            boolean isAnimate = this.animate;
            if (isAnimate) {
                this.animate = false;
            }
            if (this.pagination.getPageFactory().call(this.previousIndex) != null) {
                this.pagination.setCurrentPageIndex(this.previousIndex);
            } else {
                this.pagination.setCurrentPageIndex(0);
            }
            if (isAnimate) {
                this.animate = true;
            }
            return false;
        }
        return false;
    }

    private int getPageCount() {
        if (((Pagination)this.getSkinnable()).getPageCount() < 1) {
            return 1;
        }
        return ((Pagination)this.getSkinnable()).getPageCount();
    }

    private int getMaxPageIndicatorCount() {
        return ((Pagination)this.getSkinnable()).getMaxPageIndicatorCount();
    }

    private int getCurrentPageIndex() {
        return ((Pagination)this.getSkinnable()).getCurrentPageIndex();
    }

    private void animateSwitchPage() {
        if (this.timeline != null) {
            this.timeline.setRate(8.0);
            this.hasPendingAnimation = true;
            return;
        }
        if (!this.nextStackPane.isVisible() && !this.createPage(this.nextStackPane, this.currentAnimatedIndex)) {
            return;
        }
        if (this.nextPageReached) {
            this.swapPanes();
            this.nextPageReached = false;
            return;
        }
        this.nextStackPane.setCache(true);
        this.currentStackPane.setCache(true);
        Platform.runLater(PaginationSkin$$Lambda$5.lambdaFactory$(this));
    }

    private void swapPanes() {
        StackPane temp = this.currentStackPane;
        this.currentStackPane = this.nextStackPane;
        this.nextStackPane = temp;
        this.currentStackPane.setTranslateX(0.0);
        this.currentStackPane.setCache(false);
        this.nextStackPane.setTranslateX(0.0);
        this.nextStackPane.setCache(false);
        this.nextStackPane.setVisible(false);
        this.nextStackPane.getChildren().clear();
    }

    private void animateClamping(boolean rightToLeft) {
        if (rightToLeft) {
            this.timeline = new Timeline();
            KeyFrame k1 = new KeyFrame(Duration.millis(0.0), new KeyValue(this.currentStackPane.translateXProperty(), this.currentStackPane.getTranslateX(), interpolator), new KeyValue(this.nextStackPane.translateXProperty(), this.nextStackPane.getTranslateX(), interpolator));
            KeyFrame k2 = new KeyFrame(DURATION, this.clampAnimationEndEventHandler, new KeyValue(this.currentStackPane.translateXProperty(), 0, interpolator), new KeyValue(this.nextStackPane.translateXProperty(), this.currentStackPane.getWidth(), interpolator));
            this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{k1, k2});
            this.timeline.play();
        } else {
            this.timeline = new Timeline();
            KeyFrame k1 = new KeyFrame(Duration.millis(0.0), new KeyValue(this.currentStackPane.translateXProperty(), this.currentStackPane.getTranslateX(), interpolator), new KeyValue(this.nextStackPane.translateXProperty(), this.nextStackPane.getTranslateX(), interpolator));
            KeyFrame k2 = new KeyFrame(DURATION, this.clampAnimationEndEventHandler, new KeyValue(this.currentStackPane.translateXProperty(), 0, interpolator), new KeyValue(this.nextStackPane.translateXProperty(), -this.currentStackPane.getWidth(), interpolator));
            this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{k1, k2});
            this.timeline.play();
        }
    }

    private DoubleProperty arrowButtonGapProperty() {
        return this.arrowButtonGap;
    }

    public final void setArrowsVisible(boolean value) {
        this.arrowsVisibleProperty().set(value);
    }

    public final boolean isArrowsVisible() {
        return this.arrowsVisible == null ? DEFAULT_ARROW_VISIBLE.booleanValue() : this.arrowsVisible.get();
    }

    public final BooleanProperty arrowsVisibleProperty() {
        if (this.arrowsVisible == null) {
            this.arrowsVisible = new StyleableBooleanProperty(DEFAULT_ARROW_VISIBLE){

                @Override
                protected void invalidated() {
                    ((Pagination)PaginationSkin.this.getSkinnable()).requestLayout();
                }

                @Override
                public CssMetaData<Pagination, Boolean> getCssMetaData() {
                    return StyleableProperties.ARROWS_VISIBLE;
                }

                @Override
                public Object getBean() {
                    return PaginationSkin.this;
                }

                @Override
                public String getName() {
                    return "arrowVisible";
                }
            };
        }
        return this.arrowsVisible;
    }

    public final void setPageInformationVisible(boolean value) {
        this.pageInformationVisibleProperty().set(value);
    }

    public final boolean isPageInformationVisible() {
        return this.pageInformationVisible == null ? DEFAULT_PAGE_INFORMATION_VISIBLE.booleanValue() : this.pageInformationVisible.get();
    }

    public final BooleanProperty pageInformationVisibleProperty() {
        if (this.pageInformationVisible == null) {
            this.pageInformationVisible = new StyleableBooleanProperty(DEFAULT_PAGE_INFORMATION_VISIBLE){

                @Override
                protected void invalidated() {
                    ((Pagination)PaginationSkin.this.getSkinnable()).requestLayout();
                }

                @Override
                public CssMetaData<Pagination, Boolean> getCssMetaData() {
                    return StyleableProperties.PAGE_INFORMATION_VISIBLE;
                }

                @Override
                public Object getBean() {
                    return PaginationSkin.this;
                }

                @Override
                public String getName() {
                    return "pageInformationVisible";
                }
            };
        }
        return this.pageInformationVisible;
    }

    public final void setPageInformationAlignment(Side value) {
        this.pageInformationAlignmentProperty().set(value);
    }

    public final Side getPageInformationAlignment() {
        return this.pageInformationAlignment == null ? DEFAULT_PAGE_INFORMATION_ALIGNMENT : (Side)((Object)this.pageInformationAlignment.get());
    }

    public final ObjectProperty<Side> pageInformationAlignmentProperty() {
        if (this.pageInformationAlignment == null) {
            this.pageInformationAlignment = new StyleableObjectProperty<Side>(Side.BOTTOM){

                @Override
                protected void invalidated() {
                    ((Pagination)PaginationSkin.this.getSkinnable()).requestLayout();
                }

                @Override
                public CssMetaData<Pagination, Side> getCssMetaData() {
                    return StyleableProperties.PAGE_INFORMATION_ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return PaginationSkin.this;
                }

                @Override
                public String getName() {
                    return "pageInformationAlignment";
                }
            };
        }
        return this.pageInformationAlignment;
    }

    public final void setTooltipVisible(boolean value) {
        this.tooltipVisibleProperty().set(value);
    }

    public final boolean isTooltipVisible() {
        return this.tooltipVisible == null ? DEFAULT_TOOLTIP_VISIBLE.booleanValue() : this.tooltipVisible.get();
    }

    public final BooleanProperty tooltipVisibleProperty() {
        if (this.tooltipVisible == null) {
            this.tooltipVisible = new StyleableBooleanProperty(DEFAULT_TOOLTIP_VISIBLE){

                @Override
                protected void invalidated() {
                    ((Pagination)PaginationSkin.this.getSkinnable()).requestLayout();
                }

                @Override
                public CssMetaData<Pagination, Boolean> getCssMetaData() {
                    return StyleableProperties.TOOLTIP_VISIBLE;
                }

                @Override
                public Object getBean() {
                    return PaginationSkin.this;
                }

                @Override
                public String getName() {
                    return "tooltipVisible";
                }
            };
        }
        return this.tooltipVisible;
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("PAGE_FACTORY".equals(p)) {
            if (this.animate && this.timeline != null) {
                this.timeline.setRate(8.0);
                this.timeline.setOnFinished(PaginationSkin$$Lambda$6.lambdaFactory$(this));
                return;
            }
            this.resetIndiciesAndNav();
        } else if ("PAGE_COUNT".equals(p)) {
            this.resetIndiciesAndNav();
        } else if ("WIDTH".equals(p)) {
            this.clipRect.setWidth(((Pagination)this.getSkinnable()).getWidth());
        } else if ("HEIGHT".equals(p)) {
            this.clipRect.setHeight(((Pagination)this.getSkinnable()).getHeight());
        }
        ((Pagination)this.getSkinnable()).requestLayout();
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double navigationWidth = this.navigation.isVisible() ? this.snapSize(this.navigation.minWidth(height)) : 0.0;
        return leftInset + Math.max(this.currentStackPane.minWidth(height), navigationWidth) + rightInset;
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double navigationHeight = this.navigation.isVisible() ? this.snapSize(this.navigation.minHeight(width)) : 0.0;
        return topInset + this.currentStackPane.minHeight(width) + navigationHeight + bottomInset;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double navigationWidth = this.navigation.isVisible() ? this.snapSize(this.navigation.prefWidth(height)) : 0.0;
        return leftInset + Math.max(this.currentStackPane.prefWidth(height), navigationWidth) + rightInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double navigationHeight = this.navigation.isVisible() ? this.snapSize(this.navigation.prefHeight(width)) : 0.0;
        return topInset + this.currentStackPane.prefHeight(width) + navigationHeight + bottomInset;
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double navigationHeight = this.navigation.isVisible() ? this.snapSize(this.navigation.prefHeight(-1.0)) : 0.0;
        double stackPaneHeight = this.snapSize(h - navigationHeight);
        this.layoutInArea(this.currentStackPane, x, y, w, stackPaneHeight, 0.0, HPos.CENTER, VPos.CENTER);
        this.layoutInArea(this.nextStackPane, x, y, w, stackPaneHeight, 0.0, HPos.CENTER, VPos.CENTER);
        this.layoutInArea(this.navigation, x, stackPaneHeight, w, navigationHeight, 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case FOCUS_ITEM: {
                return this.navigation.indicatorButtons.getSelectedToggle();
            }
            case ITEM_COUNT: {
                return this.navigation.indicatorButtons.getToggles().size();
            }
            case ITEM_AT_INDEX: {
                Integer index = (Integer)parameters[0];
                if (index == null) {
                    return null;
                }
                return this.navigation.indicatorButtons.getToggles().get(index);
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return PaginationSkin.getClassCssMetaData();
    }

    /* synthetic */ void lambda$handleControlPropertyChanged$419(ActionEvent arg0) {
        this.resetIndiciesAndNav();
    }

    /* synthetic */ void lambda$animateSwitchPage$418() {
        boolean useTranslateX;
        boolean bl = useTranslateX = this.nextStackPane.getTranslateX() != 0.0;
        if (this.currentAnimatedIndex > this.previousIndex) {
            if (!useTranslateX) {
                this.nextStackPane.setTranslateX(this.currentStackPane.getWidth());
            }
            this.nextStackPane.setVisible(true);
            this.timeline = new Timeline();
            KeyFrame k1 = new KeyFrame(Duration.millis(0.0), new KeyValue(this.currentStackPane.translateXProperty(), useTranslateX ? this.currentStackPane.getTranslateX() : 0.0, interpolator), new KeyValue(this.nextStackPane.translateXProperty(), useTranslateX ? this.nextStackPane.getTranslateX() : this.currentStackPane.getWidth(), interpolator));
            KeyFrame k2 = new KeyFrame(DURATION, this.swipeAnimationEndEventHandler, new KeyValue(this.currentStackPane.translateXProperty(), -this.currentStackPane.getWidth(), interpolator), new KeyValue(this.nextStackPane.translateXProperty(), 0, interpolator));
            this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{k1, k2});
            this.timeline.play();
        } else {
            if (!useTranslateX) {
                this.nextStackPane.setTranslateX(-this.currentStackPane.getWidth());
            }
            this.nextStackPane.setVisible(true);
            this.timeline = new Timeline();
            KeyFrame k1 = new KeyFrame(Duration.millis(0.0), new KeyValue(this.currentStackPane.translateXProperty(), useTranslateX ? this.currentStackPane.getTranslateX() : 0.0, interpolator), new KeyValue(this.nextStackPane.translateXProperty(), useTranslateX ? this.nextStackPane.getTranslateX() : -this.currentStackPane.getWidth(), interpolator));
            KeyFrame k2 = new KeyFrame(DURATION, this.swipeAnimationEndEventHandler, new KeyValue(this.currentStackPane.translateXProperty(), this.currentStackPane.getWidth(), interpolator), new KeyValue(this.nextStackPane.translateXProperty(), 0, interpolator));
            this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{k1, k2});
            this.timeline.play();
        }
    }

    /* synthetic */ void lambda$initializeSwipeAndTouchHandlers$417(Pagination pagination, TouchEvent e) {
        if (this.touchEventId != e.getTouchPoint().getId()) {
            return;
        }
        this.touchEventId = -1;
        this.setInitialDirection = false;
        if (this.touchThresholdBroken) {
            double drag = e.getTouchPoint().getX() - this.startTouchPos;
            long time = System.currentTimeMillis() - this.startTouchTime;
            boolean quick = time < 300L;
            double velocity = quick ? drag / (double)time : this.touchVelocity;
            double distance = velocity * 500.0;
            double width = pagination.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
            double threshold = Math.abs(distance / width);
            double delta = Math.abs(drag / width);
            if (threshold > 0.3 || delta > 0.3) {
                if (this.startTouchPos > e.getTouchPoint().getX()) {
                    this.selectNext();
                } else {
                    this.selectPrevious();
                }
            } else {
                this.animateClamping(this.startTouchPos > e.getTouchPoint().getSceneX());
            }
        }
        e.consume();
    }

    /* synthetic */ void lambda$initializeSwipeAndTouchHandlers$416(Pagination pagination, TouchEvent e) {
        if (this.touchEventId != e.getTouchPoint().getId()) {
            return;
        }
        double drag = e.getTouchPoint().getX() - this.lastTouchPos;
        long time = System.currentTimeMillis() - this.lastTouchTime;
        this.touchVelocity = drag / (double)time;
        this.lastTouchPos = e.getTouchPoint().getX();
        this.lastTouchTime = System.currentTimeMillis();
        double delta = e.getTouchPoint().getX() - this.startTouchPos;
        if (!this.touchThresholdBroken && Math.abs(delta) > 15.0) {
            this.touchThresholdBroken = true;
        }
        if (this.touchThresholdBroken) {
            double width = pagination.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
            if (!this.setInitialDirection) {
                this.setInitialDirection = true;
                int n = this.direction = delta < 0.0 ? 1 : -1;
            }
            if (delta < 0.0) {
                double nextPaneX;
                double currentPaneX;
                if (this.direction == -1) {
                    this.nextStackPane.getChildren().clear();
                    this.direction = 1;
                }
                if (Math.abs(delta) <= width) {
                    currentPaneX = delta;
                    nextPaneX = width + delta;
                    this.nextPageReached = false;
                } else {
                    currentPaneX = -width;
                    nextPaneX = 0.0;
                    this.nextPageReached = true;
                }
                this.currentStackPane.setTranslateX(currentPaneX);
                if (this.getCurrentPageIndex() < this.getPageCount() - 1) {
                    this.createPage(this.nextStackPane, this.currentIndex + 1);
                    this.nextStackPane.setVisible(true);
                    this.nextStackPane.setTranslateX(nextPaneX);
                } else {
                    this.currentStackPane.setTranslateX(0.0);
                }
            } else {
                double nextPaneX;
                double currentPaneX;
                if (this.direction == 1) {
                    this.nextStackPane.getChildren().clear();
                    this.direction = -1;
                }
                if (Math.abs(delta) <= width) {
                    currentPaneX = delta;
                    nextPaneX = -width + delta;
                    this.nextPageReached = false;
                } else {
                    currentPaneX = width;
                    nextPaneX = 0.0;
                    this.nextPageReached = true;
                }
                this.currentStackPane.setTranslateX(currentPaneX);
                if (this.getCurrentPageIndex() != 0) {
                    this.createPage(this.nextStackPane, this.currentIndex - 1);
                    this.nextStackPane.setVisible(true);
                    this.nextStackPane.setTranslateX(nextPaneX);
                } else {
                    this.currentStackPane.setTranslateX(0.0);
                }
            }
        }
        e.consume();
    }

    /* synthetic */ void lambda$initializeSwipeAndTouchHandlers$415(TouchEvent e) {
        if (this.touchEventId == -1) {
            this.touchEventId = e.getTouchPoint().getId();
        }
        if (this.touchEventId != e.getTouchPoint().getId()) {
            return;
        }
        this.lastTouchPos = this.startTouchPos = e.getTouchPoint().getX();
        this.lastTouchTime = this.startTouchTime = System.currentTimeMillis();
        this.touchThresholdBroken = false;
        e.consume();
    }

    /* synthetic */ void lambda$new$414(Observable o) {
        this.resetIndiciesAndNav();
    }

    static /* synthetic */ Boolean access$2900() {
        return DEFAULT_ARROW_VISIBLE;
    }

    static /* synthetic */ Boolean access$3100() {
        return DEFAULT_PAGE_INFORMATION_VISIBLE;
    }

    static /* synthetic */ Side access$3300() {
        return DEFAULT_PAGE_INFORMATION_ALIGNMENT;
    }

    static /* synthetic */ Boolean access$3500() {
        return DEFAULT_TOOLTIP_VISIBLE;
    }

    private static class StyleableProperties {
        private static final CssMetaData<Pagination, Boolean> ARROWS_VISIBLE = new CssMetaData<Pagination, Boolean>("-fx-arrows-visible", BooleanConverter.getInstance(), PaginationSkin.access$2900()){

            @Override
            public boolean isSettable(Pagination n) {
                PaginationSkin skin = (PaginationSkin)n.getSkin();
                return skin.arrowsVisible == null || !skin.arrowsVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Pagination n) {
                PaginationSkin skin = (PaginationSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.arrowsVisibleProperty());
            }
        };
        private static final CssMetaData<Pagination, Boolean> PAGE_INFORMATION_VISIBLE = new CssMetaData<Pagination, Boolean>("-fx-page-information-visible", BooleanConverter.getInstance(), PaginationSkin.access$3100()){

            @Override
            public boolean isSettable(Pagination n) {
                PaginationSkin skin = (PaginationSkin)n.getSkin();
                return skin.pageInformationVisible == null || !skin.pageInformationVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Pagination n) {
                PaginationSkin skin = (PaginationSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.pageInformationVisibleProperty());
            }
        };
        private static final CssMetaData<Pagination, Side> PAGE_INFORMATION_ALIGNMENT = new CssMetaData<Pagination, Side>("-fx-page-information-alignment", new EnumConverter<Side>(Side.class), PaginationSkin.access$3300()){

            @Override
            public boolean isSettable(Pagination n) {
                PaginationSkin skin = (PaginationSkin)n.getSkin();
                return skin.pageInformationAlignment == null || !skin.pageInformationAlignment.isBound();
            }

            @Override
            public StyleableProperty<Side> getStyleableProperty(Pagination n) {
                PaginationSkin skin = (PaginationSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.pageInformationAlignmentProperty());
            }
        };
        private static final CssMetaData<Pagination, Boolean> TOOLTIP_VISIBLE = new CssMetaData<Pagination, Boolean>("-fx-tooltip-visible", BooleanConverter.getInstance(), PaginationSkin.access$3500()){

            @Override
            public boolean isSettable(Pagination n) {
                PaginationSkin skin = (PaginationSkin)n.getSkin();
                return skin.tooltipVisible == null || !skin.tooltipVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Pagination n) {
                PaginationSkin skin = (PaginationSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.tooltipVisibleProperty());
            }
        };
        private static final CssMetaData<Pagination, Number> ARROW_BUTTON_GAP = new CssMetaData<Pagination, Number>("-fx-arrow-button-gap", SizeConverter.getInstance(), (Number)4){

            @Override
            public boolean isSettable(Pagination n) {
                PaginationSkin skin = (PaginationSkin)n.getSkin();
                return skin.arrowButtonGap == null || !skin.arrowButtonGap.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Pagination n) {
                PaginationSkin skin = (PaginationSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.arrowButtonGapProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(SkinBase.getClassCssMetaData());
            styleables.add(ARROWS_VISIBLE);
            styleables.add(PAGE_INFORMATION_VISIBLE);
            styleables.add(PAGE_INFORMATION_ALIGNMENT);
            styleables.add(TOOLTIP_VISIBLE);
            styleables.add(ARROW_BUTTON_GAP);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    class IndicatorButton
    extends ToggleButton {
        private final ListChangeListener<String> updateSkinIndicatorType = PaginationSkin$IndicatorButton$$Lambda$1.lambdaFactory$(this);
        private final ChangeListener<Boolean> updateTooltipVisibility = PaginationSkin$IndicatorButton$$Lambda$2.lambdaFactory$(this);
        private int pageNumber;

        public IndicatorButton(int pageNumber) {
            this.pageNumber = pageNumber;
            this.setFocusTraversable(false);
            this.setIndicatorType();
            this.setTooltipVisible(PaginationSkin.this.isTooltipVisible());
            ((Pagination)PaginationSkin.this.getSkinnable()).getStyleClass().addListener(this.updateSkinIndicatorType);
            this.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent arg0) {
                    int selected = PaginationSkin.this.getCurrentPageIndex();
                    if (selected != IndicatorButton.this.pageNumber) {
                        PaginationSkin.this.pagination.setCurrentPageIndex(IndicatorButton.this.pageNumber);
                        IndicatorButton.this.requestLayout();
                    }
                }
            });
            PaginationSkin.this.tooltipVisibleProperty().addListener(this.updateTooltipVisibility);
            this.prefHeightProperty().bind(this.minHeightProperty());
            this.setAccessibleRole(AccessibleRole.PAGE_ITEM);
        }

        private void setIndicatorType() {
            if (((Pagination)PaginationSkin.this.getSkinnable()).getStyleClass().contains("bullet")) {
                this.getStyleClass().remove("number-button");
                this.getStyleClass().add("bullet-button");
                this.setText(null);
                this.prefWidthProperty().bind(this.minWidthProperty());
            } else {
                this.getStyleClass().remove("bullet-button");
                this.getStyleClass().add("number-button");
                this.setText(Integer.toString(this.pageNumber + 1));
                this.prefWidthProperty().unbind();
            }
        }

        private void setTooltipVisible(boolean b) {
            if (b) {
                this.setTooltip(new Tooltip(Integer.toString(this.pageNumber + 1)));
            } else {
                this.setTooltip(null);
            }
        }

        public int getPageNumber() {
            return this.pageNumber;
        }

        @Override
        public void fire() {
            if (this.getToggleGroup() == null || !this.isSelected()) {
                super.fire();
            }
        }

        public void release() {
            ((Pagination)PaginationSkin.this.getSkinnable()).getStyleClass().removeListener(this.updateSkinIndicatorType);
            PaginationSkin.this.tooltipVisibleProperty().removeListener(this.updateTooltipVisibility);
        }

        @Override
        public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
            switch (attribute) {
                case TEXT: {
                    return this.getText();
                }
                case SELECTED: {
                    return this.isSelected();
                }
            }
            return super.queryAccessibleAttribute(attribute, parameters);
        }

        @Override
        public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
            switch (action) {
                case REQUEST_FOCUS: {
                    ((Pagination)PaginationSkin.this.getSkinnable()).setCurrentPageIndex(this.pageNumber);
                    break;
                }
                default: {
                    super.executeAccessibleAction(action, new Object[0]);
                }
            }
        }

        /* synthetic */ void lambda$new$430(ObservableValue ob, Boolean oldValue, Boolean newValue) {
            this.setTooltipVisible(newValue);
        }

        /* synthetic */ void lambda$new$429(ListChangeListener.Change c) {
            this.setIndicatorType();
        }
    }

    class NavigationControl
    extends StackPane {
        private HBox controlBox;
        private Button leftArrowButton;
        private StackPane leftArrow;
        private Button rightArrowButton;
        private StackPane rightArrow;
        private ToggleGroup indicatorButtons;
        private Label pageInformation;
        private double previousWidth = -1.0;
        private double minButtonSize = -1.0;
        private int previousIndicatorCount = 0;

        public NavigationControl() {
            this.getStyleClass().setAll((String[])new String[]{"pagination-control"});
            this.addEventHandler(MouseEvent.MOUSE_PRESSED, PaginationSkin$NavigationControl$$Lambda$1.lambdaFactory$(this));
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, PaginationSkin$NavigationControl$$Lambda$2.lambdaFactory$(this));
            this.addEventHandler(MouseEvent.MOUSE_ENTERED, PaginationSkin$NavigationControl$$Lambda$3.lambdaFactory$(this));
            this.addEventHandler(MouseEvent.MOUSE_EXITED, PaginationSkin$NavigationControl$$Lambda$4.lambdaFactory$(this));
            this.controlBox = new HBox();
            this.controlBox.getStyleClass().add("control-box");
            this.leftArrowButton = new Button();
            this.leftArrowButton.setAccessibleText(ControlResources.getString("Accessibility.title.Pagination.PreviousButton"));
            this.minButtonSize = this.leftArrowButton.getFont().getSize() * 2.0;
            this.leftArrowButton.fontProperty().addListener(PaginationSkin$NavigationControl$$Lambda$5.lambdaFactory$(this));
            this.leftArrowButton.setMinSize(this.minButtonSize, this.minButtonSize);
            this.leftArrowButton.prefWidthProperty().bind(this.leftArrowButton.minWidthProperty());
            this.leftArrowButton.prefHeightProperty().bind(this.leftArrowButton.minHeightProperty());
            this.leftArrowButton.getStyleClass().add("left-arrow-button");
            this.leftArrowButton.setFocusTraversable(false);
            HBox.setMargin(this.leftArrowButton, new Insets(0.0, this.snapSize(PaginationSkin.this.arrowButtonGap.get()), 0.0, 0.0));
            this.leftArrow = new StackPane();
            this.leftArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            this.leftArrowButton.setGraphic(this.leftArrow);
            this.leftArrow.getStyleClass().add("left-arrow");
            this.rightArrowButton = new Button();
            this.rightArrowButton.setAccessibleText(ControlResources.getString("Accessibility.title.Pagination.NextButton"));
            this.rightArrowButton.setMinSize(this.minButtonSize, this.minButtonSize);
            this.rightArrowButton.prefWidthProperty().bind(this.rightArrowButton.minWidthProperty());
            this.rightArrowButton.prefHeightProperty().bind(this.rightArrowButton.minHeightProperty());
            this.rightArrowButton.getStyleClass().add("right-arrow-button");
            this.rightArrowButton.setFocusTraversable(false);
            HBox.setMargin(this.rightArrowButton, new Insets(0.0, 0.0, 0.0, this.snapSize(PaginationSkin.this.arrowButtonGap.get())));
            this.rightArrow = new StackPane();
            this.rightArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            this.rightArrowButton.setGraphic(this.rightArrow);
            this.rightArrow.getStyleClass().add("right-arrow");
            this.indicatorButtons = new ToggleGroup();
            this.pageInformation = new Label();
            this.pageInformation.getStyleClass().add("page-information");
            this.getChildren().addAll((Node[])new Node[]{this.controlBox, this.pageInformation});
            this.initializeNavigationHandlers();
            this.initializePageIndicators();
            this.updatePageIndex();
            PaginationSkin.this.arrowButtonGap.addListener(PaginationSkin$NavigationControl$$Lambda$6.lambdaFactory$(this));
        }

        private void initializeNavigationHandlers() {
            this.leftArrowButton.setOnAction(PaginationSkin$NavigationControl$$Lambda$7.lambdaFactory$(this));
            this.rightArrowButton.setOnAction(PaginationSkin$NavigationControl$$Lambda$8.lambdaFactory$(this));
            PaginationSkin.this.pagination.currentPageIndexProperty().addListener(PaginationSkin$NavigationControl$$Lambda$9.lambdaFactory$(this));
        }

        private void initializePageIndicators() {
            this.previousIndicatorCount = 0;
            this.controlBox.getChildren().clear();
            this.clearIndicatorButtons();
            this.controlBox.getChildren().add(this.leftArrowButton);
            for (int i = PaginationSkin.this.fromIndex; i <= PaginationSkin.this.toIndex; ++i) {
                IndicatorButton ib = new IndicatorButton(i);
                ib.setMinSize(this.minButtonSize, this.minButtonSize);
                ib.setToggleGroup(this.indicatorButtons);
                this.controlBox.getChildren().add(ib);
            }
            this.controlBox.getChildren().add(this.rightArrowButton);
        }

        private void clearIndicatorButtons() {
            for (Toggle toggle : this.indicatorButtons.getToggles()) {
                if (!(toggle instanceof IndicatorButton)) continue;
                IndicatorButton indicatorButton = (IndicatorButton)toggle;
                indicatorButton.release();
            }
            this.indicatorButtons.getToggles().clear();
        }

        private void updatePageIndicators() {
            for (int i = 0; i < this.indicatorButtons.getToggles().size(); ++i) {
                IndicatorButton ib = (IndicatorButton)this.indicatorButtons.getToggles().get(i);
                if (ib.getPageNumber() != PaginationSkin.this.currentIndex) continue;
                ib.setSelected(true);
                this.updatePageInformation();
                break;
            }
            ((Pagination)PaginationSkin.this.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
        }

        private void updatePageIndex() {
            if (PaginationSkin.this.pageCount == PaginationSkin.this.maxPageIndicatorCount && this.changePageSet()) {
                this.initializePageIndicators();
            }
            this.updatePageIndicators();
            this.requestLayout();
        }

        private void updatePageInformation() {
            String currentPageNumber = Integer.toString(PaginationSkin.this.currentIndex + 1);
            String lastPageNumber = PaginationSkin.this.getPageCount() == Integer.MAX_VALUE ? "..." : Integer.toString(PaginationSkin.this.getPageCount());
            this.pageInformation.setText(currentPageNumber + "/" + lastPageNumber);
        }

        private void layoutPageIndicators() {
            double left = this.snappedLeftInset();
            double right = this.snappedRightInset();
            double width = this.snapSize(this.getWidth()) - (left + right);
            double controlBoxleft = this.controlBox.snappedLeftInset();
            double controlBoxRight = this.controlBox.snappedRightInset();
            double leftArrowWidth = this.snapSize(Utils.boundedSize(this.leftArrowButton.prefWidth(-1.0), this.leftArrowButton.minWidth(-1.0), this.leftArrowButton.maxWidth(-1.0)));
            double rightArrowWidth = this.snapSize(Utils.boundedSize(this.rightArrowButton.prefWidth(-1.0), this.rightArrowButton.minWidth(-1.0), this.rightArrowButton.maxWidth(-1.0)));
            double spacing = this.snapSize(this.controlBox.getSpacing());
            double w = width - (controlBoxleft + leftArrowWidth + 2.0 * PaginationSkin.this.arrowButtonGap.get() + spacing + rightArrowWidth + controlBoxRight);
            if (PaginationSkin.this.isPageInformationVisible() && (Side.LEFT.equals((Object)PaginationSkin.this.getPageInformationAlignment()) || Side.RIGHT.equals((Object)PaginationSkin.this.getPageInformationAlignment()))) {
                w -= this.snapSize(this.pageInformation.prefWidth(-1.0));
            }
            double x = 0.0;
            int indicatorCount = 0;
            for (int i = 0; i < PaginationSkin.this.getMaxPageIndicatorCount(); ++i) {
                int index = i < this.indicatorButtons.getToggles().size() ? i : this.indicatorButtons.getToggles().size() - 1;
                double iw = this.minButtonSize;
                if (index != -1) {
                    IndicatorButton ib = (IndicatorButton)this.indicatorButtons.getToggles().get(index);
                    iw = this.snapSize(Utils.boundedSize(ib.prefWidth(-1.0), ib.minWidth(-1.0), ib.maxWidth(-1.0)));
                }
                if ((x += iw + spacing) > w) break;
                ++indicatorCount;
            }
            if (indicatorCount == 0) {
                indicatorCount = 1;
            }
            if (indicatorCount != this.previousIndicatorCount) {
                int lastIndicatorButtonIndex;
                if (indicatorCount < PaginationSkin.this.getMaxPageIndicatorCount()) {
                    PaginationSkin.this.maxPageIndicatorCount = indicatorCount;
                } else {
                    PaginationSkin.this.maxPageIndicatorCount = PaginationSkin.this.getMaxPageIndicatorCount();
                }
                if (PaginationSkin.this.pageCount > PaginationSkin.this.maxPageIndicatorCount) {
                    PaginationSkin.this.pageCount = PaginationSkin.this.maxPageIndicatorCount;
                    lastIndicatorButtonIndex = PaginationSkin.this.maxPageIndicatorCount - 1;
                } else if (indicatorCount > PaginationSkin.this.getPageCount()) {
                    PaginationSkin.this.pageCount = PaginationSkin.this.getPageCount();
                    lastIndicatorButtonIndex = PaginationSkin.this.getPageCount() - 1;
                } else {
                    PaginationSkin.this.pageCount = indicatorCount;
                    lastIndicatorButtonIndex = indicatorCount - 1;
                }
                if (PaginationSkin.this.currentIndex >= PaginationSkin.this.toIndex) {
                    PaginationSkin.this.toIndex = PaginationSkin.this.currentIndex;
                    PaginationSkin.this.fromIndex = PaginationSkin.this.toIndex - lastIndicatorButtonIndex;
                } else if (PaginationSkin.this.currentIndex <= PaginationSkin.this.fromIndex) {
                    PaginationSkin.this.fromIndex = PaginationSkin.this.currentIndex;
                    PaginationSkin.this.toIndex = PaginationSkin.this.fromIndex + lastIndicatorButtonIndex;
                } else {
                    PaginationSkin.this.toIndex = PaginationSkin.this.fromIndex + lastIndicatorButtonIndex;
                }
                if (PaginationSkin.this.toIndex > PaginationSkin.this.getPageCount() - 1) {
                    PaginationSkin.this.toIndex = PaginationSkin.this.getPageCount() - 1;
                }
                if (PaginationSkin.this.fromIndex < 0) {
                    PaginationSkin.this.fromIndex = 0;
                    PaginationSkin.this.toIndex = PaginationSkin.this.fromIndex + lastIndicatorButtonIndex;
                }
                this.initializePageIndicators();
                this.updatePageIndicators();
                this.previousIndicatorCount = indicatorCount;
            }
        }

        private boolean changePageSet() {
            int index = this.indexToIndicatorButtonsIndex(PaginationSkin.this.currentIndex);
            int lastIndicatorButtonIndex = PaginationSkin.this.maxPageIndicatorCount - 1;
            if (PaginationSkin.this.previousIndex < PaginationSkin.this.currentIndex && index == 0 && lastIndicatorButtonIndex != 0 && index % lastIndicatorButtonIndex == 0) {
                PaginationSkin.this.fromIndex = PaginationSkin.this.currentIndex;
                PaginationSkin.this.toIndex = PaginationSkin.this.fromIndex + lastIndicatorButtonIndex;
            } else if (PaginationSkin.this.currentIndex < PaginationSkin.this.previousIndex && index == lastIndicatorButtonIndex && lastIndicatorButtonIndex != 0 && index % lastIndicatorButtonIndex == 0) {
                PaginationSkin.this.toIndex = PaginationSkin.this.currentIndex;
                PaginationSkin.this.fromIndex = PaginationSkin.this.toIndex - lastIndicatorButtonIndex;
            } else if (PaginationSkin.this.currentIndex < PaginationSkin.this.fromIndex || PaginationSkin.this.currentIndex > PaginationSkin.this.toIndex) {
                PaginationSkin.this.fromIndex = PaginationSkin.this.currentIndex - index;
                PaginationSkin.this.toIndex = PaginationSkin.this.fromIndex + lastIndicatorButtonIndex;
            } else {
                return false;
            }
            if (PaginationSkin.this.toIndex > PaginationSkin.this.getPageCount() - 1) {
                if (PaginationSkin.this.fromIndex > PaginationSkin.this.getPageCount() - 1) {
                    return false;
                }
                PaginationSkin.this.toIndex = PaginationSkin.this.getPageCount() - 1;
            }
            if (PaginationSkin.this.fromIndex < 0) {
                PaginationSkin.this.fromIndex = 0;
                PaginationSkin.this.toIndex = PaginationSkin.this.fromIndex + lastIndicatorButtonIndex;
            }
            return true;
        }

        private int indexToIndicatorButtonsIndex(int index) {
            if (index >= PaginationSkin.this.fromIndex && index <= PaginationSkin.this.toIndex) {
                return index - PaginationSkin.this.fromIndex;
            }
            int i = 0;
            int from = PaginationSkin.this.fromIndex;
            int to = PaginationSkin.this.toIndex;
            if (PaginationSkin.this.currentIndex > PaginationSkin.this.previousIndex) {
                while (from < PaginationSkin.this.getPageCount() && to < PaginationSkin.this.getPageCount()) {
                    if (index >= (from += i) && index <= (to += i)) {
                        if (index == from) {
                            return 0;
                        }
                        if (index == to) {
                            return PaginationSkin.this.maxPageIndicatorCount - 1;
                        }
                        return index - from;
                    }
                    i += PaginationSkin.this.maxPageIndicatorCount;
                }
            } else {
                while (from > 0 && to > 0) {
                    if (index >= (from -= i) && index <= (to -= i)) {
                        if (index == from) {
                            return 0;
                        }
                        if (index == to) {
                            return PaginationSkin.this.maxPageIndicatorCount - 1;
                        }
                        return index - from;
                    }
                    i += PaginationSkin.this.maxPageIndicatorCount;
                }
            }
            return PaginationSkin.this.maxPageIndicatorCount - 1;
        }

        private Pos sideToPos(Side s) {
            if (Side.TOP.equals((Object)s)) {
                return Pos.TOP_CENTER;
            }
            if (Side.RIGHT.equals((Object)s)) {
                return Pos.CENTER_RIGHT;
            }
            if (Side.BOTTOM.equals((Object)s)) {
                return Pos.BOTTOM_CENTER;
            }
            return Pos.CENTER_LEFT;
        }

        @Override
        protected double computeMinWidth(double height) {
            double left = this.snappedLeftInset();
            double right = this.snappedRightInset();
            double leftArrowWidth = this.snapSize(Utils.boundedSize(this.leftArrowButton.prefWidth(-1.0), this.leftArrowButton.minWidth(-1.0), this.leftArrowButton.maxWidth(-1.0)));
            double rightArrowWidth = this.snapSize(Utils.boundedSize(this.rightArrowButton.prefWidth(-1.0), this.rightArrowButton.minWidth(-1.0), this.rightArrowButton.maxWidth(-1.0)));
            double spacing = this.snapSize(this.controlBox.getSpacing());
            double pageInformationWidth = 0.0;
            Side side = PaginationSkin.this.getPageInformationAlignment();
            if (Side.LEFT.equals((Object)side) || Side.RIGHT.equals((Object)side)) {
                pageInformationWidth = this.snapSize(this.pageInformation.prefWidth(-1.0));
            }
            double arrowGap = PaginationSkin.this.arrowButtonGap.get();
            return left + leftArrowWidth + 2.0 * arrowGap + this.minButtonSize + 2.0 * spacing + rightArrowWidth + right + pageInformationWidth;
        }

        @Override
        protected double computeMinHeight(double width) {
            return this.computePrefHeight(width);
        }

        @Override
        protected double computePrefWidth(double height) {
            double left = this.snappedLeftInset();
            double right = this.snappedRightInset();
            double controlBoxWidth = this.snapSize(this.controlBox.prefWidth(height));
            double pageInformationWidth = 0.0;
            Side side = PaginationSkin.this.getPageInformationAlignment();
            if (Side.LEFT.equals((Object)side) || Side.RIGHT.equals((Object)side)) {
                pageInformationWidth = this.snapSize(this.pageInformation.prefWidth(-1.0));
            }
            return left + controlBoxWidth + right + pageInformationWidth;
        }

        @Override
        protected double computePrefHeight(double width) {
            double top = this.snappedTopInset();
            double bottom = this.snappedBottomInset();
            double boxHeight = this.snapSize(this.controlBox.prefHeight(width));
            double pageInformationHeight = 0.0;
            Side side = PaginationSkin.this.getPageInformationAlignment();
            if (Side.TOP.equals((Object)side) || Side.BOTTOM.equals((Object)side)) {
                pageInformationHeight = this.snapSize(this.pageInformation.prefHeight(-1.0));
            }
            return top + boxHeight + pageInformationHeight + bottom;
        }

        @Override
        protected void layoutChildren() {
            double top = this.snappedTopInset();
            double bottom = this.snappedBottomInset();
            double left = this.snappedLeftInset();
            double right = this.snappedRightInset();
            double width = this.snapSize(this.getWidth()) - (left + right);
            double height = this.snapSize(this.getHeight()) - (top + bottom);
            double controlBoxWidth = this.snapSize(this.controlBox.prefWidth(-1.0));
            double controlBoxHeight = this.snapSize(this.controlBox.prefHeight(-1.0));
            double pageInformationWidth = this.snapSize(this.pageInformation.prefWidth(-1.0));
            double pageInformationHeight = this.snapSize(this.pageInformation.prefHeight(-1.0));
            this.leftArrowButton.setDisable(false);
            this.rightArrowButton.setDisable(false);
            if (PaginationSkin.this.currentIndex == 0) {
                this.leftArrowButton.setDisable(true);
            }
            if (PaginationSkin.this.currentIndex == PaginationSkin.this.getPageCount() - 1) {
                this.rightArrowButton.setDisable(true);
            }
            this.applyCss();
            this.leftArrowButton.setVisible(PaginationSkin.this.isArrowsVisible());
            this.rightArrowButton.setVisible(PaginationSkin.this.isArrowsVisible());
            this.pageInformation.setVisible(PaginationSkin.this.isPageInformationVisible());
            this.layoutPageIndicators();
            this.previousWidth = this.getWidth();
            HPos controlBoxHPos = this.controlBox.getAlignment().getHpos();
            VPos controlBoxVPos = this.controlBox.getAlignment().getVpos();
            double controlBoxX = left + Utils.computeXOffset(width, controlBoxWidth, controlBoxHPos);
            double controlBoxY = top + Utils.computeYOffset(height, controlBoxHeight, controlBoxVPos);
            if (PaginationSkin.this.isPageInformationVisible()) {
                Pos p = this.sideToPos(PaginationSkin.this.getPageInformationAlignment());
                HPos pageInformationHPos = p.getHpos();
                VPos pageInformationVPos = p.getVpos();
                double pageInformationX = left + Utils.computeXOffset(width, pageInformationWidth, pageInformationHPos);
                double pageInformationY = top + Utils.computeYOffset(height, pageInformationHeight, pageInformationVPos);
                if (Side.TOP.equals((Object)PaginationSkin.this.getPageInformationAlignment())) {
                    pageInformationY = top;
                    controlBoxY = top + pageInformationHeight;
                } else if (Side.RIGHT.equals((Object)PaginationSkin.this.getPageInformationAlignment())) {
                    pageInformationX = width - right - pageInformationWidth;
                } else if (Side.BOTTOM.equals((Object)PaginationSkin.this.getPageInformationAlignment())) {
                    controlBoxY = top;
                    pageInformationY = top + controlBoxHeight;
                } else if (Side.LEFT.equals((Object)PaginationSkin.this.getPageInformationAlignment())) {
                    pageInformationX = left;
                }
                this.layoutInArea(this.pageInformation, pageInformationX, pageInformationY, pageInformationWidth, pageInformationHeight, 0.0, pageInformationHPos, pageInformationVPos);
            }
            this.layoutInArea(this.controlBox, controlBoxX, controlBoxY, controlBoxWidth, controlBoxHeight, 0.0, controlBoxHPos, controlBoxVPos);
        }

        /* synthetic */ void lambda$initializeNavigationHandlers$428(ObservableValue arg0, Number arg1, Number arg2) {
            PaginationSkin.this.previousIndex = arg1.intValue();
            PaginationSkin.this.currentIndex = arg2.intValue();
            this.updatePageIndex();
            if (PaginationSkin.this.animate) {
                PaginationSkin.this.currentAnimatedIndex = PaginationSkin.this.currentIndex;
                PaginationSkin.this.animateSwitchPage();
            } else {
                PaginationSkin.this.createPage(PaginationSkin.this.currentStackPane, PaginationSkin.this.currentIndex);
            }
        }

        /* synthetic */ void lambda$initializeNavigationHandlers$427(ActionEvent arg0) {
            PaginationSkin.this.selectNext();
            this.requestLayout();
        }

        /* synthetic */ void lambda$initializeNavigationHandlers$426(ActionEvent arg0) {
            PaginationSkin.this.selectPrevious();
            this.requestLayout();
        }

        /* synthetic */ void lambda$new$425(ObservableValue observable, Number oldValue, Number newValue) {
            if (newValue.doubleValue() == 0.0) {
                HBox.setMargin(this.leftArrowButton, null);
                HBox.setMargin(this.rightArrowButton, null);
            } else {
                HBox.setMargin(this.leftArrowButton, new Insets(0.0, this.snapSize(newValue.doubleValue()), 0.0, 0.0));
                HBox.setMargin(this.rightArrowButton, new Insets(0.0, 0.0, 0.0, this.snapSize(newValue.doubleValue())));
            }
        }

        /* synthetic */ void lambda$new$424(ObservableValue arg0, Font arg1, Font newFont) {
            this.minButtonSize = newFont.getSize() * 2.0;
            for (Node child : this.controlBox.getChildren()) {
                ((Control)child).setMinSize(this.minButtonSize, this.minButtonSize);
            }
            this.requestLayout();
        }

        /* synthetic */ void lambda$new$423(MouseEvent e) {
            ((PaginationBehavior)PaginationSkin.this.getBehavior()).mouseExited(e);
        }

        /* synthetic */ void lambda$new$422(MouseEvent e) {
            ((PaginationBehavior)PaginationSkin.this.getBehavior()).mouseEntered(e);
        }

        /* synthetic */ void lambda$new$421(MouseEvent e) {
            ((PaginationBehavior)PaginationSkin.this.getBehavior()).mouseReleased(e);
        }

        /* synthetic */ void lambda$new$420(MouseEvent e) {
            ((PaginationBehavior)PaginationSkin.this.getBehavior()).mousePressed(e);
        }
    }
}

