/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.MultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.behavior.TreeTableRowBehavior;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import com.sun.javafx.scene.control.skin.TableRowSkinBase;
import com.sun.javafx.scene.control.skin.TreeTableRowSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;

public class TreeTableRowSkin<T>
extends TableRowSkinBase<TreeItem<T>, TreeTableRow<T>, TreeTableRowBehavior<T>, TreeTableCell<T, ?>> {
    private SimpleObjectProperty<ObservableList<TreeItem<T>>> itemsProperty;
    private TreeItem<?> treeItem;
    private boolean disclosureNodeDirty = true;
    private Node graphic;
    private TreeTableViewSkin treeTableViewSkin;
    private boolean childrenDirty = false;
    private MultiplePropertyChangeListenerHandler treeItemListener = new MultiplePropertyChangeListenerHandler(TreeTableRowSkin$$Lambda$1.lambdaFactory$(this));
    private DoubleProperty indent = null;

    public TreeTableRowSkin(TreeTableRow<T> control) {
        super(control, new TreeTableRowBehavior<T>(control));
        super.init(control);
        this.updateTreeItem();
        this.updateTableViewSkin();
        this.registerChangeListener(control.treeTableViewProperty(), "TREE_TABLE_VIEW");
        this.registerChangeListener(control.indexProperty(), "INDEX");
        this.registerChangeListener(control.treeItemProperty(), "TREE_ITEM");
        this.registerChangeListener(control.getTreeTableView().treeColumnProperty(), "TREE_COLUMN");
    }

    public final void setIndent(double value) {
        this.indentProperty().set(value);
    }

    public final double getIndent() {
        return this.indent == null ? 10.0 : this.indent.get();
    }

    public final DoubleProperty indentProperty() {
        if (this.indent == null) {
            this.indent = new StyleableDoubleProperty(10.0){

                @Override
                public Object getBean() {
                    return TreeTableRowSkin.this;
                }

                @Override
                public String getName() {
                    return "indent";
                }

                @Override
                public CssMetaData<TreeTableRow<?>, Number> getCssMetaData() {
                    return StyleableProperties.INDENT;
                }
            };
        }
        return this.indent;
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("TREE_ABLE_VIEW".equals(p)) {
            this.updateTableViewSkin();
        } else if ("INDEX".equals(p)) {
            this.updateCells = true;
        } else if ("TREE_ITEM".equals(p)) {
            this.updateTreeItem();
            this.isDirty = true;
        } else if ("TREE_COLUMN".equals(p)) {
            this.isDirty = true;
            ((TreeTableRow)this.getSkinnable()).requestLayout();
        }
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        this.updateDisclosureNodeAndGraphic();
        if (this.childrenDirty) {
            this.childrenDirty = false;
            if (this.cells.isEmpty()) {
                this.getChildren().clear();
            } else {
                this.getChildren().addAll(this.cells);
            }
        }
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        Node disclosureNode;
        if (this.disclosureNodeDirty) {
            this.updateDisclosureNodeAndGraphic();
            this.disclosureNodeDirty = false;
        }
        if ((disclosureNode = this.getDisclosureNode()) != null && disclosureNode.getScene() == null) {
            this.updateDisclosureNodeAndGraphic();
        }
        super.layoutChildren(x, y, w, h);
    }

    @Override
    protected TreeTableCell<T, ?> getCell(TableColumnBase tcb) {
        TreeTableColumn tableColumn = (TreeTableColumn)tcb;
        TreeTableCell cell = tableColumn.getCellFactory().call(tableColumn);
        cell.updateTreeTableColumn(tableColumn);
        cell.updateTreeTableView(tableColumn.getTreeTableView());
        return cell;
    }

    @Override
    protected void updateCells(boolean resetChildren) {
        super.updateCells(resetChildren);
        if (resetChildren) {
            this.childrenDirty = true;
            this.updateChildren();
        }
    }

    @Override
    protected boolean isIndentationRequired() {
        return true;
    }

    @Override
    protected TableColumnBase getTreeColumn() {
        return ((TreeTableRow)this.getSkinnable()).getTreeTableView().getTreeColumn();
    }

    @Override
    protected int getIndentationLevel(TreeTableRow<T> control) {
        return control.getTreeTableView().getTreeItemLevel(control.getTreeItem());
    }

    @Override
    protected double getIndentationPerLevel() {
        return this.getIndent();
    }

    @Override
    protected Node getDisclosureNode() {
        return ((TreeTableRow)this.getSkinnable()).getDisclosureNode();
    }

    @Override
    protected boolean isDisclosureNodeVisible() {
        return this.getDisclosureNode() != null && this.treeItem != null && !this.treeItem.isLeaf();
    }

    @Override
    protected boolean isShowRoot() {
        return ((TreeTableRow)this.getSkinnable()).getTreeTableView().isShowRoot();
    }

    @Override
    protected ObservableList<TreeTableColumn<T, ?>> getVisibleLeafColumns() {
        return ((TreeTableRow)this.getSkinnable()).getTreeTableView().getVisibleLeafColumns();
    }

    @Override
    protected void updateCell(TreeTableCell<T, ?> cell, TreeTableRow<T> row) {
        cell.updateTreeTableRow(row);
    }

    @Override
    protected boolean isColumnPartiallyOrFullyVisible(TableColumnBase tc) {
        return this.treeTableViewSkin == null ? false : this.treeTableViewSkin.isColumnPartiallyOrFullyVisible(tc);
    }

    @Override
    protected TreeTableColumn<T, ?> getTableColumnBase(TreeTableCell cell) {
        return cell.getTableColumn();
    }

    @Override
    protected ObjectProperty<Node> graphicProperty() {
        TreeTableRow treeTableRow = (TreeTableRow)this.getSkinnable();
        if (treeTableRow == null) {
            return null;
        }
        if (this.treeItem == null) {
            return null;
        }
        return this.treeItem.graphicProperty();
    }

    @Override
    protected Control getVirtualFlowOwner() {
        return ((TreeTableRow)this.getSkinnable()).getTreeTableView();
    }

    @Override
    protected DoubleProperty fixedCellSizeProperty() {
        return ((TreeTableRow)this.getSkinnable()).getTreeTableView().fixedCellSizeProperty();
    }

    private void updateTreeItem() {
        if (this.treeItem != null) {
            this.treeItemListener.unregisterChangeListener(this.treeItem.expandedProperty());
            this.treeItemListener.unregisterChangeListener(this.treeItem.graphicProperty());
        }
        this.treeItem = ((TreeTableRow)this.getSkinnable()).getTreeItem();
        if (this.treeItem != null) {
            this.treeItemListener.registerChangeListener(this.treeItem.graphicProperty(), "GRAPHIC");
        }
    }

    private void updateDisclosureNodeAndGraphic() {
        Node disclosureNode;
        Node newGraphic;
        if (((TreeTableRow)this.getSkinnable()).isEmpty()) {
            return;
        }
        ObjectProperty<Node> graphicProperty = this.graphicProperty();
        Node node = newGraphic = graphicProperty == null ? null : (Node)graphicProperty.get();
        if (newGraphic != null) {
            if (newGraphic != this.graphic) {
                this.getChildren().remove(this.graphic);
            }
            if (!this.getChildren().contains(newGraphic)) {
                this.getChildren().add(newGraphic);
                this.graphic = newGraphic;
            }
        }
        if ((disclosureNode = ((TreeTableRow)this.getSkinnable()).getDisclosureNode()) != null) {
            boolean disclosureVisible = this.treeItem != null && !this.treeItem.isLeaf();
            disclosureNode.setVisible(disclosureVisible);
            if (!disclosureVisible) {
                this.getChildren().remove(disclosureNode);
            } else if (disclosureNode.getParent() == null) {
                this.getChildren().add(disclosureNode);
                disclosureNode.toFront();
            } else {
                disclosureNode.toBack();
            }
            if (disclosureNode.getScene() != null) {
                disclosureNode.applyCss();
            }
        }
    }

    private void updateTableViewSkin() {
        TreeTableView tableView = ((TreeTableRow)this.getSkinnable()).getTreeTableView();
        if (tableView.getSkin() instanceof TreeTableViewSkin) {
            this.treeTableViewSkin = (TreeTableViewSkin)tableView.getSkin();
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TreeTableRowSkin.getClassCssMetaData();
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        TreeTableView treeTableView = ((TreeTableRow)this.getSkinnable()).getTreeTableView();
        switch (attribute) {
            case SELECTED_ITEMS: {
                ArrayList<TreeTableCell> selection = new ArrayList<TreeTableCell>();
                int index = ((TreeTableRow)this.getSkinnable()).getIndex();
                Iterator iterator = treeTableView.getSelectionModel().getSelectedCells().iterator();
                if (iterator.hasNext()) {
                    TreeTablePosition pos = (TreeTablePosition)iterator.next();
                    if (pos.getRow() == index) {
                        TreeTableCell cell;
                        TreeTableColumn column = pos.getTableColumn();
                        if (column == null) {
                            column = treeTableView.getVisibleLeafColumn(0);
                        }
                        if ((cell = (TreeTableCell)((Reference)this.cellsMap.get(column)).get()) != null) {
                            selection.add(cell);
                        }
                    }
                    return FXCollections.observableArrayList(selection);
                }
            }
            case CELL_AT_ROW_COLUMN: {
                int colIndex = (Integer)parameters[1];
                TreeTableColumn column = treeTableView.getVisibleLeafColumn(colIndex);
                if (this.cellsMap.containsKey(column)) {
                    return ((Reference)this.cellsMap.get(column)).get();
                }
                return null;
            }
            case FOCUS_ITEM: {
                TreeTableView.TreeTableViewFocusModel fm = treeTableView.getFocusModel();
                TreeTablePosition focusedCell = fm.getFocusedCell();
                TreeTableColumn column = focusedCell.getTableColumn();
                if (column == null) {
                    column = treeTableView.getVisibleLeafColumn(0);
                }
                if (this.cellsMap.containsKey(column)) {
                    return ((Reference)this.cellsMap.get(column)).get();
                }
                return null;
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    /* synthetic */ Void lambda$new$522(String p) {
        if ("GRAPHIC".equals(p)) {
            this.disclosureNodeDirty = true;
            ((TreeTableRow)this.getSkinnable()).requestLayout();
        }
        return null;
    }

    private static class StyleableProperties {
        private static final CssMetaData<TreeTableRow<?>, Number> INDENT = new CssMetaData<TreeTableRow<?>, Number>("-fx-indent", SizeConverter.getInstance(), 10.0){

            @Override
            public boolean isSettable(TreeTableRow<?> n) {
                DoubleProperty p = ((TreeTableRowSkin)n.getSkin()).indentProperty();
                return p == null || !p.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TreeTableRow<?> n) {
                TreeTableRowSkin skin = (TreeTableRowSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.indentProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(CellSkinBase.getClassCssMetaData());
            styleables.add(INDENT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

