/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.TreeViewBehavior;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$10;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$11;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$12;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$13;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$5;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$6;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$7;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$8;
import com.sun.javafx.scene.control.skin.TreeViewSkin$$Lambda$9;
import com.sun.javafx.scene.control.skin.TreeViewSkin$1$$Lambda$1;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;

public class TreeViewSkin<T>
extends VirtualContainerBase<TreeView<T>, TreeViewBehavior<T>, TreeCell<T>> {
    public static final String RECREATE = "treeRecreateKey";
    private static final boolean IS_PANNABLE = (Boolean)AccessController.doPrivileged(TreeViewSkin$$Lambda$13.lambdaFactory$());
    private boolean needCellsRebuilt = true;
    private boolean needCellsReconfigured = false;
    private MapChangeListener<Object, Object> propertiesMapListener = TreeViewSkin$$Lambda$1.lambdaFactory$(this);
    private EventHandler<TreeItem.TreeModificationEvent<T>> rootListener = TreeViewSkin$$Lambda$2.lambdaFactory$(this);
    private WeakEventHandler<TreeItem.TreeModificationEvent<T>> weakRootListener;
    private WeakReference<TreeItem<T>> weakRoot;

    public TreeViewSkin(TreeView treeView) {
        super(treeView, new TreeViewBehavior(treeView));
        this.flow.setPannable(IS_PANNABLE);
        this.flow.setCreateCell(TreeViewSkin$$Lambda$3.lambdaFactory$(this));
        this.flow.setFixedCellSize(treeView.getFixedCellSize());
        this.getChildren().add(this.flow);
        this.setRoot(((TreeView)this.getSkinnable()).getRoot());
        EventHandler ml = TreeViewSkin$$Lambda$4.lambdaFactory$(treeView);
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, ml);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, ml);
        ObservableMap<Object, Object> properties = treeView.getProperties();
        properties.remove(RECREATE);
        properties.addListener(this.propertiesMapListener);
        ((TreeViewBehavior)this.getBehavior()).setOnFocusPreviousRow(TreeViewSkin$$Lambda$5.lambdaFactory$(this));
        ((TreeViewBehavior)this.getBehavior()).setOnFocusNextRow(TreeViewSkin$$Lambda$6.lambdaFactory$(this));
        ((TreeViewBehavior)this.getBehavior()).setOnMoveToFirstCell(TreeViewSkin$$Lambda$7.lambdaFactory$(this));
        ((TreeViewBehavior)this.getBehavior()).setOnMoveToLastCell(TreeViewSkin$$Lambda$8.lambdaFactory$(this));
        ((TreeViewBehavior)this.getBehavior()).setOnScrollPageDown(TreeViewSkin$$Lambda$9.lambdaFactory$(this));
        ((TreeViewBehavior)this.getBehavior()).setOnScrollPageUp(TreeViewSkin$$Lambda$10.lambdaFactory$(this));
        ((TreeViewBehavior)this.getBehavior()).setOnSelectPreviousRow(TreeViewSkin$$Lambda$11.lambdaFactory$(this));
        ((TreeViewBehavior)this.getBehavior()).setOnSelectNextRow(TreeViewSkin$$Lambda$12.lambdaFactory$(this));
        this.registerChangeListener(treeView.rootProperty(), "ROOT");
        this.registerChangeListener(treeView.showRootProperty(), "SHOW_ROOT");
        this.registerChangeListener(treeView.cellFactoryProperty(), "CELL_FACTORY");
        this.registerChangeListener(treeView.fixedCellSizeProperty(), "FIXED_CELL_SIZE");
        this.updateRowCount();
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("ROOT".equals(p)) {
            this.setRoot(((TreeView)this.getSkinnable()).getRoot());
        } else if ("SHOW_ROOT".equals(p)) {
            if (!((TreeView)this.getSkinnable()).isShowRoot() && this.getRoot() != null) {
                this.getRoot().setExpanded(true);
            }
            this.updateRowCount();
        } else if ("CELL_FACTORY".equals(p)) {
            this.flow.recreateCells();
        } else if ("FIXED_CELL_SIZE".equals(p)) {
            this.flow.setFixedCellSize(((TreeView)this.getSkinnable()).getFixedCellSize());
        }
    }

    private TreeItem<T> getRoot() {
        return this.weakRoot == null ? null : (TreeItem)this.weakRoot.get();
    }

    private void setRoot(TreeItem<T> newRoot) {
        if (this.getRoot() != null && this.weakRootListener != null) {
            this.getRoot().removeEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
        this.weakRoot = new WeakReference<TreeItem<TreeItem<T>>>(newRoot);
        if (this.getRoot() != null) {
            this.weakRootListener = new WeakEventHandler<TreeItem.TreeModificationEvent<TreeItem.TreeModificationEvent<T>>>(this.rootListener);
            this.getRoot().addEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
        this.updateRowCount();
    }

    @Override
    public int getItemCount() {
        return ((TreeView)this.getSkinnable()).getExpandedItemCount();
    }

    @Override
    protected void updateRowCount() {
        int newCount = this.getItemCount();
        this.flow.setCellCount(newCount);
        this.needCellsRebuilt = true;
        ((TreeView)this.getSkinnable()).requestLayout();
    }

    @Override
    public TreeCell<T> createCell() {
        TreeCell<T> cell = ((TreeView)this.getSkinnable()).getCellFactory() != null ? ((TreeView)this.getSkinnable()).getCellFactory().call(this.getSkinnable()) : this.createDefaultCellImpl();
        if (cell.getDisclosureNode() == null) {
            StackPane disclosureNode = new StackPane();
            disclosureNode.getStyleClass().setAll((String[])new String[]{"tree-disclosure-node"});
            StackPane disclosureNodeArrow = new StackPane();
            disclosureNodeArrow.getStyleClass().setAll((String[])new String[]{"arrow"});
            disclosureNode.getChildren().add(disclosureNodeArrow);
            cell.setDisclosureNode(disclosureNode);
        }
        cell.updateTreeView((TreeView)this.getSkinnable());
        return cell;
    }

    private TreeCell<T> createDefaultCellImpl() {
        return new TreeCell<T>(){
            private HBox hbox;
            private WeakReference<TreeItem<T>> treeItemRef;
            private InvalidationListener treeItemGraphicListener = TreeViewSkin$1$$Lambda$1.lambdaFactory$(this);
            private InvalidationListener treeItemListener = new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    TreeItem newTreeItem;
                    TreeItem oldTreeItem;
                    TreeItem treeItem = oldTreeItem = treeItemRef == null ? null : (TreeItem)treeItemRef.get();
                    if (oldTreeItem != null) {
                        oldTreeItem.graphicProperty().removeListener(weakTreeItemGraphicListener);
                    }
                    if ((newTreeItem = this.getTreeItem()) != null) {
                        newTreeItem.graphicProperty().addListener(weakTreeItemGraphicListener);
                        treeItemRef = new WeakReference(newTreeItem);
                    }
                }
            };
            private WeakInvalidationListener weakTreeItemGraphicListener = new WeakInvalidationListener(this.treeItemGraphicListener);
            private WeakInvalidationListener weakTreeItemListener = new WeakInvalidationListener(this.treeItemListener);
            {
                this.treeItemProperty().addListener(this.weakTreeItemListener);
                if (this.getTreeItem() != null) {
                    this.getTreeItem().graphicProperty().addListener(this.weakTreeItemGraphicListener);
                }
            }

            private void updateDisplay(T item, boolean empty) {
                if (item == null || empty) {
                    this.hbox = null;
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    Node graphic;
                    TreeItem treeItem = this.getTreeItem();
                    Node node = graphic = treeItem == null ? null : treeItem.getGraphic();
                    if (graphic != null) {
                        if (item instanceof Node) {
                            this.setText(null);
                            if (this.hbox == null) {
                                this.hbox = new HBox(3.0);
                            }
                            this.hbox.getChildren().setAll((Node[])new Node[]{graphic, (Node)item});
                            this.setGraphic(this.hbox);
                        } else {
                            this.hbox = null;
                            this.setText(item.toString());
                            this.setGraphic(graphic);
                        }
                    } else {
                        this.hbox = null;
                        if (item instanceof Node) {
                            this.setText(null);
                            this.setGraphic((Node)item);
                        } else {
                            this.setText(item.toString());
                            this.setGraphic(null);
                        }
                    }
                }
            }

            @Override
            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                this.updateDisplay(item, empty);
            }

            /* synthetic */ void lambda$$548(Observable observable) {
                this.updateDisplay(this.getItem(), this.isEmpty());
            }
        };
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(-1.0, topInset, rightInset, bottomInset, leftInset) * 0.618033987;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 400.0;
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        if (this.needCellsRebuilt) {
            this.flow.rebuildCells();
        } else if (this.needCellsReconfigured) {
            this.flow.reconfigureCells();
        }
        this.needCellsRebuilt = false;
        this.needCellsReconfigured = false;
        this.flow.resizeRelocate(x, y, w, h);
    }

    private void onFocusPreviousCell() {
        FocusModel fm = ((TreeView)this.getSkinnable()).getFocusModel();
        if (fm == null) {
            return;
        }
        this.flow.show(fm.getFocusedIndex());
    }

    private void onFocusNextCell() {
        FocusModel fm = ((TreeView)this.getSkinnable()).getFocusModel();
        if (fm == null) {
            return;
        }
        this.flow.show(fm.getFocusedIndex());
    }

    private void onSelectPreviousCell() {
        int row = ((TreeView)this.getSkinnable()).getSelectionModel().getSelectedIndex();
        this.flow.show(row);
    }

    private void onSelectNextCell() {
        int row = ((TreeView)this.getSkinnable()).getSelectionModel().getSelectedIndex();
        this.flow.show(row);
    }

    private void onMoveToFirstCell() {
        this.flow.show(0);
        this.flow.setPosition(0.0);
    }

    private void onMoveToLastCell() {
        this.flow.show(this.getItemCount());
        this.flow.setPosition(1.0);
    }

    public int onScrollPageDown(boolean isFocusDriven) {
        TreeCell lastVisibleCell = (TreeCell)this.flow.getLastVisibleCellWithinViewPort();
        if (lastVisibleCell == null) {
            return -1;
        }
        MultipleSelectionModel sm = ((TreeView)this.getSkinnable()).getSelectionModel();
        FocusModel fm = ((TreeView)this.getSkinnable()).getFocusModel();
        if (sm == null || fm == null) {
            return -1;
        }
        int lastVisibleCellIndex = lastVisibleCell.getIndex();
        boolean isSelected = false;
        if (isFocusDriven) {
            isSelected = lastVisibleCell.isFocused() || fm.isFocused(lastVisibleCellIndex);
        } else {
            boolean bl = isSelected = lastVisibleCell.isSelected() || sm.isSelected(lastVisibleCellIndex);
        }
        if (isSelected) {
            boolean isLeadIndex;
            boolean bl = isLeadIndex = isFocusDriven && fm.getFocusedIndex() == lastVisibleCellIndex || !isFocusDriven && sm.getSelectedIndex() == lastVisibleCellIndex;
            if (isLeadIndex) {
                this.flow.showAsFirst(lastVisibleCell);
                TreeCell newLastVisibleCell = (TreeCell)this.flow.getLastVisibleCellWithinViewPort();
                lastVisibleCell = newLastVisibleCell == null ? lastVisibleCell : newLastVisibleCell;
            }
        }
        int newSelectionIndex = lastVisibleCell.getIndex();
        this.flow.show(lastVisibleCell);
        return newSelectionIndex;
    }

    public int onScrollPageUp(boolean isFocusDriven) {
        TreeCell firstVisibleCell = (TreeCell)this.flow.getFirstVisibleCellWithinViewPort();
        if (firstVisibleCell == null) {
            return -1;
        }
        MultipleSelectionModel sm = ((TreeView)this.getSkinnable()).getSelectionModel();
        FocusModel fm = ((TreeView)this.getSkinnable()).getFocusModel();
        if (sm == null || fm == null) {
            return -1;
        }
        int firstVisibleCellIndex = firstVisibleCell.getIndex();
        boolean isSelected = false;
        if (isFocusDriven) {
            isSelected = firstVisibleCell.isFocused() || fm.isFocused(firstVisibleCellIndex);
        } else {
            boolean bl = isSelected = firstVisibleCell.isSelected() || sm.isSelected(firstVisibleCellIndex);
        }
        if (isSelected) {
            boolean isLeadIndex;
            boolean bl = isLeadIndex = isFocusDriven && fm.getFocusedIndex() == firstVisibleCellIndex || !isFocusDriven && sm.getSelectedIndex() == firstVisibleCellIndex;
            if (isLeadIndex) {
                this.flow.showAsLast(firstVisibleCell);
                TreeCell newFirstVisibleCell = (TreeCell)this.flow.getFirstVisibleCellWithinViewPort();
                firstVisibleCell = newFirstVisibleCell == null ? firstVisibleCell : newFirstVisibleCell;
            }
        }
        int newSelectionIndex = firstVisibleCell.getIndex();
        this.flow.show(firstVisibleCell);
        return newSelectionIndex;
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case FOCUS_ITEM: {
                FocusModel fm = ((TreeView)this.getSkinnable()).getFocusModel();
                int focusedIndex = fm.getFocusedIndex();
                if (focusedIndex == -1) {
                    if (this.getItemCount() > 0) {
                        focusedIndex = 0;
                    } else {
                        return null;
                    }
                }
                return this.flow.getPrivateCell(focusedIndex);
            }
            case ROW_AT_INDEX: {
                int rowIndex = (Integer)parameters[0];
                return rowIndex < 0 ? null : this.flow.getPrivateCell(rowIndex);
            }
            case SELECTED_ITEMS: {
                MultipleSelectionModel sm = ((TreeView)this.getSkinnable()).getSelectionModel();
                ObservableList<Integer> indices = sm.getSelectedIndices();
                ArrayList<TreeCell> selection = new ArrayList<TreeCell>(indices.size());
                Iterator iterator = indices.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    TreeCell row = (TreeCell)this.flow.getPrivateCell(i);
                    if (row == null) continue;
                    selection.add(row);
                }
                return FXCollections.observableArrayList(selection);
            }
            case VERTICAL_SCROLLBAR: {
                return this.flow.getVbar();
            }
            case HORIZONTAL_SCROLLBAR: {
                return this.flow.getHbar();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case SHOW_ITEM: {
                Node item = (Node)parameters[0];
                if (!(item instanceof TreeCell)) break;
                TreeCell cell = (TreeCell)item;
                this.flow.show(cell.getIndex());
                break;
            }
            case SET_SELECTED_ITEMS: {
                MultipleSelectionModel sm;
                ObservableList items = (ObservableList)parameters[0];
                if (items == null || (sm = ((TreeView)this.getSkinnable()).getSelectionModel()) == null) break;
                sm.clearSelection();
                for (Node item : items) {
                    if (!(item instanceof TreeCell)) continue;
                    TreeCell cell = (TreeCell)item;
                    sm.select(cell.getIndex());
                }
                break;
            }
            default: {
                super.executeAccessibleAction(action, parameters);
            }
        }
    }

    /* synthetic */ void lambda$new$547(TreeItem.TreeModificationEvent e) {
        if (e.wasAdded() && e.wasRemoved() && e.getAddedSize() == e.getRemovedSize()) {
            this.rowCountDirty = true;
            ((TreeView)this.getSkinnable()).requestLayout();
        } else if (e.getEventType().equals(TreeItem.valueChangedEvent())) {
            this.needCellsRebuilt = true;
            ((TreeView)this.getSkinnable()).requestLayout();
        } else {
            for (EventType<? extends Event> eventType = e.getEventType(); eventType != null; eventType = eventType.getSuperType()) {
                if (!eventType.equals(TreeItem.expandedItemCountChangeEvent())) continue;
                this.rowCountDirty = true;
                ((TreeView)this.getSkinnable()).requestLayout();
                break;
            }
        }
        ((TreeView)this.getSkinnable()).edit(null);
    }

    /* synthetic */ void lambda$new$546(MapChangeListener.Change c) {
        if (!c.wasAdded()) {
            return;
        }
        if (RECREATE.equals(c.getKey())) {
            this.needCellsRebuilt = true;
            ((TreeView)this.getSkinnable()).requestLayout();
            ((TreeView)this.getSkinnable()).getProperties().remove(RECREATE);
        }
    }

    /* synthetic */ void lambda$new$545() {
        this.onSelectNextCell();
    }

    /* synthetic */ void lambda$new$544() {
        this.onSelectPreviousCell();
    }

    /* synthetic */ Integer lambda$new$543(Boolean isFocusDriven) {
        return this.onScrollPageUp(isFocusDriven);
    }

    /* synthetic */ Integer lambda$new$542(Boolean isFocusDriven) {
        return this.onScrollPageDown(isFocusDriven);
    }

    /* synthetic */ void lambda$new$541() {
        this.onMoveToLastCell();
    }

    /* synthetic */ void lambda$new$540() {
        this.onMoveToFirstCell();
    }

    /* synthetic */ void lambda$new$539() {
        this.onFocusNextCell();
    }

    /* synthetic */ void lambda$new$538() {
        this.onFocusPreviousCell();
    }

    static /* synthetic */ void lambda$new$537(TreeView treeView, MouseEvent event) {
        if (treeView.getEditingItem() != null) {
            treeView.edit(null);
        }
        if (treeView.isFocusTraversable()) {
            treeView.requestFocus();
        }
    }

    /* synthetic */ TreeCell lambda$new$536(VirtualFlow flow1) {
        return this.createCell();
    }

    static /* synthetic */ Boolean lambda$static$535() {
        return Boolean.getBoolean("com.sun.javafx.scene.control.skin.TreeViewSkin.pannable");
    }
}

