/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Pixels;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.embed.AbstractEvents;
import com.sun.javafx.embed.EmbeddedSceneDTInterface;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.HostDragStartListener;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.scene.input.KeyCodeMap;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.EmbeddedScene$$Lambda$1;
import com.sun.javafx.tk.quantum.EmbeddedScene$$Lambda$10;
import com.sun.javafx.tk.quantum.EmbeddedScene$$Lambda$11;
import com.sun.javafx.tk.quantum.EmbeddedScene$$Lambda$12;
import com.sun.javafx.tk.quantum.EmbeddedScene$$Lambda$2;
import com.sun.javafx.tk.quantum.EmbeddedScene$$Lambda$3;
import com.sun.javafx.tk.quantum.EmbeddedScene$$Lambda$4;
import com.sun.javafx.tk.quantum.EmbeddedScene$$Lambda$5;
import com.sun.javafx.tk.quantum.EmbeddedScene$$Lambda$6;
import com.sun.javafx.tk.quantum.EmbeddedScene$$Lambda$7;
import com.sun.javafx.tk.quantum.EmbeddedScene$$Lambda$8;
import com.sun.javafx.tk.quantum.EmbeddedScene$$Lambda$9;
import com.sun.javafx.tk.quantum.EmbeddedSceneDnD;
import com.sun.javafx.tk.quantum.EmbeddedState;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.UploadingPainter;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import java.nio.IntBuffer;
import java.security.AccessController;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventType;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

final class EmbeddedScene
extends GlassScene
implements EmbeddedSceneInterface {
    private HostInterface host;
    private UploadingPainter painter;
    private PaintRenderJob paintRenderJob;
    private final EmbeddedSceneDnD embeddedDnD;
    private volatile IntBuffer texBits;
    private volatile int texLineStride;
    private volatile float texScaleFactor = 1.0f;

    public EmbeddedScene(HostInterface host, boolean depthBuffer, boolean msaa) {
        super(depthBuffer, msaa);
        this.sceneState = new EmbeddedState(this);
        this.host = host;
        this.embeddedDnD = new EmbeddedSceneDnD(this);
        PaintCollector collector = PaintCollector.getInstance();
        this.painter = new UploadingPainter(this);
        this.paintRenderJob = new PaintRenderJob(this, collector.getRendered(), this.painter);
    }

    @Override
    public void dispose() {
        assert (this.host != null);
        QuantumToolkit.runWithRenderLock(EmbeddedScene$$Lambda$1.lambdaFactory$(this));
        super.dispose();
    }

    @Override
    void setStage(GlassStage stage) {
        super.setStage(stage);
        assert (this.host != null);
        this.host.setEmbeddedScene(stage != null ? this : null);
    }

    @Override
    protected boolean isSynchronous() {
        return false;
    }

    @Override
    public void setRoot(NGNode root) {
        super.setRoot(root);
        this.painter.setRoot(root);
    }

    @Override
    public TKClipboard createDragboard(boolean isDragSource) {
        return this.embeddedDnD.createDragboard(isDragSource);
    }

    @Override
    public void enableInputMethodEvents(boolean enable) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedScene.enableInputMethodEvents " + enable);
        }
    }

    @Override
    public void finishInputMethodComposition() {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedScene.finishInputMethodComposition");
        }
    }

    @Override
    public void setPixelScaleFactor(float scale) {
        this.painter.setPixelScaleFactor(scale);
        this.entireSceneNeedsRepaint();
    }

    void uploadPixels(Pixels pixels) {
        this.texBits = (IntBuffer)pixels.getPixels();
        this.texLineStride = pixels.getWidthUnsafe();
        this.texScaleFactor = pixels.getScaleUnsafe();
        if (this.host != null) {
            this.host.repaint();
        }
    }

    @Override
    public void repaint() {
        Toolkit tk = Toolkit.getToolkit();
        tk.addRenderJob(this.paintRenderJob);
    }

    @Override
    public boolean traverseOut(Direction dir) {
        if (dir == Direction.NEXT) {
            return this.host.traverseFocusOut(true);
        }
        if (dir == Direction.PREVIOUS) {
            return this.host.traverseFocusOut(false);
        }
        return false;
    }

    @Override
    public void setSize(int width, int height) {
        Platform.runLater(EmbeddedScene$$Lambda$2.lambdaFactory$(this, width, height));
    }

    @Override
    public boolean getPixels(IntBuffer dest, int width, int height) {
        return (Boolean)QuantumToolkit.runWithRenderLock(EmbeddedScene$$Lambda$3.lambdaFactory$(this, width, height, dest));
    }

    @Override
    protected Color getClearColor() {
        if (this.fillPaint != null && this.fillPaint.getType() == Paint.Type.COLOR && ((Color)this.fillPaint).getAlpha() == 0.0f) {
            return (Color)this.fillPaint;
        }
        return super.getClearColor();
    }

    @Override
    public void mouseEvent(int type, int button, boolean primaryBtnDown, boolean middleBtnDown, boolean secondaryBtnDown, int x, int y, int xAbs, int yAbs, boolean shift, boolean ctrl, boolean alt, boolean meta, int wheelRotation, boolean popupTrigger) {
        Platform.runLater(EmbeddedScene$$Lambda$4.lambdaFactory$(this, type, wheelRotation, x, y, xAbs, yAbs, shift, ctrl, alt, meta, button, popupTrigger, primaryBtnDown, middleBtnDown, secondaryBtnDown));
    }

    @Override
    public void inputMethodEvent(EventType<InputMethodEvent> type, ObservableList<InputMethodTextRun> composed, String committed, int caretPosition) {
        Platform.runLater(EmbeddedScene$$Lambda$5.lambdaFactory$(this, type, composed, committed, caretPosition));
    }

    @Override
    public void menuEvent(int x, int y, int xAbs, int yAbs, boolean isKeyboardTrigger) {
        Platform.runLater(EmbeddedScene$$Lambda$6.lambdaFactory$(this, x, y, xAbs, yAbs, isKeyboardTrigger));
    }

    @Override
    public void keyEvent(int type, int key, char[] ch, int modifiers) {
        Platform.runLater(EmbeddedScene$$Lambda$7.lambdaFactory$(this, modifiers, ch, type, key));
    }

    @Override
    public void setCursor(Object cursor) {
        super.setCursor(cursor);
        this.host.setCursor((CursorFrame)cursor);
    }

    @Override
    public void setDragStartListener(HostDragStartListener l) {
        this.embeddedDnD.setDragStartListener(l);
    }

    @Override
    public EmbeddedSceneDTInterface createDropTarget() {
        return this.embeddedDnD.createDropTarget();
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.inputMethodRequests;
    }

    /* synthetic */ void lambda$keyEvent$283(int n, char[] cArray, int n2, int n3) {
        AccessController.doPrivileged(EmbeddedScene$$Lambda$8.lambdaFactory$(this, n, cArray, n2, n3), this.getAccessControlContext());
    }

    /* synthetic */ Void lambda$null$282(int n, char[] cArray, int n2, int n3) {
        if (this.sceneListener != null) {
            String str;
            boolean shiftDown = (n & 1) != 0;
            boolean controlDown = (n & 2) != 0;
            boolean altDown = (n & 4) != 0;
            boolean metaDown = (n & 8) != 0;
            String text = str = new String(cArray);
            KeyEvent keyEvent = new KeyEvent(AbstractEvents.keyIDToFXEventType(n2), str, text, KeyCodeMap.valueOf(n3), shiftDown, controlDown, altDown, metaDown);
            this.sceneListener.keyEvent(keyEvent);
        }
        return null;
    }

    /* synthetic */ void lambda$menuEvent$281(int n, int n2, int n3, int n4, boolean bl) {
        AccessController.doPrivileged(EmbeddedScene$$Lambda$9.lambdaFactory$(this, n, n2, n3, n4, bl), this.getAccessControlContext());
    }

    /* synthetic */ Void lambda$null$280(int n, int n2, int n3, int n4, boolean bl) {
        if (this.sceneListener != null) {
            this.sceneListener.menuEvent(n, n2, n3, n4, bl);
        }
        return null;
    }

    /* synthetic */ void lambda$inputMethodEvent$279(EventType eventType, ObservableList observableList, String string, int n) {
        AccessController.doPrivileged(EmbeddedScene$$Lambda$10.lambdaFactory$(this, eventType, observableList, string, n));
    }

    /* synthetic */ Void lambda$null$278(EventType eventType, ObservableList observableList, String string, int n) {
        if (this.sceneListener != null) {
            this.sceneListener.inputMethodEvent(eventType, observableList, string, n);
        }
        return null;
    }

    /* synthetic */ void lambda$mouseEvent$277(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n7, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        AccessController.doPrivileged(EmbeddedScene$$Lambda$11.lambdaFactory$(this, n, n2, n3, n4, n5, n6, bl, bl2, bl3, bl4, n7, bl5, bl6, bl7, bl8), this.getAccessControlContext());
    }

    /* synthetic */ Void lambda$null$276(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n7, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        if (this.sceneListener == null) {
            return null;
        }
        assert (n != 2);
        if (n == 7) {
            this.sceneListener.scrollEvent(ScrollEvent.SCROLL, 0.0, -n2, 0.0, 0.0, 40.0, 40.0, 0, 0, 0, 0, 0, n3, n4, n5, n6, bl, bl2, bl3, bl4, false, false);
        } else {
            EventType<MouseEvent> eventType = AbstractEvents.mouseIDToFXEventID(n);
            this.sceneListener.mouseEvent(eventType, n3, n4, n5, n6, AbstractEvents.mouseButtonToFXMouseButton(n7), bl5, false, bl, bl2, bl3, bl4, bl6, bl7, bl8);
        }
        return null;
    }

    /* synthetic */ Boolean lambda$getPixels$275(int n, int n2, IntBuffer intBuffer) {
        int scaledWidth = n;
        int scaledHeight = n2;
        if (this.painter.getPixelScaleFactor() != this.texScaleFactor || this.texBits == null) {
            return false;
        }
        scaledWidth = Math.round((float)scaledWidth * this.texScaleFactor);
        scaledHeight = Math.round((float)scaledHeight * this.texScaleFactor);
        intBuffer.rewind();
        this.texBits.rewind();
        if (intBuffer.capacity() != this.texBits.capacity()) {
            int w = Math.min(scaledWidth, this.texLineStride);
            int h = Math.min(scaledHeight, this.texBits.capacity() / this.texLineStride);
            int[] linebuf = new int[w];
            for (int i = 0; i < h; ++i) {
                this.texBits.position(i * this.texLineStride);
                this.texBits.get(linebuf, 0, w);
                intBuffer.position(i * scaledWidth);
                intBuffer.put(linebuf);
            }
            return true;
        }
        intBuffer.put(this.texBits);
        return true;
    }

    /* synthetic */ void lambda$setSize$274(int n, int n2) {
        AccessController.doPrivileged(EmbeddedScene$$Lambda$12.lambdaFactory$(this, n, n2), this.getAccessControlContext());
    }

    /* synthetic */ Void lambda$null$273(int n, int n2) {
        if (this.sceneListener != null) {
            this.sceneListener.changedSize(n, n2);
        }
        return null;
    }

    /* synthetic */ Object lambda$dispose$272() {
        this.host.setEmbeddedScene(null);
        this.host = null;
        this.updateSceneState();
        this.painter = null;
        this.paintRenderJob = null;
        this.texBits = null;
        return null;
    }
}

