/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.quantum.GestureRecognizer;
import com.sun.javafx.tk.quantum.RotateGestureRecognizer$$Lambda$1;
import com.sun.javafx.tk.quantum.RotateGestureRecognizer$$Lambda$2;
import com.sun.javafx.tk.quantum.RotateGestureRecognizer$$Lambda$3;
import com.sun.javafx.tk.quantum.RotateGestureRecognizer$$Lambda$4;
import com.sun.javafx.tk.quantum.RotateGestureRecognizer$$Lambda$5;
import com.sun.javafx.tk.quantum.RotateGestureRecognizer$$Lambda$6;
import com.sun.javafx.tk.quantum.ViewScene;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.ActionEvent;
import javafx.scene.input.RotateEvent;
import javafx.util.Duration;

class RotateGestureRecognizer
implements GestureRecognizer {
    private ViewScene scene;
    private static double ROTATATION_THRESHOLD = 5.0;
    private static boolean ROTATION_INERTIA_ENABLED = true;
    private static double MAX_INITIAL_VELOCITY = 500.0;
    private static double ROTATION_INERTIA_MILLIS = 1500.0;
    private RotateRecognitionState state = RotateRecognitionState.IDLE;
    private Timeline inertiaTimeline = new Timeline();
    private DoubleProperty inertiaRotationVelocity = new SimpleDoubleProperty();
    private double initialInertiaRotationVelocity = 0.0;
    private double rotationStartTime = 0.0;
    private double lastTouchEventTime = 0.0;
    Map<Long, TouchPointTracker> trackers = new HashMap<Long, TouchPointTracker>();
    int modifiers;
    boolean direct;
    private int currentTouchCount = 0;
    private boolean touchPointsSetChanged;
    private boolean touchPointsPressed;
    int touchPointsInEvent;
    long touchPointID1 = -1L;
    long touchPointID2 = -1L;
    double centerX;
    double centerY;
    double centerAbsX;
    double centerAbsY;
    double currentRotation;
    double angleReference;
    double totalRotation = 0.0;
    double inertiaLastTime = 0.0;

    RotateGestureRecognizer(ViewScene scene) {
        this.scene = scene;
        this.inertiaRotationVelocity.addListener(RotateGestureRecognizer$$Lambda$1.lambdaFactory$(this));
    }

    @Override
    public void notifyBeginTouchEvent(long time, int modifiers, boolean isDirect, int touchEventCount) {
        this.params(modifiers, isDirect);
        this.touchPointsSetChanged = false;
        this.touchPointsPressed = false;
        this.touchPointsInEvent = 0;
    }

    @Override
    public void notifyNextTouchEvent(long time, int type, long touchId, int x, int y, int xAbs, int yAbs) {
        ++this.touchPointsInEvent;
        switch (type) {
            case 811: {
                this.touchPointsSetChanged = true;
                this.touchPointsPressed = true;
                this.touchPressed(touchId, time, x, y, xAbs, yAbs);
                break;
            }
            case 814: {
                break;
            }
            case 812: {
                this.touchMoved(touchId, time, x, y, xAbs, yAbs);
                break;
            }
            case 813: {
                this.touchPointsSetChanged = true;
                this.touchReleased(touchId, time, x, y, xAbs, yAbs);
                break;
            }
            default: {
                throw new RuntimeException("Error in Rotate gesture recognition: unknown touch state: " + (Object)((Object)this.state));
            }
        }
    }

    private void calculateCenter() {
        if (this.currentTouchCount <= 0) {
            throw new RuntimeException("Error in Rotate gesture recognition: touch count is zero!");
        }
        double totalX = 0.0;
        double totalY = 0.0;
        double totalAbsX = 0.0;
        double totalAbsY = 0.0;
        for (TouchPointTracker tracker : this.trackers.values()) {
            totalX += tracker.getX();
            totalY += tracker.getY();
            totalAbsX += tracker.getAbsX();
            totalAbsY += tracker.getAbsY();
        }
        this.centerX = totalX / (double)this.currentTouchCount;
        this.centerY = totalY / (double)this.currentTouchCount;
        this.centerAbsX = totalAbsX / (double)this.currentTouchCount;
        this.centerAbsY = totalAbsY / (double)this.currentTouchCount;
    }

    private double getAngle(TouchPointTracker tp1, TouchPointTracker tp2) {
        double dx = tp2.getAbsX() - tp1.getAbsX();
        double dy = -(tp2.getAbsY() - tp1.getAbsY());
        double newAngle = Math.toDegrees(Math.atan2(dy, dx));
        return newAngle;
    }

    private double getNormalizedDelta(double oldAngle, double newAngle) {
        double delta = -(newAngle - oldAngle);
        if (delta > 180.0) {
            delta -= 360.0;
        } else if (delta < -180.0) {
            delta += 360.0;
        }
        return delta;
    }

    private void assignActiveTouchpoints() {
        boolean needToReassign = false;
        if (!this.trackers.containsKey(this.touchPointID1)) {
            this.touchPointID1 = -1L;
            needToReassign = true;
        }
        if (!this.trackers.containsKey(this.touchPointID2)) {
            this.touchPointID2 = -1L;
            needToReassign = true;
        }
        if (needToReassign) {
            for (Long id : this.trackers.keySet()) {
                if (id == this.touchPointID1 || id == this.touchPointID2) continue;
                if (this.touchPointID1 == -1L) {
                    this.touchPointID1 = id;
                    continue;
                }
                if (this.touchPointID2 != -1L) break;
                this.touchPointID2 = id;
            }
        }
    }

    @Override
    public void notifyEndTouchEvent(long time) {
        this.lastTouchEventTime = time;
        if (this.currentTouchCount != this.trackers.size()) {
            throw new RuntimeException("Error in Rotate gesture recognition: touch count is wrong: " + this.currentTouchCount);
        }
        if (this.currentTouchCount == 0) {
            if (this.state == RotateRecognitionState.ACTIVE) {
                this.sendRotateFinishedEvent();
            }
            if (ROTATION_INERTIA_ENABLED && (this.state == RotateRecognitionState.PRE_INERTIA || this.state == RotateRecognitionState.ACTIVE)) {
                double timeFromLastRotation = ((double)time - this.rotationStartTime) / 1000000.0;
                if (timeFromLastRotation < 300.0) {
                    this.state = RotateRecognitionState.INERTIA;
                    this.inertiaLastTime = 0.0;
                    if (this.initialInertiaRotationVelocity > MAX_INITIAL_VELOCITY) {
                        this.initialInertiaRotationVelocity = MAX_INITIAL_VELOCITY;
                    } else if (this.initialInertiaRotationVelocity < -MAX_INITIAL_VELOCITY) {
                        this.initialInertiaRotationVelocity = -MAX_INITIAL_VELOCITY;
                    }
                    this.inertiaTimeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.millis(0.0), new KeyValue(this.inertiaRotationVelocity, this.initialInertiaRotationVelocity, Interpolator.LINEAR)), new KeyFrame(Duration.millis(ROTATION_INERTIA_MILLIS * Math.abs(this.initialInertiaRotationVelocity) / MAX_INITIAL_VELOCITY), RotateGestureRecognizer$$Lambda$2.lambdaFactory$(this), new KeyValue(this.inertiaRotationVelocity, 0, Interpolator.LINEAR))});
                    this.inertiaTimeline.playFromStart();
                } else {
                    this.reset();
                }
            }
        } else {
            if (this.touchPointsPressed && this.state == RotateRecognitionState.INERTIA) {
                this.inertiaTimeline.stop();
                this.reset();
            }
            if (this.currentTouchCount == 1) {
                if (this.state == RotateRecognitionState.ACTIVE) {
                    this.sendRotateFinishedEvent();
                    if (ROTATION_INERTIA_ENABLED) {
                        this.state = RotateRecognitionState.PRE_INERTIA;
                    } else {
                        this.reset();
                    }
                }
            } else {
                if (this.state == RotateRecognitionState.IDLE) {
                    this.state = RotateRecognitionState.TRACKING;
                    this.assignActiveTouchpoints();
                }
                this.calculateCenter();
                if (this.touchPointsSetChanged) {
                    this.assignActiveTouchpoints();
                }
                TouchPointTracker tp1 = this.trackers.get(this.touchPointID1);
                TouchPointTracker tp2 = this.trackers.get(this.touchPointID2);
                double newAngle = this.getAngle(tp1, tp2);
                if (this.touchPointsSetChanged) {
                    this.angleReference = newAngle;
                } else {
                    this.currentRotation = this.getNormalizedDelta(this.angleReference, newAngle);
                    if (this.state == RotateRecognitionState.TRACKING && Math.abs(this.currentRotation) > ROTATATION_THRESHOLD) {
                        this.state = RotateRecognitionState.ACTIVE;
                        this.sendRotateStartedEvent();
                    }
                    if (this.state == RotateRecognitionState.ACTIVE) {
                        this.totalRotation += this.currentRotation;
                        this.sendRotateEvent(false);
                        this.angleReference = newAngle;
                        double timePassed = ((double)time - this.rotationStartTime) / 1.0E9;
                        if (timePassed > 1.0E-4) {
                            this.initialInertiaRotationVelocity = this.currentRotation / timePassed;
                            this.rotationStartTime = time;
                        }
                    }
                }
            }
        }
    }

    private void sendRotateStartedEvent() {
        AccessController.doPrivileged(RotateGestureRecognizer$$Lambda$3.lambdaFactory$(this), this.scene.getAccessControlContext());
    }

    private void sendRotateEvent(boolean isInertia) {
        AccessController.doPrivileged(RotateGestureRecognizer$$Lambda$4.lambdaFactory$(this, isInertia), this.scene.getAccessControlContext());
    }

    private void sendRotateFinishedEvent() {
        AccessController.doPrivileged(RotateGestureRecognizer$$Lambda$5.lambdaFactory$(this), this.scene.getAccessControlContext());
    }

    public void params(int modifiers, boolean direct) {
        this.modifiers = modifiers;
        this.direct = direct;
    }

    public void touchPressed(long id, long nanos, int x, int y, int xAbs, int yAbs) {
        ++this.currentTouchCount;
        TouchPointTracker tracker = new TouchPointTracker();
        tracker.update(nanos, x, y, xAbs, yAbs);
        this.trackers.put(id, tracker);
    }

    public void touchReleased(long id, long nanos, int x, int y, int xAbs, int yAbs) {
        if (this.state != RotateRecognitionState.FAILURE) {
            TouchPointTracker tracker = this.trackers.get(id);
            if (tracker == null) {
                this.state = RotateRecognitionState.FAILURE;
                throw new RuntimeException("Error in Rotate gesture recognition: released unknown touch point");
            }
            this.trackers.remove(id);
        }
        --this.currentTouchCount;
    }

    public void touchMoved(long id, long nanos, int x, int y, int xAbs, int yAbs) {
        if (this.state == RotateRecognitionState.FAILURE) {
            return;
        }
        TouchPointTracker tracker = this.trackers.get(id);
        if (tracker == null) {
            this.state = RotateRecognitionState.FAILURE;
            throw new RuntimeException("Error in rotate gesture recognition: reported unknown touch point");
        }
        tracker.update(nanos, x, y, xAbs, yAbs);
    }

    void reset() {
        this.state = RotateRecognitionState.IDLE;
        this.touchPointID1 = -1L;
        this.touchPointID2 = -1L;
        this.currentRotation = 0.0;
        this.totalRotation = 0.0;
    }

    /* synthetic */ Void lambda$sendRotateFinishedEvent$418() {
        if (this.scene.sceneListener != null) {
            this.scene.sceneListener.rotateEvent(RotateEvent.ROTATION_FINISHED, 0.0, this.totalRotation, this.centerX, this.centerY, this.centerAbsX, this.centerAbsY, (this.modifiers & 1) != 0, (this.modifiers & 4) != 0, (this.modifiers & 8) != 0, (this.modifiers & 0x10) != 0, this.direct, false);
        }
        return null;
    }

    /* synthetic */ Void lambda$sendRotateEvent$417(boolean bl) {
        if (this.scene.sceneListener != null) {
            this.scene.sceneListener.rotateEvent(RotateEvent.ROTATE, this.currentRotation, this.totalRotation, this.centerX, this.centerY, this.centerAbsX, this.centerAbsY, (this.modifiers & 1) != 0, (this.modifiers & 4) != 0, (this.modifiers & 8) != 0, (this.modifiers & 0x10) != 0, this.direct, bl);
        }
        return null;
    }

    /* synthetic */ Void lambda$sendRotateStartedEvent$416() {
        if (this.scene.sceneListener != null) {
            this.scene.sceneListener.rotateEvent(RotateEvent.ROTATION_STARTED, 0.0, 0.0, this.centerX, this.centerY, this.centerAbsX, this.centerAbsY, (this.modifiers & 1) != 0, (this.modifiers & 4) != 0, (this.modifiers & 8) != 0, (this.modifiers & 0x10) != 0, this.direct, false);
        }
        return null;
    }

    /* synthetic */ void lambda$notifyEndTouchEvent$415(ActionEvent event) {
        this.reset();
    }

    /* synthetic */ void lambda$new$414(Observable valueModel) {
        double currentTime = this.inertiaTimeline.getCurrentTime().toSeconds();
        double timePassed = currentTime - this.inertiaLastTime;
        this.inertiaLastTime = currentTime;
        this.currentRotation = timePassed * this.inertiaRotationVelocity.get();
        this.totalRotation += this.currentRotation;
        this.sendRotateEvent(true);
    }

    static /* synthetic */ Void lambda$static$413() {
        String s = System.getProperty("com.sun.javafx.gestures.rotate.threshold");
        if (s != null) {
            ROTATATION_THRESHOLD = Double.valueOf(s);
        }
        if ((s = System.getProperty("com.sun.javafx.gestures.rotate.inertia")) != null) {
            ROTATION_INERTIA_ENABLED = Boolean.valueOf(s);
        }
        return null;
    }

    static {
        AccessController.doPrivileged(RotateGestureRecognizer$$Lambda$6.lambdaFactory$());
    }

    private static enum RotateRecognitionState {
        IDLE,
        TRACKING,
        ACTIVE,
        PRE_INERTIA,
        INERTIA,
        FAILURE;

    }

    private static class TouchPointTracker {
        double x;
        double y;
        double absX;
        double absY;

        private TouchPointTracker() {
        }

        public void update(long nanos, double x, double y, double absX, double absY) {
            this.x = x;
            this.y = y;
            this.absX = absX;
            this.absY = absY;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getAbsX() {
            return this.absX;
        }

        public double getAbsY() {
            return this.absY;
        }
    }
}

