/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.es2.GLPixelFormat$$Lambda$1;
import java.security.AccessController;

class GLPixelFormat {
    private final Attributes attributes;
    private final long nativeScreen;
    private long nativePFInfo;
    private static int defaultDepthSize;
    private static int defaultBufferSize;

    GLPixelFormat(long nativeScreen, Attributes attributes) {
        this.nativeScreen = nativeScreen;
        this.attributes = attributes;
    }

    Attributes getAttributes() {
        return this.attributes;
    }

    long getNativeScreen() {
        return this.nativeScreen;
    }

    void setNativePFInfo(long nativePFInfo) {
        this.nativePFInfo = nativePFInfo;
    }

    long getNativePFInfo() {
        return this.nativePFInfo;
    }

    static /* synthetic */ Void lambda$static$443() {
        defaultDepthSize = Integer.getInteger("prism.glDepthSize", 24);
        defaultBufferSize = Integer.getInteger("prism.glBufferSize", 32);
        return null;
    }

    static /* synthetic */ int access$000() {
        return defaultDepthSize;
    }

    static {
        AccessController.doPrivileged(GLPixelFormat$$Lambda$1.lambdaFactory$());
    }

    static class Attributes {
        static final int RED_SIZE = 0;
        static final int GREEN_SIZE = 1;
        static final int BLUE_SIZE = 2;
        static final int ALPHA_SIZE = 3;
        static final int DEPTH_SIZE = 4;
        static final int DOUBLEBUFFER = 5;
        static final int ONSCREEN = 6;
        static final int NUM_ITEMS = 7;
        private boolean onScreen = true;
        private boolean doubleBuffer = true;
        private int alphaSize;
        private int blueSize;
        private int greenSize;
        private int redSize;
        private int depthSize = GLPixelFormat.access$000();

        Attributes() {
            switch (defaultBufferSize) {
                case 32: {
                    this.alphaSize = 8;
                    this.blueSize = 8;
                    this.greenSize = 8;
                    this.redSize = 8;
                    break;
                }
                case 24: {
                    this.blueSize = 8;
                    this.greenSize = 8;
                    this.redSize = 8;
                    this.alphaSize = 0;
                    break;
                }
                case 16: {
                    this.blueSize = 5;
                    this.redSize = 5;
                    this.greenSize = 6;
                    this.alphaSize = 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("color buffer size " + defaultBufferSize + " not supported");
                }
            }
        }

        boolean isOnScreen() {
            return this.onScreen;
        }

        boolean isDoubleBuffer() {
            return this.doubleBuffer;
        }

        int getDepthSize() {
            return this.depthSize;
        }

        int getAlphaSize() {
            return this.alphaSize;
        }

        int getBlueSize() {
            return this.blueSize;
        }

        int getGreenSize() {
            return this.greenSize;
        }

        int getRedSize() {
            return this.redSize;
        }

        void setOnScreen(boolean os) {
            this.onScreen = os;
        }

        void setDoubleBuffer(boolean db) {
            this.doubleBuffer = db;
        }

        void setDepthSize(int ds) {
            this.depthSize = ds;
        }

        void setAlphaSize(int as) {
            this.alphaSize = as;
        }

        void setBlueSize(int bs) {
            this.blueSize = bs;
        }

        void setGreenSize(int gs) {
            this.greenSize = gs;
        }

        void setRedSize(int rs) {
            this.redSize = rs;
        }

        public String toString() {
            return "onScreen: " + this.onScreen + "redSize : " + this.redSize + ", " + "greenSize : " + this.greenSize + ", " + "blueSize : " + this.blueSize + ", " + "alphaSize : " + this.alphaSize + ", " + "depthSize : " + this.depthSize + ", " + "doubleBuffer : " + this.doubleBuffer;
        }
    }
}

