/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.geom.transform.AffineBase;
import com.sun.prism.paint.Color;
import java.util.Arrays;

public class VertexBuffer {
    protected static final int VERTS_PER_QUAD = 4;
    protected static final int FLOATS_PER_TC = 2;
    protected static final int FLOATS_PER_VC = 3;
    protected static final int FLOATS_PER_VERT = 7;
    protected static final int BYTES_PER_VERT = 4;
    protected static final int VCOFF = 0;
    protected static final int TC1OFF = 3;
    protected static final int TC2OFF = 5;
    protected int capacity;
    protected int index;
    protected byte r;
    protected byte g;
    protected byte b;
    protected byte a;
    protected byte[] colorArray;
    protected float[] coordArray;

    public VertexBuffer(int maxQuads) {
        this.capacity = maxQuads * 4;
        this.index = 0;
        this.colorArray = new byte[this.capacity * 4];
        this.coordArray = new float[this.capacity * 7];
    }

    protected void drawQuads(int numVertices) {
        throw new Error("flush not implemented for lightweight");
    }

    protected void drawTriangles(int numTriangles, float[] fData, byte[] cData) {
        throw new Error("flush not implemented for lightweight");
    }

    public final void setPerVertexColor(Color c, float extraAlpha) {
        float ca = c.getAlpha() * extraAlpha;
        this.r = (byte)(c.getRed() * ca * 255.0f);
        this.g = (byte)(c.getGreen() * ca * 255.0f);
        this.b = (byte)(c.getBlue() * ca * 255.0f);
        this.a = (byte)(ca * 255.0f);
    }

    public final void setPerVertexColor(float extraAlpha) {
        this.b = this.a = (byte)(extraAlpha * 255.0f);
        this.g = this.a;
        this.r = this.a;
    }

    public final void updateVertexColors(int numVerts) {
        for (int i = 0; i != numVerts; ++i) {
            this.putColor(i);
        }
    }

    private void putColor(int idx) {
        int i = idx * 4;
        this.colorArray[i + 0] = this.r;
        this.colorArray[i + 1] = this.g;
        this.colorArray[i + 2] = this.b;
        this.colorArray[i + 3] = this.a;
    }

    public final void flush() {
        if (this.index > 0) {
            this.drawQuads(this.index);
            this.index = 0;
        }
    }

    public final void rewind() {
        this.index = 0;
    }

    private void grow() {
        this.capacity *= 2;
        this.colorArray = Arrays.copyOf(this.colorArray, this.capacity * 4);
        this.coordArray = Arrays.copyOf(this.coordArray, this.capacity * 7);
    }

    public final void addVert(float x, float y) {
        if (this.index == this.capacity) {
            this.grow();
        }
        int i = 7 * this.index;
        this.coordArray[i + 0] = x;
        this.coordArray[i + 1] = y;
        this.coordArray[i + 2] = 0.0f;
        this.putColor(this.index);
        ++this.index;
    }

    public final void addVert(float x, float y, float tx, float ty) {
        if (this.index == this.capacity) {
            this.grow();
        }
        int i = 7 * this.index;
        this.coordArray[i + 0] = x;
        this.coordArray[i + 1] = y;
        this.coordArray[i + 2] = 0.0f;
        this.coordArray[i + 3] = tx;
        this.coordArray[i + 4] = ty;
        this.putColor(this.index);
        ++this.index;
    }

    public final void addVert(float x, float y, float t0x, float t0y, float t1x, float t1y) {
        if (this.index == this.capacity) {
            this.grow();
        }
        int i = 7 * this.index;
        this.coordArray[i + 0] = x;
        this.coordArray[i + 1] = y;
        this.coordArray[i + 2] = 0.0f;
        this.coordArray[i + 3] = t0x;
        this.coordArray[i + 4] = t0y;
        this.coordArray[i + 5] = t1x;
        this.coordArray[i + 6] = t1y;
        this.putColor(this.index);
        ++this.index;
    }

    private void addVertNoCheck(float x, float y) {
        int i = 7 * this.index;
        this.coordArray[i + 0] = x;
        this.coordArray[i + 1] = y;
        this.coordArray[i + 2] = 0.0f;
        this.putColor(this.index);
        ++this.index;
    }

    private void addVertNoCheck(float x, float y, float tx, float ty) {
        int i = 7 * this.index;
        this.coordArray[i + 0] = x;
        this.coordArray[i + 1] = y;
        this.coordArray[i + 2] = 0.0f;
        this.coordArray[i + 3] = tx;
        this.coordArray[i + 4] = ty;
        this.putColor(this.index);
        ++this.index;
    }

    private void addVertNoCheck(float x, float y, float t0x, float t0y, float t1x, float t1y) {
        int i = 7 * this.index;
        this.coordArray[i + 0] = x;
        this.coordArray[i + 1] = y;
        this.coordArray[i + 2] = 0.0f;
        this.coordArray[i + 3] = t0x;
        this.coordArray[i + 4] = t0y;
        this.coordArray[i + 5] = t1x;
        this.coordArray[i + 6] = t1y;
        this.putColor(this.index);
        ++this.index;
    }

    public final void addVerts(VertexBuffer vb, int numVerts) {
        this.flush();
        this.drawTriangles(numVerts / 3, vb.coordArray, vb.colorArray);
    }

    private void ensureCapacityForQuad() {
        if (this.index + 4 > this.capacity) {
            this.drawQuads(this.index);
            this.index = 0;
        }
    }

    public final void addQuad(float dx1, float dy1, float dx2, float dy2) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(dx1, dy1);
        this.addVertNoCheck(dx1, dy2);
        this.addVertNoCheck(dx2, dy1);
        this.addVertNoCheck(dx2, dy2);
    }

    public final void addQuad(float dx1, float dy1, float dx2, float dy2, float t1x1, float t1y1, float t1x2, float t1y2, float t2x1, float t2y1, float t2x2, float t2y2) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(dx1, dy1, t1x1, t1y1, t2x1, t2y1);
        this.addVertNoCheck(dx1, dy2, t1x1, t1y2, t2x1, t2y2);
        this.addVertNoCheck(dx2, dy1, t1x2, t1y1, t2x2, t2y1);
        this.addVertNoCheck(dx2, dy2, t1x2, t1y2, t2x2, t2y2);
    }

    public final void addMappedQuad(float dx1, float dy1, float dx2, float dy2, float tx11, float ty11, float tx21, float ty21, float tx12, float ty12, float tx22, float ty22) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(dx1, dy1, tx11, ty11);
        this.addVertNoCheck(dx1, dy2, tx12, ty12);
        this.addVertNoCheck(dx2, dy1, tx21, ty21);
        this.addVertNoCheck(dx2, dy2, tx22, ty22);
    }

    public final void addMappedQuad(float dx1, float dy1, float dx2, float dy2, float ux11, float uy11, float ux21, float uy21, float ux12, float uy12, float ux22, float uy22, float vx11, float vy11, float vx21, float vy21, float vx12, float vy12, float vx22, float vy22) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(dx1, dy1, ux11, uy11, vx11, vy11);
        this.addVertNoCheck(dx1, dy2, ux12, uy12, vx12, vy12);
        this.addVertNoCheck(dx2, dy1, ux21, uy21, vx21, vy21);
        this.addVertNoCheck(dx2, dy2, ux22, uy22, vx22, vy22);
    }

    public final void addQuad(float dx1, float dy1, float dx2, float dy2, float tx1, float ty1, float tx2, float ty2, AffineBase tx) {
        this.addQuad(dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2);
        if (tx != null) {
            int i = 7 * this.index - 7;
            tx.transform(this.coordArray, i + 0, this.coordArray, i + 5, 1);
            tx.transform(this.coordArray, (i -= 7) + 0, this.coordArray, i + 5, 1);
            tx.transform(this.coordArray, (i -= 7) + 0, this.coordArray, i + 5, 1);
            tx.transform(this.coordArray, (i -= 7) + 0, this.coordArray, i + 5, 1);
        }
    }

    public final void addSuperQuad(float dx1, float dy1, float dx2, float dy2, float tx1, float ty1, float tx2, float ty2, boolean isText) {
        int idx = this.index;
        if (idx + 4 > this.capacity) {
            this.drawQuads(idx);
            this.index = 0;
            idx = 0;
        }
        int i = 7 * idx;
        float[] farr = this.coordArray;
        float text = isText ? 1.0f : 0.0f;
        float image = isText ? 0.0f : 1.0f;
        farr[i] = dx1;
        farr[++i] = dy1;
        farr[++i] = 0.0f;
        farr[++i] = tx1;
        farr[++i] = ty1;
        farr[++i] = image;
        farr[++i] = text;
        farr[++i] = dx1;
        farr[++i] = dy2;
        farr[++i] = 0.0f;
        farr[++i] = tx1;
        farr[++i] = ty2;
        farr[++i] = image;
        farr[++i] = text;
        farr[++i] = dx2;
        farr[++i] = dy1;
        farr[++i] = 0.0f;
        farr[++i] = tx2;
        farr[++i] = ty1;
        farr[++i] = image;
        farr[++i] = text;
        farr[++i] = dx2;
        farr[++i] = dy2;
        farr[++i] = 0.0f;
        farr[++i] = tx2;
        farr[++i] = ty2;
        farr[++i] = image;
        farr[++i] = text;
        ++i;
        byte[] barr = this.colorArray;
        byte r = this.r;
        byte g = this.g;
        byte b = this.b;
        byte a = this.a;
        int j = 4 * idx;
        barr[j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        barr[++j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        barr[++j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        barr[++j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        this.index = idx + 4;
    }

    public final void addQuad(float dx1, float dy1, float dx2, float dy2, float tx1, float ty1, float tx2, float ty2) {
        int idx = this.index;
        if (idx + 4 > this.capacity) {
            this.drawQuads(idx);
            this.index = 0;
            idx = 0;
        }
        int i = 7 * idx;
        float[] farr = this.coordArray;
        farr[i] = dx1;
        farr[++i] = dy1;
        farr[++i] = 0.0f;
        farr[++i] = tx1;
        farr[++i] = ty1;
        farr[i += 3] = dx1;
        farr[++i] = dy2;
        farr[++i] = 0.0f;
        farr[++i] = tx1;
        farr[++i] = ty2;
        farr[i += 3] = dx2;
        farr[++i] = dy1;
        farr[++i] = 0.0f;
        farr[++i] = tx2;
        farr[++i] = ty1;
        farr[i += 3] = dx2;
        farr[++i] = dy2;
        farr[++i] = 0.0f;
        farr[++i] = tx2;
        farr[++i] = ty2;
        byte[] barr = this.colorArray;
        byte r = this.r;
        byte g = this.g;
        byte b = this.b;
        byte a = this.a;
        int j = 4 * idx;
        barr[j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        barr[++j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        barr[++j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        barr[++j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        this.index = idx + 4;
    }

    public final void addQuadVO(float topopacity, float botopacity, float dx1, float dy1, float dx2, float dy2, float tx1, float ty1, float tx2, float ty2) {
        int idx = this.index;
        if (idx + 4 > this.capacity) {
            this.drawQuads(idx);
            this.index = 0;
            idx = 0;
        }
        int i = 7 * idx;
        float[] farr = this.coordArray;
        farr[i] = dx1;
        farr[++i] = dy1;
        farr[++i] = 0.0f;
        farr[++i] = tx1;
        farr[++i] = ty1;
        farr[i += 3] = dx1;
        farr[++i] = dy2;
        farr[++i] = 0.0f;
        farr[++i] = tx1;
        farr[++i] = ty2;
        farr[i += 3] = dx2;
        farr[++i] = dy1;
        farr[++i] = 0.0f;
        farr[++i] = tx2;
        farr[++i] = ty1;
        farr[i += 3] = dx2;
        farr[++i] = dy2;
        farr[++i] = 0.0f;
        farr[++i] = tx2;
        farr[++i] = ty2;
        byte[] barr = this.colorArray;
        int j = 4 * idx;
        byte to = (byte)(topopacity * 255.0f);
        byte bo = (byte)(botopacity * 255.0f);
        barr[j] = to;
        barr[++j] = to;
        barr[++j] = to;
        barr[++j] = to;
        barr[++j] = bo;
        barr[++j] = bo;
        barr[++j] = bo;
        barr[++j] = bo;
        barr[++j] = to;
        barr[++j] = to;
        barr[++j] = to;
        barr[++j] = to;
        barr[++j] = bo;
        barr[++j] = bo;
        barr[++j] = bo;
        barr[++j] = bo;
        this.index = idx + 4;
    }

    public final void addMappedPgram(float dx11, float dy11, float dx21, float dy21, float dx12, float dy12, float dx22, float dy22, float ux11, float uy11, float ux21, float uy21, float ux12, float uy12, float ux22, float uy22, float vx11, float vy11, float vx22, float vy22, AffineBase tx) {
        this.addMappedPgram(dx11, dy11, dx21, dy21, dx12, dy12, dx22, dy22, ux11, uy11, ux21, uy21, ux12, uy12, ux22, uy22, vx11, vy11, vx22, vy11, vx11, vy22, vx22, vy22);
        int i = 7 * this.index - 7;
        tx.transform(this.coordArray, i + 5, this.coordArray, i + 5, 1);
        tx.transform(this.coordArray, (i -= 7) + 5, this.coordArray, i + 5, 1);
        tx.transform(this.coordArray, (i -= 7) + 5, this.coordArray, i + 5, 1);
        tx.transform(this.coordArray, (i -= 7) + 5, this.coordArray, i + 5, 1);
    }

    public final void addMappedPgram(float dx11, float dy11, float dx21, float dy21, float dx12, float dy12, float dx22, float dy22, float ux11, float uy11, float ux21, float uy21, float ux12, float uy12, float ux22, float uy22, float vx, float vy) {
        int idx = this.index;
        if (idx + 4 > this.capacity) {
            this.drawQuads(idx);
            this.index = 0;
            idx = 0;
        }
        int i = 7 * idx;
        float[] farr = this.coordArray;
        farr[i] = dx11;
        farr[++i] = dy11;
        farr[++i] = 0.0f;
        farr[++i] = ux11;
        farr[++i] = uy11;
        farr[++i] = vx;
        farr[++i] = vy;
        farr[++i] = dx12;
        farr[++i] = dy12;
        farr[++i] = 0.0f;
        farr[++i] = ux12;
        farr[++i] = uy12;
        farr[++i] = vx;
        farr[++i] = vy;
        farr[++i] = dx21;
        farr[++i] = dy21;
        farr[++i] = 0.0f;
        farr[++i] = ux21;
        farr[++i] = uy21;
        farr[++i] = vx;
        farr[++i] = vy;
        farr[++i] = dx22;
        farr[++i] = dy22;
        farr[++i] = 0.0f;
        farr[++i] = ux22;
        farr[++i] = uy22;
        farr[++i] = vx;
        farr[++i] = vy;
        byte[] barr = this.colorArray;
        byte r = this.r;
        byte g = this.g;
        byte b = this.b;
        byte a = this.a;
        int j = 4 * idx;
        barr[j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        barr[++j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        barr[++j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        barr[++j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        this.index = idx + 4;
    }

    public final void addMappedPgram(float dx11, float dy11, float dx21, float dy21, float dx12, float dy12, float dx22, float dy22, float ux11, float uy11, float ux21, float uy21, float ux12, float uy12, float ux22, float uy22, float vx11, float vy11, float vx21, float vy21, float vx12, float vy12, float vx22, float vy22) {
        int idx = this.index;
        if (idx + 4 > this.capacity) {
            this.drawQuads(idx);
            this.index = 0;
            idx = 0;
        }
        int i = 7 * idx;
        float[] farr = this.coordArray;
        farr[i] = dx11;
        farr[++i] = dy11;
        farr[++i] = 0.0f;
        farr[++i] = ux11;
        farr[++i] = uy11;
        farr[++i] = vx11;
        farr[++i] = vy11;
        farr[++i] = dx12;
        farr[++i] = dy12;
        farr[++i] = 0.0f;
        farr[++i] = ux12;
        farr[++i] = uy12;
        farr[++i] = vx12;
        farr[++i] = vy12;
        farr[++i] = dx21;
        farr[++i] = dy21;
        farr[++i] = 0.0f;
        farr[++i] = ux21;
        farr[++i] = uy21;
        farr[++i] = vx21;
        farr[++i] = vy21;
        farr[++i] = dx22;
        farr[++i] = dy22;
        farr[++i] = 0.0f;
        farr[++i] = ux22;
        farr[++i] = uy22;
        farr[++i] = vx22;
        farr[++i] = vy22;
        byte[] barr = this.colorArray;
        byte r = this.r;
        byte g = this.g;
        byte b = this.b;
        byte a = this.a;
        int j = 4 * idx;
        barr[j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        barr[++j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        barr[++j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        barr[++j] = r;
        barr[++j] = g;
        barr[++j] = b;
        barr[++j] = a;
        this.index = idx + 4;
    }
}

