/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.light;

import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.light.Light;

public class PointLight
extends Light {
    private float x;
    private float y;
    private float z;

    public PointLight() {
        this(0.0f, 0.0f, 0.0f, Color4f.WHITE);
    }

    public PointLight(float x, float y, float z, Color4f color) {
        this(Light.Type.POINT, x, y, z, color);
    }

    PointLight(Light.Type type, float x, float y, float z, Color4f color) {
        super(type, color);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float z) {
        this.z = z;
    }

    @Override
    public float[] getNormalizedLightPosition() {
        float len = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (len == 0.0f) {
            len = 1.0f;
        }
        float[] pos = new float[]{this.x / len, this.y / len, this.z / len};
        return pos;
    }
}

