/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.SetExpressionHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlySetProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;

public class ReadOnlySetWrapper<E>
extends SimpleSetProperty<E> {
    private ReadOnlyPropertyImpl readOnlyProperty;

    public ReadOnlySetWrapper() {
    }

    public ReadOnlySetWrapper(ObservableSet<E> initialValue) {
        super(initialValue);
    }

    public ReadOnlySetWrapper(Object bean, String name) {
        super(bean, name);
    }

    public ReadOnlySetWrapper(Object bean, String name, ObservableSet<E> initialValue) {
        super(bean, name, initialValue);
    }

    public ReadOnlySetProperty<E> getReadOnlyProperty() {
        if (this.readOnlyProperty == null) {
            this.readOnlyProperty = new ReadOnlyPropertyImpl();
        }
        return this.readOnlyProperty;
    }

    @Override
    public void addListener(InvalidationListener listener) {
        this.getReadOnlyProperty().addListener(listener);
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(listener);
        }
    }

    @Override
    public void addListener(ChangeListener<? super ObservableSet<E>> listener) {
        this.getReadOnlyProperty().addListener(listener);
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableSet<E>> listener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(listener);
        }
    }

    @Override
    public void addListener(SetChangeListener<? super E> listener) {
        this.getReadOnlyProperty().addListener(listener);
    }

    @Override
    public void removeListener(SetChangeListener<? super E> listener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(listener);
        }
    }

    @Override
    protected void fireValueChangedEvent() {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent();
        }
    }

    @Override
    protected void fireValueChangedEvent(SetChangeListener.Change<? extends E> change) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent(change);
        }
    }

    private class ReadOnlyPropertyImpl
    extends ReadOnlySetProperty<E> {
        private SetExpressionHelper<E> helper = null;

        private ReadOnlyPropertyImpl() {
        }

        @Override
        public ObservableSet<E> get() {
            return ReadOnlySetWrapper.this.get();
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.helper = SetExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.helper = SetExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(ChangeListener<? super ObservableSet<E>> listener) {
            this.helper = SetExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(ChangeListener<? super ObservableSet<E>> listener) {
            this.helper = SetExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(SetChangeListener<? super E> listener) {
            this.helper = SetExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(SetChangeListener<? super E> listener) {
            this.helper = SetExpressionHelper.removeListener(this.helper, listener);
        }

        private void fireValueChangedEvent() {
            SetExpressionHelper.fireValueChangedEvent(this.helper);
        }

        private void fireValueChangedEvent(SetChangeListener.Change<? extends E> change) {
            SetExpressionHelper.fireValueChangedEvent(this.helper, change);
        }

        @Override
        public Object getBean() {
            return ReadOnlySetWrapper.this.getBean();
        }

        @Override
        public String getName() {
            return ReadOnlySetWrapper.this.getName();
        }

        @Override
        public ReadOnlyIntegerProperty sizeProperty() {
            return ReadOnlySetWrapper.this.sizeProperty();
        }

        @Override
        public ReadOnlyBooleanProperty emptyProperty() {
            return ReadOnlySetWrapper.this.emptyProperty();
        }
    }
}

