/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.DoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.StackedBarChart$$Lambda$1;
import javafx.scene.chart.StackedBarChart$$Lambda$2;
import javafx.scene.chart.StackedBarChart$$Lambda$3;
import javafx.scene.chart.StackedBarChart$$Lambda$4;
import javafx.scene.chart.StackedBarChart$$Lambda$5;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class StackedBarChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart.Series, Map<String, List<XYChart.Data<X, Y>>>> seriesCategoryMap = new HashMap<XYChart.Series, Map<String, List<XYChart.Data<X, Y>>>>();
    private Legend legend = new Legend();
    private final Orientation orientation;
    private CategoryAxis categoryAxis;
    private ValueAxis valueAxis;
    private int seriesDefaultColorIndex = 0;
    private Map<XYChart.Series<X, Y>, String> seriesDefaultColorMap = new HashMap<XYChart.Series<X, Y>, String>();
    private ListChangeListener<String> categoriesListener = new ListChangeListener<String>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends String> c) {
            while (c.next()) {
                for (String string : c.getRemoved()) {
                    for (XYChart.Series series : StackedBarChart.this.getData()) {
                        for (XYChart.Data data : series.getData()) {
                            Orientation orientation = StackedBarChart.this.orientation;
                            StackedBarChart.this.orientation;
                            if (!string.equals(orientation == Orientation.VERTICAL ? data.getXValue() : data.getYValue())) continue;
                            boolean animatedOn = StackedBarChart.this.getAnimated();
                            StackedBarChart.this.setAnimated(false);
                            StackedBarChart.this.dataItemRemoved(data, series);
                            StackedBarChart.this.setAnimated(animatedOn);
                        }
                    }
                    StackedBarChart.this.requestChartLayout();
                }
            }
        }
    };
    private DoubleProperty categoryGap = new StyleableDoubleProperty(10.0){

        @Override
        protected void invalidated() {
            this.get();
            StackedBarChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return StackedBarChart.this;
        }

        @Override
        public String getName() {
            return "categoryGap";
        }

        @Override
        public CssMetaData<StackedBarChart<?, ?>, Number> getCssMetaData() {
            return StyleableProperties.CATEGORY_GAP;
        }
    };
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("horizontal");

    public double getCategoryGap() {
        return this.categoryGap.getValue();
    }

    public void setCategoryGap(double value) {
        this.categoryGap.setValue(value);
    }

    public DoubleProperty categoryGapProperty() {
        return this.categoryGap;
    }

    public StackedBarChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis) {
        this(xAxis, yAxis, FXCollections.observableArrayList());
    }

    public StackedBarChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis, @NamedArg(value="data") ObservableList<XYChart.Series<X, Y>> data) {
        super(xAxis, yAxis);
        this.getStyleClass().add("stacked-bar-chart");
        this.setLegend(this.legend);
        if (!(xAxis instanceof ValueAxis && yAxis instanceof CategoryAxis || yAxis instanceof ValueAxis && xAxis instanceof CategoryAxis)) {
            throw new IllegalArgumentException("Axis type incorrect, one of X,Y should be CategoryAxis and the other NumberAxis");
        }
        if (xAxis instanceof CategoryAxis) {
            this.categoryAxis = (CategoryAxis)xAxis;
            this.valueAxis = (ValueAxis)yAxis;
            this.orientation = Orientation.VERTICAL;
        } else {
            this.categoryAxis = (CategoryAxis)yAxis;
            this.valueAxis = (ValueAxis)xAxis;
            this.orientation = Orientation.HORIZONTAL;
        }
        this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, this.orientation == Orientation.HORIZONTAL);
        this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, this.orientation == Orientation.VERTICAL);
        this.setData(data);
        this.categoryAxis.getCategories().addListener(this.categoriesListener);
    }

    public StackedBarChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis, @NamedArg(value="data") ObservableList<XYChart.Series<X, Y>> data, @NamedArg(value="categoryGap") double categoryGap) {
        this(xAxis, yAxis);
        this.setData(data);
        this.setCategoryGap(categoryGap);
    }

    @Override
    protected void dataItemAdded(XYChart.Series<X, Y> series, int itemIndex, XYChart.Data<X, Y> item) {
        String category = this.orientation == Orientation.VERTICAL ? (String)item.getXValue() : (String)item.getYValue();
        Map<String, List<XYChart.Data<X, Y>>> categoryMap = this.seriesCategoryMap.get(series);
        if (categoryMap == null) {
            categoryMap = new HashMap<String, List<XYChart.Data<X, Y>>>();
            this.seriesCategoryMap.put(series, categoryMap);
        }
        List<Object> itemList = categoryMap.get(category) != null ? categoryMap.get(category) : new ArrayList();
        itemList.add(item);
        categoryMap.put(category, itemList);
        Node bar = this.createBar(series, this.getData().indexOf(series), item, itemIndex);
        if (this.shouldAnimate()) {
            this.animateDataAdd(item, bar);
        } else {
            this.getPlotChildren().add(bar);
        }
    }

    @Override
    protected void dataItemRemoved(XYChart.Data<X, Y> item, XYChart.Series<X, Y> series) {
        Node bar = item.getNode();
        if (bar != null) {
            bar.focusTraversableProperty().unbind();
        }
        if (this.shouldAnimate()) {
            Timeline t = this.createDataRemoveTimeline(item, bar, series);
            t.setOnFinished(StackedBarChart$$Lambda$1.lambdaFactory$(this, series, item));
            t.play();
        } else {
            this.getPlotChildren().remove(bar);
            this.removeDataItemFromDisplay(series, item);
        }
    }

    @Override
    protected void dataItemChanged(XYChart.Data<X, Y> item) {
        double currentVal;
        double barVal;
        if (this.orientation == Orientation.VERTICAL) {
            barVal = ((Number)item.getYValue()).doubleValue();
            currentVal = ((Number)this.getCurrentDisplayedYValue(item)).doubleValue();
        } else {
            barVal = ((Number)item.getXValue()).doubleValue();
            currentVal = ((Number)this.getCurrentDisplayedXValue(item)).doubleValue();
        }
        if (currentVal > 0.0 && barVal < 0.0) {
            item.getNode().getStyleClass().add("negative");
        } else if (currentVal < 0.0 && barVal > 0.0) {
            item.getNode().getStyleClass().remove("negative");
        }
    }

    private void animateDataAdd(XYChart.Data<X, Y> item, Node bar) {
        if (this.orientation == Orientation.VERTICAL) {
            double barVal = ((Number)item.getYValue()).doubleValue();
            if (barVal < 0.0) {
                bar.getStyleClass().add("negative");
            }
            item.setYValue(this.getYAxis().toRealValue(this.getYAxis().getZeroPosition()));
            this.setCurrentDisplayedYValue(item, this.getYAxis().toRealValue(this.getYAxis().getZeroPosition()));
            this.getPlotChildren().add(bar);
            item.setYValue(this.getYAxis().toRealValue(barVal));
            this.animate(new Timeline(new KeyFrame(Duration.ZERO, new KeyValue(this.currentDisplayedYValueProperty(item), this.getCurrentDisplayedYValue(item))), new KeyFrame(Duration.millis(700.0), new KeyValue(this.currentDisplayedYValueProperty(item), item.getYValue(), Interpolator.EASE_BOTH))));
        } else {
            double barVal = ((Number)item.getXValue()).doubleValue();
            if (barVal < 0.0) {
                bar.getStyleClass().add("negative");
            }
            item.setXValue(this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
            this.setCurrentDisplayedXValue(item, this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
            this.getPlotChildren().add(bar);
            item.setXValue(this.getXAxis().toRealValue(barVal));
            this.animate(new Timeline(new KeyFrame(Duration.ZERO, new KeyValue(this.currentDisplayedXValueProperty(item), this.getCurrentDisplayedXValue(item))), new KeyFrame(Duration.millis(700.0), new KeyValue(this.currentDisplayedXValueProperty(item), item.getXValue(), Interpolator.EASE_BOTH))));
        }
    }

    @Override
    protected void seriesAdded(XYChart.Series<X, Y> series, int seriesIndex) {
        String defaultColorStyleClass = "default-color" + this.seriesDefaultColorIndex % 8;
        this.seriesDefaultColorMap.put(series, defaultColorStyleClass);
        ++this.seriesDefaultColorIndex;
        HashMap categoryMap = new HashMap();
        for (int j = 0; j < series.getData().size(); ++j) {
            double barVal;
            XYChart.Data item = (XYChart.Data)series.getData().get(j);
            Node bar = this.createBar(series, seriesIndex, item, j);
            String category = this.orientation == Orientation.VERTICAL ? (String)item.getXValue() : (String)item.getYValue();
            List<XYChart.Data> itemList = categoryMap.get(category) != null ? (List)categoryMap.get(category) : new ArrayList();
            itemList.add(item);
            categoryMap.put(category, itemList);
            if (this.shouldAnimate()) {
                this.animateDataAdd(item, bar);
                continue;
            }
            double d = barVal = this.orientation == Orientation.VERTICAL ? ((Number)item.getYValue()).doubleValue() : ((Number)item.getXValue()).doubleValue();
            if (barVal < 0.0) {
                bar.getStyleClass().add("negative");
            }
            this.getPlotChildren().add(bar);
        }
        if (categoryMap.size() > 0) {
            this.seriesCategoryMap.put(series, categoryMap);
        }
    }

    private Timeline createDataRemoveTimeline(XYChart.Data<X, Y> item, Node bar, XYChart.Series<X, Y> series) {
        Timeline t = new Timeline();
        if (this.orientation == Orientation.VERTICAL) {
            item.setYValue(this.getYAxis().toRealValue(this.getYAxis().getZeroPosition()));
            t.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(this.currentDisplayedYValueProperty(item), this.getCurrentDisplayedYValue(item))), new KeyFrame(Duration.millis(700.0), StackedBarChart$$Lambda$2.lambdaFactory$(this, bar), new KeyValue(this.currentDisplayedYValueProperty(item), item.getYValue(), Interpolator.EASE_BOTH))});
        } else {
            item.setXValue(this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
            t.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(this.currentDisplayedXValueProperty(item), this.getCurrentDisplayedXValue(item))), new KeyFrame(Duration.millis(700.0), StackedBarChart$$Lambda$3.lambdaFactory$(this, bar), new KeyValue(this.currentDisplayedXValueProperty(item), item.getXValue(), Interpolator.EASE_BOTH))});
        }
        return t;
    }

    @Override
    protected void seriesRemoved(XYChart.Series<X, Y> series) {
        --this.seriesDefaultColorIndex;
        if (this.shouldAnimate()) {
            ParallelTransition pt = new ParallelTransition();
            pt.setOnFinished(StackedBarChart$$Lambda$4.lambdaFactory$(this, series));
            for (XYChart.Data data : series.getData()) {
                Node bar = data.getNode();
                if (this.getSeriesSize() > 1) {
                    for (int j = 0; j < series.getData().size(); ++j) {
                        XYChart.Data item = (XYChart.Data)series.getData().get(j);
                        Timeline t = this.createDataRemoveTimeline(item, bar, series);
                        pt.getChildren().add(t);
                    }
                    continue;
                }
                FadeTransition ft = new FadeTransition(Duration.millis(700.0), bar);
                ft.setFromValue(1.0);
                ft.setToValue(0.0);
                ft.setOnFinished(StackedBarChart$$Lambda$5.lambdaFactory$(this, bar));
                pt.getChildren().add(ft);
            }
            pt.play();
        } else {
            for (XYChart.Data data : series.getData()) {
                Node node = data.getNode();
                this.getPlotChildren().remove(node);
            }
            this.removeSeriesFromDisplay(series);
            this.requestChartLayout();
        }
    }

    @Override
    protected void updateAxisRange() {
        boolean categoryIsX;
        boolean bl = categoryIsX = this.categoryAxis == this.getXAxis();
        if (this.categoryAxis.isAutoRanging()) {
            ArrayList<String> cData = new ArrayList<String>();
            for (XYChart.Series series : this.getData()) {
                for (XYChart.Data data : series.getData()) {
                    if (data == null) continue;
                    cData.add((String)(categoryIsX ? data.getXValue() : data.getYValue()));
                }
            }
            this.categoryAxis.invalidateRange((List<String>)cData);
        }
        if (this.valueAxis.isAutoRanging()) {
            ArrayList<Double> vData = new ArrayList<Double>();
            for (String string : this.categoryAxis.getAllDataCategories()) {
                double totalXN = 0.0;
                double totalXP = 0.0;
                Iterator seriesIterator = this.getDisplayedSeriesIterator();
                while (seriesIterator.hasNext()) {
                    XYChart.Series series = seriesIterator.next();
                    for (XYChart.Data item : this.getDataItem(series, string)) {
                        if (item == null) continue;
                        boolean isNegative = item.getNode().getStyleClass().contains("negative");
                        Number value = (Number)(categoryIsX ? item.getYValue() : item.getXValue());
                        if (!isNegative) {
                            totalXP += this.valueAxis.toNumericValue(value);
                            continue;
                        }
                        totalXN += this.valueAxis.toNumericValue(value);
                    }
                }
                vData.add(totalXP);
                vData.add(totalXN);
            }
            this.valueAxis.invalidateRange(vData);
        }
    }

    @Override
    protected void layoutPlotChildren() {
        double availableBarSpace;
        double catSpace = this.categoryAxis.getCategorySpacing();
        double barWidth = availableBarSpace = catSpace - this.getCategoryGap();
        double barOffset = -((catSpace - this.getCategoryGap()) / 2.0);
        double lowerBoundValue = this.valueAxis.getLowerBound();
        double upperBoundValue = this.valueAxis.getUpperBound();
        for (String category : this.categoryAxis.getCategories()) {
            double currentPositiveValue = 0.0;
            double currentNegativeValue = 0.0;
            Iterator seriesIterator = this.getDisplayedSeriesIterator();
            while (seriesIterator.hasNext()) {
                XYChart.Series series = seriesIterator.next();
                for (XYChart.Data item : this.getDataItem(series, category)) {
                    double top;
                    double bottom;
                    double valNumber;
                    double categoryPos;
                    if (item == null) continue;
                    Node bar = item.getNode();
                    Object xValue = this.getCurrentDisplayedXValue(item);
                    Object yValue = this.getCurrentDisplayedYValue(item);
                    if (this.orientation == Orientation.VERTICAL) {
                        categoryPos = this.getXAxis().getDisplayPosition(xValue);
                        valNumber = this.getYAxis().toNumericValue(yValue);
                    } else {
                        categoryPos = this.getYAxis().getDisplayPosition(yValue);
                        valNumber = this.getXAxis().toNumericValue(xValue);
                    }
                    boolean isNegative = bar.getStyleClass().contains("negative");
                    if (!isNegative) {
                        bottom = this.valueAxis.getDisplayPosition(currentPositiveValue);
                        top = this.valueAxis.getDisplayPosition(currentPositiveValue + valNumber);
                        currentPositiveValue += valNumber;
                    } else {
                        bottom = this.valueAxis.getDisplayPosition(currentNegativeValue + valNumber);
                        top = this.valueAxis.getDisplayPosition(currentNegativeValue);
                        currentNegativeValue += valNumber;
                    }
                    if (this.orientation == Orientation.VERTICAL) {
                        bar.resizeRelocate(categoryPos + barOffset, top, barWidth, bottom - top);
                        continue;
                    }
                    bar.resizeRelocate(bottom, categoryPos + barOffset, top - bottom, barWidth);
                }
            }
        }
    }

    @Override
    int getSeriesSize() {
        int count = 0;
        Iterator seriesIterator = this.getDisplayedSeriesIterator();
        while (seriesIterator.hasNext()) {
            seriesIterator.next();
            ++count;
        }
        return count;
    }

    @Override
    protected void updateLegend() {
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (int seriesIndex = 0; seriesIndex < this.getData().size(); ++seriesIndex) {
                XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
                Legend.LegendItem legenditem = new Legend.LegendItem(series.getName());
                String defaultColorStyleClass = this.seriesDefaultColorMap.get(series);
                legenditem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-bar", "series" + seriesIndex, "bar-legend-symbol", defaultColorStyleClass});
                this.legend.getItems().add(legenditem);
            }
        }
        if (this.legend.getItems().size() > 0) {
            if (this.getLegend() == null) {
                this.setLegend(this.legend);
            }
        } else {
            this.setLegend(null);
        }
    }

    private Node createBar(XYChart.Series series, int seriesIndex, XYChart.Data item, int itemIndex) {
        Node bar = item.getNode();
        if (bar == null) {
            bar = new StackPane();
            bar.setAccessibleRole(AccessibleRole.TEXT);
            bar.setAccessibleRoleDescription("Bar");
            bar.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            item.setNode(bar);
        }
        String defaultColorStyleClass = this.seriesDefaultColorMap.get(series);
        bar.getStyleClass().setAll((String[])new String[]{"chart-bar", "series" + seriesIndex, "data" + itemIndex, defaultColorStyleClass});
        return bar;
    }

    private List<XYChart.Data<X, Y>> getDataItem(XYChart.Series<X, Y> series, String category) {
        Map<String, List<XYChart.Data<X, Y>>> catmap = this.seriesCategoryMap.get(series);
        return catmap != null ? (catmap.get(category) != null ? catmap.get(category) : new ArrayList()) : new ArrayList();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StackedBarChart.getClassCssMetaData();
    }

    /* synthetic */ void lambda$seriesRemoved$592(Node node, ActionEvent actionEvent) {
        this.getPlotChildren().remove(node);
        node.setOpacity(1.0);
    }

    /* synthetic */ void lambda$seriesRemoved$591(XYChart.Series series, ActionEvent event) {
        this.removeSeriesFromDisplay(series);
        this.requestChartLayout();
    }

    /* synthetic */ void lambda$createDataRemoveTimeline$590(Node node, ActionEvent actionEvent) {
        this.getPlotChildren().remove(node);
    }

    /* synthetic */ void lambda$createDataRemoveTimeline$589(Node node, ActionEvent actionEvent) {
        this.getPlotChildren().remove(node);
    }

    /* synthetic */ void lambda$dataItemRemoved$588(XYChart.Series series, XYChart.Data data, ActionEvent event) {
        this.removeDataItemFromDisplay(series, data);
    }

    private static class StyleableProperties {
        private static final CssMetaData<StackedBarChart<?, ?>, Number> CATEGORY_GAP = new CssMetaData<StackedBarChart<?, ?>, Number>("-fx-category-gap", SizeConverter.getInstance(), 10.0){

            @Override
            public boolean isSettable(StackedBarChart<?, ?> node) {
                return ((StackedBarChart)node).categoryGap == null || !((StackedBarChart)node).categoryGap.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(StackedBarChart<?, ?> node) {
                return (StyleableProperty)((Object)node.categoryGapProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(XYChart.getClassCssMetaData());
            styleables.add(CATEGORY_GAP);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

