/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.css.CssError;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.scene.control.ControlAcceleratorSupport;
import com.sun.javafx.scene.control.Logging;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.application.Application;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.event.EventHandler;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control$$Lambda$1;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Skinnable;
import javafx.scene.control.Tooltip;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.Region;
import sun.util.logging.PlatformLogger;

public abstract class Control
extends Region
implements Skinnable {
    private List<CssMetaData<? extends Styleable, ?>> styleableProperties;
    private SkinBase<?> skinBase;
    private static final EventHandler<ContextMenuEvent> contextMenuHandler;
    private ObjectProperty<Skin<?>> skin = new StyleableObjectProperty<Skin<?>>(){
        private Skin<?> oldValue;

        @Override
        public void set(Skin<?> v) {
            if (v == null ? this.oldValue == null : this.oldValue != null && v.getClass().equals(this.oldValue.getClass())) {
                return;
            }
            super.set(v);
        }

        @Override
        protected void invalidated() {
            Skin skin = (Skin)this.get();
            Control.this.currentSkinClassName = skin == null ? null : skin.getClass().getName();
            Control.this.skinClassNameProperty().set(Control.this.currentSkinClassName);
            if (this.oldValue != null) {
                this.oldValue.dispose();
            }
            this.oldValue = skin;
            Control.this.skinBase = null;
            if (skin instanceof SkinBase) {
                Control.this.skinBase = (SkinBase)skin;
            } else {
                Node n = Control.this.getSkinNode();
                if (n != null) {
                    Control.this.getChildren().setAll(n);
                } else {
                    Control.this.getChildren().clear();
                }
            }
            Control.this.styleableProperties = null;
            Control.this.impl_reapplyCSS();
            PlatformLogger logger = Logging.getControlsLogger();
            if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                logger.finest("Stored skin[" + this.getValue() + "] on " + this);
            }
        }

        @Override
        public CssMetaData getCssMetaData() {
            return StyleableProperties.SKIN;
        }

        @Override
        public Object getBean() {
            return Control.this;
        }

        @Override
        public String getName() {
            return "skin";
        }
    };
    private ObjectProperty<Tooltip> tooltip;
    private ObjectProperty<ContextMenu> contextMenu = new SimpleObjectProperty<ContextMenu>((Object)this, "contextMenu"){
        private WeakReference<ContextMenu> contextMenuRef;

        @Override
        protected void invalidated() {
            ContextMenu oldMenu;
            ContextMenu contextMenu = oldMenu = this.contextMenuRef == null ? null : (ContextMenu)this.contextMenuRef.get();
            if (oldMenu != null) {
                ControlAcceleratorSupport.removeAcceleratorsFromScene(oldMenu.getItems(), Control.this);
            }
            ContextMenu ctx = (ContextMenu)this.get();
            this.contextMenuRef = new WeakReference<ContextMenu>(ctx);
            if (ctx != null) {
                ctx.setImpl_showRelativeToWindow(true);
                ControlAcceleratorSupport.addAcceleratorsIntoScene(ctx.getItems(), Control.this);
            }
        }
    };
    private String currentSkinClassName = null;
    private StringProperty skinClassName;
    static final /* synthetic */ boolean $assertionsDisabled;

    static Class<?> loadClass(String className, Object instance) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            if (Thread.currentThread().getContextClassLoader() != null) {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (instance != null) {
                for (Class<?> currentType = instance.getClass(); currentType != null; currentType = currentType.getSuperclass()) {
                    try {
                        return currentType.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException ex2) {
                        continue;
                    }
                }
            }
            throw ex;
        }
    }

    @Override
    public final ObjectProperty<Skin<?>> skinProperty() {
        return this.skin;
    }

    @Override
    public final void setSkin(Skin<?> value) {
        this.skinProperty().set(value);
    }

    @Override
    public final Skin<?> getSkin() {
        return (Skin)this.skinProperty().getValue();
    }

    public final ObjectProperty<Tooltip> tooltipProperty() {
        if (this.tooltip == null) {
            this.tooltip = new ObjectPropertyBase<Tooltip>(){
                private Tooltip old = null;

                @Override
                protected void invalidated() {
                    Tooltip t = (Tooltip)this.get();
                    if (t != this.old) {
                        if (this.old != null) {
                            Tooltip.uninstall(Control.this, this.old);
                        }
                        if (t != null) {
                            Tooltip.install(Control.this, t);
                        }
                        this.old = t;
                    }
                }

                @Override
                public Object getBean() {
                    return Control.this;
                }

                @Override
                public String getName() {
                    return "tooltip";
                }
            };
        }
        return this.tooltip;
    }

    public final void setTooltip(Tooltip value) {
        this.tooltipProperty().setValue(value);
    }

    public final Tooltip getTooltip() {
        return this.tooltip == null ? null : (Tooltip)this.tooltip.getValue();
    }

    public final ObjectProperty<ContextMenu> contextMenuProperty() {
        return this.contextMenu;
    }

    public final void setContextMenu(ContextMenu value) {
        this.contextMenu.setValue(value);
    }

    public final ContextMenu getContextMenu() {
        return this.contextMenu == null ? null : (ContextMenu)this.contextMenu.getValue();
    }

    protected Control() {
        StyleableProperty prop = (StyleableProperty)((Object)this.focusTraversableProperty());
        prop.applyStyle(null, Boolean.TRUE);
        this.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, contextMenuHandler);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    protected double computeMinWidth(double height) {
        if (this.skinBase != null) {
            return this.skinBase.computeMinWidth(height, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node skinNode = this.getSkinNode();
        return skinNode == null ? 0.0 : skinNode.minWidth(height);
    }

    @Override
    protected double computeMinHeight(double width) {
        if (this.skinBase != null) {
            return this.skinBase.computeMinHeight(width, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node skinNode = this.getSkinNode();
        return skinNode == null ? 0.0 : skinNode.minHeight(width);
    }

    @Override
    protected double computeMaxWidth(double height) {
        if (this.skinBase != null) {
            return this.skinBase.computeMaxWidth(height, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node skinNode = this.getSkinNode();
        return skinNode == null ? 0.0 : skinNode.maxWidth(height);
    }

    @Override
    protected double computeMaxHeight(double width) {
        if (this.skinBase != null) {
            return this.skinBase.computeMaxHeight(width, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node skinNode = this.getSkinNode();
        return skinNode == null ? 0.0 : skinNode.maxHeight(width);
    }

    @Override
    protected double computePrefWidth(double height) {
        if (this.skinBase != null) {
            return this.skinBase.computePrefWidth(height, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node skinNode = this.getSkinNode();
        return skinNode == null ? 0.0 : skinNode.prefWidth(height);
    }

    @Override
    protected double computePrefHeight(double width) {
        if (this.skinBase != null) {
            return this.skinBase.computePrefHeight(width, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node skinNode = this.getSkinNode();
        return skinNode == null ? 0.0 : skinNode.prefHeight(width);
    }

    @Override
    public double getBaselineOffset() {
        if (this.skinBase != null) {
            return this.skinBase.computeBaselineOffset(this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node skinNode = this.getSkinNode();
        return skinNode == null ? 0.0 : skinNode.getBaselineOffset();
    }

    @Override
    protected void layoutChildren() {
        if (this.skinBase != null) {
            double x = this.snappedLeftInset();
            double y = this.snappedTopInset();
            double w = this.snapSize(this.getWidth()) - x - this.snappedRightInset();
            double h = this.snapSize(this.getHeight()) - y - this.snappedBottomInset();
            this.skinBase.layoutChildren(x, y, w, h);
        } else {
            Node n = this.getSkinNode();
            if (n != null) {
                n.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
            }
        }
    }

    protected Skin<?> createDefaultSkin() {
        return null;
    }

    ObservableList<Node> getControlChildren() {
        return this.getChildren();
    }

    private Node getSkinNode() {
        if (!$assertionsDisabled && this.skinBase != null) {
            throw new AssertionError();
        }
        Skin<?> skin = this.getSkin();
        return skin == null ? null : skin.getNode();
    }

    @Deprecated
    protected StringProperty skinClassNameProperty() {
        if (this.skinClassName == null) {
            this.skinClassName = new StyleableStringProperty(){

                @Override
                public void set(String v) {
                    if (v == null || v.isEmpty() || v.equals(this.get())) {
                        return;
                    }
                    super.set(v);
                }

                @Override
                public void invalidated() {
                    if (this.get() != null && !this.get().equals(Control.this.currentSkinClassName)) {
                        Control.loadSkinClass(Control.this, (String)Control.this.skinClassName.get());
                    }
                }

                @Override
                public Object getBean() {
                    return Control.this;
                }

                @Override
                public String getName() {
                    return "skinClassName";
                }

                @Override
                public CssMetaData<Control, String> getCssMetaData() {
                    return StyleableProperties.SKIN;
                }
            };
        }
        return this.skinClassName;
    }

    static void loadSkinClass(Skinnable control, String skinClassName) {
        if (skinClassName == null || skinClassName.isEmpty()) {
            String msg = "Empty -fx-skin property specified for control " + control;
            ObservableList<CssError> errors = StyleManager.getErrors();
            if (errors != null) {
                CssError error = new CssError(msg);
                errors.add(error);
            }
            Logging.getControlsLogger().severe(msg);
            return;
        }
        try {
            Class<?> skinClass = Control.loadClass(skinClassName, control);
            Constructor<?>[] constructors = skinClass.getConstructors();
            Constructor<?> skinConstructor = null;
            for (Constructor<?> c : constructors) {
                Class<?>[] parameterTypes = c.getParameterTypes();
                if (parameterTypes.length != 1 || !Skinnable.class.isAssignableFrom(parameterTypes[0])) continue;
                skinConstructor = c;
                break;
            }
            if (skinConstructor == null) {
                String msg = "No valid constructor defined in '" + skinClassName + "' for control " + control + ".\r\nYou must provide a constructor that accepts a single " + "Skinnable (e.g. Control or PopupControl) parameter in " + skinClassName + ".";
                ObservableList<CssError> errors = StyleManager.getErrors();
                if (errors != null) {
                    CssError error = new CssError(msg);
                    errors.add(error);
                }
                Logging.getControlsLogger().severe(msg);
            } else {
                Skin skinInstance = (Skin)skinConstructor.newInstance(control);
                control.skinProperty().set(skinInstance);
            }
        }
        catch (InvocationTargetException e) {
            String msg = "Failed to load skin '" + skinClassName + "' for control " + control;
            ObservableList<CssError> errors = StyleManager.getErrors();
            if (errors != null) {
                CssError error = new CssError(msg + " :" + e.getLocalizedMessage());
                errors.add(error);
            }
            Logging.getControlsLogger().severe(msg, e.getCause());
        }
        catch (Exception e) {
            String msg = "Failed to load skin '" + skinClassName + "' for control " + control;
            ObservableList<CssError> errors = StyleManager.getErrors();
            if (errors != null) {
                CssError error = new CssError(msg + " :" + e.getLocalizedMessage());
                errors.add(error);
            }
            Logging.getControlsLogger().severe(msg, e);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public final List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        if (this.styleableProperties == null) {
            CssMetaData<Styleable, ?> metaData;
            int n;
            int nMax;
            HashMap map = new HashMap();
            List<CssMetaData<Styleable, ?>> list = this.getControlCssMetaData();
            int n2 = nMax = list != null ? list.size() : 0;
            for (n = 0; n < nMax; ++n) {
                metaData = list.get(n);
                if (metaData == null) continue;
                map.put(metaData.getProperty(), metaData);
            }
            list = this.skinBase != null ? this.skinBase.getCssMetaData() : null;
            int n3 = nMax = list != null ? list.size() : 0;
            for (n = 0; n < nMax; ++n) {
                metaData = list.get(n);
                if (metaData == null) continue;
                map.put(metaData.getProperty(), metaData);
            }
            this.styleableProperties = new ArrayList();
            this.styleableProperties.addAll(map.values());
        }
        return this.styleableProperties;
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Control.getClassCssMetaData();
    }

    @Override
    @Deprecated
    protected void impl_processCSS(WritableValue<Boolean> unused) {
        super.impl_processCSS(unused);
        if (this.getSkin() == null) {
            Skin<?> defaultSkin = this.createDefaultSkin();
            if (defaultSkin != null) {
                this.skinProperty().set(defaultSkin);
                super.impl_processCSS(unused);
            } else {
                String msg = "The -fx-skin property has not been defined in CSS for " + this + " and createDefaultSkin() returned null.";
                ObservableList<CssError> errors = StyleManager.getErrors();
                if (errors != null) {
                    CssError error = new CssError(msg);
                    errors.add(error);
                }
                Logging.getControlsLogger().severe(msg);
            }
        }
    }

    @Override
    @Deprecated
    protected Boolean impl_cssGetFocusTraversableInitialValue() {
        return Boolean.TRUE;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        Object result;
        switch (attribute) {
            case HELP: {
                String help = this.getAccessibleHelp();
                if (help != null && !help.isEmpty()) {
                    return help;
                }
                Tooltip tooltip = this.getTooltip();
                return tooltip == null ? "" : tooltip.getText();
            }
        }
        if (this.skinBase != null && (result = this.skinBase.queryAccessibleAttribute(attribute, parameters)) != null) {
            return result;
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        if (this.skinBase != null) {
            this.skinBase.executeAccessibleAction(action, parameters);
        }
        super.executeAccessibleAction(action, parameters);
    }

    static /* synthetic */ void lambda$static$1(ContextMenuEvent event) {
        Control c;
        if (event.isConsumed()) {
            return;
        }
        Object source = event.getSource();
        if (source instanceof Control && (c = (Control)source).getContextMenu() != null) {
            c.getContextMenu().show(c, event.getScreenX(), event.getScreenY());
            event.consume();
        }
    }

    static {
        boolean bl = $assertionsDisabled = !Control.class.desiredAssertionStatus();
        if (Application.getUserAgentStylesheet() == null) {
            PlatformImpl.setDefaultPlatformUserAgentStylesheet();
        }
        contextMenuHandler = Control$$Lambda$1.lambdaFactory$();
    }

    private static class StyleableProperties {
        private static final CssMetaData<Control, String> SKIN = new CssMetaData<Control, String>("-fx-skin", StringConverter.getInstance()){

            @Override
            public boolean isSettable(Control n) {
                return n.skin == null || !n.skin.isBound();
            }

            @Override
            public StyleableProperty<String> getStyleableProperty(Control n) {
                return (StyleableProperty)((Object)n.skinClassNameProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
            styleables.add(SKIN);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

