/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.InsetsConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.css.converters.StringConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.OverrunStyle;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="text")
public abstract class Labeled
extends Control {
    private static final String DEFAULT_ELLIPSIS_STRING = "...";
    private StringProperty text;
    private ObjectProperty<Pos> alignment;
    private ObjectProperty<TextAlignment> textAlignment;
    private ObjectProperty<OverrunStyle> textOverrun;
    private StringProperty ellipsisString;
    private BooleanProperty wrapText;
    private ObjectProperty<Font> font;
    private ObjectProperty<Node> graphic;
    private StyleableStringProperty imageUrl = null;
    private BooleanProperty underline;
    private DoubleProperty lineSpacing;
    private ObjectProperty<ContentDisplay> contentDisplay;
    private ObjectProperty<Insets> labelPadding;
    private DoubleProperty graphicTextGap;
    private ObjectProperty<Paint> textFill;
    private BooleanProperty mnemonicParsing;

    public Labeled() {
    }

    public Labeled(String text) {
        this.setText(text);
    }

    public Labeled(String text, Node graphic) {
        this.setText(text);
        ((StyleableProperty)((Object)this.graphicProperty())).applyStyle(null, graphic);
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new SimpleStringProperty(this, "text", "");
        }
        return this.text;
    }

    public final void setText(String value) {
        this.textProperty().setValue(value);
    }

    public final String getText() {
        return this.text == null ? "" : this.text.getValue();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.CENTER_LEFT){

                @Override
                public CssMetaData<Labeled, Pos> getCssMetaData() {
                    return StyleableProperties.ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos value) {
        this.alignmentProperty().set(value);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.CENTER_LEFT : (Pos)((Object)this.alignment.get());
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        if (this.textAlignment == null) {
            this.textAlignment = new StyleableObjectProperty<TextAlignment>(TextAlignment.LEFT){

                @Override
                public CssMetaData<Labeled, TextAlignment> getCssMetaData() {
                    return StyleableProperties.TEXT_ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "textAlignment";
                }
            };
        }
        return this.textAlignment;
    }

    public final void setTextAlignment(TextAlignment value) {
        this.textAlignmentProperty().setValue(value);
    }

    public final TextAlignment getTextAlignment() {
        return this.textAlignment == null ? TextAlignment.LEFT : (TextAlignment)((Object)this.textAlignment.getValue());
    }

    public final ObjectProperty<OverrunStyle> textOverrunProperty() {
        if (this.textOverrun == null) {
            this.textOverrun = new StyleableObjectProperty<OverrunStyle>(OverrunStyle.ELLIPSIS){

                @Override
                public CssMetaData<Labeled, OverrunStyle> getCssMetaData() {
                    return StyleableProperties.TEXT_OVERRUN;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "textOverrun";
                }
            };
        }
        return this.textOverrun;
    }

    public final void setTextOverrun(OverrunStyle value) {
        this.textOverrunProperty().setValue(value);
    }

    public final OverrunStyle getTextOverrun() {
        return this.textOverrun == null ? OverrunStyle.ELLIPSIS : (OverrunStyle)((Object)this.textOverrun.getValue());
    }

    public final StringProperty ellipsisStringProperty() {
        if (this.ellipsisString == null) {
            this.ellipsisString = new StyleableStringProperty(DEFAULT_ELLIPSIS_STRING){

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "ellipsisString";
                }

                @Override
                public CssMetaData<Labeled, String> getCssMetaData() {
                    return StyleableProperties.ELLIPSIS_STRING;
                }
            };
        }
        return this.ellipsisString;
    }

    public final void setEllipsisString(String value) {
        this.ellipsisStringProperty().set(value == null ? "" : value);
    }

    public final String getEllipsisString() {
        return this.ellipsisString == null ? DEFAULT_ELLIPSIS_STRING : (String)this.ellipsisString.get();
    }

    public final BooleanProperty wrapTextProperty() {
        if (this.wrapText == null) {
            this.wrapText = new StyleableBooleanProperty(){

                @Override
                public CssMetaData<Labeled, Boolean> getCssMetaData() {
                    return StyleableProperties.WRAP_TEXT;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "wrapText";
                }
            };
        }
        return this.wrapText;
    }

    public final void setWrapText(boolean value) {
        this.wrapTextProperty().setValue(value);
    }

    public final boolean isWrapText() {
        return this.wrapText == null ? false : this.wrapText.getValue();
    }

    @Override
    public Orientation getContentBias() {
        return this.isWrapText() ? Orientation.HORIZONTAL : null;
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new StyleableObjectProperty<Font>(Font.getDefault()){
                private boolean fontSetByCss;
                {
                    this.fontSetByCss = false;
                }

                @Override
                public void applyStyle(StyleOrigin newOrigin, Font value) {
                    try {
                        this.fontSetByCss = true;
                        super.applyStyle(newOrigin, value);
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        this.fontSetByCss = false;
                    }
                }

                @Override
                public void set(Font value) {
                    Font oldValue = (Font)this.get();
                    if (value != null ? !value.equals(oldValue) : oldValue != null) {
                        super.set(value);
                    }
                }

                @Override
                protected void invalidated() {
                    if (!this.fontSetByCss) {
                        Labeled.this.impl_reapplyCSS();
                    }
                }

                @Override
                public CssMetaData<Labeled, Font> getCssMetaData() {
                    return StyleableProperties.FONT;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "font";
                }
            };
        }
        return this.font;
    }

    public final void setFont(Font value) {
        this.fontProperty().setValue(value);
    }

    public final Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.getValue();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new StyleableObjectProperty<Node>(){

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.GRAPHIC;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "graphic";
                }
            };
        }
        return this.graphic;
    }

    public final void setGraphic(Node value) {
        this.graphicProperty().setValue(value);
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.getValue();
    }

    private StyleableStringProperty imageUrlProperty() {
        if (this.imageUrl == null) {
            this.imageUrl = new StyleableStringProperty(){
                StyleOrigin origin = StyleOrigin.USER;

                @Override
                public void applyStyle(StyleOrigin origin, String v) {
                    this.origin = origin;
                    if (Labeled.this.graphic == null || !Labeled.this.graphic.isBound()) {
                        super.applyStyle(origin, v);
                    }
                    this.origin = StyleOrigin.USER;
                }

                @Override
                protected void invalidated() {
                    String url = super.get();
                    if (url == null) {
                        ((StyleableProperty)((Object)Labeled.this.graphicProperty())).applyStyle(this.origin, null);
                    } else {
                        String imageViewUrl;
                        ImageView imageView;
                        Image image;
                        Node graphicNode = Labeled.this.getGraphic();
                        if (graphicNode instanceof ImageView && (image = (imageView = (ImageView)graphicNode).getImage()) != null && url.equals(imageViewUrl = image.impl_getUrl())) {
                            return;
                        }
                        Image img = StyleManager.getInstance().getCachedImage(url);
                        if (img != null) {
                            ((StyleableProperty)((Object)Labeled.this.graphicProperty())).applyStyle(this.origin, new ImageView(img));
                        }
                    }
                }

                @Override
                public String get() {
                    Image image;
                    Node graphic = Labeled.this.getGraphic();
                    if (graphic instanceof ImageView && (image = ((ImageView)graphic).getImage()) != null) {
                        return image.impl_getUrl();
                    }
                    return null;
                }

                @Override
                public StyleOrigin getStyleOrigin() {
                    return Labeled.this.graphic != null ? ((StyleableProperty)((Object)Labeled.this.graphic)).getStyleOrigin() : null;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "imageUrl";
                }

                @Override
                public CssMetaData<Labeled, String> getCssMetaData() {
                    return StyleableProperties.GRAPHIC;
                }
            };
        }
        return this.imageUrl;
    }

    public final BooleanProperty underlineProperty() {
        if (this.underline == null) {
            this.underline = new StyleableBooleanProperty(false){

                @Override
                public CssMetaData<Labeled, Boolean> getCssMetaData() {
                    return StyleableProperties.UNDERLINE;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "underline";
                }
            };
        }
        return this.underline;
    }

    public final void setUnderline(boolean value) {
        this.underlineProperty().setValue(value);
    }

    public final boolean isUnderline() {
        return this.underline == null ? false : this.underline.getValue();
    }

    public final DoubleProperty lineSpacingProperty() {
        if (this.lineSpacing == null) {
            this.lineSpacing = new StyleableDoubleProperty(0.0){

                @Override
                public CssMetaData<Labeled, Number> getCssMetaData() {
                    return StyleableProperties.LINE_SPACING;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "lineSpacing";
                }
            };
        }
        return this.lineSpacing;
    }

    public final void setLineSpacing(double value) {
        this.lineSpacingProperty().setValue(value);
    }

    public final double getLineSpacing() {
        return this.lineSpacing == null ? 0.0 : this.lineSpacing.getValue();
    }

    public final ObjectProperty<ContentDisplay> contentDisplayProperty() {
        if (this.contentDisplay == null) {
            this.contentDisplay = new StyleableObjectProperty<ContentDisplay>(ContentDisplay.LEFT){

                @Override
                public CssMetaData<Labeled, ContentDisplay> getCssMetaData() {
                    return StyleableProperties.CONTENT_DISPLAY;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "contentDisplay";
                }
            };
        }
        return this.contentDisplay;
    }

    public final void setContentDisplay(ContentDisplay value) {
        this.contentDisplayProperty().setValue(value);
    }

    public final ContentDisplay getContentDisplay() {
        return this.contentDisplay == null ? ContentDisplay.LEFT : (ContentDisplay)((Object)this.contentDisplay.getValue());
    }

    public final ReadOnlyObjectProperty<Insets> labelPaddingProperty() {
        return this.labelPaddingPropertyImpl();
    }

    private ObjectProperty<Insets> labelPaddingPropertyImpl() {
        if (this.labelPadding == null) {
            this.labelPadding = new StyleableObjectProperty<Insets>(Insets.EMPTY){
                private Insets lastValidValue;
                {
                    this.lastValidValue = Insets.EMPTY;
                }

                @Override
                public void invalidated() {
                    Insets newValue = (Insets)this.get();
                    if (newValue == null) {
                        this.set(this.lastValidValue);
                        throw new NullPointerException("cannot set labelPadding to null");
                    }
                    this.lastValidValue = newValue;
                    Labeled.this.requestLayout();
                }

                @Override
                public CssMetaData<Labeled, Insets> getCssMetaData() {
                    return StyleableProperties.LABEL_PADDING;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "labelPadding";
                }
            };
        }
        return this.labelPadding;
    }

    private void setLabelPadding(Insets value) {
        this.labelPaddingPropertyImpl().set(value);
    }

    public final Insets getLabelPadding() {
        return this.labelPadding == null ? Insets.EMPTY : (Insets)this.labelPadding.get();
    }

    public final DoubleProperty graphicTextGapProperty() {
        if (this.graphicTextGap == null) {
            this.graphicTextGap = new StyleableDoubleProperty(4.0){

                @Override
                public CssMetaData<Labeled, Number> getCssMetaData() {
                    return StyleableProperties.GRAPHIC_TEXT_GAP;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "graphicTextGap";
                }
            };
        }
        return this.graphicTextGap;
    }

    public final void setGraphicTextGap(double value) {
        this.graphicTextGapProperty().setValue(value);
    }

    public final double getGraphicTextGap() {
        return this.graphicTextGap == null ? 4.0 : this.graphicTextGap.getValue();
    }

    public final void setTextFill(Paint value) {
        this.textFillProperty().set(value);
    }

    public final Paint getTextFill() {
        return this.textFill == null ? Color.BLACK : (Paint)this.textFill.get();
    }

    public final ObjectProperty<Paint> textFillProperty() {
        if (this.textFill == null) {
            this.textFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                @Override
                public CssMetaData<Labeled, Paint> getCssMetaData() {
                    return StyleableProperties.TEXT_FILL;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "textFill";
                }
            };
        }
        return this.textFill;
    }

    public final void setMnemonicParsing(boolean value) {
        this.mnemonicParsingProperty().set(value);
    }

    public final boolean isMnemonicParsing() {
        return this.mnemonicParsing == null ? false : this.mnemonicParsing.get();
    }

    public final BooleanProperty mnemonicParsingProperty() {
        if (this.mnemonicParsing == null) {
            this.mnemonicParsing = new SimpleBooleanProperty(this, "mnemonicParsing");
        }
        return this.mnemonicParsing;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString()).append("'").append(this.getText()).append("'");
        return builder.toString();
    }

    @Deprecated
    protected Pos impl_cssGetAlignmentInitialValue() {
        return Pos.CENTER_LEFT;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Labeled.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final FontCssMetaData<Labeled> FONT = new FontCssMetaData<Labeled>("-fx-font", Font.getDefault()){

            @Override
            public boolean isSettable(Labeled n) {
                return n.font == null || !n.font.isBound();
            }

            @Override
            public StyleableProperty<Font> getStyleableProperty(Labeled n) {
                return (StyleableProperty)((Object)n.fontProperty());
            }
        };
        private static final CssMetaData<Labeled, Pos> ALIGNMENT = new CssMetaData<Labeled, Pos>("-fx-alignment", new EnumConverter<Pos>(Pos.class), Pos.CENTER_LEFT){

            @Override
            public boolean isSettable(Labeled n) {
                return n.alignment == null || !n.alignment.isBound();
            }

            @Override
            public StyleableProperty<Pos> getStyleableProperty(Labeled n) {
                return (StyleableProperty)((Object)n.alignmentProperty());
            }

            @Override
            public Pos getInitialValue(Labeled n) {
                return n.impl_cssGetAlignmentInitialValue();
            }
        };
        private static final CssMetaData<Labeled, TextAlignment> TEXT_ALIGNMENT = new CssMetaData<Labeled, TextAlignment>("-fx-text-alignment", new EnumConverter<TextAlignment>(TextAlignment.class), TextAlignment.LEFT){

            @Override
            public boolean isSettable(Labeled n) {
                return n.textAlignment == null || !n.textAlignment.isBound();
            }

            @Override
            public StyleableProperty<TextAlignment> getStyleableProperty(Labeled n) {
                return (StyleableProperty)((Object)n.textAlignmentProperty());
            }
        };
        private static final CssMetaData<Labeled, Paint> TEXT_FILL = new CssMetaData<Labeled, Paint>("-fx-text-fill", PaintConverter.getInstance(), (Paint)Color.BLACK){

            @Override
            public boolean isSettable(Labeled n) {
                return n.textFill == null || !n.textFill.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(Labeled n) {
                return (StyleableProperty)((Object)n.textFillProperty());
            }
        };
        private static final CssMetaData<Labeled, OverrunStyle> TEXT_OVERRUN = new CssMetaData<Labeled, OverrunStyle>("-fx-text-overrun", new EnumConverter<OverrunStyle>(OverrunStyle.class), OverrunStyle.ELLIPSIS){

            @Override
            public boolean isSettable(Labeled n) {
                return n.textOverrun == null || !n.textOverrun.isBound();
            }

            @Override
            public StyleableProperty<OverrunStyle> getStyleableProperty(Labeled n) {
                return (StyleableProperty)((Object)n.textOverrunProperty());
            }
        };
        private static final CssMetaData<Labeled, String> ELLIPSIS_STRING = new CssMetaData<Labeled, String>("-fx-ellipsis-string", StringConverter.getInstance(), "..."){

            @Override
            public boolean isSettable(Labeled n) {
                return n.ellipsisString == null || !n.ellipsisString.isBound();
            }

            @Override
            public StyleableProperty<String> getStyleableProperty(Labeled n) {
                return (StyleableProperty)((Object)n.ellipsisStringProperty());
            }
        };
        private static final CssMetaData<Labeled, Boolean> WRAP_TEXT = new CssMetaData<Labeled, Boolean>("-fx-wrap-text", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            @Override
            public boolean isSettable(Labeled n) {
                return n.wrapText == null || !n.wrapText.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Labeled n) {
                return (StyleableProperty)((Object)n.wrapTextProperty());
            }
        };
        private static final CssMetaData<Labeled, String> GRAPHIC = new CssMetaData<Labeled, String>("-fx-graphic", StringConverter.getInstance()){

            @Override
            public boolean isSettable(Labeled n) {
                return n.graphic == null || !n.graphic.isBound();
            }

            @Override
            public StyleableProperty<String> getStyleableProperty(Labeled n) {
                return n.imageUrlProperty();
            }
        };
        private static final CssMetaData<Labeled, Boolean> UNDERLINE = new CssMetaData<Labeled, Boolean>("-fx-underline", BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(Labeled n) {
                return n.underline == null || !n.underline.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Labeled n) {
                return (StyleableProperty)((Object)n.underlineProperty());
            }
        };
        private static final CssMetaData<Labeled, Number> LINE_SPACING = new CssMetaData<Labeled, Number>("-fx-line-spacing", SizeConverter.getInstance(), (Number)0){

            @Override
            public boolean isSettable(Labeled n) {
                return n.lineSpacing == null || !n.lineSpacing.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Labeled n) {
                return (StyleableProperty)((Object)n.lineSpacingProperty());
            }
        };
        private static final CssMetaData<Labeled, ContentDisplay> CONTENT_DISPLAY = new CssMetaData<Labeled, ContentDisplay>("-fx-content-display", new EnumConverter<ContentDisplay>(ContentDisplay.class), ContentDisplay.LEFT){

            @Override
            public boolean isSettable(Labeled n) {
                return n.contentDisplay == null || !n.contentDisplay.isBound();
            }

            @Override
            public StyleableProperty<ContentDisplay> getStyleableProperty(Labeled n) {
                return (StyleableProperty)((Object)n.contentDisplayProperty());
            }
        };
        private static final CssMetaData<Labeled, Insets> LABEL_PADDING = new CssMetaData<Labeled, Insets>("-fx-label-padding", InsetsConverter.getInstance(), Insets.EMPTY){

            @Override
            public boolean isSettable(Labeled n) {
                return n.labelPadding == null || !n.labelPadding.isBound();
            }

            @Override
            public StyleableProperty<Insets> getStyleableProperty(Labeled n) {
                return (StyleableProperty)((Object)n.labelPaddingPropertyImpl());
            }
        };
        private static final CssMetaData<Labeled, Number> GRAPHIC_TEXT_GAP = new CssMetaData<Labeled, Number>("-fx-graphic-text-gap", SizeConverter.getInstance(), (Number)4.0){

            @Override
            public boolean isSettable(Labeled n) {
                return n.graphicTextGap == null || !n.graphicTextGap.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Labeled n) {
                return (StyleableProperty)((Object)n.graphicTextGapProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT, ALIGNMENT, TEXT_ALIGNMENT, TEXT_FILL, TEXT_OVERRUN, ELLIPSIS_STRING, WRAP_TEXT, GRAPHIC, UNDERLINE, LINE_SPACING, CONTENT_DISPLAY, LABEL_PADDING, GRAPHIC_TEXT_GAP);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

