/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.behavior.ListCellBehavior;
import com.sun.javafx.scene.control.skin.ListViewSkin;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.FocusModel;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView$$Lambda$1;
import javafx.scene.control.ListView$$Lambda$2;
import javafx.scene.control.ListView$ListViewFocusModel$$Lambda$1;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.MultipleSelectionModelBase;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.util.Callback;

@DefaultProperty(value="items")
public class ListView<T>
extends Control {
    private static final EventType<?> EDIT_ANY_EVENT = new EventType<Event>(Event.ANY, "LIST_VIEW_EDIT");
    private static final EventType<?> EDIT_START_EVENT = new EventType(ListView.editAnyEvent(), "EDIT_START");
    private static final EventType<?> EDIT_CANCEL_EVENT = new EventType(ListView.editAnyEvent(), "EDIT_CANCEL");
    private static final EventType<?> EDIT_COMMIT_EVENT = new EventType(ListView.editAnyEvent(), "EDIT_COMMIT");
    private boolean selectFirstRowByDefault = true;
    private EventHandler<EditEvent<T>> DEFAULT_EDIT_COMMIT_HANDLER = ListView$$Lambda$1.lambdaFactory$(this);
    private ObjectProperty<ObservableList<T>> items;
    private ObjectProperty<Node> placeholder;
    private ObjectProperty<MultipleSelectionModel<T>> selectionModel = new SimpleObjectProperty<MultipleSelectionModel<T>>(this, "selectionModel");
    private ObjectProperty<FocusModel<T>> focusModel;
    private ObjectProperty<Orientation> orientation;
    private ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactory;
    private DoubleProperty fixedCellSize;
    private BooleanProperty editable;
    private ReadOnlyIntegerWrapper editingIndex;
    private ObjectProperty<EventHandler<EditEvent<T>>> onEditStart;
    private ObjectProperty<EventHandler<EditEvent<T>>> onEditCommit;
    private ObjectProperty<EventHandler<EditEvent<T>>> onEditCancel;
    private ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollTo;
    private static final String DEFAULT_STYLE_CLASS = "list-view";
    private static final PseudoClass PSEUDO_CLASS_VERTICAL = PseudoClass.getPseudoClass("vertical");
    private static final PseudoClass PSEUDO_CLASS_HORIZONTAL = PseudoClass.getPseudoClass("horizontal");

    public static <T> EventType<EditEvent<T>> editAnyEvent() {
        return EDIT_ANY_EVENT;
    }

    public static <T> EventType<EditEvent<T>> editStartEvent() {
        return EDIT_START_EVENT;
    }

    public static <T> EventType<EditEvent<T>> editCancelEvent() {
        return EDIT_CANCEL_EVENT;
    }

    public static <T> EventType<EditEvent<T>> editCommitEvent() {
        return EDIT_COMMIT_EVENT;
    }

    public ListView() {
        this(FXCollections.observableArrayList());
    }

    public ListView(ObservableList<T> items) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.LIST_VIEW);
        this.setItems(items);
        this.setSelectionModel(new ListViewBitSetSelectionModel(this));
        this.setFocusModel(new ListViewFocusModel(this));
        this.setOnEditCommit(this.DEFAULT_EDIT_COMMIT_HANDLER);
        this.getProperties().addListener(ListView$$Lambda$2.lambdaFactory$(this));
    }

    public final void setItems(ObservableList<T> value) {
        this.itemsProperty().set(value);
    }

    public final ObservableList<T> getItems() {
        return this.items == null ? null : (ObservableList)this.items.get();
    }

    public final ObjectProperty<ObservableList<T>> itemsProperty() {
        if (this.items == null) {
            this.items = new SimpleObjectProperty<ObservableList<T>>(this, "items");
        }
        return this.items;
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty<Node>(this, "placeholder");
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node value) {
        this.placeholderProperty().set(value);
    }

    public final Node getPlaceholder() {
        return this.placeholder == null ? null : (Node)this.placeholder.get();
    }

    public final void setSelectionModel(MultipleSelectionModel<T> value) {
        this.selectionModelProperty().set(value);
    }

    public final MultipleSelectionModel<T> getSelectionModel() {
        return this.selectionModel == null ? null : (MultipleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<MultipleSelectionModel<T>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final void setFocusModel(FocusModel<T> value) {
        this.focusModelProperty().set(value);
    }

    public final FocusModel<T> getFocusModel() {
        return this.focusModel == null ? null : (FocusModel)this.focusModel.get();
    }

    public final ObjectProperty<FocusModel<T>> focusModelProperty() {
        if (this.focusModel == null) {
            this.focusModel = new SimpleObjectProperty<FocusModel<T>>(this, "focusModel");
        }
        return this.focusModel;
    }

    public final void setOrientation(Orientation value) {
        this.orientationProperty().set(value);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.VERTICAL : (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty<Orientation>(Orientation.VERTICAL){

                @Override
                public void invalidated() {
                    boolean active = this.get() == Orientation.VERTICAL;
                    ListView.this.pseudoClassStateChanged(PSEUDO_CLASS_VERTICAL, active);
                    ListView.this.pseudoClassStateChanged(PSEUDO_CLASS_HORIZONTAL, !active);
                }

                @Override
                public CssMetaData<ListView<?>, Orientation> getCssMetaData() {
                    return StyleableProperties.ORIENTATION;
                }

                @Override
                public Object getBean() {
                    return ListView.this;
                }

                @Override
                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public final void setCellFactory(Callback<ListView<T>, ListCell<T>> value) {
        this.cellFactoryProperty().set(value);
    }

    public final Callback<ListView<T>, ListCell<T>> getCellFactory() {
        return this.cellFactory == null ? null : (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            this.cellFactory = new SimpleObjectProperty<Callback<ListView<T>, ListCell<T>>>(this, "cellFactory");
        }
        return this.cellFactory;
    }

    public final void setFixedCellSize(double value) {
        this.fixedCellSizeProperty().set(value);
    }

    public final double getFixedCellSize() {
        return this.fixedCellSize == null ? -1.0 : this.fixedCellSize.get();
    }

    public final DoubleProperty fixedCellSizeProperty() {
        if (this.fixedCellSize == null) {
            this.fixedCellSize = new StyleableDoubleProperty(-1.0){

                @Override
                public CssMetaData<ListView<?>, Number> getCssMetaData() {
                    return StyleableProperties.FIXED_CELL_SIZE;
                }

                @Override
                public Object getBean() {
                    return ListView.this;
                }

                @Override
                public String getName() {
                    return "fixedCellSize";
                }
            };
        }
        return this.fixedCellSize;
    }

    public final void setEditable(boolean value) {
        this.editableProperty().set(value);
    }

    public final boolean isEditable() {
        return this.editable == null ? false : this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", false);
        }
        return this.editable;
    }

    private void setEditingIndex(int value) {
        this.editingIndexPropertyImpl().set(value);
    }

    public final int getEditingIndex() {
        return this.editingIndex == null ? -1 : this.editingIndex.get();
    }

    public final ReadOnlyIntegerProperty editingIndexProperty() {
        return this.editingIndexPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyIntegerWrapper editingIndexPropertyImpl() {
        if (this.editingIndex == null) {
            this.editingIndex = new ReadOnlyIntegerWrapper(this, "editingIndex", -1);
        }
        return this.editingIndex;
    }

    public final void setOnEditStart(EventHandler<EditEvent<T>> value) {
        this.onEditStartProperty().set(value);
    }

    public final EventHandler<EditEvent<T>> getOnEditStart() {
        return this.onEditStart == null ? null : (EventHandler)this.onEditStart.get();
    }

    public final ObjectProperty<EventHandler<EditEvent<T>>> onEditStartProperty() {
        if (this.onEditStart == null) {
            this.onEditStart = new ObjectPropertyBase<EventHandler<EditEvent<T>>>(){

                @Override
                protected void invalidated() {
                    ListView.this.setEventHandler(ListView.editStartEvent(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return ListView.this;
                }

                @Override
                public String getName() {
                    return "onEditStart";
                }
            };
        }
        return this.onEditStart;
    }

    public final void setOnEditCommit(EventHandler<EditEvent<T>> value) {
        this.onEditCommitProperty().set(value);
    }

    public final EventHandler<EditEvent<T>> getOnEditCommit() {
        return this.onEditCommit == null ? null : (EventHandler)this.onEditCommit.get();
    }

    public final ObjectProperty<EventHandler<EditEvent<T>>> onEditCommitProperty() {
        if (this.onEditCommit == null) {
            this.onEditCommit = new ObjectPropertyBase<EventHandler<EditEvent<T>>>(){

                @Override
                protected void invalidated() {
                    ListView.this.setEventHandler(ListView.editCommitEvent(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return ListView.this;
                }

                @Override
                public String getName() {
                    return "onEditCommit";
                }
            };
        }
        return this.onEditCommit;
    }

    public final void setOnEditCancel(EventHandler<EditEvent<T>> value) {
        this.onEditCancelProperty().set(value);
    }

    public final EventHandler<EditEvent<T>> getOnEditCancel() {
        return this.onEditCancel == null ? null : (EventHandler)this.onEditCancel.get();
    }

    public final ObjectProperty<EventHandler<EditEvent<T>>> onEditCancelProperty() {
        if (this.onEditCancel == null) {
            this.onEditCancel = new ObjectPropertyBase<EventHandler<EditEvent<T>>>(){

                @Override
                protected void invalidated() {
                    ListView.this.setEventHandler(ListView.editCancelEvent(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return ListView.this;
                }

                @Override
                public String getName() {
                    return "onEditCancel";
                }
            };
        }
        return this.onEditCancel;
    }

    public void edit(int itemIndex) {
        if (!this.isEditable()) {
            return;
        }
        this.setEditingIndex(itemIndex);
    }

    public void scrollTo(int index) {
        ControlUtils.scrollToIndex(this, index);
    }

    public void scrollTo(T object) {
        int idx;
        if (this.getItems() != null && (idx = this.getItems().indexOf(object)) >= 0) {
            ControlUtils.scrollToIndex(this, idx);
        }
    }

    public void setOnScrollTo(EventHandler<ScrollToEvent<Integer>> value) {
        this.onScrollToProperty().set(value);
    }

    public EventHandler<ScrollToEvent<Integer>> getOnScrollTo() {
        if (this.onScrollTo != null) {
            return (EventHandler)this.onScrollTo.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollToProperty() {
        if (this.onScrollTo == null) {
            this.onScrollTo = new ObjectPropertyBase<EventHandler<ScrollToEvent<Integer>>>(){

                @Override
                protected void invalidated() {
                    ListView.this.setEventHandler(ScrollToEvent.scrollToTopIndex(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return ListView.this;
                }

                @Override
                public String getName() {
                    return "onScrollTo";
                }
            };
        }
        return this.onScrollTo;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ListViewSkin(this);
    }

    public void refresh() {
        this.getProperties().put("listRecreateKey", Boolean.TRUE);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return ListView.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case MULTIPLE_SELECTION: {
                MultipleSelectionModel<T> sm = this.getSelectionModel();
                return sm != null && sm.getSelectionMode() == SelectionMode.MULTIPLE;
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    /* synthetic */ void lambda$new$156(EditEvent t) {
        int index = t.getIndex();
        ObservableList<T> list = this.getItems();
        if (index < 0 || index >= list.size()) {
            return;
        }
        list.set(index, t.getNewValue());
    }

    /* synthetic */ void lambda$new$155(MapChangeListener.Change change) {
        if (change.wasAdded() && "selectFirstRowByDefault".equals(change.getKey())) {
            Boolean _selectFirstRowByDefault = (Boolean)change.getValueAdded();
            if (_selectFirstRowByDefault == null) {
                return;
            }
            this.selectFirstRowByDefault = _selectFirstRowByDefault;
        }
    }

    static /* synthetic */ EventType access$1100() {
        return EDIT_ANY_EVENT;
    }

    static class ListViewFocusModel<T>
    extends FocusModel<T> {
        private final ListView<T> listView;
        private int itemCount = 0;
        private final InvalidationListener itemsObserver;
        private final ListChangeListener<T> itemsContentListener = ListView$ListViewFocusModel$$Lambda$1.lambdaFactory$(this);
        private WeakListChangeListener<T> weakItemsContentListener = new WeakListChangeListener<T>(this.itemsContentListener);

        public ListViewFocusModel(final ListView<T> listView) {
            if (listView == null) {
                throw new IllegalArgumentException("ListView can not be null");
            }
            this.listView = listView;
            this.itemsObserver = new InvalidationListener(){
                private WeakReference<ObservableList<T>> weakItemsRef;
                {
                    this.weakItemsRef = new WeakReference(listView.getItems());
                }

                @Override
                public void invalidated(Observable observable) {
                    ObservableList oldItems = (ObservableList)this.weakItemsRef.get();
                    this.weakItemsRef = new WeakReference(listView.getItems());
                    ListViewFocusModel.this.updateItemsObserver(oldItems, listView.getItems());
                }
            };
            this.listView.itemsProperty().addListener(new WeakInvalidationListener(this.itemsObserver));
            if (listView.getItems() != null) {
                this.listView.getItems().addListener(this.weakItemsContentListener);
            }
            this.updateItemCount();
            if (this.itemCount > 0) {
                this.focus(0);
            }
        }

        private void updateItemsObserver(ObservableList<T> oldList, ObservableList<T> newList) {
            if (oldList != null) {
                oldList.removeListener(this.weakItemsContentListener);
            }
            if (newList != null) {
                newList.addListener(this.weakItemsContentListener);
            }
            this.updateItemCount();
        }

        @Override
        protected int getItemCount() {
            return this.itemCount;
        }

        @Override
        protected T getModelItem(int index) {
            if (this.isEmpty()) {
                return null;
            }
            if (index < 0 || index >= this.itemCount) {
                return null;
            }
            return (T)this.listView.getItems().get(index);
        }

        private boolean isEmpty() {
            return this.itemCount == -1;
        }

        private void updateItemCount() {
            ObservableList<T> items;
            this.itemCount = this.listView == null ? -1 : ((items = this.listView.getItems()) == null ? -1 : items.size());
        }

        /* synthetic */ void lambda$new$157(ListChangeListener.Change c) {
            this.updateItemCount();
            while (c.next()) {
                int from = c.getFrom();
                if (this.getFocusedIndex() == -1 || from > this.getFocusedIndex()) {
                    return;
                }
                c.reset();
                boolean added = false;
                boolean removed = false;
                int addedSize = 0;
                int removedSize = 0;
                while (c.next()) {
                    added |= c.wasAdded();
                    removed |= c.wasRemoved();
                    addedSize += c.getAddedSize();
                    removedSize += c.getRemovedSize();
                }
                if (added && !removed) {
                    this.focus(Math.min(this.getItemCount() - 1, this.getFocusedIndex() + addedSize));
                    continue;
                }
                if (added || !removed) continue;
                this.focus(Math.max(0, this.getFocusedIndex() - removedSize));
            }
        }
    }

    static class ListViewBitSetSelectionModel<T>
    extends MultipleSelectionModelBase<T> {
        private final ListChangeListener<T> itemsContentObserver = new ListChangeListener<T>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends T> c) {
                ListViewBitSetSelectionModel.this.updateItemCount();
                while (c.next()) {
                    int previousRow;
                    Object newSelectedItem;
                    Object selectedItem = ListViewBitSetSelectionModel.this.getSelectedItem();
                    int selectedIndex = ListViewBitSetSelectionModel.this.getSelectedIndex();
                    if (ListViewBitSetSelectionModel.this.listView.getItems() == null || ListViewBitSetSelectionModel.this.listView.getItems().isEmpty()) {
                        ListViewBitSetSelectionModel.this.selectedItemChange = c;
                        ListViewBitSetSelectionModel.this.clearSelection();
                        ListViewBitSetSelectionModel.this.selectedItemChange = null;
                        continue;
                    }
                    if (selectedIndex == -1 && selectedItem != null) {
                        int newIndex = ListViewBitSetSelectionModel.this.listView.getItems().indexOf(selectedItem);
                        if (newIndex == -1) continue;
                        ListViewBitSetSelectionModel.this.setSelectedIndex(newIndex);
                        continue;
                    }
                    if (!c.wasRemoved() || c.getRemovedSize() != 1 || c.wasAdded() || selectedItem == null || !selectedItem.equals(c.getRemoved().get(0)) || ListViewBitSetSelectionModel.this.getSelectedIndex() >= ListViewBitSetSelectionModel.this.getItemCount() || selectedItem.equals(newSelectedItem = ListViewBitSetSelectionModel.this.getModelItem(previousRow = selectedIndex == 0 ? 0 : selectedIndex - 1))) continue;
                    ListViewBitSetSelectionModel.this.startAtomic();
                    ListViewBitSetSelectionModel.this.clearSelection(selectedIndex);
                    ListViewBitSetSelectionModel.this.stopAtomic();
                    ListViewBitSetSelectionModel.this.select(newSelectedItem);
                }
                ListViewBitSetSelectionModel.this.updateSelection(c);
            }
        };
        private final InvalidationListener itemsObserver;
        private WeakListChangeListener<T> weakItemsContentObserver = new WeakListChangeListener<T>(this.itemsContentObserver);
        private final ListView<T> listView;
        private int itemCount = 0;
        private int previousModelSize = 0;

        public ListViewBitSetSelectionModel(final ListView<T> listView) {
            if (listView == null) {
                throw new IllegalArgumentException("ListView can not be null");
            }
            this.listView = listView;
            this.itemsObserver = new InvalidationListener(){
                private WeakReference<ObservableList<T>> weakItemsRef;
                {
                    this.weakItemsRef = new WeakReference(listView.getItems());
                }

                @Override
                public void invalidated(Observable observable) {
                    ObservableList oldItems = (ObservableList)this.weakItemsRef.get();
                    this.weakItemsRef = new WeakReference(listView.getItems());
                    ListViewBitSetSelectionModel.this.updateItemsObserver(oldItems, listView.getItems());
                }
            };
            this.listView.itemsProperty().addListener(new WeakInvalidationListener(this.itemsObserver));
            if (listView.getItems() != null) {
                this.listView.getItems().addListener(this.weakItemsContentObserver);
            }
            this.updateItemCount();
            this.updateDefaultSelection();
        }

        private void updateSelection(ListChangeListener.Change<? extends T> c) {
            c.reset();
            int shift = 0;
            while (c.next()) {
                if (c.wasReplaced()) {
                    if (c.getList().isEmpty()) {
                        this.clearSelection();
                        continue;
                    }
                    int index = this.getSelectedIndex();
                    if (this.previousModelSize == c.getRemovedSize()) {
                        this.clearSelection();
                        continue;
                    }
                    if (index < this.getItemCount() && index >= 0) {
                        this.startAtomic();
                        this.clearSelection(index);
                        this.stopAtomic();
                        this.select(index);
                        continue;
                    }
                    this.clearSelection();
                    continue;
                }
                if (c.wasAdded() || c.wasRemoved()) {
                    shift += c.wasAdded() ? c.getAddedSize() : -c.getRemovedSize();
                    continue;
                }
                if (!c.wasPermutated()) continue;
                int length = c.getTo() - c.getFrom();
                HashMap<Integer, Integer> pMap = new HashMap<Integer, Integer>(length);
                for (int i = c.getFrom(); i < c.getTo(); ++i) {
                    pMap.put(i, c.getPermutation(i));
                }
                ArrayList<Integer> selectedIndices = new ArrayList<Integer>(this.getSelectedIndices());
                this.clearSelection();
                ArrayList<Integer> newIndices = new ArrayList<Integer>(this.getSelectedIndices().size());
                for (int i = 0; i < selectedIndices.size(); ++i) {
                    int oldIndex = (Integer)selectedIndices.get(i);
                    if (!pMap.containsKey(oldIndex)) continue;
                    Integer newIndex = (Integer)pMap.get(oldIndex);
                    newIndices.add(newIndex);
                }
                if (newIndices.isEmpty()) continue;
                if (newIndices.size() == 1) {
                    this.select((Integer)newIndices.get(0));
                    continue;
                }
                int[] ints = new int[newIndices.size() - 1];
                for (int i = 0; i < newIndices.size() - 1; ++i) {
                    ints[i] = (Integer)newIndices.get(i + 1);
                }
                this.selectIndices((Integer)newIndices.get(0), ints);
            }
            if (shift != 0) {
                this.shiftSelection(c.getFrom(), shift, null);
            }
            this.previousModelSize = this.getItemCount();
        }

        @Override
        public void selectAll() {
            int anchor = ListCellBehavior.getAnchor(this.listView, -1);
            super.selectAll();
            ListCellBehavior.setAnchor(this.listView, anchor, false);
        }

        @Override
        public void clearAndSelect(int row) {
            ListCellBehavior.setAnchor(this.listView, row, false);
            super.clearAndSelect(row);
        }

        @Override
        protected void focus(int row) {
            if (this.listView.getFocusModel() == null) {
                return;
            }
            this.listView.getFocusModel().focus(row);
            this.listView.notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
        }

        @Override
        protected int getFocusedIndex() {
            if (this.listView.getFocusModel() == null) {
                return -1;
            }
            return this.listView.getFocusModel().getFocusedIndex();
        }

        @Override
        protected int getItemCount() {
            return this.itemCount;
        }

        @Override
        protected T getModelItem(int index) {
            ObservableList<T> items = this.listView.getItems();
            if (items == null) {
                return null;
            }
            if (index < 0 || index >= this.itemCount) {
                return null;
            }
            return (T)items.get(index);
        }

        private void updateItemCount() {
            ObservableList<T> items;
            this.itemCount = this.listView == null ? -1 : ((items = this.listView.getItems()) == null ? -1 : items.size());
        }

        private void updateItemsObserver(ObservableList<T> oldList, ObservableList<T> newList) {
            if (oldList != null) {
                oldList.removeListener(this.weakItemsContentObserver);
            }
            if (newList != null) {
                newList.addListener(this.weakItemsContentObserver);
            }
            this.updateItemCount();
            this.updateDefaultSelection();
        }

        private void updateDefaultSelection() {
            int newSelectionIndex = -1;
            int newFocusIndex = -1;
            if (this.listView.getItems() != null) {
                Object selectedItem = this.getSelectedItem();
                if (selectedItem != null) {
                    newFocusIndex = newSelectionIndex = this.listView.getItems().indexOf(selectedItem);
                }
                if (((ListView)this.listView).selectFirstRowByDefault && newFocusIndex == -1) {
                    newFocusIndex = this.listView.getItems().size() > 0 ? 0 : -1;
                }
            }
            this.clearSelection();
            this.select(newSelectionIndex);
            this.focus(newFocusIndex);
        }
    }

    public static class EditEvent<T>
    extends Event {
        private final T newValue;
        private final int editIndex;
        private static final long serialVersionUID = 20130724L;
        public static final EventType<?> ANY = ListView.access$1100();

        public EditEvent(ListView<T> source, EventType<? extends EditEvent<T>> eventType, T newValue, int editIndex) {
            super(source, Event.NULL_SOURCE_TARGET, eventType);
            this.editIndex = editIndex;
            this.newValue = newValue;
        }

        @Override
        public ListView<T> getSource() {
            return (ListView)super.getSource();
        }

        public int getIndex() {
            return this.editIndex;
        }

        public T getNewValue() {
            return this.newValue;
        }

        @Override
        public String toString() {
            return "ListViewEditEvent [ newValue: " + this.getNewValue() + ", ListView: " + this.getSource() + " ]";
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<ListView<?>, Orientation> ORIENTATION = new CssMetaData<ListView<?>, Orientation>("-fx-orientation", new EnumConverter<Orientation>(Orientation.class), Orientation.VERTICAL){

            @Override
            public Orientation getInitialValue(ListView<?> node) {
                return node.getOrientation();
            }

            @Override
            public boolean isSettable(ListView<?> n) {
                return ((ListView)n).orientation == null || !((ListView)n).orientation.isBound();
            }

            @Override
            public StyleableProperty<Orientation> getStyleableProperty(ListView<?> n) {
                return (StyleableProperty)((Object)n.orientationProperty());
            }
        };
        private static final CssMetaData<ListView<?>, Number> FIXED_CELL_SIZE = new CssMetaData<ListView<?>, Number>("-fx-fixed-cell-size", SizeConverter.getInstance(), -1.0){

            @Override
            public Double getInitialValue(ListView<?> node) {
                return node.getFixedCellSize();
            }

            @Override
            public boolean isSettable(ListView<?> n) {
                return ((ListView)n).fixedCellSize == null || !((ListView)n).fixedCellSize.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ListView<?> n) {
                return (StyleableProperty)((Object)n.fixedCellSizeProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.add(ORIENTATION);
            styleables.add(FIXED_CELL_SIZE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

