/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.TreeCellSkin;
import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeCell$$Lambda$1;
import javafx.scene.control.TreeCell$$Lambda$2;
import javafx.scene.control.TreeCell$$Lambda$3;
import javafx.scene.control.TreeCell$$Lambda$4;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;

public class TreeCell<T>
extends IndexedCell<T> {
    private final ListChangeListener<Integer> selectedListener = TreeCell$$Lambda$1.lambdaFactory$(this);
    private final ChangeListener<MultipleSelectionModel<TreeItem<T>>> selectionModelPropertyListener = new ChangeListener<MultipleSelectionModel<TreeItem<T>>>(){

        @Override
        public void changed(ObservableValue<? extends MultipleSelectionModel<TreeItem<T>>> observable, MultipleSelectionModel<TreeItem<T>> oldValue, MultipleSelectionModel<TreeItem<T>> newValue) {
            if (oldValue != null) {
                oldValue.getSelectedIndices().removeListener(TreeCell.this.weakSelectedListener);
            }
            if (newValue != null) {
                newValue.getSelectedIndices().addListener(TreeCell.this.weakSelectedListener);
            }
            TreeCell.this.updateSelection();
        }
    };
    private final InvalidationListener focusedListener = TreeCell$$Lambda$2.lambdaFactory$(this);
    private final ChangeListener<FocusModel<TreeItem<T>>> focusModelPropertyListener = new ChangeListener<FocusModel<TreeItem<T>>>(){

        @Override
        public void changed(ObservableValue<? extends FocusModel<TreeItem<T>>> observable, FocusModel<TreeItem<T>> oldValue, FocusModel<TreeItem<T>> newValue) {
            if (oldValue != null) {
                oldValue.focusedIndexProperty().removeListener(TreeCell.this.weakFocusedListener);
            }
            if (newValue != null) {
                newValue.focusedIndexProperty().addListener(TreeCell.this.weakFocusedListener);
            }
            TreeCell.this.updateFocus();
        }
    };
    private final InvalidationListener editingListener = TreeCell$$Lambda$3.lambdaFactory$(this);
    private final InvalidationListener leafListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable valueModel) {
            TreeItem treeItem = TreeCell.this.getTreeItem();
            if (treeItem != null) {
                TreeCell.this.requestLayout();
            }
        }
    };
    private boolean oldIsExpanded;
    private final InvalidationListener treeItemExpandedInvalidationListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable o) {
            boolean isExpanded = ((BooleanProperty)o).get();
            TreeCell.this.pseudoClassStateChanged(EXPANDED_PSEUDOCLASS_STATE, isExpanded);
            TreeCell.this.pseudoClassStateChanged(COLLAPSED_PSEUDOCLASS_STATE, !isExpanded);
            if (isExpanded != TreeCell.this.oldIsExpanded) {
                TreeCell.this.notifyAccessibleAttributeChanged(AccessibleAttribute.EXPANDED);
            }
            TreeCell.this.oldIsExpanded = isExpanded;
        }
    };
    private final InvalidationListener rootPropertyListener = TreeCell$$Lambda$4.lambdaFactory$(this);
    private final WeakListChangeListener<Integer> weakSelectedListener = new WeakListChangeListener<Integer>(this.selectedListener);
    private final WeakChangeListener<MultipleSelectionModel<TreeItem<T>>> weakSelectionModelPropertyListener = new WeakChangeListener<MultipleSelectionModel<TreeItem<MultipleSelectionModel<TreeItem<T>>>>>(this.selectionModelPropertyListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakChangeListener<FocusModel<TreeItem<T>>> weakFocusModelPropertyListener = new WeakChangeListener<FocusModel<TreeItem<FocusModel<TreeItem<T>>>>>(this.focusModelPropertyListener);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakInvalidationListener weakLeafListener = new WeakInvalidationListener(this.leafListener);
    private final WeakInvalidationListener weakTreeItemExpandedInvalidationListener = new WeakInvalidationListener(this.treeItemExpandedInvalidationListener);
    private final WeakInvalidationListener weakRootPropertyListener = new WeakInvalidationListener(this.rootPropertyListener);
    private ReadOnlyObjectWrapper<TreeItem<T>> treeItem = new ReadOnlyObjectWrapper<TreeItem<T>>(this, "treeItem"){
        TreeItem<T> oldValue;
        {
            this.oldValue = null;
        }

        @Override
        protected void invalidated() {
            if (this.oldValue != null) {
                this.oldValue.expandedProperty().removeListener(TreeCell.this.weakTreeItemExpandedInvalidationListener);
            }
            this.oldValue = (TreeItem)this.get();
            if (this.oldValue != null) {
                TreeCell.this.oldIsExpanded = this.oldValue.isExpanded();
                this.oldValue.expandedProperty().addListener(TreeCell.this.weakTreeItemExpandedInvalidationListener);
                TreeCell.this.weakTreeItemExpandedInvalidationListener.invalidated(this.oldValue.expandedProperty());
            }
        }
    };
    private ObjectProperty<Node> disclosureNode = new SimpleObjectProperty<Node>(this, "disclosureNode");
    private ReadOnlyObjectWrapper<TreeView<T>> treeView = new ReadOnlyObjectWrapper<TreeView<T>>(){
        private WeakReference<TreeView<T>> weakTreeViewRef;

        @Override
        protected void invalidated() {
            TreeView treeView;
            FocusModel fm;
            MultipleSelectionModel<TreeItem<Object>> sm;
            if (this.weakTreeViewRef != null) {
                TreeView oldTreeView = (TreeView)this.weakTreeViewRef.get();
                if (oldTreeView != null) {
                    sm = oldTreeView.getSelectionModel();
                    if (sm != null) {
                        sm.getSelectedIndices().removeListener(TreeCell.this.weakSelectedListener);
                    }
                    if ((fm = oldTreeView.getFocusModel()) != null) {
                        fm.focusedIndexProperty().removeListener(TreeCell.this.weakFocusedListener);
                    }
                    oldTreeView.editingItemProperty().removeListener(TreeCell.this.weakEditingListener);
                    oldTreeView.focusModelProperty().removeListener(TreeCell.this.weakFocusModelPropertyListener);
                    oldTreeView.selectionModelProperty().removeListener(TreeCell.this.weakSelectionModelPropertyListener);
                    oldTreeView.rootProperty().removeListener(TreeCell.this.weakRootPropertyListener);
                }
                this.weakTreeViewRef = null;
            }
            if ((treeView = (TreeView)this.get()) != null) {
                sm = treeView.getSelectionModel();
                if (sm != null) {
                    sm.getSelectedIndices().addListener(TreeCell.this.weakSelectedListener);
                }
                if ((fm = treeView.getFocusModel()) != null) {
                    fm.focusedIndexProperty().addListener(TreeCell.this.weakFocusedListener);
                }
                treeView.editingItemProperty().addListener(TreeCell.this.weakEditingListener);
                treeView.focusModelProperty().addListener(TreeCell.this.weakFocusModelPropertyListener);
                treeView.selectionModelProperty().addListener(TreeCell.this.weakSelectionModelPropertyListener);
                treeView.rootProperty().addListener(TreeCell.this.weakRootPropertyListener);
                this.weakTreeViewRef = new WeakReference<TreeView>(treeView);
            }
            TreeCell.this.updateItem(-1);
            TreeCell.this.requestLayout();
        }

        @Override
        public Object getBean() {
            return TreeCell.this;
        }

        @Override
        public String getName() {
            return "treeView";
        }
    };
    private boolean isFirstRun = true;
    private boolean updateEditingIndex = true;
    private static final String DEFAULT_STYLE_CLASS = "tree-cell";
    private static final PseudoClass EXPANDED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("expanded");
    private static final PseudoClass COLLAPSED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("collapsed");

    public TreeCell() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TREE_ITEM);
    }

    private void setTreeItem(TreeItem<T> value) {
        this.treeItem.set(value);
    }

    public final TreeItem<T> getTreeItem() {
        return (TreeItem)this.treeItem.get();
    }

    public final ReadOnlyObjectProperty<TreeItem<T>> treeItemProperty() {
        return this.treeItem.getReadOnlyProperty();
    }

    public final void setDisclosureNode(Node value) {
        this.disclosureNodeProperty().set(value);
    }

    public final Node getDisclosureNode() {
        return (Node)this.disclosureNode.get();
    }

    public final ObjectProperty<Node> disclosureNodeProperty() {
        return this.disclosureNode;
    }

    private void setTreeView(TreeView<T> value) {
        this.treeView.set(value);
    }

    public final TreeView<T> getTreeView() {
        return (TreeView)this.treeView.get();
    }

    public final ReadOnlyObjectProperty<TreeView<T>> treeViewProperty() {
        return this.treeView.getReadOnlyProperty();
    }

    @Override
    public void startEdit() {
        if (this.isEditing()) {
            return;
        }
        TreeView<T> tree = this.getTreeView();
        if (!this.isEditable() || tree != null && !tree.isEditable()) {
            return;
        }
        this.updateItem(-1);
        super.startEdit();
        if (tree != null) {
            tree.fireEvent(new TreeView.EditEvent<Object>((TreeView<Object>)tree, TreeView.editStartEvent(), (TreeItem<Object>)this.getTreeItem(), this.getItem(), null));
            tree.requestFocus();
        }
    }

    @Override
    public void commitEdit(T newValue) {
        if (!this.isEditing()) {
            return;
        }
        TreeItem<T> treeItem = this.getTreeItem();
        TreeView tree = this.getTreeView();
        if (tree != null) {
            tree.fireEvent(new TreeView.EditEvent<T>(tree, TreeView.editCommitEvent(), treeItem, this.getItem(), newValue));
        }
        super.commitEdit(newValue);
        if (treeItem != null) {
            treeItem.setValue(newValue);
            this.updateTreeItem(treeItem);
            this.updateItem(newValue, false);
        }
        if (tree != null) {
            tree.edit(null);
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(tree);
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        TreeView tree = this.getTreeView();
        super.cancelEdit();
        if (tree != null) {
            if (this.updateEditingIndex) {
                tree.edit(null);
            }
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(tree);
            tree.fireEvent(new TreeView.EditEvent<Object>(tree, TreeView.editCancelEvent(), (TreeItem<Object>)this.getTreeItem(), this.getItem(), null));
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TreeCellSkin(this);
    }

    @Override
    void indexChanged(int oldIndex, int newIndex) {
        super.indexChanged(oldIndex, newIndex);
        if (!this.isEditing() || newIndex != oldIndex) {
            this.updateItem(oldIndex);
            this.updateSelection();
            this.updateFocus();
        }
    }

    private void updateItem(int oldIndex) {
        TreeView<T> tv = this.getTreeView();
        if (tv == null) {
            return;
        }
        int index = this.getIndex();
        boolean valid = index >= 0 && index < tv.getExpandedItemCount();
        boolean isEmpty = this.isEmpty();
        TreeItem<T> oldTreeItem = this.getTreeItem();
        if (valid) {
            Object oldValue;
            TreeItem<T> newTreeItem = tv.getTreeItem(index);
            Object newValue = newTreeItem == null ? null : (Object)newTreeItem.getValue();
            Object t = oldValue = oldTreeItem == null ? null : (Object)oldTreeItem.getValue();
            if (oldIndex != index || this.isItemChanged(oldValue, newValue)) {
                this.updateTreeItem(newTreeItem);
                this.updateItem(newValue, false);
            }
        } else if (!isEmpty && oldTreeItem != null || this.isFirstRun) {
            this.updateTreeItem(null);
            this.updateItem(null, true);
            this.isFirstRun = false;
        }
    }

    private void updateSelection() {
        if (this.isEmpty()) {
            return;
        }
        if (this.getIndex() == -1 || this.getTreeView() == null) {
            return;
        }
        MultipleSelectionModel<TreeItem<T>> sm = this.getTreeView().getSelectionModel();
        if (sm == null) {
            this.updateSelected(false);
            return;
        }
        boolean isSelected = sm.isSelected(this.getIndex());
        if (this.isSelected() == isSelected) {
            return;
        }
        this.updateSelected(isSelected);
    }

    private void updateFocus() {
        if (this.getIndex() == -1 || this.getTreeView() == null) {
            return;
        }
        FocusModel<TreeItem<T>> fm = this.getTreeView().getFocusModel();
        if (fm == null) {
            this.setFocused(false);
            return;
        }
        this.setFocused(fm.isFocused(this.getIndex()));
    }

    private void updateEditing() {
        int index = this.getIndex();
        TreeView<T> tree = this.getTreeView();
        TreeItem<T> treeItem = this.getTreeItem();
        TreeItem<T> editItem = tree == null ? null : tree.getEditingItem();
        boolean editing = this.isEditing();
        if (index == -1 || tree == null || treeItem == null) {
            return;
        }
        boolean match = treeItem.equals(editItem);
        if (match && !editing) {
            this.startEdit();
        } else if (!match && editing) {
            this.updateEditingIndex = false;
            this.cancelEdit();
            this.updateEditingIndex = true;
        }
    }

    public final void updateTreeView(TreeView<T> tree) {
        this.setTreeView(tree);
    }

    public final void updateTreeItem(TreeItem<T> treeItem) {
        TreeItem<T> _treeItem = this.getTreeItem();
        if (_treeItem != null) {
            _treeItem.leafProperty().removeListener(this.weakLeafListener);
        }
        this.setTreeItem(treeItem);
        if (treeItem != null) {
            treeItem.leafProperty().addListener(this.weakLeafListener);
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        TreeItem<T> treeItem = this.getTreeItem();
        TreeView<T> treeView = this.getTreeView();
        switch (attribute) {
            case TREE_ITEM_PARENT: {
                if (treeView == null) {
                    return null;
                }
                if (treeItem == null) {
                    return null;
                }
                TreeItem<T> parent = treeItem.getParent();
                if (parent == null) {
                    return null;
                }
                int parentIndex = treeView.getRow(parent);
                return treeView.queryAccessibleAttribute(AccessibleAttribute.ROW_AT_INDEX, parentIndex);
            }
            case TREE_ITEM_COUNT: {
                if (treeItem == null) {
                    return 0;
                }
                if (!treeItem.isExpanded()) {
                    return 0;
                }
                return treeItem.getChildren().size();
            }
            case TREE_ITEM_AT_INDEX: {
                if (treeItem == null) {
                    return null;
                }
                if (!treeItem.isExpanded()) {
                    return null;
                }
                int index = (Integer)parameters[0];
                if (index >= treeItem.getChildren().size()) {
                    return null;
                }
                TreeItem child = (TreeItem)treeItem.getChildren().get(index);
                if (child == null) {
                    return null;
                }
                int childIndex = treeView.getRow(child);
                return treeView.queryAccessibleAttribute(AccessibleAttribute.ROW_AT_INDEX, childIndex);
            }
            case LEAF: {
                return treeItem == null ? true : treeItem.isLeaf();
            }
            case EXPANDED: {
                return treeItem == null ? false : treeItem.isExpanded();
            }
            case INDEX: {
                return this.getIndex();
            }
            case SELECTED: {
                return this.isSelected();
            }
            case DISCLOSURE_LEVEL: {
                return treeView == null ? 0 : treeView.getTreeItemLevel(treeItem);
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case EXPAND: {
                TreeItem<T> treeItem = this.getTreeItem();
                if (treeItem == null) break;
                treeItem.setExpanded(true);
                break;
            }
            case COLLAPSE: {
                TreeItem<T> treeItem = this.getTreeItem();
                if (treeItem == null) break;
                treeItem.setExpanded(false);
                break;
            }
            case REQUEST_FOCUS: {
                FocusModel<TreeItem<T>> fm;
                TreeView<T> treeView = this.getTreeView();
                if (treeView == null || (fm = treeView.getFocusModel()) == null) break;
                fm.focus(this.getIndex());
                break;
            }
            default: {
                super.executeAccessibleAction(action, new Object[0]);
            }
        }
    }

    /* synthetic */ void lambda$new$255(Observable observable) {
        this.updateItem(-1);
    }

    /* synthetic */ void lambda$new$254(Observable valueModel) {
        this.updateEditing();
    }

    /* synthetic */ void lambda$new$253(Observable valueModel) {
        this.updateFocus();
    }

    /* synthetic */ void lambda$new$252(ListChangeListener.Change c) {
        this.updateSelection();
    }
}

