/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.TreeTableCellSkin;
import java.lang.ref.WeakReference;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeTableCell$$Lambda$1;
import javafx.scene.control.TreeTableCell$$Lambda$2;
import javafx.scene.control.TreeTableCell$$Lambda$3;
import javafx.scene.control.TreeTableCell$$Lambda$4;
import javafx.scene.control.TreeTableCell$$Lambda$5;
import javafx.scene.control.TreeTableCell$$Lambda$6;
import javafx.scene.control.TreeTableCell$$Lambda$7;
import javafx.scene.control.TreeTableCell$$Lambda$8;
import javafx.scene.control.TreeTableCell$$Lambda$9;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;

public class TreeTableCell<S, T>
extends IndexedCell<T> {
    boolean lockItemOnEdit = false;
    private boolean itemDirty = false;
    private ListChangeListener<TreeTablePosition<S, ?>> selectedListener = TreeTableCell$$Lambda$1.lambdaFactory$(this);
    private final InvalidationListener focusedListener = TreeTableCell$$Lambda$2.lambdaFactory$(this);
    private final InvalidationListener tableRowUpdateObserver = TreeTableCell$$Lambda$3.lambdaFactory$(this);
    private final InvalidationListener editingListener = TreeTableCell$$Lambda$4.lambdaFactory$(this);
    private ListChangeListener<TreeTableColumn<S, ?>> visibleLeafColumnsListener = TreeTableCell$$Lambda$5.lambdaFactory$(this);
    private ListChangeListener<String> columnStyleClassListener = TreeTableCell$$Lambda$6.lambdaFactory$(this);
    private final InvalidationListener rootPropertyListener = TreeTableCell$$Lambda$7.lambdaFactory$(this);
    private final InvalidationListener columnStyleListener = TreeTableCell$$Lambda$8.lambdaFactory$(this);
    private final InvalidationListener columnIdListener = TreeTableCell$$Lambda$9.lambdaFactory$(this);
    private final WeakListChangeListener<TreeTablePosition<S, ?>> weakSelectedListener = new WeakListChangeListener(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weaktableRowUpdateObserver = new WeakInvalidationListener(this.tableRowUpdateObserver);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakListChangeListener<TreeTableColumn<S, ?>> weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private final WeakListChangeListener<String> weakColumnStyleClassListener = new WeakListChangeListener<String>(this.columnStyleClassListener);
    private final WeakInvalidationListener weakColumnStyleListener = new WeakInvalidationListener(this.columnStyleListener);
    private final WeakInvalidationListener weakColumnIdListener = new WeakInvalidationListener(this.columnIdListener);
    private final WeakInvalidationListener weakRootPropertyListener = new WeakInvalidationListener(this.rootPropertyListener);
    private ReadOnlyObjectWrapper<TreeTableColumn<S, T>> treeTableColumn = new ReadOnlyObjectWrapper<TreeTableColumn<S, T>>(this, "treeTableColumn"){

        @Override
        protected void invalidated() {
            TreeTableCell.this.updateColumnIndex();
        }
    };
    private ReadOnlyObjectWrapper<TreeTableView<S>> treeTableView;
    private ReadOnlyObjectWrapper<TreeTableRow<S>> treeTableRow = new ReadOnlyObjectWrapper(this, "treeTableRow");
    private boolean isLastVisibleColumn = false;
    private int columnIndex = -1;
    private boolean updateEditingIndex = true;
    private ObservableValue<T> currentObservableValue = null;
    private boolean isFirstRun = true;
    private WeakReference<S> oldRowItemRef;
    private static final String DEFAULT_STYLE_CLASS = "tree-table-cell";
    private static final PseudoClass PSEUDO_CLASS_LAST_VISIBLE = PseudoClass.getPseudoClass("last-visible");

    public TreeTableCell() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TREE_TABLE_CELL);
        this.updateColumnIndex();
    }

    public final ReadOnlyObjectProperty<TreeTableColumn<S, T>> tableColumnProperty() {
        return this.treeTableColumn.getReadOnlyProperty();
    }

    private void setTableColumn(TreeTableColumn<S, T> value) {
        this.treeTableColumn.set(value);
    }

    public final TreeTableColumn<S, T> getTableColumn() {
        return (TreeTableColumn)this.treeTableColumn.get();
    }

    private void setTreeTableView(TreeTableView<S> value) {
        this.treeTableViewPropertyImpl().set(value);
    }

    public final TreeTableView<S> getTreeTableView() {
        return this.treeTableView == null ? null : (TreeTableView)this.treeTableView.get();
    }

    public final ReadOnlyObjectProperty<TreeTableView<S>> treeTableViewProperty() {
        return this.treeTableViewPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TreeTableView<S>> treeTableViewPropertyImpl() {
        if (this.treeTableView == null) {
            this.treeTableView = new ReadOnlyObjectWrapper<TreeTableView<S>>(this, "treeTableView"){
                private WeakReference<TreeTableView<S>> weakTableViewRef;

                @Override
                protected void invalidated() {
                    TreeTableView newTreeTableView;
                    TreeTableView.TreeTableViewFocusModel fm;
                    TreeTableView.TreeTableViewSelectionModel sm;
                    TreeTableView oldTableView;
                    if (this.weakTableViewRef != null && (oldTableView = (TreeTableView)this.weakTableViewRef.get()) != null) {
                        sm = oldTableView.getSelectionModel();
                        if (sm != null) {
                            sm.getSelectedCells().removeListener(TreeTableCell.this.weakSelectedListener);
                        }
                        if ((fm = oldTableView.getFocusModel()) != null) {
                            fm.focusedCellProperty().removeListener(TreeTableCell.this.weakFocusedListener);
                        }
                        oldTableView.editingCellProperty().removeListener(TreeTableCell.this.weakEditingListener);
                        oldTableView.getVisibleLeafColumns().removeListener(TreeTableCell.this.weakVisibleLeafColumnsListener);
                        oldTableView.rootProperty().removeListener(TreeTableCell.this.weakRootPropertyListener);
                    }
                    if ((newTreeTableView = (TreeTableView)this.get()) != null) {
                        sm = newTreeTableView.getSelectionModel();
                        if (sm != null) {
                            sm.getSelectedCells().addListener(TreeTableCell.this.weakSelectedListener);
                        }
                        if ((fm = newTreeTableView.getFocusModel()) != null) {
                            fm.focusedCellProperty().addListener(TreeTableCell.this.weakFocusedListener);
                        }
                        newTreeTableView.editingCellProperty().addListener(TreeTableCell.this.weakEditingListener);
                        newTreeTableView.getVisibleLeafColumns().addListener(TreeTableCell.this.weakVisibleLeafColumnsListener);
                        newTreeTableView.rootProperty().addListener(TreeTableCell.this.weakRootPropertyListener);
                        this.weakTableViewRef = new WeakReference<TreeTableView>(newTreeTableView);
                    }
                    TreeTableCell.this.updateColumnIndex();
                }
            };
        }
        return this.treeTableView;
    }

    private void setTreeTableRow(TreeTableRow<S> value) {
        this.treeTableRow.set(value);
    }

    public final TreeTableRow<S> getTreeTableRow() {
        return (TreeTableRow)this.treeTableRow.get();
    }

    public final ReadOnlyObjectProperty<TreeTableRow<S>> tableRowProperty() {
        return this.treeTableRow;
    }

    @Override
    public void startEdit() {
        if (this.isEditing()) {
            return;
        }
        TreeTableView<S> table = this.getTreeTableView();
        TreeTableColumn<S, T> column = this.getTableColumn();
        if (!this.isEditable() || table != null && !table.isEditable() || column != null && !this.getTableColumn().isEditable()) {
            return;
        }
        if (!this.lockItemOnEdit) {
            this.updateItem(-1);
        }
        super.startEdit();
        if (column != null) {
            TreeTableColumn.CellEditEvent<S, Object> editEvent = new TreeTableColumn.CellEditEvent<S, Object>(table, table.getEditingCell(), TreeTableColumn.editStartEvent(), null);
            Event.fireEvent(column, editEvent);
        }
    }

    @Override
    public void commitEdit(T newValue) {
        if (!this.isEditing()) {
            return;
        }
        TreeTableView table = this.getTreeTableView();
        if (table != null) {
            TreeTablePosition<S, ?> editingCell = table.getEditingCell();
            TreeTableColumn.CellEditEvent editEvent = new TreeTableColumn.CellEditEvent(table, editingCell, TreeTableColumn.editCommitEvent(), newValue);
            Event.fireEvent(this.getTableColumn(), editEvent);
        }
        super.commitEdit(newValue);
        this.updateItem(newValue, false);
        if (table != null) {
            table.edit(-1, null);
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(table);
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        TreeTableView table = this.getTreeTableView();
        super.cancelEdit();
        if (table != null) {
            TreeTablePosition<S, ?> editingCell = table.getEditingCell();
            if (this.updateEditingIndex) {
                table.edit(-1, null);
            }
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(table);
            TreeTableColumn.CellEditEvent<S, Object> editEvent = new TreeTableColumn.CellEditEvent<S, Object>(table, editingCell, TreeTableColumn.editCancelEvent(), null);
            Event.fireEvent(this.getTableColumn(), editEvent);
        }
    }

    @Override
    public void updateSelected(boolean selected) {
        if (this.getTreeTableRow() == null || this.getTreeTableRow().isEmpty()) {
            return;
        }
        this.setSelected(selected);
    }

    @Override
    void indexChanged(int oldIndex, int newIndex) {
        super.indexChanged(oldIndex, newIndex);
        if (!this.isEditing() || newIndex != oldIndex) {
            this.updateItem(oldIndex);
            this.updateSelection();
            this.updateFocus();
            this.updateEditing();
        }
    }

    private void updateColumnIndex() {
        TreeTableView<S> tv = this.getTreeTableView();
        TreeTableColumn<S, T> tc = this.getTableColumn();
        this.columnIndex = tv == null || tc == null ? -1 : tv.getVisibleLeafIndex(tc);
        this.isLastVisibleColumn = this.getTableColumn() != null && this.columnIndex != -1 && this.columnIndex == tv.getVisibleLeafColumns().size() - 1;
        this.pseudoClassStateChanged(PSEUDO_CLASS_LAST_VISIBLE, this.isLastVisibleColumn);
    }

    private void updateSelection() {
        if (this.isEmpty()) {
            return;
        }
        boolean isSelected = this.isSelected();
        if (!this.isInCellSelectionMode()) {
            if (isSelected) {
                this.updateSelected(false);
            }
            return;
        }
        TreeTableView<S> tv = this.getTreeTableView();
        if (this.getIndex() == -1 || tv == null) {
            return;
        }
        TreeTableView.TreeTableViewSelectionModel<S> sm = tv.getSelectionModel();
        if (sm == null) {
            this.updateSelected(false);
            return;
        }
        boolean isSelectedNow = sm.isSelected(this.getIndex(), this.getTableColumn());
        if (isSelected == isSelectedNow) {
            return;
        }
        this.updateSelected(isSelectedNow);
    }

    private void updateFocus() {
        boolean isFocused = this.isFocused();
        if (!this.isInCellSelectionMode()) {
            if (isFocused) {
                this.setFocused(false);
            }
            return;
        }
        TreeTableView<S> tv = this.getTreeTableView();
        if (this.getIndex() == -1 || tv == null) {
            return;
        }
        TreeTableView.TreeTableViewFocusModel<S> fm = tv.getFocusModel();
        if (fm == null) {
            this.setFocused(false);
            return;
        }
        boolean isFocusedNow = fm != null && fm.isFocused(this.getIndex(), this.getTableColumn());
        this.setFocused(isFocusedNow);
    }

    private void updateEditing() {
        TreeTableView<S> tv = this.getTreeTableView();
        if (this.getIndex() == -1 || tv == null) {
            return;
        }
        TreeTablePosition<S, ?> editCell = tv.getEditingCell();
        boolean match = this.match(editCell);
        if (match && !this.isEditing()) {
            this.startEdit();
        } else if (!match && this.isEditing()) {
            this.updateEditingIndex = false;
            this.cancelEdit();
            this.updateEditingIndex = true;
        }
    }

    private boolean match(TreeTablePosition pos) {
        return pos != null && pos.getRow() == this.getIndex() && pos.getTableColumn() == this.getTableColumn();
    }

    private boolean isInCellSelectionMode() {
        TreeTableView<S> tv = this.getTreeTableView();
        if (tv == null) {
            return false;
        }
        TreeTableView.TreeTableViewSelectionModel<S> sm = tv.getSelectionModel();
        return sm != null && sm.isCellSelectionEnabled();
    }

    private void updateItem(int oldIndex) {
        Object rowItem;
        block8: {
            Object newValue;
            block7: {
                Object oldRowItem;
                boolean indexExceedsItemCount;
                if (this.currentObservableValue != null) {
                    this.currentObservableValue.removeListener(this.weaktableRowUpdateObserver);
                }
                TreeTableView<S> tableView = this.getTreeTableView();
                TreeTableColumn<S, T> tableColumn = this.getTableColumn();
                int itemCount = tableView == null ? -1 : this.getTreeTableView().getExpandedItemCount();
                int index = this.getIndex();
                boolean isEmpty = this.isEmpty();
                Object oldValue = this.getItem();
                TreeTableRow<S> tableRow = this.getTreeTableRow();
                rowItem = tableRow == null ? null : (Object)tableRow.getItem();
                boolean bl = indexExceedsItemCount = index >= itemCount;
                if (indexExceedsItemCount || index < 0 || this.columnIndex < 0 || !this.isVisible() || tableColumn == null || !tableColumn.isVisible() || tableView.getRoot() == null) {
                    if (!isEmpty && oldValue != null || this.isFirstRun || indexExceedsItemCount) {
                        this.updateItem(null, true);
                        this.isFirstRun = false;
                    }
                    return;
                }
                this.currentObservableValue = tableColumn.getCellObservableValue(index);
                Object t = newValue = this.currentObservableValue == null ? null : (Object)this.currentObservableValue.getValue();
                if (oldIndex != index || this.isItemChanged(oldValue, newValue)) break block7;
                Object object = oldRowItem = this.oldRowItemRef != null ? (Object)this.oldRowItemRef.get() : null;
                if (oldRowItem != null && oldRowItem.equals(rowItem)) break block8;
            }
            this.updateItem(newValue, false);
        }
        this.oldRowItemRef = new WeakReference<Object>(rowItem);
        if (this.currentObservableValue == null) {
            return;
        }
        this.currentObservableValue.addListener(this.weaktableRowUpdateObserver);
    }

    @Override
    protected void layoutChildren() {
        if (this.itemDirty) {
            this.updateItem(-1);
            this.itemDirty = false;
        }
        super.layoutChildren();
    }

    public final void updateTreeTableView(TreeTableView<S> tv) {
        this.setTreeTableView(tv);
    }

    public final void updateTreeTableRow(TreeTableRow<S> treeTableRow) {
        this.setTreeTableRow(treeTableRow);
    }

    public final void updateTreeTableColumn(TreeTableColumn<S, T> col) {
        TreeTableColumn<S, T> oldCol = this.getTableColumn();
        if (oldCol != null) {
            oldCol.getStyleClass().removeListener(this.weakColumnStyleClassListener);
            this.getStyleClass().removeAll((Collection<?>)oldCol.getStyleClass());
            oldCol.idProperty().removeListener(this.weakColumnIdListener);
            oldCol.styleProperty().removeListener(this.weakColumnStyleListener);
            String id = this.getId();
            String style = this.getStyle();
            if (id != null && id.equals(oldCol.getId())) {
                this.setId(null);
            }
            if (style != null && style.equals(oldCol.getStyle())) {
                this.setStyle("");
            }
        }
        this.setTableColumn(col);
        if (col != null) {
            this.getStyleClass().addAll((Collection<String>)col.getStyleClass());
            col.getStyleClass().addListener(this.weakColumnStyleClassListener);
            col.idProperty().addListener(this.weakColumnIdListener);
            col.styleProperty().addListener(this.weakColumnStyleListener);
            this.possiblySetId(col.getId());
            this.possiblySetStyle(col.getStyle());
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TreeTableCellSkin(this);
    }

    private void possiblySetId(String idCandidate) {
        if (this.getId() == null || this.getId().isEmpty()) {
            this.setId(idCandidate);
        }
    }

    private void possiblySetStyle(String styleCandidate) {
        if (this.getStyle() == null || this.getStyle().isEmpty()) {
            this.setStyle(styleCandidate);
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case ROW_INDEX: {
                return this.getIndex();
            }
            case COLUMN_INDEX: {
                return this.columnIndex;
            }
            case SELECTED: {
                return this.isInCellSelectionMode() ? this.isSelected() : this.getTreeTableRow().isSelected();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case REQUEST_FOCUS: {
                TreeTableView.TreeTableViewFocusModel<S> fm;
                TreeTableView<S> treeTableView = this.getTreeTableView();
                if (treeTableView == null || (fm = treeTableView.getFocusModel()) == null) break;
                fm.focus(this.getIndex(), this.getTableColumn());
                break;
            }
            default: {
                super.executeAccessibleAction(action, parameters);
            }
        }
    }

    /* synthetic */ void lambda$new$110(Observable value) {
        if (this.getTableColumn() != null) {
            this.possiblySetId(this.getTableColumn().getId());
        }
    }

    /* synthetic */ void lambda$new$109(Observable value) {
        if (this.getTableColumn() != null) {
            this.possiblySetStyle(this.getTableColumn().getStyle());
        }
    }

    /* synthetic */ void lambda$new$108(Observable observable) {
        this.updateItem(-1);
    }

    /* synthetic */ void lambda$new$107(ListChangeListener.Change c) {
        while (c.next()) {
            if (c.wasRemoved()) {
                this.getStyleClass().removeAll(c.getRemoved());
            }
            if (!c.wasAdded()) continue;
            this.getStyleClass().addAll(c.getAddedSubList());
        }
    }

    /* synthetic */ void lambda$new$106(ListChangeListener.Change c) {
        this.updateColumnIndex();
    }

    /* synthetic */ void lambda$new$105(Observable value) {
        this.updateEditing();
    }

    /* synthetic */ void lambda$new$104(Observable value) {
        this.itemDirty = true;
        this.requestLayout();
    }

    /* synthetic */ void lambda$new$103(Observable value) {
        this.updateFocus();
    }

    /* synthetic */ void lambda$new$102(ListChangeListener.Change c) {
        while (c.next()) {
            if (!c.wasAdded() && !c.wasRemoved()) continue;
            this.updateSelection();
        }
    }
}

