/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.MappingChange;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import com.sun.javafx.scene.control.SelectedCellsMap;
import com.sun.javafx.scene.control.TableColumnComparatorBase;
import com.sun.javafx.scene.control.behavior.TableCellBehaviorBase;
import com.sun.javafx.scene.control.behavior.TreeTableCellBehavior;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.MultipleSelectionModelBase;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.SortEvent;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableUtil;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeSortMode;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView$$Lambda$1;
import javafx.scene.control.TreeTableView$$Lambda$2;
import javafx.scene.control.TreeTableView$$Lambda$3;
import javafx.scene.control.TreeTableView$$Lambda$4;
import javafx.scene.control.TreeTableView$$Lambda$5;
import javafx.scene.control.TreeTableView$$Lambda$6;
import javafx.scene.control.TreeTableView$$Lambda$7;
import javafx.scene.control.TreeTableView$$Lambda$8;
import javafx.scene.control.TreeTableView$TreeTableViewArrayListSelectionModel$$Lambda$1;
import javafx.scene.control.TreeTableView$TreeTableViewArrayListSelectionModel$$Lambda$2;
import javafx.scene.control.TreeTableView$TreeTableViewArrayListSelectionModel$$Lambda$3;
import javafx.scene.control.TreeTableView$TreeTableViewArrayListSelectionModel$$Lambda$4;
import javafx.scene.control.TreeTableView$TreeTableViewArrayListSelectionModel$$Lambda$5;
import javafx.scene.control.TreeTableView$TreeTableViewArrayListSelectionModel$$Lambda$6;
import javafx.scene.control.TreeTableView$TreeTableViewFocusModel$$Lambda$1;
import javafx.scene.control.TreeTableView$TreeTableViewFocusModel$$Lambda$2;
import javafx.scene.control.TreeTableView$TreeTableViewFocusModel$1$$Lambda$1;
import javafx.scene.control.TreeUtil;
import javafx.scene.control.TreeView;
import javafx.util.Callback;

@DefaultProperty(value="root")
public class TreeTableView<S>
extends Control {
    private static final EventType<?> EDIT_ANY_EVENT = new EventType<Event>(Event.ANY, "TREE_TABLE_VIEW_EDIT");
    private static final EventType<?> EDIT_START_EVENT = new EventType(TreeTableView.editAnyEvent(), "EDIT_START");
    private static final EventType<?> EDIT_CANCEL_EVENT = new EventType(TreeTableView.editAnyEvent(), "EDIT_CANCEL");
    private static final EventType<?> EDIT_COMMIT_EVENT = new EventType(TreeTableView.editAnyEvent(), "EDIT_COMMIT");
    public static final Callback<ResizeFeatures, Boolean> UNCONSTRAINED_RESIZE_POLICY = new Callback<ResizeFeatures, Boolean>(){

        public String toString() {
            return "unconstrained-resize";
        }

        @Override
        public Boolean call(ResizeFeatures prop) {
            double result = TableUtil.resize(prop.getColumn(), prop.getDelta());
            return Double.compare(result, 0.0) == 0;
        }
    };
    public static final Callback<ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY = new Callback<ResizeFeatures, Boolean>(){
        private boolean isFirstRun = true;

        public String toString() {
            return "constrained-resize";
        }

        @Override
        public Boolean call(ResizeFeatures prop) {
            TreeTableView table = prop.getTable();
            ObservableList visibleLeafColumns = table.getVisibleLeafColumns();
            Boolean result = TableUtil.constrainedResize(prop, this.isFirstRun, table.contentWidth, visibleLeafColumns);
            this.isFirstRun = !this.isFirstRun ? false : result == false;
            return result;
        }
    };
    public static final Callback<TreeTableView, Boolean> DEFAULT_SORT_POLICY = new Callback<TreeTableView, Boolean>(){

        @Override
        public Boolean call(TreeTableView table) {
            try {
                TreeItem rootItem = table.getRoot();
                if (rootItem == null) {
                    return false;
                }
                TreeSortMode sortMode = table.getSortMode();
                if (sortMode == null) {
                    return false;
                }
                rootItem.lastSortMode = sortMode;
                rootItem.lastComparator = table.getComparator();
                rootItem.sort();
                return true;
            }
            catch (UnsupportedOperationException e) {
                return false;
            }
        }
    };
    private boolean expandedItemCountDirty = true;
    private Map<Integer, SoftReference<TreeItem<S>>> treeItemCacheMap = new HashMap<Integer, SoftReference<TreeItem<S>>>();
    private final ObservableList<TreeTableColumn<S, ?>> columns = FXCollections.observableArrayList();
    private final ObservableList<TreeTableColumn<S, ?>> visibleLeafColumns = FXCollections.observableArrayList();
    private final ObservableList<TreeTableColumn<S, ?>> unmodifiableVisibleLeafColumns = FXCollections.unmodifiableObservableList(this.visibleLeafColumns);
    private ObservableList<TreeTableColumn<S, ?>> sortOrder = FXCollections.observableArrayList();
    double contentWidth;
    private boolean isInited = false;
    private final EventHandler<TreeItem.TreeModificationEvent<S>> rootEvent = TreeTableView$$Lambda$1.lambdaFactory$(this);
    private final ListChangeListener<TreeTableColumn<S, ?>> columnsObserver = new ListChangeListener<TreeTableColumn<S, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TreeTableColumn<S, ?>> c) {
            ObservableList columns = TreeTableView.this.getColumns();
            while (c.next()) {
                if (!c.wasAdded()) continue;
                ArrayList<Object> duplicates = new ArrayList<Object>();
                for (TreeTableColumn addedColumn : c.getAddedSubList()) {
                    if (addedColumn == null) continue;
                    int n = 0;
                    for (TreeTableColumn treeTableColumn : columns) {
                        if (addedColumn != treeTableColumn) continue;
                        ++n;
                    }
                    if (n <= true) continue;
                    duplicates.add(addedColumn);
                }
                if (duplicates.isEmpty()) continue;
                String titleList = "";
                for (TreeTableColumn treeTableColumn : duplicates) {
                    titleList = titleList + "'" + treeTableColumn.getText() + "', ";
                }
                throw new IllegalStateException("Duplicate TreeTableColumns detected in TreeTableView columns list with titles " + titleList);
            }
            c.reset();
            TreeTableView.this.updateVisibleLeafColumns();
            ArrayList toRemove = new ArrayList();
            while (c.next()) {
                List removed = c.getRemoved();
                List added = c.getAddedSubList();
                if (c.wasRemoved()) {
                    toRemove.addAll(removed);
                    for (TreeTableColumn treeTableColumn : removed) {
                        treeTableColumn.setTreeTableView(null);
                    }
                }
                if (c.wasAdded()) {
                    toRemove.removeAll(added);
                    for (TreeTableColumn treeTableColumn : added) {
                        treeTableColumn.setTreeTableView(TreeTableView.this);
                    }
                }
                TableUtil.removeColumnsListener(removed, TreeTableView.this.weakColumnsObserver);
                TableUtil.addColumnsListener(added, TreeTableView.this.weakColumnsObserver);
                TableUtil.removeTableColumnListener(c.getRemoved(), TreeTableView.this.weakColumnVisibleObserver, TreeTableView.this.weakColumnSortableObserver, TreeTableView.this.weakColumnSortTypeObserver, TreeTableView.this.weakColumnComparatorObserver);
                TableUtil.addTableColumnListener(c.getAddedSubList(), TreeTableView.this.weakColumnVisibleObserver, TreeTableView.this.weakColumnSortableObserver, TreeTableView.this.weakColumnSortTypeObserver, TreeTableView.this.weakColumnComparatorObserver);
            }
            TreeTableView.this.sortOrder.removeAll(toRemove);
            TreeTableViewFocusModel fm = TreeTableView.this.getFocusModel();
            TreeTableViewSelectionModel sm = TreeTableView.this.getSelectionModel();
            c.reset();
            while (c.next()) {
                if (!c.wasRemoved()) continue;
                List list = c.getRemoved();
                if (fm != null) {
                    boolean bl;
                    TreeTablePosition treeTablePosition = fm.getFocusedCell();
                    boolean bl2 = false;
                    for (TreeTableColumn tc : list) {
                        bl = treeTablePosition != null && treeTablePosition.getTableColumn() == tc;
                        if (!bl) continue;
                        break;
                    }
                    if (bl) {
                        int n = TreeTableView.this.lastKnownColumnIndex.getOrDefault(treeTablePosition.getTableColumn(), 0);
                        int newFocusColumnIndex = n == 0 ? 0 : Math.min(TreeTableView.this.getVisibleLeafColumns().size() - 1, n - 1);
                        fm.focus(treeTablePosition.getRow(), TreeTableView.this.getVisibleLeafColumn(newFocusColumnIndex));
                    }
                }
                if (sm == null) continue;
                ArrayList arrayList = new ArrayList(sm.getSelectedCells());
                for (TreeTablePosition treeTablePosition : arrayList) {
                    int matchingColumnIndex;
                    boolean match = false;
                    for (TreeTableColumn tc : list) {
                        match = treeTablePosition != null && treeTablePosition.getTableColumn() == tc;
                        if (!match) continue;
                        break;
                    }
                    if (!match || (matchingColumnIndex = TreeTableView.this.lastKnownColumnIndex.getOrDefault(treeTablePosition.getTableColumn(), -1).intValue()) == -1) continue;
                    if (sm instanceof TreeTableViewArrayListSelectionModel) {
                        TreeTablePosition fixedTablePosition = new TreeTablePosition(TreeTableView.this, treeTablePosition.getRow(), treeTablePosition.getTableColumn());
                        fixedTablePosition.fixedColumnIndex = matchingColumnIndex;
                        ((TreeTableViewArrayListSelectionModel)sm).clearSelection(fixedTablePosition);
                        continue;
                    }
                    sm.clearSelection(treeTablePosition.getRow(), treeTablePosition.getTableColumn());
                }
            }
            TreeTableView.this.lastKnownColumnIndex.clear();
            for (TreeTableColumn treeTableColumn : TreeTableView.this.getColumns()) {
                int n = TreeTableView.this.getVisibleLeafIndex(treeTableColumn);
                if (n <= -1) continue;
                TreeTableView.this.lastKnownColumnIndex.put(treeTableColumn, n);
            }
        }
    };
    private final WeakHashMap<TreeTableColumn<S, ?>, Integer> lastKnownColumnIndex = new WeakHashMap();
    private final InvalidationListener columnVisibleObserver = TreeTableView$$Lambda$2.lambdaFactory$(this);
    private final InvalidationListener columnSortableObserver = TreeTableView$$Lambda$3.lambdaFactory$(this);
    private final InvalidationListener columnSortTypeObserver = TreeTableView$$Lambda$4.lambdaFactory$(this);
    private final InvalidationListener columnComparatorObserver = TreeTableView$$Lambda$5.lambdaFactory$(this);
    private final InvalidationListener cellSelectionModelInvalidationListener = TreeTableView$$Lambda$6.lambdaFactory$(this);
    private WeakEventHandler<TreeItem.TreeModificationEvent<S>> weakRootEventListener;
    private final WeakInvalidationListener weakColumnVisibleObserver = new WeakInvalidationListener(this.columnVisibleObserver);
    private final WeakInvalidationListener weakColumnSortableObserver = new WeakInvalidationListener(this.columnSortableObserver);
    private final WeakInvalidationListener weakColumnSortTypeObserver = new WeakInvalidationListener(this.columnSortTypeObserver);
    private final WeakInvalidationListener weakColumnComparatorObserver = new WeakInvalidationListener(this.columnComparatorObserver);
    private final WeakListChangeListener<TreeTableColumn<S, ?>> weakColumnsObserver = new WeakListChangeListener(this.columnsObserver);
    private final WeakInvalidationListener weakCellSelectionModelInvalidationListener = new WeakInvalidationListener(this.cellSelectionModelInvalidationListener);
    private ObjectProperty<TreeItem<S>> root = new SimpleObjectProperty<TreeItem<S>>(this, "root"){
        private WeakReference<TreeItem<S>> weakOldItem;

        @Override
        protected void invalidated() {
            TreeItem root;
            TreeItem oldTreeItem;
            TreeItem treeItem = oldTreeItem = this.weakOldItem == null ? null : (TreeItem)this.weakOldItem.get();
            if (oldTreeItem != null && TreeTableView.this.weakRootEventListener != null) {
                oldTreeItem.removeEventHandler(TreeItem.treeNotificationEvent(), TreeTableView.this.weakRootEventListener);
            }
            if ((root = TreeTableView.this.getRoot()) != null) {
                TreeTableView.this.weakRootEventListener = new WeakEventHandler(TreeTableView.this.rootEvent);
                TreeTableView.this.getRoot().addEventHandler(TreeItem.treeNotificationEvent(), TreeTableView.this.weakRootEventListener);
                this.weakOldItem = new WeakReference(root);
            }
            TreeTableView.this.getSortOrder().clear();
            TreeTableView.this.expandedItemCountDirty = true;
            TreeTableView.this.updateRootExpanded();
        }
    };
    private BooleanProperty showRoot;
    private ObjectProperty<TreeTableColumn<S, ?>> treeColumn;
    private ObjectProperty<TreeTableViewSelectionModel<S>> selectionModel;
    private ObjectProperty<TreeTableViewFocusModel<S>> focusModel;
    private ReadOnlyIntegerWrapper expandedItemCount = new ReadOnlyIntegerWrapper(this, "expandedItemCount", 0);
    private BooleanProperty editable;
    private ReadOnlyObjectWrapper<TreeTablePosition<S, ?>> editingCell;
    private BooleanProperty tableMenuButtonVisible;
    private ObjectProperty<Callback<ResizeFeatures, Boolean>> columnResizePolicy;
    private ObjectProperty<Callback<TreeTableView<S>, TreeTableRow<S>>> rowFactory;
    private ObjectProperty<Node> placeholder;
    private DoubleProperty fixedCellSize;
    private ObjectProperty<TreeSortMode> sortMode;
    private ReadOnlyObjectWrapper<Comparator<TreeItem<S>>> comparator;
    private ObjectProperty<Callback<TreeTableView<S>, Boolean>> sortPolicy;
    private ObjectProperty<EventHandler<SortEvent<TreeTableView<S>>>> onSort;
    private ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollTo;
    private ObjectProperty<EventHandler<ScrollToEvent<TreeTableColumn<S, ?>>>> onScrollToColumn;
    private boolean sortLock = false;
    private TableUtil.SortEventType lastSortEventType = null;
    private Object[] lastSortEventSupportInfo = null;
    private static final String DEFAULT_STYLE_CLASS = "tree-table-view";
    private static final PseudoClass PSEUDO_CLASS_CELL_SELECTION = PseudoClass.getPseudoClass("cell-selection");
    private static final PseudoClass PSEUDO_CLASS_ROW_SELECTION = PseudoClass.getPseudoClass("row-selection");

    public TreeTableView() {
        this(null);
    }

    public TreeTableView(TreeItem<S> root) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TREE_TABLE_VIEW);
        this.setRoot(root);
        this.updateExpandedItemCount(root);
        this.setSelectionModel(new TreeTableViewArrayListSelectionModel(this));
        this.setFocusModel(new TreeTableViewFocusModel(this));
        this.getColumns().addListener(this.weakColumnsObserver);
        this.getSortOrder().addListener(TreeTableView$$Lambda$7.lambdaFactory$(this));
        this.getProperties().addListener(TreeTableView$$Lambda$8.lambdaFactory$(this));
        this.isInited = true;
    }

    public static <S> EventType<EditEvent<S>> editAnyEvent() {
        return EDIT_ANY_EVENT;
    }

    public static <S> EventType<EditEvent<S>> editStartEvent() {
        return EDIT_START_EVENT;
    }

    public static <S> EventType<EditEvent<S>> editCancelEvent() {
        return EDIT_CANCEL_EVENT;
    }

    public static <S> EventType<EditEvent<S>> editCommitEvent() {
        return EDIT_COMMIT_EVENT;
    }

    @Deprecated
    public static int getNodeLevel(TreeItem<?> node) {
        return TreeView.getNodeLevel(node);
    }

    public final void setRoot(TreeItem<S> value) {
        this.rootProperty().set(value);
    }

    public final TreeItem<S> getRoot() {
        return this.root == null ? null : (TreeItem)this.root.get();
    }

    public final ObjectProperty<TreeItem<S>> rootProperty() {
        return this.root;
    }

    public final void setShowRoot(boolean value) {
        this.showRootProperty().set(value);
    }

    public final boolean isShowRoot() {
        return this.showRoot == null ? true : this.showRoot.get();
    }

    public final BooleanProperty showRootProperty() {
        if (this.showRoot == null) {
            this.showRoot = new SimpleBooleanProperty(this, "showRoot", true){

                @Override
                protected void invalidated() {
                    TreeTableView.this.updateRootExpanded();
                    TreeTableView.this.updateExpandedItemCount(TreeTableView.this.getRoot());
                }
            };
        }
        return this.showRoot;
    }

    public final ObjectProperty<TreeTableColumn<S, ?>> treeColumnProperty() {
        if (this.treeColumn == null) {
            this.treeColumn = new SimpleObjectProperty<Object>(this, "treeColumn", null);
        }
        return this.treeColumn;
    }

    public final void setTreeColumn(TreeTableColumn<S, ?> value) {
        this.treeColumnProperty().set(value);
    }

    public final TreeTableColumn<S, ?> getTreeColumn() {
        return this.treeColumn == null ? null : (TreeTableColumn)this.treeColumn.get();
    }

    public final void setSelectionModel(TreeTableViewSelectionModel<S> value) {
        this.selectionModelProperty().set(value);
    }

    public final TreeTableViewSelectionModel<S> getSelectionModel() {
        return this.selectionModel == null ? null : (TreeTableViewSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<TreeTableViewSelectionModel<S>> selectionModelProperty() {
        if (this.selectionModel == null) {
            this.selectionModel = new SimpleObjectProperty<TreeTableViewSelectionModel<S>>(this, "selectionModel"){
                TreeTableViewSelectionModel<S> oldValue;
                {
                    this.oldValue = null;
                }

                @Override
                protected void invalidated() {
                    if (this.oldValue != null) {
                        this.oldValue.cellSelectionEnabledProperty().removeListener(TreeTableView.this.weakCellSelectionModelInvalidationListener);
                    }
                    this.oldValue = (TreeTableViewSelectionModel)this.get();
                    if (this.oldValue != null) {
                        this.oldValue.cellSelectionEnabledProperty().addListener(TreeTableView.this.weakCellSelectionModelInvalidationListener);
                        TreeTableView.this.weakCellSelectionModelInvalidationListener.invalidated(this.oldValue.cellSelectionEnabledProperty());
                    }
                }
            };
        }
        return this.selectionModel;
    }

    public final void setFocusModel(TreeTableViewFocusModel<S> value) {
        this.focusModelProperty().set(value);
    }

    public final TreeTableViewFocusModel<S> getFocusModel() {
        return this.focusModel == null ? null : (TreeTableViewFocusModel)this.focusModel.get();
    }

    public final ObjectProperty<TreeTableViewFocusModel<S>> focusModelProperty() {
        if (this.focusModel == null) {
            this.focusModel = new SimpleObjectProperty<TreeTableViewFocusModel<S>>(this, "focusModel");
        }
        return this.focusModel;
    }

    public final ReadOnlyIntegerProperty expandedItemCountProperty() {
        return this.expandedItemCount.getReadOnlyProperty();
    }

    private void setExpandedItemCount(int value) {
        this.expandedItemCount.set(value);
    }

    public final int getExpandedItemCount() {
        if (this.expandedItemCountDirty) {
            this.updateExpandedItemCount(this.getRoot());
        }
        return this.expandedItemCount.get();
    }

    public final void setEditable(boolean value) {
        this.editableProperty().set(value);
    }

    public final boolean isEditable() {
        return this.editable == null ? false : this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", false);
        }
        return this.editable;
    }

    private void setEditingCell(TreeTablePosition<S, ?> value) {
        this.editingCellPropertyImpl().set(value);
    }

    public final TreeTablePosition<S, ?> getEditingCell() {
        return this.editingCell == null ? null : (TreeTablePosition)this.editingCell.get();
    }

    public final ReadOnlyObjectProperty<TreeTablePosition<S, ?>> editingCellProperty() {
        return this.editingCellPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TreeTablePosition<S, ?>> editingCellPropertyImpl() {
        if (this.editingCell == null) {
            this.editingCell = new ReadOnlyObjectWrapper(this, "editingCell");
        }
        return this.editingCell;
    }

    public final BooleanProperty tableMenuButtonVisibleProperty() {
        if (this.tableMenuButtonVisible == null) {
            this.tableMenuButtonVisible = new SimpleBooleanProperty(this, "tableMenuButtonVisible");
        }
        return this.tableMenuButtonVisible;
    }

    public final void setTableMenuButtonVisible(boolean value) {
        this.tableMenuButtonVisibleProperty().set(value);
    }

    public final boolean isTableMenuButtonVisible() {
        return this.tableMenuButtonVisible == null ? false : this.tableMenuButtonVisible.get();
    }

    public final void setColumnResizePolicy(Callback<ResizeFeatures, Boolean> callback) {
        this.columnResizePolicyProperty().set(callback);
    }

    public final Callback<ResizeFeatures, Boolean> getColumnResizePolicy() {
        return this.columnResizePolicy == null ? UNCONSTRAINED_RESIZE_POLICY : (Callback)this.columnResizePolicy.get();
    }

    public final ObjectProperty<Callback<ResizeFeatures, Boolean>> columnResizePolicyProperty() {
        if (this.columnResizePolicy == null) {
            this.columnResizePolicy = new SimpleObjectProperty<Callback<ResizeFeatures, Boolean>>((Object)this, "columnResizePolicy", UNCONSTRAINED_RESIZE_POLICY){
                private Callback<ResizeFeatures, Boolean> oldPolicy;

                @Override
                protected void invalidated() {
                    if (TreeTableView.this.isInited) {
                        PseudoClass state;
                        ((Callback)this.get()).call(new ResizeFeatures(TreeTableView.this, null, 0.0));
                        if (this.oldPolicy != null) {
                            state = PseudoClass.getPseudoClass(this.oldPolicy.toString());
                            TreeTableView.this.pseudoClassStateChanged(state, false);
                        }
                        if (this.get() != null) {
                            state = PseudoClass.getPseudoClass(((Callback)this.get()).toString());
                            TreeTableView.this.pseudoClassStateChanged(state, true);
                        }
                        this.oldPolicy = (Callback)this.get();
                    }
                }
            };
        }
        return this.columnResizePolicy;
    }

    public final ObjectProperty<Callback<TreeTableView<S>, TreeTableRow<S>>> rowFactoryProperty() {
        if (this.rowFactory == null) {
            this.rowFactory = new SimpleObjectProperty<Callback<TreeTableView<S>, TreeTableRow<S>>>(this, "rowFactory");
        }
        return this.rowFactory;
    }

    public final void setRowFactory(Callback<TreeTableView<S>, TreeTableRow<S>> value) {
        this.rowFactoryProperty().set(value);
    }

    public final Callback<TreeTableView<S>, TreeTableRow<S>> getRowFactory() {
        return this.rowFactory == null ? null : (Callback)this.rowFactory.get();
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty<Node>(this, "placeholder");
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node value) {
        this.placeholderProperty().set(value);
    }

    public final Node getPlaceholder() {
        return this.placeholder == null ? null : (Node)this.placeholder.get();
    }

    public final void setFixedCellSize(double value) {
        this.fixedCellSizeProperty().set(value);
    }

    public final double getFixedCellSize() {
        return this.fixedCellSize == null ? -1.0 : this.fixedCellSize.get();
    }

    public final DoubleProperty fixedCellSizeProperty() {
        if (this.fixedCellSize == null) {
            this.fixedCellSize = new StyleableDoubleProperty(-1.0){

                @Override
                public CssMetaData<TreeTableView<?>, Number> getCssMetaData() {
                    return StyleableProperties.FIXED_CELL_SIZE;
                }

                @Override
                public Object getBean() {
                    return TreeTableView.this;
                }

                @Override
                public String getName() {
                    return "fixedCellSize";
                }
            };
        }
        return this.fixedCellSize;
    }

    public final ObjectProperty<TreeSortMode> sortModeProperty() {
        if (this.sortMode == null) {
            this.sortMode = new SimpleObjectProperty<TreeSortMode>(this, "sortMode", TreeSortMode.ALL_DESCENDANTS);
        }
        return this.sortMode;
    }

    public final void setSortMode(TreeSortMode value) {
        this.sortModeProperty().set(value);
    }

    public final TreeSortMode getSortMode() {
        return this.sortMode == null ? TreeSortMode.ALL_DESCENDANTS : (TreeSortMode)((Object)this.sortMode.get());
    }

    private void setComparator(Comparator<TreeItem<S>> value) {
        this.comparatorPropertyImpl().set(value);
    }

    public final Comparator<TreeItem<S>> getComparator() {
        return this.comparator == null ? null : (Comparator)this.comparator.get();
    }

    public final ReadOnlyObjectProperty<Comparator<TreeItem<S>>> comparatorProperty() {
        return this.comparatorPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Comparator<TreeItem<S>>> comparatorPropertyImpl() {
        if (this.comparator == null) {
            this.comparator = new ReadOnlyObjectWrapper(this, "comparator");
        }
        return this.comparator;
    }

    public final void setSortPolicy(Callback<TreeTableView<S>, Boolean> callback) {
        this.sortPolicyProperty().set(callback);
    }

    public final Callback<TreeTableView<S>, Boolean> getSortPolicy() {
        return this.sortPolicy == null ? DEFAULT_SORT_POLICY : (Callback)this.sortPolicy.get();
    }

    public final ObjectProperty<Callback<TreeTableView<S>, Boolean>> sortPolicyProperty() {
        if (this.sortPolicy == null) {
            this.sortPolicy = new SimpleObjectProperty<Callback<TreeTableView<S>, Boolean>>(this, "sortPolicy", DEFAULT_SORT_POLICY){

                @Override
                protected void invalidated() {
                    TreeTableView.this.sort();
                }
            };
        }
        return this.sortPolicy;
    }

    public void setOnSort(EventHandler<SortEvent<TreeTableView<S>>> value) {
        this.onSortProperty().set(value);
    }

    public EventHandler<SortEvent<TreeTableView<S>>> getOnSort() {
        if (this.onSort != null) {
            return (EventHandler)this.onSort.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<SortEvent<TreeTableView<S>>>> onSortProperty() {
        if (this.onSort == null) {
            this.onSort = new ObjectPropertyBase<EventHandler<SortEvent<TreeTableView<S>>>>(){

                @Override
                protected void invalidated() {
                    EventType eventType = SortEvent.sortEvent();
                    EventHandler eventHandler = (EventHandler)this.get();
                    TreeTableView.this.setEventHandler(eventType, eventHandler);
                }

                @Override
                public Object getBean() {
                    return TreeTableView.this;
                }

                @Override
                public String getName() {
                    return "onSort";
                }
            };
        }
        return this.onSort;
    }

    @Override
    protected void layoutChildren() {
        if (this.expandedItemCountDirty) {
            this.updateExpandedItemCount(this.getRoot());
        }
        super.layoutChildren();
    }

    public void scrollTo(int index) {
        ControlUtils.scrollToIndex(this, index);
    }

    public void setOnScrollTo(EventHandler<ScrollToEvent<Integer>> value) {
        this.onScrollToProperty().set(value);
    }

    public EventHandler<ScrollToEvent<Integer>> getOnScrollTo() {
        if (this.onScrollTo != null) {
            return (EventHandler)this.onScrollTo.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollToProperty() {
        if (this.onScrollTo == null) {
            this.onScrollTo = new ObjectPropertyBase<EventHandler<ScrollToEvent<Integer>>>(){

                @Override
                protected void invalidated() {
                    TreeTableView.this.setEventHandler(ScrollToEvent.scrollToTopIndex(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return TreeTableView.this;
                }

                @Override
                public String getName() {
                    return "onScrollTo";
                }
            };
        }
        return this.onScrollTo;
    }

    public void scrollToColumn(TreeTableColumn<S, ?> column) {
        ControlUtils.scrollToColumn(this, column);
    }

    public void scrollToColumnIndex(int columnIndex) {
        if (this.getColumns() != null) {
            ControlUtils.scrollToColumn(this, (TableColumnBase)this.getColumns().get(columnIndex));
        }
    }

    public void setOnScrollToColumn(EventHandler<ScrollToEvent<TreeTableColumn<S, ?>>> value) {
        this.onScrollToColumnProperty().set(value);
    }

    public EventHandler<ScrollToEvent<TreeTableColumn<S, ?>>> getOnScrollToColumn() {
        if (this.onScrollToColumn != null) {
            return (EventHandler)this.onScrollToColumn.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<ScrollToEvent<TreeTableColumn<S, ?>>>> onScrollToColumnProperty() {
        if (this.onScrollToColumn == null) {
            this.onScrollToColumn = new ObjectPropertyBase<EventHandler<ScrollToEvent<TreeTableColumn<S, ?>>>>(){

                @Override
                protected void invalidated() {
                    EventType type = ScrollToEvent.scrollToColumn();
                    TreeTableView.this.setEventHandler(type, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return TreeTableView.this;
                }

                @Override
                public String getName() {
                    return "onScrollToColumn";
                }
            };
        }
        return this.onScrollToColumn;
    }

    public int getRow(TreeItem<S> item) {
        return TreeUtil.getRow(item, this.getRoot(), this.expandedItemCountDirty, this.isShowRoot());
    }

    public TreeItem<S> getTreeItem(int row) {
        SoftReference<TreeItem<S>> treeItemRef;
        TreeItem<S> treeItem;
        int _row;
        if (row < 0) {
            return null;
        }
        int n = _row = this.isShowRoot() ? row : row + 1;
        if (this.expandedItemCountDirty) {
            this.updateExpandedItemCount(this.getRoot());
        } else if (this.treeItemCacheMap.containsKey(_row) && (treeItem = (treeItemRef = this.treeItemCacheMap.get(_row)).get()) != null) {
            return treeItem;
        }
        TreeItem<S> treeItem2 = TreeUtil.getItem(this.getRoot(), _row, this.expandedItemCountDirty);
        this.treeItemCacheMap.put(_row, new SoftReference<TreeItem<S>>(treeItem2));
        return treeItem2;
    }

    public int getTreeItemLevel(TreeItem<?> node) {
        TreeItem<S> root = this.getRoot();
        if (node == null) {
            return -1;
        }
        if (node == root) {
            return 0;
        }
        int level = 0;
        for (TreeItem<?> parent = node.getParent(); parent != null; parent = parent.getParent()) {
            ++level;
            if (parent == root) break;
        }
        return level;
    }

    public final ObservableList<TreeTableColumn<S, ?>> getColumns() {
        return this.columns;
    }

    public final ObservableList<TreeTableColumn<S, ?>> getSortOrder() {
        return this.sortOrder;
    }

    public boolean resizeColumn(TreeTableColumn<S, ?> column, double delta) {
        if (column == null || Double.compare(delta, 0.0) == 0) {
            return false;
        }
        boolean allowed = this.getColumnResizePolicy().call(new ResizeFeatures<S>(this, column, delta));
        return allowed;
    }

    public void edit(int row, TreeTableColumn<S, ?> column) {
        if (!this.isEditable() || column != null && !column.isEditable()) {
            return;
        }
        if (row < 0 && column == null) {
            this.setEditingCell(null);
        } else {
            this.setEditingCell(new TreeTablePosition(this, row, column));
        }
    }

    public ObservableList<TreeTableColumn<S, ?>> getVisibleLeafColumns() {
        return this.unmodifiableVisibleLeafColumns;
    }

    public int getVisibleLeafIndex(TreeTableColumn<S, ?> column) {
        return this.getVisibleLeafColumns().indexOf(column);
    }

    public TreeTableColumn<S, ?> getVisibleLeafColumn(int column) {
        if (column < 0 || column >= this.visibleLeafColumns.size()) {
            return null;
        }
        return (TreeTableColumn)this.visibleLeafColumns.get(column);
    }

    public void sort() {
        ObservableList sortOrder = this.getSortOrder();
        Comparator<TreeItem<S>> oldComparator = this.getComparator();
        this.setComparator(sortOrder.isEmpty() ? null : new TableColumnComparatorBase.TreeTableColumnComparator(sortOrder));
        SortEvent<TreeTableView> sortEvent = new SortEvent<TreeTableView>(this, this);
        this.fireEvent(sortEvent);
        if (sortEvent.isConsumed()) {
            return;
        }
        ArrayList prevState = new ArrayList(this.getSelectionModel().getSelectedCells());
        int itemCount = prevState.size();
        this.getSelectionModel().startAtomic();
        Callback<TreeTableView<S>, Boolean> sortPolicy = this.getSortPolicy();
        if (sortPolicy == null) {
            return;
        }
        Boolean success = sortPolicy.call(this);
        this.getSelectionModel().stopAtomic();
        if (success == null || !success.booleanValue()) {
            this.sortLock = true;
            TableUtil.handleSortFailure(sortOrder, this.lastSortEventType, this.lastSortEventSupportInfo);
            this.setComparator(oldComparator);
            this.sortLock = false;
        } else if (this.getSelectionModel() instanceof TreeTableViewArrayListSelectionModel) {
            TreeTableViewArrayListSelectionModel sm = (TreeTableViewArrayListSelectionModel)this.getSelectionModel();
            ObservableList newState = sm.getSelectedCells();
            ArrayList<TreeTablePosition> removed = new ArrayList<TreeTablePosition>();
            for (int i = 0; i < itemCount; ++i) {
                TreeTablePosition prevItem = (TreeTablePosition)prevState.get(i);
                if (newState.contains(prevItem)) continue;
                removed.add(prevItem);
            }
            if (!removed.isEmpty()) {
                NonIterableChange.GenericAddRemoveChange c = new NonIterableChange.GenericAddRemoveChange(0, itemCount, removed, newState);
                sm.handleSelectedCellsListChangeEvent(c);
            }
        }
    }

    public void refresh() {
        this.getProperties().put("tableRecreateKey", Boolean.TRUE);
    }

    private void doSort(TableUtil.SortEventType sortEventType, Object ... supportInfo) {
        if (this.sortLock) {
            return;
        }
        this.lastSortEventType = sortEventType;
        this.lastSortEventSupportInfo = supportInfo;
        this.sort();
        this.lastSortEventType = null;
        this.lastSortEventSupportInfo = null;
    }

    private void updateExpandedItemCount(TreeItem<S> treeItem) {
        this.setExpandedItemCount(TreeUtil.updateExpandedItemCount(treeItem, this.expandedItemCountDirty, this.isShowRoot()));
        if (this.expandedItemCountDirty) {
            this.treeItemCacheMap.clear();
        }
        this.expandedItemCountDirty = false;
    }

    private void updateRootExpanded() {
        if (!this.isShowRoot() && this.getRoot() != null && !this.getRoot().isExpanded()) {
            this.getRoot().setExpanded(true);
        }
    }

    private void setContentWidth(double contentWidth) {
        this.contentWidth = contentWidth;
        if (this.isInited) {
            this.getColumnResizePolicy().call(new ResizeFeatures(this, null, 0.0));
        }
    }

    private void updateVisibleLeafColumns() {
        ArrayList cols = new ArrayList();
        this.buildVisibleLeafColumns(this.getColumns(), cols);
        this.visibleLeafColumns.setAll(cols);
        this.getColumnResizePolicy().call(new ResizeFeatures(this, null, 0.0));
    }

    private void buildVisibleLeafColumns(List<TreeTableColumn<S, ?>> cols, List<TreeTableColumn<S, ?>> vlc) {
        for (TreeTableColumn<S, ?> c : cols) {
            boolean hasChildren;
            if (c == null) continue;
            boolean bl = hasChildren = !c.getColumns().isEmpty();
            if (hasChildren) {
                this.buildVisibleLeafColumns(c.getColumns(), vlc);
                continue;
            }
            if (!c.isVisible()) continue;
            vlc.add(c);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TreeTableView.getClassCssMetaData();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TreeTableViewSkin(this);
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case ROW_COUNT: {
                return this.getExpandedItemCount();
            }
            case COLUMN_COUNT: {
                return this.getVisibleLeafColumns().size();
            }
            case SELECTED_ITEMS: {
                ObservableList rows = (ObservableList)super.queryAccessibleAttribute(attribute, parameters);
                ArrayList selection = new ArrayList();
                for (TreeTableRow row : rows) {
                    ObservableList cells = (ObservableList)row.queryAccessibleAttribute(attribute, parameters);
                    if (cells == null) continue;
                    selection.addAll(cells);
                }
                return FXCollections.observableArrayList(selection);
            }
            case FOCUS_ITEM: {
                Node row = (Node)super.queryAccessibleAttribute(attribute, parameters);
                if (row == null) {
                    return null;
                }
                Node cell = (Node)row.queryAccessibleAttribute(attribute, parameters);
                return cell != null ? cell : row;
            }
            case CELL_AT_ROW_COLUMN: {
                TreeTableRow row = (TreeTableRow)super.queryAccessibleAttribute(attribute, parameters);
                return row != null ? row.queryAccessibleAttribute(attribute, parameters) : null;
            }
            case MULTIPLE_SELECTION: {
                TreeTableViewSelectionModel<S> sm = this.getSelectionModel();
                return sm != null && sm.getSelectionMode() == SelectionMode.MULTIPLE;
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    /* synthetic */ void lambda$new$121(Observable o) {
        boolean isCellSelection = ((BooleanProperty)o).get();
        this.pseudoClassStateChanged(PSEUDO_CLASS_CELL_SELECTION, isCellSelection);
        this.pseudoClassStateChanged(PSEUDO_CLASS_ROW_SELECTION, !isCellSelection);
    }

    /* synthetic */ void lambda$new$120(Observable valueModel) {
        TreeTableColumn col = (TreeTableColumn)((SimpleObjectProperty)valueModel).getBean();
        if (!this.getSortOrder().contains(col)) {
            return;
        }
        this.doSort(TableUtil.SortEventType.COLUMN_COMPARATOR_CHANGE, col);
    }

    /* synthetic */ void lambda$new$119(Observable valueModel) {
        TreeTableColumn col = (TreeTableColumn)((ObjectProperty)valueModel).getBean();
        if (!this.getSortOrder().contains(col)) {
            return;
        }
        this.doSort(TableUtil.SortEventType.COLUMN_SORT_TYPE_CHANGE, col);
    }

    /* synthetic */ void lambda$new$118(Observable valueModel) {
        TreeTableColumn col = (TreeTableColumn)((BooleanProperty)valueModel).getBean();
        if (!this.getSortOrder().contains(col)) {
            return;
        }
        this.doSort(TableUtil.SortEventType.COLUMN_SORTABLE_CHANGE, col);
    }

    /* synthetic */ void lambda$new$117(Observable valueModel) {
        this.updateVisibleLeafColumns();
    }

    /* synthetic */ void lambda$new$116(TreeItem.TreeModificationEvent e) {
        boolean match = false;
        for (EventType<? extends Event> eventType = e.getEventType(); eventType != null; eventType = eventType.getSuperType()) {
            if (!eventType.equals(TreeItem.expandedItemCountChangeEvent())) continue;
            match = true;
            break;
        }
        if (match) {
            this.expandedItemCountDirty = true;
            this.requestLayout();
        }
    }

    /* synthetic */ void lambda$new$115(MapChangeListener.Change c) {
        if (c.wasAdded() && "TableView.contentWidth".equals(c.getKey())) {
            if (c.getValueAdded() instanceof Number) {
                this.setContentWidth((Double)c.getValueAdded());
            }
            this.getProperties().remove("TableView.contentWidth");
        }
    }

    /* synthetic */ void lambda$new$114(ListChangeListener.Change c) {
        this.doSort(TableUtil.SortEventType.SORT_ORDER_CHANGE, c);
    }

    static /* synthetic */ EventType access$2300() {
        return EDIT_ANY_EVENT;
    }

    public static class TreeTableViewFocusModel<S>
    extends TableFocusModel<TreeItem<S>, TreeTableColumn<S, ?>> {
        private final TreeTableView<S> treeTableView;
        private final TreeTablePosition EMPTY_CELL;
        private final ChangeListener<TreeItem<S>> rootPropertyListener = TreeTableView$TreeTableViewFocusModel$$Lambda$1.lambdaFactory$(this);
        private final WeakChangeListener<TreeItem<S>> weakRootPropertyListener = new WeakChangeListener<TreeItem<S>>(this.rootPropertyListener);
        private EventHandler<TreeItem.TreeModificationEvent<S>> treeItemListener = new EventHandler<TreeItem.TreeModificationEvent<S>>(){

            @Override
            public void handle(TreeItem.TreeModificationEvent<S> e) {
                TreeTablePosition focusedCell;
                int newFocus;
                if (TreeTableViewFocusModel.this.getFocusedIndex() == -1) {
                    return;
                }
                int shift = 0;
                if (e.getChange() != null) {
                    e.getChange().next();
                }
                do {
                    int row = TreeTableViewFocusModel.this.treeTableView.getRow(e.getTreeItem());
                    if (e.wasExpanded()) {
                        if (row >= TreeTableViewFocusModel.this.getFocusedIndex()) continue;
                        shift += e.getTreeItem().getExpandedDescendentCount(false) - 1;
                        continue;
                    }
                    if (e.wasCollapsed()) {
                        if (row >= TreeTableViewFocusModel.this.getFocusedIndex()) continue;
                        shift += -e.getTreeItem().previousExpandedDescendentCount + 1;
                        continue;
                    }
                    if (e.wasAdded()) {
                        TreeItem eventTreeItem = e.getTreeItem();
                        if (!eventTreeItem.isExpanded()) continue;
                        for (int i = 0; i < e.getAddedChildren().size(); ++i) {
                            TreeItem item = e.getAddedChildren().get(i);
                            row = TreeTableViewFocusModel.this.treeTableView.getRow(item);
                            if (item == null || row > TreeTableViewFocusModel.this.getFocusedIndex()) continue;
                            shift += item.getExpandedDescendentCount(false);
                        }
                    } else {
                        if (!e.wasRemoved()) continue;
                        row += e.getFrom() + 1;
                        for (int i = 0; i < e.getRemovedChildren().size(); ++i) {
                            TreeItem item = e.getRemovedChildren().get(i);
                            if (item == null || !item.equals(TreeTableViewFocusModel.this.getFocusedItem())) continue;
                            TreeTableViewFocusModel.this.focus(Math.max(0, TreeTableViewFocusModel.this.getFocusedIndex() - 1));
                            return;
                        }
                        if (row > TreeTableViewFocusModel.this.getFocusedIndex()) continue;
                        shift += e.getTreeItem().isExpanded() ? -e.getRemovedSize() : 0;
                    }
                } while (e.getChange() != null && e.getChange().next());
                if (shift != 0 && (newFocus = (focusedCell = TreeTableViewFocusModel.this.getFocusedCell()).getRow() + shift) >= 0) {
                    Platform.runLater(TreeTableView$TreeTableViewFocusModel$1$$Lambda$1.lambdaFactory$(this, newFocus, focusedCell));
                }
            }

            /* synthetic */ void lambda$handle$130(int n, TreeTablePosition treeTablePosition) {
                TreeTableViewFocusModel.this.focus(n, treeTablePosition.getTableColumn());
            }
        };
        private WeakEventHandler<TreeItem.TreeModificationEvent<S>> weakTreeItemListener;
        private ReadOnlyObjectWrapper<TreeTablePosition<S, ?>> focusedCell;

        public TreeTableViewFocusModel(TreeTableView<S> treeTableView) {
            if (treeTableView == null) {
                throw new NullPointerException("TableView can not be null");
            }
            this.treeTableView = treeTableView;
            this.EMPTY_CELL = new TreeTablePosition(treeTableView, -1, null);
            this.treeTableView.rootProperty().addListener(this.weakRootPropertyListener);
            this.updateTreeEventListener(null, treeTableView.getRoot());
            int focusRow = this.getItemCount() > 0 ? 0 : -1;
            TreeTablePosition pos = new TreeTablePosition(treeTableView, focusRow, null);
            this.setFocusedCell(pos);
            treeTableView.showRootProperty().addListener(TreeTableView$TreeTableViewFocusModel$$Lambda$2.lambdaFactory$(this));
        }

        private void updateTreeEventListener(TreeItem<S> oldRoot, TreeItem<S> newRoot) {
            if (oldRoot != null && this.weakTreeItemListener != null) {
                oldRoot.removeEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
            }
            if (newRoot != null) {
                this.weakTreeItemListener = new WeakEventHandler<TreeItem.TreeModificationEvent<S>>(this.treeItemListener);
                newRoot.addEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
            }
        }

        @Override
        protected int getItemCount() {
            return this.treeTableView.getExpandedItemCount();
        }

        @Override
        protected TreeItem<S> getModelItem(int index) {
            if (index < 0 || index >= this.getItemCount()) {
                return null;
            }
            return this.treeTableView.getTreeItem(index);
        }

        public final ReadOnlyObjectProperty<TreeTablePosition<S, ?>> focusedCellProperty() {
            return this.focusedCellPropertyImpl().getReadOnlyProperty();
        }

        private void setFocusedCell(TreeTablePosition<S, ?> value) {
            this.focusedCellPropertyImpl().set(value);
        }

        public final TreeTablePosition<S, ?> getFocusedCell() {
            return this.focusedCell == null ? this.EMPTY_CELL : (TreeTablePosition)this.focusedCell.get();
        }

        private ReadOnlyObjectWrapper<TreeTablePosition<S, ?>> focusedCellPropertyImpl() {
            if (this.focusedCell == null) {
                this.focusedCell = new ReadOnlyObjectWrapper<TreeTablePosition<S, ?>>(this.EMPTY_CELL){
                    private TreeTablePosition<S, ?> old;

                    @Override
                    protected void invalidated() {
                        if (this.get() == null) {
                            return;
                        }
                        if (this.old == null || !this.old.equals(this.get())) {
                            TreeTableViewFocusModel.this.setFocusedIndex(((TreeTablePosition)this.get()).getRow());
                            TreeTableViewFocusModel.this.setFocusedItem(TreeTableViewFocusModel.this.getModelItem(((TreeTablePosition)this.getValue()).getRow()));
                            this.old = (TreeTablePosition)this.get();
                        }
                    }

                    @Override
                    public Object getBean() {
                        return TreeTableViewFocusModel.this;
                    }

                    @Override
                    public String getName() {
                        return "focusedCell";
                    }
                };
            }
            return this.focusedCell;
        }

        @Override
        public void focus(int row, TreeTableColumn<S, ?> column) {
            if (row < 0 || row >= this.getItemCount()) {
                this.setFocusedCell(this.EMPTY_CELL);
            } else {
                TreeTablePosition<S, ?> oldFocusCell = this.getFocusedCell();
                TreeTablePosition newFocusCell = new TreeTablePosition(this.treeTableView, row, column);
                this.setFocusedCell(newFocusCell);
                if (newFocusCell.equals(oldFocusCell)) {
                    this.setFocusedIndex(row);
                    this.setFocusedItem(this.getModelItem(row));
                }
            }
        }

        public void focus(TreeTablePosition<S, ?> pos) {
            if (pos == null) {
                return;
            }
            this.focus(pos.getRow(), (TreeTableColumn<S, ?>)pos.getTableColumn());
        }

        @Override
        public boolean isFocused(int row, TreeTableColumn<S, ?> column) {
            if (row < 0 || row >= this.getItemCount()) {
                return false;
            }
            TreeTablePosition<S, ?> cell = this.getFocusedCell();
            boolean columnMatch = column == null || column.equals(cell.getTableColumn());
            return cell.getRow() == row && columnMatch;
        }

        @Override
        public void focus(int index) {
            if (((TreeTableView)this.treeTableView).expandedItemCountDirty) {
                ((TreeTableView)this.treeTableView).updateExpandedItemCount(this.treeTableView.getRoot());
            }
            if (index < 0 || index >= this.getItemCount()) {
                this.setFocusedCell(this.EMPTY_CELL);
            } else {
                this.setFocusedCell(new TreeTablePosition(this.treeTableView, index, null));
            }
        }

        @Override
        public void focusAboveCell() {
            TreeTablePosition<S, ?> cell = this.getFocusedCell();
            if (this.getFocusedIndex() == -1) {
                this.focus(this.getItemCount() - 1, (TreeTableColumn<S, ?>)cell.getTableColumn());
            } else if (this.getFocusedIndex() > 0) {
                this.focus(this.getFocusedIndex() - 1, (TreeTableColumn<S, ?>)cell.getTableColumn());
            }
        }

        @Override
        public void focusBelowCell() {
            TreeTablePosition<S, ?> cell = this.getFocusedCell();
            if (this.getFocusedIndex() == -1) {
                this.focus(0, (TreeTableColumn<S, ?>)cell.getTableColumn());
            } else if (this.getFocusedIndex() != this.getItemCount() - 1) {
                this.focus(this.getFocusedIndex() + 1, (TreeTableColumn<S, ?>)cell.getTableColumn());
            }
        }

        @Override
        public void focusLeftCell() {
            TreeTablePosition<S, ?> cell = this.getFocusedCell();
            if (cell.getColumn() <= 0) {
                return;
            }
            this.focus(cell.getRow(), this.getTableColumn((TreeTableColumn<S, ?>)cell.getTableColumn(), -1));
        }

        @Override
        public void focusRightCell() {
            TreeTablePosition<S, ?> cell = this.getFocusedCell();
            if (cell.getColumn() == this.getColumnCount() - 1) {
                return;
            }
            this.focus(cell.getRow(), this.getTableColumn((TreeTableColumn<S, ?>)cell.getTableColumn(), 1));
        }

        @Override
        public void focusPrevious() {
            if (this.getFocusedIndex() == -1) {
                this.focus(0);
            } else if (this.getFocusedIndex() > 0) {
                this.focusAboveCell();
            }
        }

        @Override
        public void focusNext() {
            if (this.getFocusedIndex() == -1) {
                this.focus(0);
            } else if (this.getFocusedIndex() != this.getItemCount() - 1) {
                this.focusBelowCell();
            }
        }

        private int getColumnCount() {
            return this.treeTableView.getVisibleLeafColumns().size();
        }

        private TreeTableColumn<S, ?> getTableColumn(TreeTableColumn<S, ?> column, int offset) {
            int columnIndex = this.treeTableView.getVisibleLeafIndex(column);
            int newColumnIndex = columnIndex + offset;
            return this.treeTableView.getVisibleLeafColumn(newColumnIndex);
        }

        /* synthetic */ void lambda$new$129(ObservableValue observable, TreeItem oldValue, TreeItem newValue) {
            this.updateTreeEventListener(oldValue, newValue);
        }

        /* synthetic */ void lambda$new$128(Observable o) {
            if (this.isFocused(0)) {
                this.focus(-1);
                this.focus(0);
            }
        }
    }

    static class TreeTableViewArrayListSelectionModel<S>
    extends TreeTableViewSelectionModel<S> {
        private final MappingChange.Map<TreeTablePosition<S, ?>, TreeItem<S>> cellToItemsMap = TreeTableView$TreeTableViewArrayListSelectionModel$$Lambda$1.lambdaFactory$(this);
        private final MappingChange.Map<TreeTablePosition<S, ?>, Integer> cellToIndicesMap = TreeTableView$TreeTableViewArrayListSelectionModel$$Lambda$2.lambdaFactory$();
        private TreeTableView<S> treeTableView = null;
        private ChangeListener<TreeItem<S>> rootPropertyListener = TreeTableView$TreeTableViewArrayListSelectionModel$$Lambda$3.lambdaFactory$(this);
        private EventHandler<TreeItem.TreeModificationEvent<S>> treeItemListener = new EventHandler<TreeItem.TreeModificationEvent<S>>(){

            @Override
            public void handle(TreeItem.TreeModificationEvent<S> e) {
                if (TreeTableViewArrayListSelectionModel.this.getSelectedIndex() == -1 && TreeTableViewArrayListSelectionModel.this.getSelectedItem() == null) {
                    return;
                }
                TreeItem treeItem = e.getTreeItem();
                if (treeItem == null) {
                    return;
                }
                int oldSelectedIndex = TreeTableViewArrayListSelectionModel.this.getSelectedIndex();
                TreeItem oldSelectedItem = (TreeItem)TreeTableViewArrayListSelectionModel.this.getSelectedItem();
                TreeTableViewArrayListSelectionModel.this.treeTableView.expandedItemCountDirty = true;
                int startRow = TreeTableViewArrayListSelectionModel.this.treeTableView.getRow(treeItem);
                int shift = 0;
                ListChangeListener.Change change = e.getChange();
                if (change != null) {
                    change.next();
                }
                do {
                    int index;
                    int removedSize;
                    int addedSize = change == null ? 0 : change.getAddedSize();
                    int n = removedSize = change == null ? 0 : change.getRemovedSize();
                    if (e.wasExpanded()) {
                        shift += treeItem.getExpandedDescendentCount(false) - 1;
                        ++startRow;
                        continue;
                    }
                    if (e.wasCollapsed()) {
                        treeItem.getExpandedDescendentCount(false);
                        int count = treeItem.previousExpandedDescendentCount;
                        int selectedIndex = TreeTableViewArrayListSelectionModel.this.getSelectedIndex();
                        boolean wasPrimarySelectionInChild = selectedIndex >= startRow + 1 && selectedIndex < startRow + count;
                        boolean wasAnyChildSelected = false;
                        boolean isCellSelectionMode = TreeTableViewArrayListSelectionModel.this.isCellSelectionEnabled();
                        ObservableList columns = TreeTableViewArrayListSelectionModel.this.getTreeTableView().getVisibleLeafColumns();
                        if (!isCellSelectionMode) {
                            TreeTableViewArrayListSelectionModel.this.startAtomic();
                        }
                        int from = startRow + 1;
                        int to = startRow + count;
                        ArrayList<Integer> removed = new ArrayList<Integer>();
                        TreeTableColumn selectedColumn = null;
                        for (int i = from; i < to; ++i) {
                            if (isCellSelectionMode) {
                                for (int column = 0; column < columns.size(); ++column) {
                                    TreeTableColumn col = (TreeTableColumn)columns.get(column);
                                    if (!TreeTableViewArrayListSelectionModel.this.isSelected(i, col)) continue;
                                    wasAnyChildSelected = true;
                                    TreeTableViewArrayListSelectionModel.this.clearSelection(i, col);
                                    selectedColumn = col;
                                }
                                continue;
                            }
                            if (!TreeTableViewArrayListSelectionModel.this.isSelected(i)) continue;
                            wasAnyChildSelected = true;
                            TreeTableViewArrayListSelectionModel.this.clearSelection(i);
                            removed.add(i);
                        }
                        if (!isCellSelectionMode) {
                            TreeTableViewArrayListSelectionModel.this.stopAtomic();
                        }
                        if (wasPrimarySelectionInChild && wasAnyChildSelected) {
                            TreeTableViewArrayListSelectionModel.this.select(startRow, selectedColumn);
                        } else if (!isCellSelectionMode) {
                            NonIterableChange.GenericAddRemoveChange newChange = new NonIterableChange.GenericAddRemoveChange(from, from, removed, TreeTableViewArrayListSelectionModel.this.selectedIndicesSeq);
                            TreeTableViewArrayListSelectionModel.this.selectedIndicesSeq.callObservers(newChange);
                        }
                        shift += -count + 1;
                        ++startRow;
                        continue;
                    }
                    if (e.wasPermutated()) {
                        TreeTableViewArrayListSelectionModel.this.quietClearSelection();
                        TreeTableViewArrayListSelectionModel.this.select(oldSelectedItem);
                        continue;
                    }
                    if (e.wasAdded()) {
                        boolean isAnchorSelected;
                        shift += treeItem.isExpanded() ? addedSize : 0;
                        startRow = TreeTableViewArrayListSelectionModel.this.treeTableView.getRow(e.getChange().getAddedSubList().get(0));
                        TreeTablePosition anchor = TreeTableCellBehavior.getAnchor(TreeTableViewArrayListSelectionModel.this.treeTableView, null);
                        if (anchor == null || !(isAnchorSelected = TreeTableViewArrayListSelectionModel.this.isSelected(anchor.getRow(), anchor.getTableColumn()))) continue;
                        TreeTablePosition newAnchor = new TreeTablePosition(TreeTableViewArrayListSelectionModel.this.treeTableView, anchor.getRow() + shift, anchor.getTableColumn());
                        TreeTableCellBehavior.setAnchor(TreeTableViewArrayListSelectionModel.this.treeTableView, newAnchor, false);
                        continue;
                    }
                    if (!e.wasRemoved()) continue;
                    shift += treeItem.isExpanded() ? -removedSize : 0;
                    startRow += e.getFrom() + 1;
                    ObservableList selectedIndices = TreeTableViewArrayListSelectionModel.this.getSelectedIndices();
                    ObservableList selectedItems = TreeTableViewArrayListSelectionModel.this.getSelectedItems();
                    TreeItem selectedItem = (TreeItem)TreeTableViewArrayListSelectionModel.this.getSelectedItem();
                    List removedChildren = e.getChange().getRemoved();
                    for (int i = 0; i < selectedIndices.size() && !selectedItems.isEmpty() && (index = ((Integer)selectedIndices.get(i)).intValue()) <= selectedItems.size(); ++i) {
                        int previousRow;
                        Object newSelectedItem;
                        if (removedChildren.size() != 1 || selectedItems.size() != 1 || selectedItem == null || !selectedItem.equals(removedChildren.get(0)) || oldSelectedIndex >= TreeTableViewArrayListSelectionModel.this.getItemCount() || selectedItem.equals(newSelectedItem = TreeTableViewArrayListSelectionModel.this.getModelItem(previousRow = oldSelectedIndex == 0 ? 0 : oldSelectedIndex - 1))) continue;
                        TreeTableViewArrayListSelectionModel.this.clearAndSelect(previousRow);
                    }
                } while (e.getChange() != null && e.getChange().next());
                TreeTableViewArrayListSelectionModel.this.shiftSelection(startRow, shift, new Callback<MultipleSelectionModelBase.ShiftParams, Void>(){

                    @Override
                    public Void call(MultipleSelectionModelBase.ShiftParams param) {
                        TreeTableViewArrayListSelectionModel.this.startAtomic();
                        int clearIndex = param.getClearIndex();
                        TreeTablePosition oldTP = null;
                        if (clearIndex > -1) {
                            for (int i = 0; i < TreeTableViewArrayListSelectionModel.this.selectedCellsMap.size(); ++i) {
                                TreeTablePosition tp = (TreeTablePosition)TreeTableViewArrayListSelectionModel.this.selectedCellsMap.get(i);
                                if (tp.getRow() != clearIndex) continue;
                                oldTP = tp;
                                TreeTableViewArrayListSelectionModel.this.selectedCellsMap.remove(tp);
                                break;
                            }
                        }
                        if (oldTP != null && param.isSelected()) {
                            TreeTablePosition newTP = new TreeTablePosition(TreeTableViewArrayListSelectionModel.this.treeTableView, param.getSetIndex(), oldTP.getTableColumn());
                            TreeTableViewArrayListSelectionModel.this.selectedCellsMap.add(newTP);
                        }
                        TreeTableViewArrayListSelectionModel.this.stopAtomic();
                        return null;
                    }
                });
            }
        };
        private WeakChangeListener<TreeItem<S>> weakRootPropertyListener = new WeakChangeListener<TreeItem<S>>(this.rootPropertyListener);
        private WeakEventHandler<TreeItem.TreeModificationEvent<S>> weakTreeItemListener;
        private final SelectedCellsMap<TreeTablePosition<S, ?>> selectedCellsMap;
        private final ReadOnlyUnbackedObservableList<TreeItem<S>> selectedItems;
        private final ReadOnlyUnbackedObservableList<TreeTablePosition<S, ?>> selectedCellsSeq;

        public TreeTableViewArrayListSelectionModel(TreeTableView<S> treeTableView) {
            super(treeTableView);
            this.treeTableView = treeTableView;
            this.treeTableView.rootProperty().addListener(this.weakRootPropertyListener);
            this.treeTableView.showRootProperty().addListener(TreeTableView$TreeTableViewArrayListSelectionModel$$Lambda$4.lambdaFactory$(this, treeTableView));
            this.updateTreeEventListener(null, treeTableView.getRoot());
            this.selectedCellsMap = new SelectedCellsMap<TreeTablePosition<S, ?>>(TreeTableView$TreeTableViewArrayListSelectionModel$$Lambda$5.lambdaFactory$(this)){

                @Override
                public boolean isCellSelectionEnabled() {
                    return TreeTableViewArrayListSelectionModel.this.isCellSelectionEnabled();
                }
            };
            this.selectedItems = new ReadOnlyUnbackedObservableList<TreeItem<S>>(){

                @Override
                public TreeItem<S> get(int i) {
                    return TreeTableViewArrayListSelectionModel.this.getModelItem((Integer)TreeTableViewArrayListSelectionModel.this.getSelectedIndices().get(i));
                }

                @Override
                public int size() {
                    return TreeTableViewArrayListSelectionModel.this.getSelectedIndices().size();
                }
            };
            this.selectedCellsSeq = new ReadOnlyUnbackedObservableList<TreeTablePosition<S, ?>>(){

                @Override
                public TreeTablePosition<S, ?> get(int i) {
                    return (TreeTablePosition)TreeTableViewArrayListSelectionModel.this.selectedCellsMap.get(i);
                }

                @Override
                public int size() {
                    return TreeTableViewArrayListSelectionModel.this.selectedCellsMap.size();
                }
            };
            this.updateDefaultSelection();
            this.cellSelectionEnabledProperty().addListener(TreeTableView$TreeTableViewArrayListSelectionModel$$Lambda$6.lambdaFactory$(this, treeTableView));
        }

        private void updateTreeEventListener(TreeItem<S> oldRoot, TreeItem<S> newRoot) {
            if (oldRoot != null && this.weakTreeItemListener != null) {
                oldRoot.removeEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
            }
            if (newRoot != null) {
                this.weakTreeItemListener = new WeakEventHandler<TreeItem.TreeModificationEvent<S>>(this.treeItemListener);
                newRoot.addEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
            }
        }

        @Override
        public ObservableList<TreeItem<S>> getSelectedItems() {
            return this.selectedItems;
        }

        @Override
        public ObservableList<TreeTablePosition<S, ?>> getSelectedCells() {
            return this.selectedCellsSeq;
        }

        @Override
        public void clearAndSelect(int row) {
            this.clearAndSelect(row, (TableColumnBase<TreeItem<S>, ?>)null);
        }

        @Override
        public void clearAndSelect(int row, TableColumnBase<TreeItem<S>, ?> column) {
            ListChangeListener.Change<TreeTablePosition<S, ?>> change;
            if (row < 0 || row >= this.getItemCount()) {
                return;
            }
            TreeTablePosition newTablePosition = new TreeTablePosition(this.getTreeTableView(), row, (TreeTableColumn)column);
            boolean isCellSelectionEnabled = this.isCellSelectionEnabled();
            TreeTableCellBehavior.setAnchor(this.treeTableView, newTablePosition, false);
            if (isCellSelectionEnabled && column == null) {
                return;
            }
            boolean wasSelected = this.isSelected(row, column);
            ArrayList previousSelection = new ArrayList(this.selectedCellsMap.getSelectedCells());
            if (wasSelected && previousSelection.size() == 1) {
                TreeTablePosition selectedCell = (TreeTablePosition)this.getSelectedCells().get(0);
                if (this.getSelectedItem() == this.getModelItem(row) && selectedCell.getRow() == row && selectedCell.getTableColumn() == column) {
                    return;
                }
            }
            this.startAtomic();
            this.clearSelection();
            this.select(row, column);
            this.stopAtomic();
            if (isCellSelectionEnabled) {
                previousSelection.remove(newTablePosition);
            } else {
                for (TreeTablePosition treeTablePosition : previousSelection) {
                    if (treeTablePosition.getRow() != row) continue;
                    previousSelection.remove(treeTablePosition);
                    break;
                }
            }
            if (wasSelected) {
                change = ControlUtils.buildClearAndSelectChange(this.selectedCellsSeq, previousSelection, row);
            } else {
                int n = this.selectedCellsSeq.indexOf(newTablePosition);
                change = new NonIterableChange.GenericAddRemoveChange(n, n + 1, previousSelection, this.selectedCellsSeq);
            }
            this.handleSelectedCellsListChangeEvent(change);
        }

        @Override
        public void select(int row) {
            this.select(row, (TableColumnBase<TreeItem<S>, ?>)null);
        }

        @Override
        public void select(int row, TableColumnBase<TreeItem<S>, ?> column) {
            if (row < 0 || row >= this.getRowCount()) {
                return;
            }
            if (this.isCellSelectionEnabled() && column == null) {
                ObservableList columns = this.getTreeTableView().getVisibleLeafColumns();
                for (int i = 0; i < columns.size(); ++i) {
                    this.select(row, (TableColumnBase)columns.get(i));
                }
                return;
            }
            TreeTablePosition pos = new TreeTablePosition(this.getTreeTableView(), row, (TreeTableColumn)column);
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.startAtomic();
                this.quietClearSelection();
                this.stopAtomic();
            }
            if (TreeTableCellBehavior.hasDefaultAnchor(this.treeTableView)) {
                TreeTableCellBehavior.removeAnchor(this.treeTableView);
            }
            this.selectedCellsMap.add(pos);
            this.updateSelectedIndex(row);
            this.focus(row, (TreeTableColumn)column);
        }

        @Override
        public void select(TreeItem<S> obj) {
            if (obj == null && this.getSelectionMode() == SelectionMode.SINGLE) {
                this.clearSelection();
                return;
            }
            int firstIndex = this.treeTableView.getRow(obj);
            if (firstIndex > -1) {
                if (this.isSelected(firstIndex)) {
                    return;
                }
                if (this.getSelectionMode() == SelectionMode.SINGLE) {
                    this.quietClearSelection();
                }
                this.select(firstIndex);
            } else {
                this.setSelectedIndex(-1);
                this.setSelectedItem(obj);
            }
        }

        @Override
        public void selectIndices(int row, int ... rows) {
            if (rows == null) {
                this.select(row);
                return;
            }
            int rowCount = this.getRowCount();
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
                for (int i = rows.length - 1; i >= 0; --i) {
                    int index = rows[i];
                    if (index < 0 || index >= rowCount) continue;
                    this.select(index);
                    break;
                }
                if (this.selectedCellsMap.isEmpty() && row > 0 && row < rowCount) {
                    this.select(row);
                }
            } else {
                int lastIndex = -1;
                LinkedHashSet positions = new LinkedHashSet();
                if (row >= 0 && row < rowCount) {
                    if (this.isCellSelectionEnabled()) {
                        ObservableList columns = this.getTreeTableView().getVisibleLeafColumns();
                        for (int column = 0; column < columns.size(); ++column) {
                            if (this.selectedCellsMap.isSelected(row, column)) continue;
                            positions.add(new TreeTablePosition(this.getTreeTableView(), row, (TreeTableColumn)columns.get(column)));
                        }
                    } else {
                        boolean match = this.selectedCellsMap.isSelected(row, -1);
                        if (!match) {
                            positions.add(new TreeTablePosition(this.getTreeTableView(), row, null));
                        }
                    }
                    lastIndex = row;
                }
                for (int i = 0; i < rows.length; ++i) {
                    int index = rows[i];
                    if (index < 0 || index >= rowCount) continue;
                    lastIndex = index;
                    if (this.isCellSelectionEnabled()) {
                        ObservableList columns = this.getTreeTableView().getVisibleLeafColumns();
                        for (int column = 0; column < columns.size(); ++column) {
                            if (this.selectedCellsMap.isSelected(index, column)) continue;
                            positions.add(new TreeTablePosition(this.getTreeTableView(), index, (TreeTableColumn)columns.get(column)));
                            lastIndex = index;
                        }
                        continue;
                    }
                    if (this.selectedCellsMap.isSelected(index, -1)) continue;
                    positions.add(new TreeTablePosition(this.getTreeTableView(), index, null));
                }
                this.selectedCellsMap.addAll(positions);
                if (lastIndex != -1) {
                    this.select(lastIndex);
                }
            }
        }

        @Override
        public void selectAll() {
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                return;
            }
            if (this.isCellSelectionEnabled()) {
                ArrayList indices = new ArrayList();
                TreeTablePosition tp = null;
                for (int col = 0; col < this.getTreeTableView().getVisibleLeafColumns().size(); ++col) {
                    TreeTableColumn column = (TreeTableColumn)this.getTreeTableView().getVisibleLeafColumns().get(col);
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        tp = new TreeTablePosition(this.getTreeTableView(), row, column);
                        indices.add(tp);
                    }
                }
                this.selectedCellsMap.setAll(indices);
                if (tp != null) {
                    this.select(tp.getRow(), tp.getTableColumn());
                    this.focus(tp.getRow(), (TreeTableColumn<S, ?>)tp.getTableColumn());
                }
            } else {
                ArrayList indices = new ArrayList();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    indices.add(new TreeTablePosition(this.getTreeTableView(), i, null));
                }
                this.selectedCellsMap.setAll(indices);
                int focusedIndex = this.getFocusedIndex();
                if (focusedIndex == -1) {
                    int itemCount = this.getItemCount();
                    if (itemCount > 0) {
                        this.select(itemCount - 1);
                        this.focus((TreeTablePosition)indices.get(indices.size() - 1));
                    }
                } else {
                    this.select(focusedIndex);
                    this.focus(focusedIndex);
                }
            }
        }

        @Override
        public void selectRange(int minRow, TableColumnBase<TreeItem<S>, ?> minColumn, int maxRow, TableColumnBase<TreeItem<S>, ?> maxColumn) {
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
                this.select(maxRow, maxColumn);
                return;
            }
            this.startAtomic();
            int itemCount = this.getItemCount();
            boolean isCellSelectionEnabled = this.isCellSelectionEnabled();
            int minColumnIndex = this.treeTableView.getVisibleLeafIndex((TreeTableColumn)minColumn);
            int maxColumnIndex = this.treeTableView.getVisibleLeafIndex((TreeTableColumn)maxColumn);
            int _minColumnIndex = Math.min(minColumnIndex, maxColumnIndex);
            int _maxColumnIndex = Math.max(minColumnIndex, maxColumnIndex);
            int _minRow = Math.min(minRow, maxRow);
            int _maxRow = Math.max(minRow, maxRow);
            ArrayList cellsToSelect = new ArrayList();
            for (int _row = _minRow; _row <= _maxRow; ++_row) {
                if (_row < 0 || _row >= itemCount) continue;
                if (!isCellSelectionEnabled) {
                    cellsToSelect.add(new TreeTablePosition(this.treeTableView, _row, (TreeTableColumn)minColumn));
                    continue;
                }
                for (int _col = _minColumnIndex; _col <= _maxColumnIndex; ++_col) {
                    TreeTableColumn<S, ?> column = this.treeTableView.getVisibleLeafColumn(_col);
                    if (column == null && isCellSelectionEnabled) continue;
                    cellsToSelect.add(new TreeTablePosition(this.treeTableView, _row, column));
                }
            }
            cellsToSelect.removeAll(this.getSelectedCells());
            this.selectedCellsMap.addAll(cellsToSelect);
            this.stopAtomic();
            this.updateSelectedIndex(maxRow);
            this.focus(maxRow, (TreeTableColumn)maxColumn);
            TreeTableColumn startColumn = (TreeTableColumn)minColumn;
            TreeTableColumn endColumn = isCellSelectionEnabled ? (TreeTableColumn)maxColumn : startColumn;
            int startChangeIndex = this.selectedCellsMap.indexOf(new TreeTablePosition(this.treeTableView, minRow, startColumn));
            int endChangeIndex = this.selectedCellsMap.indexOf(new TreeTablePosition(this.treeTableView, maxRow, endColumn));
            if (startChangeIndex > -1 && endChangeIndex > -1) {
                int startIndex = Math.min(startChangeIndex, endChangeIndex);
                int endIndex = Math.max(startChangeIndex, endChangeIndex);
                NonIterableChange.SimpleAddChange c = new NonIterableChange.SimpleAddChange(startIndex, endIndex + 1, this.selectedCellsSeq);
                this.handleSelectedCellsListChangeEvent(c);
            }
        }

        @Override
        public void clearSelection(int index) {
            this.clearSelection(index, (TableColumnBase<TreeItem<S>, ?>)null);
        }

        @Override
        public void clearSelection(int row, TableColumnBase<TreeItem<S>, ?> column) {
            this.clearSelection(new TreeTablePosition(this.getTreeTableView(), row, (TreeTableColumn)column));
        }

        private void clearSelection(TreeTablePosition<S, ?> tp) {
            boolean csMode = this.isCellSelectionEnabled();
            int row = tp.getRow();
            for (TreeTablePosition treeTablePosition : this.getSelectedCells()) {
                if (!csMode) {
                    if (treeTablePosition.getRow() != row) continue;
                    this.selectedCellsMap.remove(treeTablePosition);
                    break;
                }
                if (!treeTablePosition.equals(tp)) continue;
                this.selectedCellsMap.remove(tp);
                break;
            }
            if (this.isEmpty() && !this.isAtomic()) {
                this.updateSelectedIndex(-1);
                this.selectedCellsMap.clear();
            }
        }

        @Override
        public void clearSelection() {
            final ArrayList removed = new ArrayList(this.getSelectedCells());
            this.quietClearSelection();
            if (!this.isAtomic()) {
                this.updateSelectedIndex(-1);
                this.focus(-1);
                NonIterableChange c = new NonIterableChange<TreeTablePosition<S, ?>>(0, 0, this.selectedCellsSeq){

                    @Override
                    public List<TreeTablePosition<S, ?>> getRemoved() {
                        return removed;
                    }
                };
                this.handleSelectedCellsListChangeEvent(c);
            }
        }

        private void quietClearSelection() {
            this.startAtomic();
            this.selectedCellsMap.clear();
            this.stopAtomic();
        }

        @Override
        public boolean isSelected(int index) {
            return this.isSelected(index, (TableColumnBase<TreeItem<S>, ?>)null);
        }

        @Override
        public boolean isSelected(int row, TableColumnBase<TreeItem<S>, ?> column) {
            boolean isCellSelectionEnabled = this.isCellSelectionEnabled();
            if (isCellSelectionEnabled && column == null) {
                return false;
            }
            int columnIndex = !isCellSelectionEnabled || column == null ? -1 : this.treeTableView.getVisibleLeafIndex((TreeTableColumn)column);
            return this.selectedCellsMap.isSelected(row, columnIndex);
        }

        @Override
        public boolean isEmpty() {
            return this.selectedCellsMap.isEmpty();
        }

        @Override
        public void selectPrevious() {
            if (this.isCellSelectionEnabled()) {
                TreeTablePosition<S, ?> pos = this.getFocusedCell();
                if (pos.getColumn() - 1 >= 0) {
                    this.select(pos.getRow(), (TableColumnBase<TreeItem<S>, ?>)this.getTableColumn((TreeTableColumn<S, ?>)pos.getTableColumn(), -1));
                } else if (pos.getRow() < this.getRowCount() - 1) {
                    this.select(pos.getRow() - 1, (TableColumnBase<TreeItem<S>, ?>)this.getTableColumn(this.getTreeTableView().getVisibleLeafColumns().size() - 1));
                }
            } else {
                int focusIndex = this.getFocusedIndex();
                if (focusIndex == -1) {
                    this.select(this.getRowCount() - 1);
                } else if (focusIndex > 0) {
                    this.select(focusIndex - 1);
                }
            }
        }

        @Override
        public void selectNext() {
            if (this.isCellSelectionEnabled()) {
                TreeTablePosition<S, ?> pos = this.getFocusedCell();
                if (pos.getColumn() + 1 < this.getTreeTableView().getVisibleLeafColumns().size()) {
                    this.select(pos.getRow(), (TableColumnBase<TreeItem<S>, ?>)this.getTableColumn((TreeTableColumn<S, ?>)pos.getTableColumn(), 1));
                } else if (pos.getRow() < this.getRowCount() - 1) {
                    this.select(pos.getRow() + 1, (TableColumnBase<TreeItem<S>, ?>)this.getTableColumn(0));
                }
            } else {
                int focusIndex = this.getFocusedIndex();
                if (focusIndex == -1) {
                    this.select(0);
                } else if (focusIndex < this.getRowCount() - 1) {
                    this.select(focusIndex + 1);
                }
            }
        }

        @Override
        public void selectAboveCell() {
            TreeTablePosition<S, ?> pos = this.getFocusedCell();
            if (pos.getRow() == -1) {
                this.select(this.getRowCount() - 1);
            } else if (pos.getRow() > 0) {
                this.select(pos.getRow() - 1, pos.getTableColumn());
            }
        }

        @Override
        public void selectBelowCell() {
            TreeTablePosition<S, ?> pos = this.getFocusedCell();
            if (pos.getRow() == -1) {
                this.select(0);
            } else if (pos.getRow() < this.getRowCount() - 1) {
                this.select(pos.getRow() + 1, pos.getTableColumn());
            }
        }

        @Override
        public void selectFirst() {
            TreeTablePosition<S, ?> focusedCell = this.getFocusedCell();
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            if (this.getRowCount() > 0) {
                if (this.isCellSelectionEnabled()) {
                    this.select(0, focusedCell.getTableColumn());
                } else {
                    this.select(0);
                }
            }
        }

        @Override
        public void selectLast() {
            int numItems;
            TreeTablePosition<S, ?> focusedCell = this.getFocusedCell();
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            if ((numItems = this.getRowCount()) > 0 && this.getSelectedIndex() < numItems - 1) {
                if (this.isCellSelectionEnabled()) {
                    this.select(numItems - 1, focusedCell.getTableColumn());
                } else {
                    this.select(numItems - 1);
                }
            }
        }

        @Override
        public void selectLeftCell() {
            if (!this.isCellSelectionEnabled()) {
                return;
            }
            TreeTablePosition<S, ?> pos = this.getFocusedCell();
            if (pos.getColumn() - 1 >= 0) {
                this.select(pos.getRow(), (TableColumnBase<TreeItem<S>, ?>)this.getTableColumn((TreeTableColumn<S, ?>)pos.getTableColumn(), -1));
            }
        }

        @Override
        public void selectRightCell() {
            if (!this.isCellSelectionEnabled()) {
                return;
            }
            TreeTablePosition<S, ?> pos = this.getFocusedCell();
            if (pos.getColumn() + 1 < this.getTreeTableView().getVisibleLeafColumns().size()) {
                this.select(pos.getRow(), (TableColumnBase<TreeItem<S>, ?>)this.getTableColumn((TreeTableColumn<S, ?>)pos.getTableColumn(), 1));
            }
        }

        private void updateDefaultSelection() {
            this.clearSelection();
            int newFocusIndex = this.getItemCount() > 0 ? 0 : -1;
            this.focus(newFocusIndex, this.isCellSelectionEnabled() ? this.getTableColumn(0) : null);
        }

        private TreeTableColumn<S, ?> getTableColumn(int pos) {
            return this.getTreeTableView().getVisibleLeafColumn(pos);
        }

        private TreeTableColumn<S, ?> getTableColumn(TreeTableColumn<S, ?> column, int offset) {
            int columnIndex = this.getTreeTableView().getVisibleLeafIndex(column);
            int newColumnIndex = columnIndex + offset;
            return this.getTreeTableView().getVisibleLeafColumn(newColumnIndex);
        }

        private void updateSelectedIndex(int row) {
            this.setSelectedIndex(row);
            this.setSelectedItem(this.getModelItem(row));
        }

        @Override
        public void focus(int row) {
            this.focus(row, null);
        }

        private void focus(int row, TreeTableColumn<S, ?> column) {
            this.focus(new TreeTablePosition(this.getTreeTableView(), row, column));
        }

        private void focus(TreeTablePosition<S, ?> pos) {
            if (this.getTreeTableView().getFocusModel() == null) {
                return;
            }
            this.getTreeTableView().getFocusModel().focus(pos.getRow(), pos.getTableColumn());
            this.getTreeTableView().notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
        }

        @Override
        public int getFocusedIndex() {
            return this.getFocusedCell().getRow();
        }

        private TreeTablePosition<S, ?> getFocusedCell() {
            if (this.treeTableView.getFocusModel() == null) {
                return new TreeTablePosition(this.treeTableView, -1, null);
            }
            return this.treeTableView.getFocusModel().getFocusedCell();
        }

        private int getRowCount() {
            return this.treeTableView.getExpandedItemCount();
        }

        private void handleSelectedCellsListChangeEvent(ListChangeListener.Change<? extends TreeTablePosition<S, ?>> c) {
            boolean fireChangeEvent;
            ArrayList<Integer> newlyUnselectedRows;
            ArrayList<Integer> newlySelectedRows;
            block15: {
                newlySelectedRows = new ArrayList<Integer>();
                newlyUnselectedRows = new ArrayList<Integer>();
                while (c.next()) {
                    int row;
                    TreeTablePosition<S, ?> tp;
                    int i;
                    if (c.wasRemoved()) {
                        List<TreeTablePosition<S, ?>> removed = c.getRemoved();
                        for (i = 0; i < removed.size(); ++i) {
                            tp = removed.get(i);
                            row = tp.getRow();
                            if (!this.selectedIndices.get(row)) continue;
                            this.selectedIndices.clear(row);
                            newlyUnselectedRows.add(row);
                        }
                    }
                    if (!c.wasAdded()) continue;
                    List<TreeTablePosition<S, ?>> added = c.getAddedSubList();
                    for (i = 0; i < added.size(); ++i) {
                        tp = added.get(i);
                        row = tp.getRow();
                        if (this.selectedIndices.get(row)) continue;
                        this.selectedIndices.set(row);
                        newlySelectedRows.add(row);
                    }
                }
                c.reset();
                if (this.isAtomic()) {
                    return;
                }
                c.next();
                if (c.wasReplaced()) {
                    int addedSize;
                    int removedSize = c.getRemovedSize();
                    if (removedSize != (addedSize = c.getAddedSize())) {
                        fireChangeEvent = true;
                    } else {
                        for (int i = 0; i < c.getRemovedSize(); ++i) {
                            TreeTablePosition<S, ?> removed = c.getRemoved().get(i);
                            TreeItem<S> removedTreeItem = removed.getTreeItem();
                            boolean matchFound = false;
                            for (int j = 0; j < c.getAddedSize(); ++j) {
                                TreeTablePosition<S, ?> added = c.getAddedSubList().get(j);
                                TreeItem<S> addedTreeItem = added.getTreeItem();
                                if (removedTreeItem == null || !removedTreeItem.equals(addedTreeItem)) continue;
                                matchFound = true;
                                break;
                            }
                            if (matchFound) continue;
                            fireChangeEvent = true;
                            break block15;
                        }
                        fireChangeEvent = false;
                    }
                } else {
                    fireChangeEvent = true;
                }
            }
            if (fireChangeEvent) {
                this.selectedItems.callObservers(new MappingChange(c, this.cellToItemsMap, this.selectedItems));
            }
            c.reset();
            if (this.selectedItems.isEmpty() && this.getSelectedItem() != null) {
                this.setSelectedItem(null);
            }
            ReadOnlyUnbackedObservableList selectedIndicesSeq = (ReadOnlyUnbackedObservableList)this.getSelectedIndices();
            if (!newlySelectedRows.isEmpty() && newlyUnselectedRows.isEmpty()) {
                ListChangeListener.Change<Integer> change = TreeTableViewArrayListSelectionModel.createRangeChange(selectedIndicesSeq, newlySelectedRows, false);
                selectedIndicesSeq.callObservers(change);
            } else {
                selectedIndicesSeq.callObservers(new MappingChange(c, this.cellToIndicesMap, selectedIndicesSeq));
                c.reset();
            }
            this.selectedCellsSeq.callObservers(new MappingChange(c, MappingChange.NOOP_MAP, this.selectedCellsSeq));
            c.reset();
        }

        /* synthetic */ void lambda$new$127(ObservableValue observable, TreeItem oldValue, TreeItem newValue) {
            this.updateDefaultSelection();
            this.updateTreeEventListener(oldValue, newValue);
        }

        /* synthetic */ void lambda$new$126(TreeTableView treeTableView, Observable o) {
            this.updateDefaultSelection();
            TableCellBehaviorBase.setAnchor(treeTableView, this.getFocusedCell(), true);
        }

        /* synthetic */ void lambda$new$125(ListChangeListener.Change c) {
            this.handleSelectedCellsListChangeEvent(c);
        }

        /* synthetic */ void lambda$new$124(TreeTableView treeTableView, Observable o) {
            this.shiftSelection(0, treeTableView.isShowRoot() ? 1 : -1, null);
        }

        static /* synthetic */ Integer lambda$new$123(TreeTablePosition f) {
            return f.getRow();
        }

        /* synthetic */ TreeItem lambda$new$122(TreeTablePosition f) {
            return this.getModelItem(f.getRow());
        }
    }

    public static abstract class TreeTableViewSelectionModel<S>
    extends TableSelectionModel<TreeItem<S>> {
        private final TreeTableView<S> treeTableView;

        public TreeTableViewSelectionModel(TreeTableView<S> treeTableView) {
            if (treeTableView == null) {
                throw new NullPointerException("TreeTableView can not be null");
            }
            this.treeTableView = treeTableView;
        }

        public abstract ObservableList<TreeTablePosition<S, ?>> getSelectedCells();

        public TreeTableView<S> getTreeTableView() {
            return this.treeTableView;
        }

        @Override
        public TreeItem<S> getModelItem(int index) {
            return this.treeTableView.getTreeItem(index);
        }

        @Override
        protected int getItemCount() {
            return this.treeTableView.getExpandedItemCount();
        }

        @Override
        public void focus(int row) {
            this.focus(row, null);
        }

        @Override
        public int getFocusedIndex() {
            return this.getFocusedCell().getRow();
        }

        @Override
        public void selectRange(int minRow, TableColumnBase<TreeItem<S>, ?> minColumn, int maxRow, TableColumnBase<TreeItem<S>, ?> maxColumn) {
            int minColumnIndex = this.treeTableView.getVisibleLeafIndex((TreeTableColumn)minColumn);
            int maxColumnIndex = this.treeTableView.getVisibleLeafIndex((TreeTableColumn)maxColumn);
            for (int _row = minRow; _row <= maxRow; ++_row) {
                for (int _col = minColumnIndex; _col <= maxColumnIndex; ++_col) {
                    this.select(_row, this.treeTableView.getVisibleLeafColumn(_col));
                }
            }
        }

        private void focus(int row, TreeTableColumn<S, ?> column) {
            this.focus(new TreeTablePosition(this.getTreeTableView(), row, column));
        }

        private void focus(TreeTablePosition<S, ?> pos) {
            if (this.getTreeTableView().getFocusModel() == null) {
                return;
            }
            this.getTreeTableView().getFocusModel().focus(pos.getRow(), (TreeTableColumn<S, ?>)pos.getTableColumn());
        }

        private TreeTablePosition<S, ?> getFocusedCell() {
            if (this.treeTableView.getFocusModel() == null) {
                return new TreeTablePosition(this.treeTableView, -1, null);
            }
            return this.treeTableView.getFocusModel().getFocusedCell();
        }
    }

    public static class EditEvent<S>
    extends Event {
        private static final long serialVersionUID = -4437033058917528976L;
        public static final EventType<?> ANY = TreeTableView.access$2300();
        private final S oldValue;
        private final S newValue;
        private final transient TreeItem<S> treeItem;

        public EditEvent(TreeTableView<S> source, EventType<? extends EditEvent> eventType, TreeItem<S> treeItem, S oldValue, S newValue) {
            super(source, Event.NULL_SOURCE_TARGET, eventType);
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.treeItem = treeItem;
        }

        @Override
        public TreeTableView<S> getSource() {
            return (TreeTableView)super.getSource();
        }

        public TreeItem<S> getTreeItem() {
            return this.treeItem;
        }

        public S getNewValue() {
            return this.newValue;
        }

        public S getOldValue() {
            return this.oldValue;
        }
    }

    public static class ResizeFeatures<S>
    extends ResizeFeaturesBase<TreeItem<S>> {
        private TreeTableView<S> treeTable;

        public ResizeFeatures(TreeTableView<S> treeTable, TreeTableColumn<S, ?> column, Double delta) {
            super(column, delta);
            this.treeTable = treeTable;
        }

        @Override
        public TreeTableColumn<S, ?> getColumn() {
            return (TreeTableColumn)super.getColumn();
        }

        public TreeTableView<S> getTable() {
            return this.treeTable;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<TreeTableView<?>, Number> FIXED_CELL_SIZE = new CssMetaData<TreeTableView<?>, Number>("-fx-fixed-cell-size", SizeConverter.getInstance(), -1.0){

            @Override
            public Double getInitialValue(TreeTableView<?> node) {
                return node.getFixedCellSize();
            }

            @Override
            public boolean isSettable(TreeTableView<?> n) {
                return ((TreeTableView)n).fixedCellSize == null || !((TreeTableView)n).fixedCellSize.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TreeTableView<?> n) {
                return (StyleableProperty)((Object)n.fixedCellSizeProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.add(FIXED_CELL_SIZE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

