/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.CellUtils$$Lambda$1;
import javafx.scene.control.cell.CellUtils$$Lambda$2;
import javafx.scene.control.cell.CellUtils$$Lambda$3;
import javafx.scene.control.cell.CellUtils$$Lambda$4;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;

class CellUtils {
    static int TREE_VIEW_HBOX_GRAPHIC_PADDING = 3;
    private static final StringConverter<?> defaultStringConverter = new StringConverter<Object>(){

        @Override
        public String toString(Object t) {
            return t == null ? null : t.toString();
        }

        @Override
        public Object fromString(String string) {
            return string;
        }
    };
    private static final StringConverter<?> defaultTreeItemStringConverter = new StringConverter<TreeItem<?>>(){

        @Override
        public String toString(TreeItem<?> treeItem) {
            return treeItem == null || treeItem.getValue() == null ? "" : treeItem.getValue().toString();
        }

        @Override
        public TreeItem<?> fromString(String string) {
            return new TreeItem<String>(string);
        }
    };

    CellUtils() {
    }

    static <T> StringConverter<T> defaultStringConverter() {
        return defaultStringConverter;
    }

    static <T> StringConverter<TreeItem<T>> defaultTreeItemStringConverter() {
        return defaultTreeItemStringConverter;
    }

    private static <T> String getItemText(Cell<T> cell, StringConverter<T> converter) {
        return converter == null ? (cell.getItem() == null ? "" : cell.getItem().toString()) : converter.toString(cell.getItem());
    }

    static Node getGraphic(TreeItem<?> treeItem) {
        return treeItem == null ? null : treeItem.getGraphic();
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> converter, ChoiceBox<T> choiceBox) {
        CellUtils.updateItem(cell, converter, null, null, choiceBox);
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> converter, HBox hbox, Node graphic, ChoiceBox<T> choiceBox) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (choiceBox != null) {
                choiceBox.getSelectionModel().select(cell.getItem());
            }
            cell.setText(null);
            if (graphic != null) {
                hbox.getChildren().setAll((Node[])new Node[]{graphic, choiceBox});
                cell.setGraphic(hbox);
            } else {
                cell.setGraphic(choiceBox);
            }
        } else {
            cell.setText(CellUtils.getItemText(cell, converter));
            cell.setGraphic(graphic);
        }
    }

    static <T> ChoiceBox<T> createChoiceBox(Cell<T> cell, ObservableList<T> items, ObjectProperty<StringConverter<T>> converter) {
        ChoiceBox<T> choiceBox = new ChoiceBox<T>(items);
        choiceBox.setMaxWidth(Double.MAX_VALUE);
        choiceBox.converterProperty().bind(converter);
        choiceBox.getSelectionModel().selectedItemProperty().addListener(CellUtils$$Lambda$1.lambdaFactory$(cell));
        return choiceBox;
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> converter, TextField textField) {
        CellUtils.updateItem(cell, converter, null, null, textField);
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> converter, HBox hbox, Node graphic, TextField textField) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (textField != null) {
                textField.setText(CellUtils.getItemText(cell, converter));
            }
            cell.setText(null);
            if (graphic != null) {
                hbox.getChildren().setAll((Node[])new Node[]{graphic, textField});
                cell.setGraphic(hbox);
            } else {
                cell.setGraphic(textField);
            }
        } else {
            cell.setText(CellUtils.getItemText(cell, converter));
            cell.setGraphic(graphic);
        }
    }

    static <T> void startEdit(Cell<T> cell, StringConverter<T> converter, HBox hbox, Node graphic, TextField textField) {
        if (textField != null) {
            textField.setText(CellUtils.getItemText(cell, converter));
        }
        cell.setText(null);
        if (graphic != null) {
            hbox.getChildren().setAll((Node[])new Node[]{graphic, textField});
            cell.setGraphic(hbox);
        } else {
            cell.setGraphic(textField);
        }
        textField.selectAll();
        textField.requestFocus();
    }

    static <T> void cancelEdit(Cell<T> cell, StringConverter<T> converter, Node graphic) {
        cell.setText(CellUtils.getItemText(cell, converter));
        cell.setGraphic(graphic);
    }

    static <T> TextField createTextField(Cell<T> cell, StringConverter<T> converter) {
        TextField textField = new TextField(CellUtils.getItemText(cell, converter));
        textField.setOnAction(CellUtils$$Lambda$2.lambdaFactory$(converter, cell, textField));
        textField.setOnKeyReleased(CellUtils$$Lambda$3.lambdaFactory$(cell));
        return textField;
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> converter, ComboBox<T> comboBox) {
        CellUtils.updateItem(cell, converter, null, null, comboBox);
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> converter, HBox hbox, Node graphic, ComboBox<T> comboBox) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (comboBox != null) {
                comboBox.getSelectionModel().select(cell.getItem());
            }
            cell.setText(null);
            if (graphic != null) {
                hbox.getChildren().setAll((Node[])new Node[]{graphic, comboBox});
                cell.setGraphic(hbox);
            } else {
                cell.setGraphic(comboBox);
            }
        } else {
            cell.setText(CellUtils.getItemText(cell, converter));
            cell.setGraphic(graphic);
        }
    }

    static <T> ComboBox<T> createComboBox(Cell<T> cell, ObservableList<T> items, ObjectProperty<StringConverter<T>> converter) {
        ComboBox<T> comboBox = new ComboBox<T>(items);
        comboBox.converterProperty().bind(converter);
        comboBox.setMaxWidth(Double.MAX_VALUE);
        comboBox.getSelectionModel().selectedItemProperty().addListener(CellUtils$$Lambda$4.lambdaFactory$(cell));
        return comboBox;
    }

    static /* synthetic */ void lambda$createComboBox$621(Cell cell, ObservableValue ov, Object oldValue, Object newValue) {
        if (cell.isEditing()) {
            cell.commitEdit(newValue);
        }
    }

    static /* synthetic */ void lambda$createTextField$620(Cell cell, KeyEvent t) {
        if (t.getCode() == KeyCode.ESCAPE) {
            cell.cancelEdit();
            t.consume();
        }
    }

    static /* synthetic */ void lambda$createTextField$619(StringConverter stringConverter, Cell cell, TextField textField, ActionEvent event) {
        if (stringConverter == null) {
            throw new IllegalStateException("Attempting to convert text input into Object, but provided StringConverter is null. Be sure to set a StringConverter in your cell factory.");
        }
        cell.commitEdit(stringConverter.fromString(textField.getText()));
        event.consume();
    }

    static /* synthetic */ void lambda$createChoiceBox$618(Cell cell, ObservableValue ov, Object oldValue, Object newValue) {
        if (cell.isEditing()) {
            cell.commitEdit(newValue);
        }
    }
}

