/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.cell.CellUtils;
import javafx.scene.control.cell.ChoiceBoxListCell$$Lambda$1;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ChoiceBoxListCell<T>
extends ListCell<T> {
    private final ObservableList<T> items;
    private ChoiceBox<T> choiceBox;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>(this, "converter");

    @SafeVarargs
    public static <T> Callback<ListView<T>, ListCell<T>> forListView(T ... items) {
        return ChoiceBoxListCell.forListView(FXCollections.observableArrayList(items));
    }

    @SafeVarargs
    public static <T> Callback<ListView<T>, ListCell<T>> forListView(StringConverter<T> converter, T ... items) {
        return ChoiceBoxListCell.forListView(converter, FXCollections.observableArrayList(items));
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(ObservableList<T> items) {
        return ChoiceBoxListCell.forListView(null, items);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(StringConverter<T> converter, ObservableList<T> items) {
        return ChoiceBoxListCell$$Lambda$1.lambdaFactory$(converter, items);
    }

    public ChoiceBoxListCell() {
        this(FXCollections.observableArrayList());
    }

    @SafeVarargs
    public ChoiceBoxListCell(T ... items) {
        this(FXCollections.observableArrayList(items));
    }

    @SafeVarargs
    public ChoiceBoxListCell(StringConverter<T> converter, T ... items) {
        this(converter, FXCollections.observableArrayList(items));
    }

    public ChoiceBoxListCell(ObservableList<T> items) {
        this((StringConverter<T>)null, items);
    }

    public ChoiceBoxListCell(StringConverter<T> converter, ObservableList<T> items) {
        this.getStyleClass().add("choice-box-list-cell");
        this.items = items;
        this.setConverter(converter != null ? converter : CellUtils.defaultStringConverter());
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public ObservableList<T> getItems() {
        return this.items;
    }

    @Override
    public void startEdit() {
        if (!this.isEditable() || !this.getListView().isEditable()) {
            return;
        }
        if (this.choiceBox == null) {
            this.choiceBox = CellUtils.createChoiceBox(this, this.items, this.converterProperty());
        }
        this.choiceBox.getSelectionModel().select(this.getItem());
        super.startEdit();
        if (this.isEditing()) {
            this.setText(null);
            this.setGraphic(this.choiceBox);
        }
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.getConverter().toString(this.getItem()));
        this.setGraphic(null);
    }

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        CellUtils.updateItem(this, this.getConverter(), null, null, this.choiceBox);
    }

    static /* synthetic */ ListCell lambda$forListView$629(StringConverter stringConverter, ObservableList observableList, ListView list) {
        return new ChoiceBoxListCell(stringConverter, observableList);
    }
}

