/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.TilePane$$Lambda$1;
import javafx.scene.layout.TilePane$$Lambda$2;
import javafx.util.Callback;

public class TilePane
extends Pane {
    private static final String MARGIN_CONSTRAINT = "tilepane-margin";
    private static final String ALIGNMENT_CONSTRAINT = "tilepane-alignment";
    private static final Callback<Node, Insets> marginAccessor = TilePane$$Lambda$2.lambdaFactory$();
    private double _tileWidth = -1.0;
    private double _tileHeight = -1.0;
    private ObjectProperty<Orientation> orientation;
    private IntegerProperty prefRows;
    private IntegerProperty prefColumns;
    private DoubleProperty prefTileWidth;
    private DoubleProperty prefTileHeight;
    private TileSizeProperty tileWidth;
    private TileSizeProperty tileHeight;
    private DoubleProperty hgap;
    private DoubleProperty vgap;
    private ObjectProperty<Pos> alignment;
    private ObjectProperty<Pos> tileAlignment;
    private int actualRows = 0;
    private int actualColumns = 0;

    public static void setAlignment(Node node, Pos value) {
        TilePane.setConstraint(node, ALIGNMENT_CONSTRAINT, (Object)value);
    }

    public static Pos getAlignment(Node node) {
        return (Pos)((Object)TilePane.getConstraint(node, ALIGNMENT_CONSTRAINT));
    }

    public static void setMargin(Node node, Insets value) {
        TilePane.setConstraint(node, MARGIN_CONSTRAINT, value);
    }

    public static Insets getMargin(Node node) {
        return (Insets)TilePane.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node child) {
        TilePane.setAlignment(child, null);
        TilePane.setMargin(child, null);
    }

    public TilePane() {
    }

    public TilePane(Orientation orientation) {
        this.setOrientation(orientation);
    }

    public TilePane(double hgap, double vgap) {
        this.setHgap(hgap);
        this.setVgap(vgap);
    }

    public TilePane(Orientation orientation, double hgap, double vgap) {
        this();
        this.setOrientation(orientation);
        this.setHgap(hgap);
        this.setVgap(vgap);
    }

    public TilePane(Node ... children) {
        this.getChildren().addAll((Node[])children);
    }

    public TilePane(Orientation orientation, Node ... children) {
        this.setOrientation(orientation);
        this.getChildren().addAll((Node[])children);
    }

    public TilePane(double hgap, double vgap, Node ... children) {
        this.setHgap(hgap);
        this.setVgap(vgap);
        this.getChildren().addAll((Node[])children);
    }

    public TilePane(Orientation orientation, double hgap, double vgap, Node ... children) {
        this();
        this.setOrientation(orientation);
        this.setHgap(hgap);
        this.setVgap(vgap);
        this.getChildren().addAll((Node[])children);
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty((Object)Orientation.HORIZONTAL){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public CssMetaData<TilePane, Orientation> getCssMetaData() {
                    return StyleableProperties.ORIENTATION;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public final void setOrientation(Orientation value) {
        this.orientationProperty().set(value);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)((Object)this.orientation.get());
    }

    public final IntegerProperty prefRowsProperty() {
        if (this.prefRows == null) {
            this.prefRows = new StyleableIntegerProperty(5){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public CssMetaData<TilePane, Number> getCssMetaData() {
                    return StyleableProperties.PREF_ROWS;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "prefRows";
                }
            };
        }
        return this.prefRows;
    }

    public final void setPrefRows(int value) {
        this.prefRowsProperty().set(value);
    }

    public final int getPrefRows() {
        return this.prefRows == null ? 5 : this.prefRows.get();
    }

    public final IntegerProperty prefColumnsProperty() {
        if (this.prefColumns == null) {
            this.prefColumns = new StyleableIntegerProperty(5){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public CssMetaData<TilePane, Number> getCssMetaData() {
                    return StyleableProperties.PREF_COLUMNS;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "prefColumns";
                }
            };
        }
        return this.prefColumns;
    }

    public final void setPrefColumns(int value) {
        this.prefColumnsProperty().set(value);
    }

    public final int getPrefColumns() {
        return this.prefColumns == null ? 5 : this.prefColumns.get();
    }

    public final DoubleProperty prefTileWidthProperty() {
        if (this.prefTileWidth == null) {
            this.prefTileWidth = new StyleableDoubleProperty(-1.0){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public CssMetaData<TilePane, Number> getCssMetaData() {
                    return StyleableProperties.PREF_TILE_WIDTH;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "prefTileWidth";
                }
            };
        }
        return this.prefTileWidth;
    }

    public final void setPrefTileWidth(double value) {
        this.prefTileWidthProperty().set(value);
    }

    public final double getPrefTileWidth() {
        return this.prefTileWidth == null ? -1.0 : this.prefTileWidth.get();
    }

    public final DoubleProperty prefTileHeightProperty() {
        if (this.prefTileHeight == null) {
            this.prefTileHeight = new StyleableDoubleProperty(-1.0){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public CssMetaData<TilePane, Number> getCssMetaData() {
                    return StyleableProperties.PREF_TILE_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "prefTileHeight";
                }
            };
        }
        return this.prefTileHeight;
    }

    public final void setPrefTileHeight(double value) {
        this.prefTileHeightProperty().set(value);
    }

    public final double getPrefTileHeight() {
        return this.prefTileHeight == null ? -1.0 : this.prefTileHeight.get();
    }

    public final ReadOnlyDoubleProperty tileWidthProperty() {
        if (this.tileWidth == null) {
            this.tileWidth = new TileSizeProperty("tileWidth", this._tileWidth){

                @Override
                public double compute() {
                    return TilePane.this.computeTileWidth();
                }
            };
        }
        return this.tileWidth;
    }

    private void invalidateTileWidth() {
        if (this.tileWidth != null) {
            this.tileWidth.invalidate();
        } else {
            this._tileWidth = -1.0;
        }
    }

    public final double getTileWidth() {
        if (this.tileWidth != null) {
            return this.tileWidth.get();
        }
        if (this._tileWidth == -1.0) {
            this._tileWidth = this.computeTileWidth();
        }
        return this._tileWidth;
    }

    public final ReadOnlyDoubleProperty tileHeightProperty() {
        if (this.tileHeight == null) {
            this.tileHeight = new TileSizeProperty("tileHeight", this._tileHeight){

                @Override
                public double compute() {
                    return TilePane.this.computeTileHeight();
                }
            };
        }
        return this.tileHeight;
    }

    private void invalidateTileHeight() {
        if (this.tileHeight != null) {
            this.tileHeight.invalidate();
        } else {
            this._tileHeight = -1.0;
        }
    }

    public final double getTileHeight() {
        if (this.tileHeight != null) {
            return this.tileHeight.get();
        }
        if (this._tileHeight == -1.0) {
            this._tileHeight = this.computeTileHeight();
        }
        return this._tileHeight;
    }

    public final DoubleProperty hgapProperty() {
        if (this.hgap == null) {
            this.hgap = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public CssMetaData<TilePane, Number> getCssMetaData() {
                    return StyleableProperties.HGAP;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "hgap";
                }
            };
        }
        return this.hgap;
    }

    public final void setHgap(double value) {
        this.hgapProperty().set(value);
    }

    public final double getHgap() {
        return this.hgap == null ? 0.0 : this.hgap.get();
    }

    public final DoubleProperty vgapProperty() {
        if (this.vgap == null) {
            this.vgap = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public CssMetaData<TilePane, Number> getCssMetaData() {
                    return StyleableProperties.VGAP;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "vgap";
                }
            };
        }
        return this.vgap;
    }

    public final void setVgap(double value) {
        this.vgapProperty().set(value);
    }

    public final double getVgap() {
        return this.vgap == null ? 0.0 : this.vgap.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public CssMetaData<TilePane, Pos> getCssMetaData() {
                    return StyleableProperties.ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos value) {
        this.alignmentProperty().set(value);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos localPos = this.getAlignment();
        return localPos == null ? Pos.TOP_LEFT : localPos;
    }

    public final ObjectProperty<Pos> tileAlignmentProperty() {
        if (this.tileAlignment == null) {
            this.tileAlignment = new StyleableObjectProperty<Pos>(Pos.CENTER){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public CssMetaData<TilePane, Pos> getCssMetaData() {
                    return StyleableProperties.TILE_ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "tileAlignment";
                }
            };
        }
        return this.tileAlignment;
    }

    public final void setTileAlignment(Pos value) {
        this.tileAlignmentProperty().set(value);
    }

    public final Pos getTileAlignment() {
        return this.tileAlignment == null ? Pos.CENTER : (Pos)((Object)this.tileAlignment.get());
    }

    private Pos getTileAlignmentInternal() {
        Pos localPos = this.getTileAlignment();
        return localPos == null ? Pos.CENTER : localPos;
    }

    @Override
    public Orientation getContentBias() {
        return this.getOrientation();
    }

    @Override
    public void requestLayout() {
        this.invalidateTileWidth();
        this.invalidateTileHeight();
        super.requestLayout();
    }

    @Override
    protected double computeMinWidth(double height) {
        if (this.getContentBias() == Orientation.HORIZONTAL) {
            return this.getInsets().getLeft() + this.getTileWidth() + this.getInsets().getRight();
        }
        return this.computePrefWidth(height);
    }

    @Override
    protected double computeMinHeight(double width) {
        if (this.getContentBias() == Orientation.VERTICAL) {
            return this.getInsets().getTop() + this.getTileHeight() + this.getInsets().getBottom();
        }
        return this.computePrefHeight(width);
    }

    @Override
    protected double computePrefWidth(double forHeight) {
        List managed = this.getManagedChildren();
        Insets insets = this.getInsets();
        int prefCols = 0;
        if (forHeight != -1.0) {
            int prefRows = this.computeRows(forHeight - this.snapSpace(insets.getTop()) - this.snapSpace(insets.getBottom()), this.getTileHeight());
            prefCols = this.computeOther(managed.size(), prefRows);
        } else {
            prefCols = this.getOrientation() == Orientation.HORIZONTAL ? this.getPrefColumns() : this.computeOther(managed.size(), this.getPrefRows());
        }
        return this.snapSpace(insets.getLeft()) + this.computeContentWidth(prefCols, this.getTileWidth()) + this.snapSpace(insets.getRight());
    }

    @Override
    protected double computePrefHeight(double forWidth) {
        List managed = this.getManagedChildren();
        Insets insets = this.getInsets();
        int prefRows = 0;
        if (forWidth != -1.0) {
            int prefCols = this.computeColumns(forWidth - this.snapSpace(insets.getLeft()) - this.snapSpace(insets.getRight()), this.getTileWidth());
            prefRows = this.computeOther(managed.size(), prefCols);
        } else {
            prefRows = this.getOrientation() == Orientation.HORIZONTAL ? this.computeOther(managed.size(), this.getPrefColumns()) : this.getPrefRows();
        }
        return this.snapSpace(insets.getTop()) + this.computeContentHeight(prefRows, this.getTileHeight()) + this.snapSpace(insets.getBottom());
    }

    private double computeTileWidth() {
        List<Node> managed = this.getManagedChildren();
        double preftilewidth = this.getPrefTileWidth();
        if (preftilewidth == -1.0) {
            double h = -1.0;
            boolean vertBias = false;
            int size = managed.size();
            for (int i = 0; i < size; ++i) {
                Node child = (Node)managed.get(i);
                if (child.getContentBias() != Orientation.VERTICAL) continue;
                vertBias = true;
                break;
            }
            if (vertBias) {
                h = this.computeMaxPrefAreaHeight(managed, marginAccessor, -1.0, this.getTileAlignmentInternal().getVpos());
            }
            return this.snapSize(this.computeMaxPrefAreaWidth(managed, marginAccessor, h, true));
        }
        return this.snapSize(preftilewidth);
    }

    private double computeTileHeight() {
        List<Node> managed = this.getManagedChildren();
        double preftileheight = this.getPrefTileHeight();
        if (preftileheight == -1.0) {
            double w = -1.0;
            boolean horizBias = false;
            int size = managed.size();
            for (int i = 0; i < size; ++i) {
                Node child = (Node)managed.get(i);
                if (child.getContentBias() != Orientation.HORIZONTAL) continue;
                horizBias = true;
                break;
            }
            if (horizBias) {
                w = this.computeMaxPrefAreaWidth(managed, marginAccessor);
            }
            return this.snapSize(this.computeMaxPrefAreaHeight(managed, marginAccessor, w, this.getTileAlignmentInternal().getVpos()));
        }
        return this.snapSize(preftileheight);
    }

    private int computeOther(int numNodes, int numCells) {
        double other = (double)numNodes / (double)Math.max(1, numCells);
        return (int)Math.ceil(other);
    }

    private int computeColumns(double width, double tilewidth) {
        return Math.max(1, (int)((width + this.snapSpace(this.getHgap())) / (tilewidth + this.snapSpace(this.getHgap()))));
    }

    private int computeRows(double height, double tileheight) {
        return Math.max(1, (int)((height + this.snapSpace(this.getVgap())) / (tileheight + this.snapSpace(this.getVgap()))));
    }

    private double computeContentWidth(int columns, double tilewidth) {
        if (columns == 0) {
            return 0.0;
        }
        return (double)columns * tilewidth + (double)(columns - 1) * this.snapSpace(this.getHgap());
    }

    private double computeContentHeight(int rows, double tileheight) {
        if (rows == 0) {
            return 0.0;
        }
        return (double)rows * tileheight + (double)(rows - 1) * this.snapSpace(this.getVgap());
    }

    @Override
    protected void layoutChildren() {
        List<Node> managed = this.getManagedChildren();
        HPos hpos = this.getAlignmentInternal().getHpos();
        VPos vpos = this.getAlignmentInternal().getVpos();
        double width = this.getWidth();
        double height = this.getHeight();
        double top = this.snapSpace(this.getInsets().getTop());
        double left = this.snapSpace(this.getInsets().getLeft());
        double bottom = this.snapSpace(this.getInsets().getBottom());
        double right = this.snapSpace(this.getInsets().getRight());
        double vgap = this.snapSpace(this.getVgap());
        double hgap = this.snapSpace(this.getHgap());
        double insideWidth = width - left - right;
        double insideHeight = height - top - bottom;
        double tileWidth = this.getTileWidth() > insideWidth ? insideWidth : this.getTileWidth();
        double tileHeight = this.getTileHeight() > insideHeight ? insideHeight : this.getTileHeight();
        int lastRowRemainder = 0;
        int lastColumnRemainder = 0;
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            this.actualColumns = this.computeColumns(insideWidth, tileWidth);
            this.actualRows = this.computeOther(managed.size(), this.actualColumns);
            lastRowRemainder = hpos != HPos.LEFT ? this.actualColumns - (this.actualColumns * this.actualRows - managed.size()) : 0;
        } else {
            this.actualRows = this.computeRows(insideHeight, tileHeight);
            this.actualColumns = this.computeOther(managed.size(), this.actualRows);
            lastColumnRemainder = vpos != VPos.TOP ? this.actualRows - (this.actualColumns * this.actualRows - managed.size()) : 0;
        }
        double rowX = left + TilePane.computeXOffset(insideWidth, this.computeContentWidth(this.actualColumns, tileWidth), hpos);
        double columnY = top + TilePane.computeYOffset(insideHeight, this.computeContentHeight(this.actualRows, tileHeight), vpos);
        double lastRowX = lastRowRemainder > 0 ? left + TilePane.computeXOffset(insideWidth, this.computeContentWidth(lastRowRemainder, tileWidth), hpos) : rowX;
        double lastColumnY = lastColumnRemainder > 0 ? top + TilePane.computeYOffset(insideHeight, this.computeContentHeight(lastColumnRemainder, tileHeight), vpos) : columnY;
        double baselineOffset = this.getTileAlignmentInternal().getVpos() == VPos.BASELINE ? this.getAreaBaselineOffset(managed, marginAccessor, TilePane$$Lambda$1.lambdaFactory$(tileWidth), tileHeight, false) : -1.0;
        int r = 0;
        int c = 0;
        int size = managed.size();
        for (int i = 0; i < size; ++i) {
            Node child = managed.get(i);
            double xoffset = r == this.actualRows - 1 ? lastRowX : rowX;
            double yoffset = c == this.actualColumns - 1 ? lastColumnY : columnY;
            double tileX = xoffset + (double)c * (tileWidth + hgap);
            double tileY = yoffset + (double)r * (tileHeight + vgap);
            Pos childAlignment = TilePane.getAlignment(child);
            this.layoutInArea(child, tileX, tileY, tileWidth, tileHeight, baselineOffset, TilePane.getMargin(child), childAlignment != null ? childAlignment.getHpos() : this.getTileAlignmentInternal().getHpos(), childAlignment != null ? childAlignment.getVpos() : this.getTileAlignmentInternal().getVpos());
            if (this.getOrientation() == Orientation.HORIZONTAL) {
                if (++c != this.actualColumns) continue;
                c = 0;
                ++r;
                continue;
            }
            if (++r != this.actualRows) continue;
            r = 0;
            ++c;
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TilePane.getClassCssMetaData();
    }

    static /* synthetic */ Double lambda$layoutChildren$509(double d, Integer i) {
        return d;
    }

    static /* synthetic */ Insets lambda$static$508(Node n) {
        return TilePane.getMargin(n);
    }

    private abstract class TileSizeProperty
    extends ReadOnlyDoubleProperty {
        private final String name;
        private ExpressionHelper<Number> helper;
        private double value;
        private boolean valid;

        TileSizeProperty(String name, double initSize) {
            this.name = name;
            this.value = initSize;
            this.valid = initSize != -1.0;
        }

        @Override
        public Object getBean() {
            return TilePane.this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(ChangeListener<? super Number> listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(ChangeListener<? super Number> listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public double get() {
            if (!this.valid) {
                this.value = this.compute();
                this.valid = true;
            }
            return this.value;
        }

        public void invalidate() {
            if (this.valid) {
                this.valid = false;
                ExpressionHelper.fireValueChangedEvent(this.helper);
            }
        }

        public abstract double compute();
    }

    private static class StyleableProperties {
        private static final CssMetaData<TilePane, Pos> ALIGNMENT = new CssMetaData<TilePane, Pos>("-fx-alignment", new EnumConverter<Pos>(Pos.class), Pos.TOP_LEFT){

            @Override
            public boolean isSettable(TilePane node) {
                return node.alignment == null || !node.alignment.isBound();
            }

            @Override
            public StyleableProperty<Pos> getStyleableProperty(TilePane node) {
                return (StyleableProperty)((Object)node.alignmentProperty());
            }
        };
        private static final CssMetaData<TilePane, Number> PREF_COLUMNS = new CssMetaData<TilePane, Number>("-fx-pref-columns", SizeConverter.getInstance(), (Number)5.0){

            @Override
            public boolean isSettable(TilePane node) {
                return node.prefColumns == null || !node.prefColumns.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TilePane node) {
                return (StyleableProperty)((Object)node.prefColumnsProperty());
            }
        };
        private static final CssMetaData<TilePane, Number> HGAP = new CssMetaData<TilePane, Number>("-fx-hgap", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(TilePane node) {
                return node.hgap == null || !node.hgap.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TilePane node) {
                return (StyleableProperty)((Object)node.hgapProperty());
            }
        };
        private static final CssMetaData<TilePane, Number> PREF_ROWS = new CssMetaData<TilePane, Number>("-fx-pref-rows", SizeConverter.getInstance(), (Number)5.0){

            @Override
            public boolean isSettable(TilePane node) {
                return node.prefRows == null || !node.prefRows.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TilePane node) {
                return (StyleableProperty)((Object)node.prefRowsProperty());
            }
        };
        private static final CssMetaData<TilePane, Pos> TILE_ALIGNMENT = new CssMetaData<TilePane, Pos>("-fx-tile-alignment", new EnumConverter<Pos>(Pos.class), Pos.CENTER){

            @Override
            public boolean isSettable(TilePane node) {
                return node.tileAlignment == null || !node.tileAlignment.isBound();
            }

            @Override
            public StyleableProperty<Pos> getStyleableProperty(TilePane node) {
                return (StyleableProperty)((Object)node.tileAlignmentProperty());
            }
        };
        private static final CssMetaData<TilePane, Number> PREF_TILE_WIDTH = new CssMetaData<TilePane, Number>("-fx-pref-tile-width", SizeConverter.getInstance(), (Number)-1.0){

            @Override
            public boolean isSettable(TilePane node) {
                return node.prefTileWidth == null || !node.prefTileWidth.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TilePane node) {
                return (StyleableProperty)((Object)node.prefTileWidthProperty());
            }
        };
        private static final CssMetaData<TilePane, Number> PREF_TILE_HEIGHT = new CssMetaData<TilePane, Number>("-fx-pref-tile-height", SizeConverter.getInstance(), (Number)-1.0){

            @Override
            public boolean isSettable(TilePane node) {
                return node.prefTileHeight == null || !node.prefTileHeight.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TilePane node) {
                return (StyleableProperty)((Object)node.prefTileHeightProperty());
            }
        };
        private static final CssMetaData<TilePane, Orientation> ORIENTATION = new CssMetaData<TilePane, Orientation>("-fx-orientation", new EnumConverter<Orientation>(Orientation.class), Orientation.HORIZONTAL){

            @Override
            public Orientation getInitialValue(TilePane node) {
                return node.getOrientation();
            }

            @Override
            public boolean isSettable(TilePane node) {
                return node.orientation == null || !node.orientation.isBound();
            }

            @Override
            public StyleableProperty<Orientation> getStyleableProperty(TilePane node) {
                return (StyleableProperty)((Object)node.orientationProperty());
            }
        };
        private static final CssMetaData<TilePane, Number> VGAP = new CssMetaData<TilePane, Number>("-fx-vgap", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(TilePane node) {
                return node.vgap == null || !node.vgap.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TilePane node) {
                return (StyleableProperty)((Object)node.vgapProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
            styleables.add(ALIGNMENT);
            styleables.add(HGAP);
            styleables.add(ORIENTATION);
            styleables.add(PREF_COLUMNS);
            styleables.add(PREF_ROWS);
            styleables.add(PREF_TILE_WIDTH);
            styleables.add(PREF_TILE_HEIGHT);
            styleables.add(TILE_ALIGNMENT);
            styleables.add(VGAP);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

