/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.media;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.MediaFrameTracker;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.media.jfxmedia.events.VideoFrameRateListener;
import com.sun.media.jfxmediaimpl.HostUtils;
import com.sun.media.jfxmediaimpl.platform.ios.IOSMediaPlayer;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.media.Media;
import javafx.scene.media.MediaErrorEvent;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView$$Lambda$1;
import javafx.scene.media.MediaView$$Lambda$2;
import javafx.scene.media.MediaView$$Lambda$3;
import javafx.scene.media.MediaView$$Lambda$4;
import javafx.scene.media.MediaView$$Lambda$5;
import javafx.scene.media.MediaView$$Lambda$6;
import javafx.scene.media.NGMediaView;

public class MediaView
extends Node {
    private static final String VIDEO_FRAME_RATE_PROPERTY_NAME = "jfxmedia.decodedVideoFPS";
    private static final String DEFAULT_STYLE_CLASS = "media-view";
    private InvalidationListener errorListener = new MediaErrorInvalidationListener();
    private InvalidationListener mediaDimensionListener = MediaView$$Lambda$5.lambdaFactory$(this);
    private VideoFrameRateListener decodedFrameRateListener;
    private boolean registerVideoFrameRateListener = false;
    private boolean mediaPlayerReady;
    private ChangeListener<Parent> parentListener;
    private ChangeListener<Boolean> treeVisibleListener;
    private ChangeListener<Number> opacityListener;
    private ObjectProperty<MediaPlayer> mediaPlayer;
    private ObjectProperty<EventHandler<MediaErrorEvent>> onError;
    private BooleanProperty preserveRatio;
    private BooleanProperty smooth;
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty fitWidth;
    private DoubleProperty fitHeight;
    private ObjectProperty<Rectangle2D> viewport;
    private int decodedFrameCount;
    private int renderedFrameCount;

    private VideoFrameRateListener createVideoFrameRateListener() {
        String listenerProp = null;
        try {
            listenerProp = System.getProperty(VIDEO_FRAME_RATE_PROPERTY_NAME);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listenerProp == null || !Boolean.getBoolean(VIDEO_FRAME_RATE_PROPERTY_NAME)) {
            return null;
        }
        return MediaView$$Lambda$1.lambdaFactory$(this);
    }

    private void createListeners() {
        this.parentListener = MediaView$$Lambda$2.lambdaFactory$(this);
        this.treeVisibleListener = MediaView$$Lambda$3.lambdaFactory$(this);
        this.opacityListener = MediaView$$Lambda$4.lambdaFactory$(this);
    }

    private IOSMediaPlayer getIOSPlayer() {
        return (IOSMediaPlayer)this.getMediaPlayer().retrieveJfxPlayer();
    }

    private boolean determineVisibility() {
        return this.getParent() != null && this.isVisible();
    }

    private synchronized void updateOverlayVisibility() {
        if (this.mediaPlayerReady) {
            this.getIOSPlayer().setOverlayVisible(this.determineVisibility());
        }
    }

    private synchronized void updateOverlayOpacity() {
        if (this.mediaPlayerReady) {
            this.getIOSPlayer().setOverlayOpacity(this.getOpacity());
        }
    }

    private synchronized void updateOverlayX() {
        if (this.mediaPlayerReady) {
            this.getIOSPlayer().setOverlayX(this.getX());
        }
    }

    private synchronized void updateOverlayY() {
        if (this.mediaPlayerReady) {
            this.getIOSPlayer().setOverlayY(this.getY());
        }
    }

    private synchronized void updateOverlayWidth() {
        if (this.mediaPlayerReady) {
            this.getIOSPlayer().setOverlayWidth(this.getFitWidth());
        }
    }

    private synchronized void updateOverlayHeight() {
        if (this.mediaPlayerReady) {
            this.getIOSPlayer().setOverlayHeight(this.getFitHeight());
        }
    }

    private synchronized void updateOverlayPreserveRatio() {
        if (this.mediaPlayerReady) {
            this.getIOSPlayer().setOverlayPreserveRatio(this.isPreserveRatio());
        }
    }

    private static Affine3D calculateNodeToSceneTransform(Node node) {
        Affine3D transform = new Affine3D();
        do {
            transform.preConcatenate(node.impl_getLeafTransform());
        } while ((node = node.getParent()) != null);
        return transform;
    }

    private void updateOverlayTransformDirectly() {
        Affine3D trans = MediaView.calculateNodeToSceneTransform(this);
        this.getIOSPlayer().setOverlayTransform(trans.getMxx(), trans.getMxy(), trans.getMxz(), trans.getMxt(), trans.getMyx(), trans.getMyy(), trans.getMyz(), trans.getMyt(), trans.getMzx(), trans.getMzy(), trans.getMzz(), trans.getMzt());
    }

    private synchronized void updateOverlayTransform() {
        if (this.mediaPlayerReady) {
            this.updateOverlayTransformDirectly();
        }
    }

    private void updateIOSOverlay() {
        this.getIOSPlayer().setOverlayX(this.getX());
        this.getIOSPlayer().setOverlayY(this.getY());
        this.getIOSPlayer().setOverlayPreserveRatio(this.isPreserveRatio());
        this.getIOSPlayer().setOverlayWidth(this.getFitWidth());
        this.getIOSPlayer().setOverlayHeight(this.getFitHeight());
        this.getIOSPlayer().setOverlayOpacity(this.getOpacity());
        this.getIOSPlayer().setOverlayVisible(this.determineVisibility());
        this.updateOverlayTransformDirectly();
    }

    @Override
    @Deprecated
    public void impl_transformsChanged() {
        super.impl_transformsChanged();
        if (HostUtils.isIOS()) {
            this.updateOverlayTransform();
        }
    }

    private MediaView getMediaView() {
        return this;
    }

    public MediaView() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setSmooth(Toolkit.getToolkit().getDefaultImageSmooth());
        this.decodedFrameRateListener = this.createVideoFrameRateListener();
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        if (HostUtils.isIOS()) {
            this.createListeners();
            this.parentProperty().addListener(this.parentListener);
            this.impl_treeVisibleProperty().addListener(this.treeVisibleListener);
            this.opacityProperty().addListener(this.opacityListener);
        }
    }

    public MediaView(MediaPlayer mediaPlayer) {
        this();
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.setMediaPlayer(mediaPlayer);
    }

    public final void setMediaPlayer(MediaPlayer value) {
        this.mediaPlayerProperty().set(value);
    }

    public final MediaPlayer getMediaPlayer() {
        return this.mediaPlayer == null ? null : (MediaPlayer)this.mediaPlayer.get();
    }

    public final ObjectProperty<MediaPlayer> mediaPlayerProperty() {
        if (this.mediaPlayer == null) {
            this.mediaPlayer = new ObjectPropertyBase<MediaPlayer>(){
                MediaPlayer oldValue = null;

                @Override
                protected void invalidated() {
                    MediaPlayer newValue;
                    if (this.oldValue != null) {
                        Media media = this.oldValue.getMedia();
                        if (media != null) {
                            media.widthProperty().removeListener(MediaView.this.mediaDimensionListener);
                            media.heightProperty().removeListener(MediaView.this.mediaDimensionListener);
                        }
                        if (MediaView.this.decodedFrameRateListener != null && MediaView.this.getMediaPlayer().retrieveJfxPlayer() != null) {
                            MediaView.this.getMediaPlayer().retrieveJfxPlayer().getVideoRenderControl().removeVideoFrameRateListener(MediaView.this.decodedFrameRateListener);
                        }
                        this.oldValue.errorProperty().removeListener(MediaView.this.errorListener);
                        this.oldValue.removeView(MediaView.this.getMediaView());
                    }
                    if ((newValue = (MediaPlayer)this.get()) != null) {
                        newValue.addView(MediaView.this.getMediaView());
                        newValue.errorProperty().addListener(MediaView.this.errorListener);
                        if (MediaView.this.decodedFrameRateListener != null && MediaView.this.getMediaPlayer().retrieveJfxPlayer() != null) {
                            MediaView.this.getMediaPlayer().retrieveJfxPlayer().getVideoRenderControl().addVideoFrameRateListener(MediaView.this.decodedFrameRateListener);
                        } else if (MediaView.this.decodedFrameRateListener != null) {
                            MediaView.this.registerVideoFrameRateListener = true;
                        }
                        Media media = newValue.getMedia();
                        if (media != null) {
                            media.widthProperty().addListener(MediaView.this.mediaDimensionListener);
                            media.heightProperty().addListener(MediaView.this.mediaDimensionListener);
                        }
                    }
                    MediaView.this.impl_markDirty(DirtyBits.MEDIAVIEW_MEDIA);
                    MediaView.this.impl_geomChanged();
                    this.oldValue = newValue;
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "mediaPlayer";
                }
            };
        }
        return this.mediaPlayer;
    }

    public final void setOnError(EventHandler<MediaErrorEvent> value) {
        this.onErrorProperty().set(value);
    }

    public final EventHandler<MediaErrorEvent> getOnError() {
        return this.onError == null ? null : (EventHandler)this.onError.get();
    }

    public final ObjectProperty<EventHandler<MediaErrorEvent>> onErrorProperty() {
        if (this.onError == null) {
            this.onError = new ObjectPropertyBase<EventHandler<MediaErrorEvent>>(){

                @Override
                protected void invalidated() {
                    MediaView.this.setEventHandler(MediaErrorEvent.MEDIA_ERROR, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "onError";
                }
            };
        }
        return this.onError;
    }

    public final void setPreserveRatio(boolean value) {
        this.preserveRatioProperty().set(value);
    }

    public final boolean isPreserveRatio() {
        return this.preserveRatio == null ? true : this.preserveRatio.get();
    }

    public final BooleanProperty preserveRatioProperty() {
        if (this.preserveRatio == null) {
            this.preserveRatio = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    if (HostUtils.isIOS()) {
                        MediaView.this.updateOverlayPreserveRatio();
                    } else {
                        MediaView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                        MediaView.this.impl_geomChanged();
                    }
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "preserveRatio";
                }
            };
        }
        return this.preserveRatio;
    }

    public final void setSmooth(boolean value) {
        this.smoothProperty().set(value);
    }

    public final boolean isSmooth() {
        return this.smooth == null ? false : this.smooth.get();
    }

    public final BooleanProperty smoothProperty() {
        if (this.smooth == null) {
            this.smooth = new BooleanPropertyBase(){

                @Override
                protected void invalidated() {
                    MediaView.this.impl_markDirty(DirtyBits.NODE_SMOOTH);
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "smooth";
                }
            };
        }
        return this.smooth;
    }

    public final void setX(double value) {
        this.xProperty().set(value);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    if (HostUtils.isIOS()) {
                        MediaView.this.updateOverlayX();
                    } else {
                        MediaView.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                        MediaView.this.impl_geomChanged();
                    }
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double value) {
        this.yProperty().set(value);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    if (HostUtils.isIOS()) {
                        MediaView.this.updateOverlayY();
                    } else {
                        MediaView.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                        MediaView.this.impl_geomChanged();
                    }
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setFitWidth(double value) {
        this.fitWidthProperty().set(value);
    }

    public final double getFitWidth() {
        return this.fitWidth == null ? 0.0 : this.fitWidth.get();
    }

    public final DoubleProperty fitWidthProperty() {
        if (this.fitWidth == null) {
            this.fitWidth = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    if (HostUtils.isIOS()) {
                        MediaView.this.updateOverlayWidth();
                    } else {
                        MediaView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                        MediaView.this.impl_geomChanged();
                    }
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "fitWidth";
                }
            };
        }
        return this.fitWidth;
    }

    public final void setFitHeight(double value) {
        this.fitHeightProperty().set(value);
    }

    public final double getFitHeight() {
        return this.fitHeight == null ? 0.0 : this.fitHeight.get();
    }

    public final DoubleProperty fitHeightProperty() {
        if (this.fitHeight == null) {
            this.fitHeight = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    if (HostUtils.isIOS()) {
                        MediaView.this.updateOverlayHeight();
                    } else {
                        MediaView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                        MediaView.this.impl_geomChanged();
                    }
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "fitHeight";
                }
            };
        }
        return this.fitHeight;
    }

    public final void setViewport(Rectangle2D value) {
        this.viewportProperty().set(value);
    }

    public final Rectangle2D getViewport() {
        return this.viewport == null ? null : (Rectangle2D)this.viewport.get();
    }

    public final ObjectProperty<Rectangle2D> viewportProperty() {
        if (this.viewport == null) {
            this.viewport = new ObjectPropertyBase<Rectangle2D>(){

                @Override
                protected void invalidated() {
                    MediaView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    MediaView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "viewport";
                }
            };
        }
        return this.viewport;
    }

    void notifyMediaChange() {
        MediaPlayer player = this.getMediaPlayer();
        if (player != null) {
            NGMediaView peer = (NGMediaView)this.impl_getPeer();
            peer.setMediaProvider(player);
        }
        this.impl_markDirty(DirtyBits.MEDIAVIEW_MEDIA);
        this.impl_geomChanged();
    }

    void notifyMediaSizeChange() {
        this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
        this.impl_geomChanged();
    }

    void notifyMediaFrameUpdated() {
        ++this.decodedFrameCount;
        this.impl_markDirty(DirtyBits.NODE_CONTENTS);
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        NGMediaView peer = new NGMediaView();
        peer.setFrameTracker(new MediaViewFrameTracker());
        return peer;
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        double vh;
        Media media = this.getMediaPlayer() == null ? null : this.getMediaPlayer().getMedia();
        double w = media != null ? (double)media.getWidth() : 0.0;
        double h = media != null ? (double)media.getHeight() : 0.0;
        double newW = this.getFitWidth();
        double newH = this.getFitHeight();
        double vw = this.getViewport() != null ? this.getViewport().getWidth() : 0.0;
        double d = vh = this.getViewport() != null ? this.getViewport().getHeight() : 0.0;
        if (vw > 0.0 && vh > 0.0) {
            w = vw;
            h = vh;
        }
        if (this.getFitWidth() <= 0.0 && this.getFitHeight() <= 0.0) {
            newW = w;
            newH = h;
        } else if (this.isPreserveRatio()) {
            if (this.getFitWidth() <= 0.0) {
                newW = h > 0.0 ? w * (this.getFitHeight() / h) : 0.0;
                newH = this.getFitHeight();
            } else if (this.getFitHeight() <= 0.0) {
                newW = this.getFitWidth();
                newH = w > 0.0 ? h * (this.getFitWidth() / w) : 0.0;
            } else {
                if (w == 0.0) {
                    w = this.getFitWidth();
                }
                if (h == 0.0) {
                    h = this.getFitHeight();
                }
                double scale = Math.min(this.getFitWidth() / w, this.getFitHeight() / h);
                newW = w * scale;
                newH = h * scale;
            }
        } else if (this.getFitHeight() <= 0.0) {
            newH = h;
        } else if (this.getFitWidth() <= 0.0) {
            newW = w;
        }
        if (newH < 1.0) {
            newH = 1.0;
        }
        if (newW < 1.0) {
            newW = 1.0;
        }
        w = newW;
        h = newH;
        if (w <= 0.0 || h <= 0.0) {
            return bounds.makeEmpty();
        }
        bounds = bounds.deriveWithNewBounds((float)this.getX(), (float)this.getY(), 0.0f, (float)(this.getX() + w), (float)(this.getY() + h), 0.0f);
        bounds = tx.transform(bounds, bounds);
        return bounds;
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double localX, double localY) {
        return true;
    }

    void updateViewport() {
        if (this.getMediaPlayer() == null) {
            return;
        }
        NGMediaView peer = (NGMediaView)this.impl_getPeer();
        if (this.getViewport() != null) {
            peer.setViewport((float)this.getFitWidth(), (float)this.getFitHeight(), (float)this.getViewport().getMinX(), (float)this.getViewport().getMinY(), (float)this.getViewport().getWidth(), (float)this.getViewport().getHeight(), this.isPreserveRatio());
        } else {
            peer.setViewport((float)this.getFitWidth(), (float)this.getFitHeight(), 0.0f, 0.0f, 0.0f, 0.0f, this.isPreserveRatio());
        }
    }

    @Override
    @Deprecated
    public void impl_updatePeer() {
        super.impl_updatePeer();
        NGMediaView peer = (NGMediaView)this.impl_getPeer();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            peer.setX((float)this.getX());
            peer.setY((float)this.getY());
        }
        if (this.impl_isDirty(DirtyBits.NODE_SMOOTH)) {
            peer.setSmooth(this.isSmooth());
        }
        if (this.impl_isDirty(DirtyBits.NODE_VIEWPORT)) {
            this.updateViewport();
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            peer.renderNextFrame();
        }
        if (this.impl_isDirty(DirtyBits.MEDIAVIEW_MEDIA)) {
            MediaPlayer player = this.getMediaPlayer();
            if (player != null) {
                peer.setMediaProvider(player);
                this.updateViewport();
            } else {
                peer.setMediaProvider(null);
            }
        }
    }

    @Deprecated
    public void impl_perfReset() {
        this.decodedFrameCount = 0;
        this.renderedFrameCount = 0;
    }

    @Deprecated
    public int impl_perfGetDecodedFrameCount() {
        return this.decodedFrameCount;
    }

    @Deprecated
    public int impl_perfGetRenderedFrameCount() {
        return this.renderedFrameCount;
    }

    @Override
    @Deprecated
    public Object impl_processMXNode(MXNodeAlgorithm alg, MXNodeAlgorithmContext ctx) {
        return alg.processLeafNode(this, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _mediaPlayerOnReady() {
        if (this.decodedFrameRateListener != null && this.getMediaPlayer().retrieveJfxPlayer() != null && this.registerVideoFrameRateListener) {
            this.getMediaPlayer().retrieveJfxPlayer().getVideoRenderControl().addVideoFrameRateListener(this.decodedFrameRateListener);
            this.registerVideoFrameRateListener = false;
        }
        if (HostUtils.isIOS()) {
            MediaView mediaView = this;
            synchronized (mediaView) {
                this.updateIOSOverlay();
                this.mediaPlayerReady = true;
            }
        }
    }

    /* synthetic */ void lambda$createListeners$33(ObservableValue ov, Number oldOpacity, Number newOpacity) {
        this.updateOverlayOpacity();
    }

    /* synthetic */ void lambda$createListeners$32(ObservableValue ov1, Boolean oldVisible, Boolean newVisible) {
        this.updateOverlayVisibility();
    }

    /* synthetic */ void lambda$createListeners$31(ObservableValue ov2, Parent oldParent, Parent newParent) {
        this.updateOverlayVisibility();
    }

    /* synthetic */ void lambda$createVideoFrameRateListener$30(double videoFrameRate) {
        Platform.runLater(MediaView$$Lambda$6.lambdaFactory$(this, videoFrameRate));
    }

    /* synthetic */ void lambda$null$29(double d) {
        ObservableMap<Object, Object> props = this.getProperties();
        props.put(VIDEO_FRAME_RATE_PROPERTY_NAME, d);
    }

    /* synthetic */ void lambda$new$28(Observable value) {
        this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
        this.impl_geomChanged();
    }

    private class MediaViewFrameTracker
    implements MediaFrameTracker {
        private MediaViewFrameTracker() {
        }

        @Override
        public void incrementDecodedFrameCount(int count) {
            MediaView.this.decodedFrameCount = MediaView.this.decodedFrameCount + count;
        }

        @Override
        public void incrementRenderedFrameCount(int count) {
            MediaView.this.renderedFrameCount = MediaView.this.renderedFrameCount + count;
        }
    }

    private class MediaErrorInvalidationListener
    implements InvalidationListener {
        private MediaErrorInvalidationListener() {
        }

        @Override
        public void invalidated(Observable value) {
            ObservableObjectValue errorProperty = (ObservableObjectValue)value;
            MediaView.this.fireEvent(new MediaErrorEvent((Object)MediaView.this.getMediaPlayer(), (EventTarget)MediaView.this.getMediaView(), (MediaException)errorProperty.get()));
        }
    }
}

