package org.javafxports.helloworld;

import javafx.application.Application;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class HelloAndroid extends Application {

    @Override
    public void start (Stage stage) throws Exception {
        int cnt = 0;
        Screen primaryScreen = Screen.getPrimary();
        Rectangle2D visualBounds = primaryScreen.getVisualBounds();
        double width = visualBounds.getWidth();
        double height = visualBounds.getHeight();
        Label l = new Label("Click the button.");
        l.setTranslateY(30);
        Button button = new Button("Hello Android");
        button.setOnAction(e -> l.setText("You clicked the button."));
        Rectangle rectangle = new Rectangle(width-20, height-20);
        rectangle.setFill(Color.LIGHTBLUE);
        rectangle.setArcHeight(6);
        rectangle.setArcWidth(6);
        StackPane stackPane = new StackPane();
        stackPane.getChildren().addAll(rectangle, button, l);
        Scene scene = new Scene (stackPane, visualBounds.getWidth(), visualBounds.getHeight());
       
        stage.setScene(scene);
        stage.show();
    }


}
