/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.GestureSupport$$Lambda$1;
import com.sun.glass.ui.TouchInputSupport;
import com.sun.glass.ui.View;

public final class GestureSupport {
    private static final double THRESHOLD_SCROLL = 1.0;
    private static final double THRESHOLD_SCALE = 0.01;
    private static final double THRESHOLD_EXPANSION = 0.01;
    private static final double THRESHOLD_ROTATE = Math.toDegrees(Math.PI / 180);
    private final GestureState scrolling = new GestureState();
    private final GestureState rotating = new GestureState();
    private final GestureState zooming = new GestureState();
    private final GestureState swiping = new GestureState();
    private double totalScrollX = Double.NaN;
    private double totalScrollY = Double.NaN;
    private double totalScale = 1.0;
    private double totalExpansion = Double.NaN;
    private double totalRotation = 0.0;
    private double multiplierX = 1.0;
    private double multiplierY = 1.0;
    private boolean zoomWithExpansion;

    public GestureSupport(boolean zoomWithExpansion) {
        this.zoomWithExpansion = zoomWithExpansion;
    }

    private static double multiplicativeDelta(double from, double to) {
        if (from == 0.0) {
            return Double.NaN;
        }
        return to / from;
    }

    private int setScrolling(boolean isInertia) {
        return this.scrolling.updateProgress(isInertia);
    }

    private int setRotating(boolean isInertia) {
        return this.rotating.updateProgress(isInertia);
    }

    private int setZooming(boolean isInertia) {
        return this.zooming.updateProgress(isInertia);
    }

    private int setSwiping(boolean isInertia) {
        return this.swiping.updateProgress(isInertia);
    }

    public boolean isScrolling() {
        return !this.scrolling.isIdle();
    }

    public boolean isRotating() {
        return !this.rotating.isIdle();
    }

    public boolean isZooming() {
        return !this.zooming.isIdle();
    }

    public boolean isSwiping() {
        return !this.swiping.isIdle();
    }

    public void handleScrollingEnd(View view, int modifiers, int touchCount, boolean isDirect, boolean isInertia, int x, int y, int xAbs, int yAbs) {
        this.scrolling.setIdle();
        if (isInertia) {
            return;
        }
        view.notifyScrollGestureEvent(3, modifiers, isDirect, isInertia, touchCount, x, y, xAbs, yAbs, 0.0, 0.0, this.totalScrollX, this.totalScrollY, this.multiplierX, this.multiplierY);
    }

    public void handleRotationEnd(View view, int modifiers, boolean isDirect, boolean isInertia, int x, int y, int xAbs, int yAbs) {
        this.rotating.setIdle();
        if (isInertia) {
            return;
        }
        view.notifyRotateGestureEvent(3, modifiers, isDirect, isInertia, x, y, xAbs, yAbs, 0.0, this.totalRotation);
    }

    public void handleZoomingEnd(View view, int modifiers, boolean isDirect, boolean isInertia, int x, int y, int xAbs, int yAbs) {
        this.zooming.setIdle();
        if (isInertia) {
            return;
        }
        view.notifyZoomGestureEvent(3, modifiers, isDirect, isInertia, x, y, xAbs, yAbs, Double.NaN, 0.0, this.totalScale, this.totalExpansion);
    }

    public void handleSwipeEnd(View view, int modifiers, boolean isDirect, boolean isInertia, int x, int y, int xAbs, int yAbs) {
        this.swiping.setIdle();
        if (isInertia) {
            return;
        }
        view.notifySwipeGestureEvent(3, modifiers, isDirect, isInertia, Integer.MAX_VALUE, Integer.MAX_VALUE, x, y, xAbs, yAbs);
    }

    public void handleTotalZooming(View view, int modifiers, boolean isDirect, boolean isInertia, int x, int y, int xAbs, int yAbs, double scale, double expansion) {
        double baseScale = this.totalScale;
        double baseExpansion = this.totalExpansion;
        if (this.zooming.doesGestureStart(isInertia)) {
            baseScale = 1.0;
            baseExpansion = 0.0;
        }
        if (Math.abs(scale - baseScale) < 0.01 && (!this.zoomWithExpansion || Math.abs(expansion - baseExpansion) < 0.01)) {
            return;
        }
        double deltaExpansion = Double.NaN;
        if (this.zoomWithExpansion) {
            deltaExpansion = expansion - baseExpansion;
        } else {
            expansion = Double.NaN;
        }
        this.totalScale = scale;
        this.totalExpansion = expansion;
        int eventID = this.setZooming(isInertia);
        view.notifyZoomGestureEvent(eventID, modifiers, isDirect, isInertia, x, y, xAbs, yAbs, GestureSupport.multiplicativeDelta(baseScale, this.totalScale), deltaExpansion, scale, expansion);
    }

    public void handleTotalRotation(View view, int modifiers, boolean isDirect, boolean isInertia, int x, int y, int xAbs, int yAbs, double rotation) {
        double baseRotation = this.totalRotation;
        if (this.rotating.doesGestureStart(isInertia)) {
            baseRotation = 0.0;
        }
        if (Math.abs(rotation - baseRotation) < THRESHOLD_ROTATE) {
            return;
        }
        this.totalRotation = rotation;
        int eventID = this.setRotating(isInertia);
        view.notifyRotateGestureEvent(eventID, modifiers, isDirect, isInertia, x, y, xAbs, yAbs, rotation - baseRotation, rotation);
    }

    public void handleTotalScrolling(View view, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int x, int y, int xAbs, int yAbs, double dx, double dy, double multiplierX, double multiplierY) {
        this.multiplierX = multiplierX;
        this.multiplierY = multiplierY;
        double baseScrollX = this.totalScrollX;
        double baseScrollY = this.totalScrollY;
        if (this.scrolling.doesGestureStart(isInertia)) {
            baseScrollX = 0.0;
            baseScrollY = 0.0;
        }
        if (Math.abs(dx - this.totalScrollX) < 1.0 && Math.abs(dy - this.totalScrollY) < 1.0) {
            return;
        }
        this.totalScrollX = dx;
        this.totalScrollY = dy;
        int eventID = this.setScrolling(isInertia);
        view.notifyScrollGestureEvent(eventID, modifiers, isDirect, isInertia, touchCount, x, y, xAbs, yAbs, dx - baseScrollX, dy - baseScrollY, dx, dy, multiplierX, multiplierY);
    }

    public void handleDeltaZooming(View view, int modifiers, boolean isDirect, boolean isInertia, int x, int y, int xAbs, int yAbs, double scale, double expansion) {
        double baseScale = this.totalScale;
        double baseExpansion = this.totalExpansion;
        if (this.zooming.doesGestureStart(isInertia)) {
            baseScale = 1.0;
            baseExpansion = 0.0;
        }
        this.totalScale = baseScale * (1.0 + scale);
        this.totalExpansion = this.zoomWithExpansion ? baseExpansion + expansion : Double.NaN;
        int eventID = this.setZooming(isInertia);
        view.notifyZoomGestureEvent(eventID, modifiers, isDirect, isInertia, x, y, xAbs, yAbs, GestureSupport.multiplicativeDelta(baseScale, this.totalScale), expansion, this.totalScale, this.totalExpansion);
    }

    public void handleDeltaRotation(View view, int modifiers, boolean isDirect, boolean isInertia, int x, int y, int xAbs, int yAbs, double rotation) {
        double baseRotation = this.totalRotation;
        if (this.rotating.doesGestureStart(isInertia)) {
            baseRotation = 0.0;
        }
        this.totalRotation = baseRotation + rotation;
        int eventID = this.setRotating(isInertia);
        view.notifyRotateGestureEvent(eventID, modifiers, isDirect, isInertia, x, y, xAbs, yAbs, rotation, this.totalRotation);
    }

    public void handleDeltaScrolling(View view, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int x, int y, int xAbs, int yAbs, double dx, double dy, double multiplierX, double multiplierY) {
        this.multiplierX = multiplierX;
        this.multiplierY = multiplierY;
        double baseScrollX = this.totalScrollX;
        double baseScrollY = this.totalScrollY;
        if (this.scrolling.doesGestureStart(isInertia)) {
            baseScrollX = 0.0;
            baseScrollY = 0.0;
        }
        this.totalScrollX = baseScrollX + dx;
        this.totalScrollY = baseScrollY + dy;
        int eventID = this.setScrolling(isInertia);
        view.notifyScrollGestureEvent(eventID, modifiers, isDirect, isInertia, touchCount, x, y, xAbs, yAbs, dx, dy, this.totalScrollX, this.totalScrollY, multiplierX, multiplierY);
    }

    public void handleSwipe(View view, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int dir, int x, int y, int xAbs, int yAbs) {
        int eventID = this.setSwiping(isInertia);
        view.notifySwipeGestureEvent(eventID, modifiers, isDirect, isInertia, touchCount, dir, x, y, xAbs, yAbs);
    }

    public static void handleSwipePerformed(View view, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int dir, int x, int y, int xAbs, int yAbs) {
        view.notifySwipeGestureEvent(2, modifiers, isDirect, isInertia, touchCount, dir, x, y, xAbs, yAbs);
    }

    public static void handleScrollingPerformed(View view, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int x, int y, int xAbs, int yAbs, double dx, double dy, double multiplierX, double multiplierY) {
        view.notifyScrollGestureEvent(2, modifiers, isDirect, isInertia, touchCount, x, y, xAbs, yAbs, dx, dy, dx, dy, multiplierX, multiplierY);
    }

    public TouchInputSupport.TouchCountListener createTouchCountListener() {
        Application.checkEventThread();
        return GestureSupport$$Lambda$1.lambdaFactory$(this);
    }

    /* synthetic */ void lambda$createTouchCountListener$42(TouchInputSupport sender, View view, int modifiers, boolean isDirect) {
        boolean isInertia = false;
        if (this.isScrolling()) {
            this.handleScrollingEnd(view, modifiers, sender.getTouchCount(), isDirect, false, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        if (this.isRotating()) {
            this.handleRotationEnd(view, modifiers, isDirect, false, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        if (this.isZooming()) {
            this.handleZoomingEnd(view, modifiers, isDirect, false, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    private static class GestureState {
        private StateId id = StateId.Idle;

        private GestureState() {
        }

        void setIdle() {
            this.id = StateId.Idle;
        }

        boolean isIdle() {
            return this.id == StateId.Idle;
        }

        int updateProgress(boolean isInertia) {
            int eventID = 2;
            if (this.doesGestureStart(isInertia) && !isInertia) {
                eventID = 1;
            }
            this.id = isInertia ? StateId.Inertia : StateId.Running;
            return eventID;
        }

        boolean doesGestureStart(boolean isInertia) {
            switch (this.id) {
                case Running: {
                    return isInertia;
                }
                case Inertia: {
                    return !isInertia;
                }
            }
            return true;
        }

        static enum StateId {
            Idle,
            Running,
            Inertia;

        }
    }
}

