/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.monocle.KeyInput;
import com.sun.glass.ui.monocle.KeyState;
import com.sun.glass.ui.monocle.MonoclePixels;
import com.sun.glass.ui.monocle.MonocleRobot$$Lambda$1;
import com.sun.glass.ui.monocle.MonocleRobot$$Lambda$2;
import com.sun.glass.ui.monocle.MonocleRobot$$Lambda$3;
import com.sun.glass.ui.monocle.MonocleRobot$$Lambda$4;
import com.sun.glass.ui.monocle.MonocleRobot$$Lambda$5;
import com.sun.glass.ui.monocle.MonocleRobot$$Lambda$6;
import com.sun.glass.ui.monocle.MouseInput;
import com.sun.glass.ui.monocle.MouseState;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javafx.application.Platform;

class MonocleRobot
extends Robot {
    MonocleRobot() {
    }

    @Override
    protected void _create() {
    }

    @Override
    protected void _destroy() {
    }

    @Override
    protected void _keyPress(int code) {
        Platform.runLater(MonocleRobot$$Lambda$1.lambdaFactory$(code));
    }

    @Override
    protected void _keyRelease(int code) {
        Platform.runLater(MonocleRobot$$Lambda$2.lambdaFactory$(code));
    }

    @Override
    protected void _mouseMove(int x, int y) {
        Platform.runLater(MonocleRobot$$Lambda$3.lambdaFactory$(x, y));
    }

    @Override
    protected void _mousePress(int buttons) {
        Platform.runLater(MonocleRobot$$Lambda$4.lambdaFactory$(buttons));
    }

    @Override
    protected void _mouseRelease(int buttons) {
        Platform.runLater(MonocleRobot$$Lambda$5.lambdaFactory$(buttons));
    }

    @Override
    protected void _mouseWheel(int wheelAmt) {
        Platform.runLater(MonocleRobot$$Lambda$6.lambdaFactory$(wheelAmt));
    }

    @Override
    protected int _getMouseX() {
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        return state.getX();
    }

    @Override
    protected int _getMouseY() {
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        return state.getY();
    }

    @Override
    protected int _getPixelColor(int x, int y) {
        NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
        int byteDepth = screen.getDepth() >>> 3;
        int bwidth = screen.getWidth();
        int bheight = screen.getHeight();
        if (x < 0 || x > bwidth || y < 0 || y > bheight) {
            return 0;
        }
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            ByteBuffer buffer = screen.getScreenCapture();
            if (byteDepth == 2) {
                ShortBuffer shortbuf = buffer.asShortBuffer();
                short v = shortbuf.get(y * bwidth + x);
                int red = (v & 0xF800) >> 11 << 3;
                int green = (v & 0x7E0) >> 5 << 2;
                int blue = (v & 0x1F) << 3;
                int p = 0xFF000000 | red << 16 | green << 8 | blue;
                return p;
            }
            if (byteDepth >= 4) {
                IntBuffer intbuf = buffer.asIntBuffer();
                return intbuf.get(y * bwidth + x);
            }
            throw new RuntimeException("Unknown bit depth");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Pixels _getScreenCapture(int x, int y, int width, int height, boolean isHiDPI) {
        NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
        int byteDepth = screen.getDepth() >>> 3;
        int scrWidth = screen.getWidth();
        int scrHeight = screen.getHeight();
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            IntBuffer buffer = screen.getScreenCapture().asIntBuffer();
            if (x == 0 && y == 0 && width == scrWidth && height == scrHeight) {
                return new MonoclePixels(width, height, buffer);
            }
            IntBuffer ret = IntBuffer.allocate(width * height);
            int rowStop = Math.min(y + height, scrHeight);
            int colStop = Math.min(x + width, scrWidth);
            for (int row = y; row < rowStop; ++row) {
                for (int col = x; col < colStop; ++col) {
                    ret.put(buffer.get(row * scrWidth + col));
                }
            }
            ret.rewind();
            return new MonoclePixels(width, height, ret);
        }
    }

    static /* synthetic */ void lambda$_mouseWheel$114(int n) {
        MouseState state = new MouseState();
        MouseInput mouse = MouseInput.getInstance();
        mouse.getState(state);
        int direction = n < 0 ? -1 : 1;
        for (int i = 0; i < Math.abs(n); ++i) {
            state.setWheel(direction);
            mouse.setState(state, false);
            state.setWheel(0);
            mouse.setState(state, false);
        }
    }

    static /* synthetic */ void lambda$_mouseRelease$113(int n) {
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        if ((n & 1) != 0) {
            state.releaseButton(212);
        }
        if ((n & 4) != 0) {
            state.releaseButton(214);
        }
        if ((n & 2) != 0) {
            state.releaseButton(213);
        }
        MouseInput.getInstance().setState(state, false);
    }

    static /* synthetic */ void lambda$_mousePress$112(int n) {
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        if ((n & 1) != 0) {
            state.pressButton(212);
        }
        if ((n & 4) != 0) {
            state.pressButton(214);
        }
        if ((n & 2) != 0) {
            state.pressButton(213);
        }
        MouseInput.getInstance().setState(state, false);
    }

    static /* synthetic */ void lambda$_mouseMove$111(int n, int n2) {
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        state.setX(n);
        state.setY(n2);
        MouseInput.getInstance().setState(state, false);
    }

    static /* synthetic */ void lambda$_keyRelease$110(int n) {
        KeyState state = new KeyState();
        KeyInput.getInstance().getState(state);
        state.releaseKey(n);
        KeyInput.getInstance().setState(state);
    }

    static /* synthetic */ void lambda$_keyPress$109(int n) {
        KeyState state = new KeyState();
        KeyInput.getInstance().getState(state);
        state.pressKey(n);
        KeyInput.getInstance().setState(state);
    }
}

