/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontFileReader;
import com.sun.javafx.font.PrismFontFile;

abstract class CMap {
    static final char noSuchChar = '\ufffd';
    static final int SHORTMASK = 65535;
    static final int INTMASK = -1;
    public static final NullCMapClass theNullCmap = new NullCMapClass();

    CMap() {
    }

    static CMap initialize(PrismFontFile font) {
        CMap cmap = null;
        int encodingID = -1;
        int three0 = 0;
        int three1 = 0;
        int three10 = 0;
        int zeroStarOffset = 0;
        boolean zeroStar = false;
        boolean threeStar = false;
        FontFileReader.Buffer cmapBuffer = font.readTable(1668112752);
        int numberSubTables = cmapBuffer.getShort(2);
        block5: for (int i = 0; i < numberSubTables; ++i) {
            cmapBuffer.position(i * 8 + 4);
            short platformID = cmapBuffer.getShort();
            if (platformID == 0) {
                zeroStar = true;
                encodingID = cmapBuffer.getShort();
                zeroStarOffset = cmapBuffer.getInt();
                continue;
            }
            if (platformID != 3) continue;
            threeStar = true;
            encodingID = cmapBuffer.getShort();
            int offset = cmapBuffer.getInt();
            switch (encodingID) {
                case 0: {
                    three0 = offset;
                    continue block5;
                }
                case 1: {
                    three1 = offset;
                    continue block5;
                }
                case 10: {
                    three10 = offset;
                }
            }
        }
        if (threeStar) {
            if (three10 != 0) {
                cmap = CMap.createCMap(cmapBuffer, three10);
            } else if (three0 != 0) {
                cmap = CMap.createCMap(cmapBuffer, three0);
            } else if (three1 != 0) {
                cmap = CMap.createCMap(cmapBuffer, three1);
            }
        } else {
            cmap = zeroStar && zeroStarOffset != 0 ? CMap.createCMap(cmapBuffer, zeroStarOffset) : CMap.createCMap(cmapBuffer, cmapBuffer.getInt(8));
        }
        return cmap;
    }

    static CMap createCMap(FontFileReader.Buffer buffer, int offset) {
        char subtableFormat = buffer.getChar(offset);
        switch (subtableFormat) {
            case '\u0000': {
                return new CMapFormat0(buffer, offset);
            }
            case '\u0002': {
                return new CMapFormat2(buffer, offset);
            }
            case '\u0004': {
                return new CMapFormat4(buffer, offset);
            }
            case '\u0006': {
                return new CMapFormat6(buffer, offset);
            }
            case '\b': {
                return new CMapFormat8(buffer, offset);
            }
            case '\n': {
                return new CMapFormat10(buffer, offset);
            }
            case '\f': {
                return new CMapFormat12(buffer, offset);
            }
        }
        throw new RuntimeException("Cmap format unimplemented: " + buffer.getChar(offset));
    }

    abstract char getGlyph(int var1);

    final int getControlCodeGlyph(int charCode, boolean noSurrogates) {
        if (charCode < 16) {
            switch (charCode) {
                case 9: 
                case 10: 
                case 13: {
                    return 65535;
                }
            }
        } else if (charCode >= 8204) {
            if (charCode <= 8207 || charCode >= 8232 && charCode <= 8238 || charCode >= 8298 && charCode <= 8303) {
                return 65535;
            }
            if (noSurrogates && charCode >= 65535) {
                return 0;
            }
        }
        return -1;
    }

    static class NullCMapClass
    extends CMap {
        NullCMapClass() {
        }

        @Override
        char getGlyph(int charCode) {
            return '\u0000';
        }
    }

    static class CMapFormat12
    extends CMap {
        int numGroups;
        int highBit = 0;
        int power;
        int extra;
        long[] startCharCode;
        long[] endCharCode;
        int[] startGlyphID;

        CMapFormat12(FontFileReader.Buffer buffer, int offset) {
            this.numGroups = buffer.getInt(offset + 12);
            this.startCharCode = new long[this.numGroups];
            this.endCharCode = new long[this.numGroups];
            this.startGlyphID = new int[this.numGroups];
            buffer.position(offset + 16);
            for (int i = 0; i < this.numGroups; ++i) {
                this.startCharCode[i] = buffer.getInt() & 0xFFFFFFFF;
                this.endCharCode[i] = buffer.getInt() & 0xFFFFFFFF;
                this.startGlyphID[i] = buffer.getInt() & 0xFFFFFFFF;
            }
            int value = this.numGroups;
            if (value >= 65536) {
                value >>= 16;
                this.highBit += 16;
            }
            if (value >= 256) {
                value >>= 8;
                this.highBit += 8;
            }
            if (value >= 16) {
                value >>= 4;
                this.highBit += 4;
            }
            if (value >= 4) {
                value >>= 2;
                this.highBit += 2;
            }
            if (value >= 2) {
                value >>= 1;
                ++this.highBit;
            }
            this.power = 1 << this.highBit;
            this.extra = this.numGroups - this.power;
        }

        @Override
        char getGlyph(int charCode) {
            int controlGlyph = this.getControlCodeGlyph(charCode, false);
            if (controlGlyph >= 0) {
                return (char)controlGlyph;
            }
            int probe = this.power;
            int range = 0;
            if (this.startCharCode[this.extra] <= (long)charCode) {
                range = this.extra;
            }
            while (probe > 1) {
                if (this.startCharCode[range + (probe >>= 1)] > (long)charCode) continue;
                range += probe;
            }
            if (this.startCharCode[range] <= (long)charCode && this.endCharCode[range] >= (long)charCode) {
                return (char)((long)this.startGlyphID[range] + ((long)charCode - this.startCharCode[range]));
            }
            return '\u0000';
        }
    }

    static class CMapFormat10
    extends CMap {
        long startCharCode;
        int numChars;
        char[] glyphIdArray;

        CMapFormat10(FontFileReader.Buffer buffer, int offset) {
            buffer.position(offset + 12);
            this.startCharCode = buffer.getInt() & 0xFFFFFFFF;
            this.numChars = buffer.getInt() & 0xFFFFFFFF;
            this.glyphIdArray = new char[this.numChars];
            for (int i = 0; i < this.numChars; ++i) {
                this.glyphIdArray[i] = buffer.getChar();
            }
        }

        @Override
        char getGlyph(int charCode) {
            int code = (int)((long)charCode - this.startCharCode);
            if (code < 0 || code >= this.numChars) {
                return '\u0000';
            }
            return this.glyphIdArray[code];
        }
    }

    static class CMapFormat8
    extends CMap {
        CMapFormat8(FontFileReader.Buffer buffer, int offset) {
        }

        @Override
        char getGlyph(int charCode) {
            return '\u0000';
        }
    }

    static class CMapFormat6
    extends CMap {
        char firstCode;
        char entryCount;
        char[] glyphIdArray;

        CMapFormat6(FontFileReader.Buffer buffer, int offset) {
            buffer.position(offset + 6);
            this.firstCode = buffer.getChar();
            this.entryCount = buffer.getChar();
            this.glyphIdArray = new char[this.entryCount];
            for (int i = 0; i < this.entryCount; ++i) {
                this.glyphIdArray[i] = buffer.getChar();
            }
        }

        @Override
        char getGlyph(int charCode) {
            int controlGlyph = this.getControlCodeGlyph(charCode, true);
            if (controlGlyph >= 0) {
                return (char)controlGlyph;
            }
            if ((charCode -= this.firstCode) < 0 || charCode >= this.entryCount) {
                return '\u0000';
            }
            return this.glyphIdArray[charCode];
        }
    }

    static class CMapFormat2
    extends CMap {
        char[] subHeaderKey = new char[256];
        char[] firstCodeArray;
        char[] entryCountArray;
        short[] idDeltaArray;
        char[] idRangeOffSetArray;
        char[] glyphIndexArray;

        CMapFormat2(FontFileReader.Buffer buffer, int offset) {
            char tableLen = buffer.getChar(offset + 2);
            buffer.position(offset + 6);
            char maxSubHeader = '\u0000';
            for (int i = 0; i < 256; ++i) {
                this.subHeaderKey[i] = buffer.getChar();
                if (this.subHeaderKey[i] <= maxSubHeader) continue;
                maxSubHeader = this.subHeaderKey[i];
            }
            int numSubHeaders = (maxSubHeader >> 3) + 1;
            this.firstCodeArray = new char[numSubHeaders];
            this.entryCountArray = new char[numSubHeaders];
            this.idDeltaArray = new short[numSubHeaders];
            this.idRangeOffSetArray = new char[numSubHeaders];
            for (int i = 0; i < numSubHeaders; ++i) {
                this.firstCodeArray[i] = buffer.getChar();
                this.entryCountArray[i] = buffer.getChar();
                this.idDeltaArray[i] = (short)buffer.getChar();
                this.idRangeOffSetArray[i] = buffer.getChar();
            }
            int glyphIndexArrSize = (tableLen - 518 - numSubHeaders * 8) / 2;
            this.glyphIndexArray = new char[glyphIndexArrSize];
            for (int i = 0; i < glyphIndexArrSize; ++i) {
                this.glyphIndexArray[i] = buffer.getChar();
            }
        }

        @Override
        char getGlyph(int charCode) {
            int glyphArrayOffset;
            int glyphSubArrayStart;
            char glyphCode;
            char mapMe;
            int controlGlyph = this.getControlCodeGlyph(charCode, true);
            if (controlGlyph >= 0) {
                return (char)controlGlyph;
            }
            char highByte = (char)(charCode >> 8);
            char lowByte = (char)(charCode & 0xFF);
            int key = this.subHeaderKey[highByte] >> 3;
            if (key != 0) {
                mapMe = lowByte;
            } else {
                mapMe = highByte;
                if (mapMe == '\u0000') {
                    mapMe = lowByte;
                }
            }
            char firstCode = this.firstCodeArray[key];
            if (mapMe < firstCode) {
                return '\u0000';
            }
            if ((mapMe = (char)(mapMe - firstCode)) < this.entryCountArray[key] && (glyphCode = this.glyphIndexArray[(glyphSubArrayStart = (this.idRangeOffSetArray[key] - (glyphArrayOffset = (this.idRangeOffSetArray.length - key) * 8 - 6)) / 2) + mapMe]) != '\u0000') {
                glyphCode = (char)(glyphCode + this.idDeltaArray[key]);
                return glyphCode;
            }
            return '\u0000';
        }
    }

    static class CMapFormat0
    extends CMap {
        byte[] cmap;

        CMapFormat0(FontFileReader.Buffer buffer, int offset) {
            char len = buffer.getChar(offset + 2);
            this.cmap = new byte[len - 6];
            buffer.get(offset + 6, this.cmap, 0, len - 6);
        }

        @Override
        char getGlyph(int charCode) {
            if (charCode < 256) {
                if (charCode < 16) {
                    switch (charCode) {
                        case 9: 
                        case 10: 
                        case 13: {
                            return '\uffff';
                        }
                    }
                }
                return (char)(0xFF & this.cmap[charCode]);
            }
            return '\u0000';
        }
    }

    static class CMapFormat4
    extends CMap {
        int segCount;
        int entrySelector;
        int rangeShift;
        char[] endCount;
        char[] startCount;
        short[] idDelta;
        char[] idRangeOffset;
        char[] glyphIds;

        CMapFormat4(FontFileReader.Buffer buffer, int offset) {
            int i;
            buffer.position(offset);
            buffer.getChar();
            int subtableLength = buffer.getChar();
            if (offset + subtableLength > buffer.capacity()) {
                subtableLength = buffer.capacity() - offset;
            }
            buffer.getChar();
            this.segCount = buffer.getChar() / 2;
            buffer.getChar();
            this.entrySelector = buffer.getChar();
            this.rangeShift = buffer.getChar() / 2;
            this.startCount = new char[this.segCount];
            this.endCount = new char[this.segCount];
            this.idDelta = new short[this.segCount];
            this.idRangeOffset = new char[this.segCount];
            for (i = 0; i < this.segCount; ++i) {
                this.endCount[i] = buffer.getChar();
            }
            buffer.getChar();
            for (i = 0; i < this.segCount; ++i) {
                this.startCount[i] = buffer.getChar();
            }
            for (i = 0; i < this.segCount; ++i) {
                this.idDelta[i] = (short)buffer.getChar();
            }
            for (i = 0; i < this.segCount; ++i) {
                char ctmp = buffer.getChar();
                this.idRangeOffset[i] = (char)(ctmp >> 1 & 0xFFFF);
            }
            int pos = (this.segCount * 8 + 16) / 2;
            buffer.position(pos * 2 + offset);
            int numGlyphIds = subtableLength / 2 - pos;
            this.glyphIds = new char[numGlyphIds];
            for (int i2 = 0; i2 < numGlyphIds; ++i2) {
                this.glyphIds[i2] = buffer.getChar();
            }
        }

        @Override
        char getGlyph(int charCode) {
            int index = 0;
            char glyphCode = '\u0000';
            int controlGlyph = this.getControlCodeGlyph(charCode, true);
            if (controlGlyph >= 0) {
                return (char)controlGlyph;
            }
            int left = 0;
            int right = this.startCount.length;
            index = this.startCount.length >> 1;
            while (left < right) {
                if (this.endCount[index] < charCode) {
                    left = index + 1;
                } else {
                    right = index;
                }
                index = left + right >> 1;
            }
            if (charCode >= this.startCount[index] && charCode <= this.endCount[index]) {
                char rangeOffset = this.idRangeOffset[index];
                if (rangeOffset == '\u0000') {
                    glyphCode = (char)(charCode + this.idDelta[index]);
                } else {
                    int glyphIDIndex = rangeOffset - this.segCount + index + (charCode - this.startCount[index]);
                    glyphCode = this.glyphIds[glyphIDIndex];
                    if (glyphCode != '\u0000') {
                        glyphCode = (char)(glyphCode + this.idDelta[index]);
                    }
                }
            }
            return glyphCode;
        }
    }
}

