/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.ArcIterator;
import com.sun.javafx.geom.Dimension2D;
import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RectangularShape;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;

public class Arc2D
extends RectangularShape {
    public static final int OPEN = 0;
    public static final int CHORD = 1;
    public static final int PIE = 2;
    private int type;
    public float x;
    public float y;
    public float width;
    public float height;
    public float start;
    public float extent;

    public Arc2D() {
        this(0);
    }

    public Arc2D(int type) {
        this.setArcType(type);
    }

    public Arc2D(float x, float y, float w, float h, float start, float extent, int type) {
        this(type);
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.start = start;
        this.extent = extent;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public boolean isEmpty() {
        return this.width <= 0.0f || this.height <= 0.0f;
    }

    public void setArc(float x, float y, float w, float h, float angSt, float angExt, int closure) {
        this.setArcType(closure);
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.start = angSt;
        this.extent = angExt;
    }

    public int getArcType() {
        return this.type;
    }

    public Point2D getStartPoint() {
        double angle = Math.toRadians(-this.start);
        double x = (double)this.x + (Math.cos(angle) * 0.5 + 0.5) * (double)this.width;
        double y = (double)this.y + (Math.sin(angle) * 0.5 + 0.5) * (double)this.height;
        return new Point2D((float)x, (float)y);
    }

    public Point2D getEndPoint() {
        double angle = Math.toRadians(-this.start - this.extent);
        double x = (double)this.x + (Math.cos(angle) * 0.5 + 0.5) * (double)this.width;
        double y = (double)this.y + (Math.sin(angle) * 0.5 + 0.5) * (double)this.height;
        return new Point2D((float)x, (float)y);
    }

    public void setArc(Point2D loc, Dimension2D size, float angSt, float angExt, int closure) {
        this.setArc(loc.x, loc.y, size.width, size.height, angSt, angExt, closure);
    }

    public void setArc(Arc2D a) {
        this.setArc(a.x, a.y, a.width, a.height, a.start, a.extent, a.type);
    }

    public void setArcByCenter(float x, float y, float radius, float angSt, float angExt, int closure) {
        this.setArc(x - radius, y - radius, radius * 2.0f, radius * 2.0f, angSt, angExt, closure);
    }

    public void setArcByTangent(Point2D p1, Point2D p2, Point2D p3, float radius) {
        double ang1 = Math.atan2(p1.y - p2.y, p1.x - p2.x);
        double ang2 = Math.atan2(p3.y - p2.y, p3.x - p2.x);
        double diff = ang2 - ang1;
        if (diff > Math.PI) {
            ang2 -= Math.PI * 2;
        } else if (diff < -Math.PI) {
            ang2 += Math.PI * 2;
        }
        double bisect = (ang1 + ang2) / 2.0;
        double theta = Math.abs(ang2 - bisect);
        double dist = (double)radius / Math.sin(theta);
        double x = (double)p2.x + dist * Math.cos(bisect);
        double y = (double)p2.y + dist * Math.sin(bisect);
        if (ang1 < ang2) {
            ang1 -= 1.5707963267948966;
            ang2 += 1.5707963267948966;
        } else {
            ang1 += 1.5707963267948966;
            ang2 -= 1.5707963267948966;
        }
        ang1 = Math.toDegrees(-ang1);
        ang2 = Math.toDegrees(-ang2);
        diff = ang2 - ang1;
        diff = diff < 0.0 ? (diff += 360.0) : (diff -= 360.0);
        this.setArcByCenter((float)x, (float)y, radius, (float)ang1, (float)diff, this.type);
    }

    public void setAngleStart(Point2D p) {
        double dx = this.height * (p.x - this.getCenterX());
        double dy = this.width * (p.y - this.getCenterY());
        this.start = (float)(-Math.toDegrees(Math.atan2(dy, dx)));
    }

    public void setAngles(float x1, float y1, float x2, float y2) {
        double x = this.getCenterX();
        double y = this.getCenterY();
        double w = this.width;
        double h = this.height;
        double ang1 = Math.atan2(w * (y - (double)y1), h * ((double)x1 - x));
        double ang2 = Math.atan2(w * (y - (double)y2), h * ((double)x2 - x));
        if ((ang2 -= ang1) <= 0.0) {
            ang2 += Math.PI * 2;
        }
        this.start = (float)Math.toDegrees(ang1);
        this.extent = (float)Math.toDegrees(ang2);
    }

    public void setAngles(Point2D p1, Point2D p2) {
        this.setAngles(p1.x, p1.y, p2.x, p2.y);
    }

    public void setArcType(int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("invalid type for Arc: " + type);
        }
        this.type = type;
    }

    @Override
    public void setFrame(float x, float y, float w, float h) {
        this.setArc(x, y, w, h, this.start, this.extent, this.type);
    }

    @Override
    public RectBounds getBounds() {
        double x1;
        double y1;
        double x2;
        double y2;
        if (this.isEmpty()) {
            return new RectBounds(this.x, this.y, this.x + this.width, this.y + this.height);
        }
        if (this.getArcType() == 2) {
            y2 = 0.0;
            x2 = 0.0;
            y1 = 0.0;
            x1 = 0.0;
        } else {
            y1 = 1.0;
            x1 = 1.0;
            y2 = -1.0;
            x2 = -1.0;
        }
        double angle = 0.0;
        for (int i = 0; i < 6; ++i) {
            if (i < 4) {
                if (!this.containsAngle((float)(angle += 90.0))) {
                    continue;
                }
            } else {
                angle = i == 4 ? (double)this.start : (angle += (double)this.extent);
            }
            double rads = Math.toRadians(-angle);
            double xe = Math.cos(rads);
            double ye = Math.sin(rads);
            x1 = Math.min(x1, xe);
            y1 = Math.min(y1, ye);
            x2 = Math.max(x2, xe);
            y2 = Math.max(y2, ye);
        }
        double w = this.width;
        double h = this.height;
        x2 = (double)this.x + (x2 * 0.5 + 0.5) * w;
        y2 = (double)this.y + (y2 * 0.5 + 0.5) * h;
        x1 = (double)this.x + (x1 * 0.5 + 0.5) * w;
        y1 = (double)this.y + (y1 * 0.5 + 0.5) * h;
        return new RectBounds((float)x1, (float)y1, (float)x2, (float)y2);
    }

    static float normalizeDegrees(double angle) {
        if (angle > 180.0) {
            if (angle <= 540.0) {
                angle -= 360.0;
            } else if ((angle = Math.IEEEremainder(angle, 360.0)) == -180.0) {
                angle = 180.0;
            }
        } else if (angle <= -180.0) {
            if (angle > -540.0) {
                angle += 360.0;
            } else if ((angle = Math.IEEEremainder(angle, 360.0)) == -180.0) {
                angle = 180.0;
            }
        }
        return (float)angle;
    }

    public boolean containsAngle(float angle) {
        boolean backwards;
        double angExt = this.extent;
        boolean bl = backwards = angExt < 0.0;
        if (backwards) {
            angExt = -angExt;
        }
        if (angExt >= 360.0) {
            return true;
        }
        angle = Arc2D.normalizeDegrees(angle) - Arc2D.normalizeDegrees(this.start);
        if (backwards) {
            angle = -angle;
        }
        if ((double)angle < 0.0) {
            angle = (float)((double)angle + 360.0);
        }
        return (double)angle >= 0.0 && (double)angle < angExt;
    }

    @Override
    public boolean contains(float x, float y) {
        double y2;
        double x2;
        double y1;
        boolean inside;
        double ellw = this.width;
        if (ellw <= 0.0) {
            return false;
        }
        double normx = (double)(x - this.x) / ellw - 0.5;
        double ellh = this.height;
        if (ellh <= 0.0) {
            return false;
        }
        double normy = (double)(y - this.y) / ellh - 0.5;
        double distSq = normx * normx + normy * normy;
        if (distSq >= 0.25) {
            return false;
        }
        double angExt = Math.abs(this.extent);
        if (angExt >= 360.0) {
            return true;
        }
        boolean inarc = this.containsAngle((float)(-Math.toDegrees(Math.atan2(normy, normx))));
        if (this.type == 2) {
            return inarc;
        }
        if (inarc) {
            if (angExt >= 180.0) {
                return true;
            }
        } else if (angExt <= 180.0) {
            return false;
        }
        double angle = Math.toRadians(-this.start);
        double x1 = Math.cos(angle);
        boolean bl = inside = Line2D.relativeCCW((float)x1, (float)(y1 = Math.sin(angle)), (float)(x2 = Math.cos(angle += Math.toRadians(-this.extent))), (float)(y2 = Math.sin(angle)), (float)(2.0 * normx), (float)(2.0 * normy)) * Line2D.relativeCCW((float)x1, (float)y1, (float)x2, (float)y2, 0.0f, 0.0f) >= 0;
        return inarc ? !inside : inside;
    }

    @Override
    public boolean intersects(float x, float y, float w, float h) {
        float aw = this.width;
        float ah = this.height;
        if (w <= 0.0f || h <= 0.0f || aw <= 0.0f || ah <= 0.0f) {
            return false;
        }
        float ext = this.extent;
        if (ext == 0.0f) {
            return false;
        }
        float ax = this.x;
        float ay = this.y;
        float axw = ax + aw;
        float ayh = ay + ah;
        float xw = x + w;
        float yh = y + h;
        if (x >= axw || y >= ayh || xw <= ax || yh <= ay) {
            return false;
        }
        float axc = this.getCenterX();
        float ayc = this.getCenterY();
        double sangle = Math.toRadians(-this.start);
        float sx = (float)((double)this.x + (Math.cos(sangle) * 0.5 + 0.5) * (double)this.width);
        float sy = (float)((double)this.y + (Math.sin(sangle) * 0.5 + 0.5) * (double)this.height);
        double eangle = Math.toRadians(-this.start - this.extent);
        float ex = (float)((double)this.x + (Math.cos(eangle) * 0.5 + 0.5) * (double)this.width);
        float ey = (float)((double)this.y + (Math.sin(eangle) * 0.5 + 0.5) * (double)this.height);
        if (ayc >= y && ayc <= yh && (sx < xw && ex < xw && axc < xw && axw > x && this.containsAngle(0.0f) || sx > x && ex > x && axc > x && ax < xw && this.containsAngle(180.0f))) {
            return true;
        }
        if (axc >= x && axc <= xw && (sy > y && ey > y && ayc > y && ay < yh && this.containsAngle(90.0f) || sy < yh && ey < yh && ayc < yh && ayh > y && this.containsAngle(270.0f))) {
            return true;
        }
        if (this.type == 2 || Math.abs(ext) > 180.0f ? Shape.intersectsLine(x, y, w, h, axc, ayc, sx, sy) || Shape.intersectsLine(x, y, w, h, axc, ayc, ex, ey) : Shape.intersectsLine(x, y, w, h, sx, sy, ex, ey)) {
            return true;
        }
        return this.contains(x, y) || this.contains(x + w, y) || this.contains(x, y + h) || this.contains(x + w, y + h);
    }

    @Override
    public boolean contains(float x, float y, float w, float h) {
        float ye;
        float angle;
        float xe;
        float halfH;
        float yc;
        if (!(this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h))) {
            return false;
        }
        if (this.type != 2 || (double)Math.abs(this.extent) <= 180.0) {
            return true;
        }
        float halfW = this.getWidth() / 2.0f;
        float xc = x + halfW;
        if (Shape.intersectsLine(x, y, w, h, xc, yc = y + (halfH = this.getHeight() / 2.0f), xe = (float)((double)xc + (double)halfW * Math.cos(angle = (float)Math.toRadians(-this.start))), ye = (float)((double)yc + (double)halfH * Math.sin(angle)))) {
            return false;
        }
        xe = (float)((double)xc + (double)halfW * Math.cos(angle += (float)Math.toRadians(-this.extent)));
        return !Shape.intersectsLine(x, y, w, h, xc, yc, xe, ye = (float)((double)yc + (double)halfH * Math.sin(angle)));
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx) {
        return new ArcIterator(this, tx);
    }

    @Override
    public Arc2D copy() {
        return new Arc2D(this.x, this.y, this.width, this.height, this.start, this.extent, this.type);
    }

    public int hashCode() {
        int bits = Float.floatToIntBits(this.x);
        bits += Float.floatToIntBits(this.y) * 37;
        bits += Float.floatToIntBits(this.width) * 43;
        bits += Float.floatToIntBits(this.height) * 47;
        bits += Float.floatToIntBits(this.start) * 53;
        bits += Float.floatToIntBits(this.extent) * 59;
        return bits += this.getArcType() * 61;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Arc2D) {
            Arc2D a2d = (Arc2D)obj;
            return this.x == a2d.x && this.y == a2d.y && this.width == a2d.width && this.height == a2d.height && this.start == a2d.start && this.extent == a2d.extent && this.type == a2d.type;
        }
        return false;
    }
}

