/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.bmp;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.bmp.BMPDescriptor;
import com.sun.javafx.iio.bmp.BMPImageLoader$$Lambda$1;
import com.sun.javafx.iio.bmp.BMPImageLoader$$Lambda$2;
import com.sun.javafx.iio.bmp.BitmapInfoHeader;
import com.sun.javafx.iio.bmp.LEInputStream;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import com.sun.javafx.iio.common.ImageTools;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class BMPImageLoader
extends ImageLoaderImpl {
    static final short BM = 19778;
    static final int BFH_SIZE = 14;
    final LEInputStream data;
    int bfSize;
    int bfOffBits;
    byte[] bgra_palette;
    BitmapInfoHeader bih;
    int[] bitMasks;
    int[] bitOffsets;

    BMPImageLoader(InputStream input) throws IOException {
        super(BMPDescriptor.theInstance);
        this.data = new LEInputStream(input);
        if (this.data.readShort() != 19778) {
            throw new IOException("Invalid BMP file signature");
        }
        this.readHeader();
    }

    private void readHeader() throws IOException {
        this.bfSize = this.data.readInt();
        this.data.skipBytes(4);
        this.bfOffBits = this.data.readInt();
        this.bih = new BitmapInfoHeader(this.data);
        if (this.bfOffBits < this.bih.biSize + 14) {
            throw new IOException("Invalid bitmap bits offset");
        }
        if (this.bih.biSize + 14 != this.bfOffBits) {
            int length = this.bfOffBits - this.bih.biSize - 14;
            int paletteSize = length / 4;
            this.bgra_palette = new byte[paletteSize * 4];
            int read = this.data.in.read(this.bgra_palette);
            if (read < length) {
                this.data.skipBytes(length - read);
            }
        }
        if (this.bih.biCompression == 3) {
            this.parseBitfields();
        } else if (this.bih.biCompression == 0 && this.bih.biBitCount == 16) {
            this.bitMasks = new int[]{31744, 992, 31};
            this.bitOffsets = new int[]{10, 5, 0};
        }
    }

    private void parseBitfields() throws IOException {
        if (this.bgra_palette.length != 12) {
            throw new IOException("Invalid bit masks");
        }
        this.bitMasks = new int[3];
        this.bitOffsets = new int[3];
        for (int i = 0; i < 3; ++i) {
            int mask;
            this.bitMasks[i] = mask = BMPImageLoader.getDWord(this.bgra_palette, i * 4);
            int offset = 0;
            if (mask != 0) {
                while ((mask & 1) == 0) {
                    ++offset;
                    mask >>>= 1;
                }
                if (!BMPImageLoader.isPow2Minus1(mask)) {
                    throw new IOException("Bit mask is not contiguous");
                }
            }
            this.bitOffsets[i] = offset;
        }
        if (!BMPImageLoader.checkDisjointMasks(this.bitMasks[0], this.bitMasks[1], this.bitMasks[2])) {
            throw new IOException("Bit masks overlap");
        }
    }

    static boolean checkDisjointMasks(int m1, int m2, int m3) {
        return (m1 & m2 | m1 & m3 | m2 & m3) == 0;
    }

    static boolean isPow2Minus1(int i) {
        return (i & i + 1) == 0;
    }

    @Override
    public void dispose() {
    }

    private void readRLE(byte[] image, int rowLength, int hght, boolean isRLE4) throws IOException {
        int imgSize = this.bih.biSizeImage;
        if (imgSize == 0) {
            imgSize = this.bfSize - this.bfOffBits;
        }
        byte[] imgData = new byte[imgSize];
        ImageTools.readFully(this.data.in, imgData);
        boolean isBottomUp = this.bih.biHeight > 0;
        int line = isBottomUp ? hght - 1 : 0;
        int i = 0;
        int dstOffset = line * rowLength;
        block5: while (i < imgSize) {
            int b1 = BMPImageLoader.getByte(imgData, i++);
            int b2 = BMPImageLoader.getByte(imgData, i++);
            if (b1 == 0) {
                switch (b2) {
                    case 0: {
                        dstOffset = (line += isBottomUp ? -1 : 1) * rowLength;
                        break;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        int deltaX = BMPImageLoader.getByte(imgData, i++);
                        int deltaY = BMPImageLoader.getByte(imgData, i++);
                        line += deltaY;
                        dstOffset += deltaY * rowLength;
                        dstOffset += deltaX * 3;
                        break;
                    }
                    default: {
                        int indexData = 0;
                        for (int p = 0; p < b2; ++p) {
                            int index;
                            if (isRLE4) {
                                if ((p & 1) == 0) {
                                    indexData = BMPImageLoader.getByte(imgData, i++);
                                    index = (indexData & 0xF0) >> 4;
                                } else {
                                    index = indexData & 0xF;
                                }
                            } else {
                                index = BMPImageLoader.getByte(imgData, i++);
                            }
                            dstOffset = this.setRGBFromPalette(image, dstOffset, index);
                        }
                        if (isRLE4) {
                            if ((b2 & 3) != 1 && (b2 & 3) != 2) continue block5;
                            ++i;
                            break;
                        }
                        if ((b2 & 1) != 1) continue block5;
                        ++i;
                        break;
                    }
                }
                continue;
            }
            if (isRLE4) {
                int index1 = (b2 & 0xF0) >> 4;
                int index2 = b2 & 0xF;
                for (int p = 0; p < b1; ++p) {
                    dstOffset = this.setRGBFromPalette(image, dstOffset, (p & 1) == 0 ? index1 : index2);
                }
                continue;
            }
            for (int p = 0; p < b1; ++p) {
                dstOffset = this.setRGBFromPalette(image, dstOffset, b2);
            }
        }
    }

    private int setRGBFromPalette(byte[] image, int dstOffset, int index) {
        image[dstOffset++] = this.bgra_palette[(index *= 4) + 2];
        image[dstOffset++] = this.bgra_palette[index + 1];
        image[dstOffset++] = this.bgra_palette[index];
        return dstOffset;
    }

    private void readPackedBits(byte[] image, int rowLength, int hght) throws IOException {
        int pixPerByte = 8 / this.bih.biBitCount;
        int bytesPerLine = (this.bih.biWidth + pixPerByte - 1) / pixPerByte;
        int srcStride = bytesPerLine + 3 & 0xFFFFFFFC;
        int bitMask = (1 << this.bih.biBitCount) - 1;
        byte[] lineBuf = new byte[srcStride];
        for (int i = 0; i != hght; ++i) {
            ImageTools.readFully(this.data.in, lineBuf);
            int line = this.bih.biHeight < 0 ? i : hght - i - 1;
            int dstOffset = line * rowLength;
            for (int x = 0; x != this.bih.biWidth; ++x) {
                int bitnum = x * this.bih.biBitCount;
                byte element = lineBuf[bitnum / 8];
                int shift = 8 - (bitnum & 7) - this.bih.biBitCount;
                int index = element >> shift & bitMask;
                dstOffset = this.setRGBFromPalette(image, dstOffset, index);
            }
        }
    }

    private static int getDWord(byte[] buf, int pos) {
        return buf[pos] & 0xFF | (buf[pos + 1] & 0xFF) << 8 | (buf[pos + 2] & 0xFF) << 16 | (buf[pos + 3] & 0xFF) << 24;
    }

    private static int getWord(byte[] buf, int pos) {
        return buf[pos] & 0xFF | (buf[pos + 1] & 0xFF) << 8;
    }

    private static int getByte(byte[] buf, int pos) {
        return buf[pos] & 0xFF;
    }

    private static byte convertFrom5To8Bit(int i, int mask, int offset) {
        int b = (i & mask) >>> offset;
        return (byte)(b << 3 | b >> 2);
    }

    private static byte convertFromXTo8Bit(int i, int mask, int offset) {
        int b = (i & mask) >>> offset;
        return (byte)((double)b * 255.0 / (double)(mask >>> offset));
    }

    private void read16Bit(byte[] image, int rowLength, int hght, BitConverter converter) throws IOException {
        int bytesPerLine = this.bih.biWidth * 2;
        int srcStride = bytesPerLine + 3 & 0xFFFFFFFC;
        byte[] lineBuf = new byte[srcStride];
        for (int i = 0; i != hght; ++i) {
            ImageTools.readFully(this.data.in, lineBuf);
            int line = this.bih.biHeight < 0 ? i : hght - i - 1;
            int dstOffset = line * rowLength;
            for (int x = 0; x != this.bih.biWidth; ++x) {
                int element = BMPImageLoader.getWord(lineBuf, x * 2);
                for (int j = 0; j < 3; ++j) {
                    image[dstOffset++] = converter.convert(element, this.bitMasks[j], this.bitOffsets[j]);
                }
            }
        }
    }

    private void read32BitRGB(byte[] image, int rowLength, int hght) throws IOException {
        int bytesPerLine = this.bih.biWidth * 4;
        byte[] lineBuf = new byte[bytesPerLine];
        for (int i = 0; i != hght; ++i) {
            ImageTools.readFully(this.data.in, lineBuf);
            int line = this.bih.biHeight < 0 ? i : hght - i - 1;
            int dstOff = line * rowLength;
            for (int x = 0; x != this.bih.biWidth; ++x) {
                int srcOff = x * 4;
                image[dstOff++] = lineBuf[srcOff + 2];
                image[dstOff++] = lineBuf[srcOff + 1];
                image[dstOff++] = lineBuf[srcOff];
            }
        }
    }

    private void read32BitBF(byte[] image, int rowLength, int hght) throws IOException {
        int bytesPerLine = this.bih.biWidth * 4;
        byte[] lineBuf = new byte[bytesPerLine];
        for (int i = 0; i != hght; ++i) {
            ImageTools.readFully(this.data.in, lineBuf);
            int line = this.bih.biHeight < 0 ? i : hght - i - 1;
            int dstOff = line * rowLength;
            for (int x = 0; x != this.bih.biWidth; ++x) {
                int srcOff = x * 4;
                int element = BMPImageLoader.getDWord(lineBuf, srcOff);
                for (int j = 0; j < 3; ++j) {
                    image[dstOff++] = BMPImageLoader.convertFromXTo8Bit(element, this.bitMasks[j], this.bitOffsets[j]);
                }
            }
        }
    }

    private void read24Bit(byte[] image, int rowLength, int hght) throws IOException {
        int bmpStride = rowLength + 3 & 0xFFFFFFFC;
        int padding = bmpStride - rowLength;
        for (int i = 0; i != hght; ++i) {
            int line = this.bih.biHeight < 0 ? i : hght - i - 1;
            int lineOffset = line * rowLength;
            ImageTools.readFully(this.data.in, image, lineOffset, rowLength);
            this.data.skipBytes(padding);
            BMPImageLoader.BGRtoRGB(image, lineOffset, rowLength);
        }
    }

    static void BGRtoRGB(byte[] data, int pos, int size) {
        for (int sz = size / 3; sz != 0; --sz) {
            byte b = data[pos];
            byte r = data[pos + 2];
            data[pos + 2] = b;
            data[pos] = r;
            pos += 3;
        }
    }

    @Override
    public ImageFrame load(int imageIndex, int width, int height, boolean preserveAspectRatio, boolean smooth) throws IOException {
        if (0 != imageIndex) {
            return null;
        }
        int hght = Math.abs(this.bih.biHeight);
        if (width > 0 && width != this.bih.biWidth || height > 0 && height != hght) {
            throw new IOException("scaling for BMP is not supported");
        }
        ImageMetadata imageMetadata = new ImageMetadata(null, Boolean.TRUE, null, null, null, null, null, this.bih.biWidth, hght, null, null, null);
        this.updateImageMetadata(imageMetadata);
        int stride = this.bih.biWidth * 3;
        byte[] image = new byte[stride * hght];
        switch (this.bih.biBitCount) {
            case 1: {
                this.readPackedBits(image, stride, hght);
                break;
            }
            case 4: {
                if (this.bih.biCompression == 2) {
                    this.readRLE(image, stride, hght, true);
                    break;
                }
                this.readPackedBits(image, stride, hght);
                break;
            }
            case 8: {
                if (this.bih.biCompression == 1) {
                    this.readRLE(image, stride, hght, false);
                    break;
                }
                this.readPackedBits(image, stride, hght);
                break;
            }
            case 16: {
                if (this.bih.biCompression == 3) {
                    this.read16Bit(image, stride, hght, BMPImageLoader$$Lambda$1.lambdaFactory$());
                    break;
                }
                this.read16Bit(image, stride, hght, BMPImageLoader$$Lambda$2.lambdaFactory$());
                break;
            }
            case 32: {
                if (this.bih.biCompression == 3) {
                    this.read32BitBF(image, stride, hght);
                    break;
                }
                this.read32BitRGB(image, stride, hght);
                break;
            }
            case 24: {
                this.read24Bit(image, stride, hght);
                break;
            }
            default: {
                throw new IOException("Unknown BMP bit depth");
            }
        }
        return new ImageFrame(ImageStorage.ImageType.RGB, ByteBuffer.wrap(image), this.bih.biWidth, hght, stride, null, null);
    }

    @FunctionalInterface
    private static interface BitConverter {
        public byte convert(int var1, int var2, int var3);
    }
}

