/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.SizeLimitedList;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TableCellBehaviorBase;
import com.sun.javafx.scene.control.behavior.TableViewBehaviorBase$$Lambda$1;
import com.sun.javafx.scene.control.behavior.TableViewBehaviorBase$$Lambda$2;
import com.sun.javafx.scene.control.behavior.TableViewBehaviorBase$$Lambda$3;
import com.sun.javafx.scene.control.behavior.TableViewBehaviorBase$$Lambda$4;
import com.sun.javafx.scene.control.behavior.TableViewBehaviorBase$$Lambda$5;
import com.sun.javafx.scene.control.behavior.TreeTableCellBehavior;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public abstract class TableViewBehaviorBase<C extends Control, T, TC extends TableColumnBase<T, ?>>
extends BehaviorBase<C> {
    protected static final List<KeyBinding> TABLE_VIEW_BINDINGS = new ArrayList<KeyBinding>();
    protected boolean isShortcutDown = false;
    protected boolean isShiftDown = false;
    private boolean selectionPathDeviated = false;
    protected boolean selectionChanging = false;
    private final SizeLimitedList<TablePositionBase> selectionHistory = new SizeLimitedList(10);
    protected final ListChangeListener<TablePositionBase> selectedCellsListener = TableViewBehaviorBase$$Lambda$1.lambdaFactory$(this);
    protected final WeakListChangeListener<TablePositionBase> weakSelectedCellsListener = new WeakListChangeListener<TablePositionBase>(this.selectedCellsListener);
    private Callback<Boolean, Integer> onScrollPageUp;
    private Callback<Boolean, Integer> onScrollPageDown;
    private Runnable onFocusPreviousRow;
    private Runnable onFocusNextRow;
    private Runnable onSelectPreviousRow;
    private Runnable onSelectNextRow;
    private Runnable onMoveToFirstCell;
    private Runnable onMoveToLastCell;
    private Runnable onSelectRightCell;
    private Runnable onSelectLeftCell;

    @Override
    protected void callAction(String name) {
        boolean rtl;
        boolean bl = rtl = ((Node)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
        if ("SelectPreviousRow".equals(name)) {
            this.selectPreviousRow();
        } else if ("SelectNextRow".equals(name)) {
            this.selectNextRow();
        } else if ("SelectLeftCell".equals(name)) {
            if (rtl) {
                this.selectRightCell();
            } else {
                this.selectLeftCell();
            }
        } else if ("SelectRightCell".equals(name)) {
            if (rtl) {
                this.selectLeftCell();
            } else {
                this.selectRightCell();
            }
        } else if ("SelectFirstRow".equals(name)) {
            this.selectFirstRow();
        } else if ("SelectLastRow".equals(name)) {
            this.selectLastRow();
        } else if ("SelectAll".equals(name)) {
            this.selectAll();
        } else if ("SelectAllPageUp".equals(name)) {
            this.selectAllPageUp();
        } else if ("SelectAllPageDown".equals(name)) {
            this.selectAllPageDown();
        } else if ("SelectAllToFirstRow".equals(name)) {
            this.selectAllToFirstRow();
        } else if ("SelectAllToLastRow".equals(name)) {
            this.selectAllToLastRow();
        } else if ("AlsoSelectNext".equals(name)) {
            this.alsoSelectNext();
        } else if ("AlsoSelectPrevious".equals(name)) {
            this.alsoSelectPrevious();
        } else if ("AlsoSelectLeftCell".equals(name)) {
            if (rtl) {
                this.alsoSelectRightCell();
            } else {
                this.alsoSelectLeftCell();
            }
        } else if ("AlsoSelectRightCell".equals(name)) {
            if (rtl) {
                this.alsoSelectLeftCell();
            } else {
                this.alsoSelectRightCell();
            }
        } else if ("ClearSelection".equals(name)) {
            this.clearSelection();
        } else if ("ScrollUp".equals(name)) {
            this.scrollUp();
        } else if ("ScrollDown".equals(name)) {
            this.scrollDown();
        } else if ("FocusPreviousRow".equals(name)) {
            this.focusPreviousRow();
        } else if ("FocusNextRow".equals(name)) {
            this.focusNextRow();
        } else if ("FocusLeftCell".equals(name)) {
            if (rtl) {
                this.focusRightCell();
            } else {
                this.focusLeftCell();
            }
        } else if ("FocusRightCell".equals(name)) {
            if (rtl) {
                this.focusLeftCell();
            } else {
                this.focusRightCell();
            }
        } else if ("Activate".equals(name)) {
            this.activate();
        } else if ("CancelEdit".equals(name)) {
            this.cancelEdit();
        } else if ("FocusFirstRow".equals(name)) {
            this.focusFirstRow();
        } else if ("FocusLastRow".equals(name)) {
            this.focusLastRow();
        } else if ("toggleFocusOwnerSelection".equals(name)) {
            this.toggleFocusOwnerSelection();
        } else if ("SelectAllToFocus".equals(name)) {
            this.selectAllToFocus(false);
        } else if ("SelectAllToFocusAndSetAnchor".equals(name)) {
            this.selectAllToFocus(true);
        } else if ("FocusPageUp".equals(name)) {
            this.focusPageUp();
        } else if ("FocusPageDown".equals(name)) {
            this.focusPageDown();
        } else if ("DiscontinuousSelectNextRow".equals(name)) {
            this.discontinuousSelectNextRow();
        } else if ("DiscontinuousSelectPreviousRow".equals(name)) {
            this.discontinuousSelectPreviousRow();
        } else if ("DiscontinuousSelectNextColumn".equals(name)) {
            if (rtl) {
                this.discontinuousSelectPreviousColumn();
            } else {
                this.discontinuousSelectNextColumn();
            }
        } else if ("DiscontinuousSelectPreviousColumn".equals(name)) {
            if (rtl) {
                this.discontinuousSelectNextColumn();
            } else {
                this.discontinuousSelectPreviousColumn();
            }
        } else if ("DiscontinuousSelectPageUp".equals(name)) {
            this.discontinuousSelectPageUp();
        } else if ("DiscontinuousSelectPageDown".equals(name)) {
            this.discontinuousSelectPageDown();
        } else if ("DiscontinuousSelectAllToLastRow".equals(name)) {
            this.discontinuousSelectAllToLastRow();
        } else if ("DiscontinuousSelectAllToFirstRow".equals(name)) {
            this.discontinuousSelectAllToFirstRow();
        } else {
            super.callAction(name);
        }
    }

    @Override
    protected void callActionForEvent(KeyEvent e) {
        this.isShiftDown = e.getEventType() == KeyEvent.KEY_PRESSED && e.isShiftDown();
        this.isShortcutDown = e.getEventType() == KeyEvent.KEY_PRESSED && e.isShortcutDown();
        super.callActionForEvent(e);
    }

    public TableViewBehaviorBase(C control) {
        this(control, null);
    }

    public TableViewBehaviorBase(C control, List<KeyBinding> bindings) {
        super(control, bindings == null ? TABLE_VIEW_BINDINGS : bindings);
    }

    protected void setAnchor(TablePositionBase tp) {
        TableCellBehaviorBase.setAnchor(this.getControl(), tp, false);
        this.setSelectionPathDeviated(false);
    }

    protected TablePositionBase getAnchor() {
        return TableCellBehaviorBase.getAnchor(this.getControl(), this.getFocusedCell());
    }

    protected boolean hasAnchor() {
        return TableCellBehaviorBase.hasNonDefaultAnchor(this.getControl());
    }

    protected abstract int getItemCount();

    protected abstract TableFocusModel getFocusModel();

    protected abstract TableSelectionModel<T> getSelectionModel();

    protected abstract ObservableList<? extends TablePositionBase> getSelectedCells();

    protected abstract TablePositionBase getFocusedCell();

    protected abstract int getVisibleLeafIndex(TableColumnBase var1);

    protected abstract TableColumnBase getVisibleLeafColumn(int var1);

    protected abstract void editCell(int var1, TableColumnBase var2);

    protected abstract ObservableList<? extends TableColumnBase> getVisibleLeafColumns();

    protected abstract TablePositionBase<TC> getTablePosition(int var1, TableColumnBase<T, ?> var2);

    protected void setAnchor(int row, TableColumnBase col) {
        this.setAnchor(row == -1 && col == null ? null : this.getTablePosition(row, col));
    }

    public void setOnScrollPageUp(Callback<Boolean, Integer> c) {
        this.onScrollPageUp = c;
    }

    public void setOnScrollPageDown(Callback<Boolean, Integer> c) {
        this.onScrollPageDown = c;
    }

    public void setOnFocusPreviousRow(Runnable r) {
        this.onFocusPreviousRow = r;
    }

    public void setOnFocusNextRow(Runnable r) {
        this.onFocusNextRow = r;
    }

    public void setOnSelectPreviousRow(Runnable r) {
        this.onSelectPreviousRow = r;
    }

    public void setOnSelectNextRow(Runnable r) {
        this.onSelectNextRow = r;
    }

    public void setOnMoveToFirstCell(Runnable r) {
        this.onMoveToFirstCell = r;
    }

    public void setOnMoveToLastCell(Runnable r) {
        this.onMoveToLastCell = r;
    }

    public void setOnSelectRightCell(Runnable r) {
        this.onSelectRightCell = r;
    }

    public void setOnSelectLeftCell(Runnable r) {
        this.onSelectLeftCell = r;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (!((Node)this.getControl()).isFocused() && ((Node)this.getControl()).isFocusTraversable()) {
            ((Node)this.getControl()).requestFocus();
        }
    }

    protected boolean isRTL() {
        return ((Node)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
    }

    private void setSelectionPathDeviated(boolean selectionPathDeviated) {
        this.selectionPathDeviated = selectionPathDeviated;
    }

    protected void scrollUp() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null || this.getSelectedCells().isEmpty()) {
            return;
        }
        TablePositionBase selectedCell = (TablePositionBase)this.getSelectedCells().get(0);
        int newSelectedIndex = -1;
        if (this.onScrollPageUp != null) {
            newSelectedIndex = this.onScrollPageUp.call(false);
        }
        if (newSelectedIndex == -1) {
            return;
        }
        sm.clearAndSelect(newSelectedIndex, (TableColumnBase<T, ?>)selectedCell.getTableColumn());
    }

    protected void scrollDown() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null || this.getSelectedCells().isEmpty()) {
            return;
        }
        TablePositionBase selectedCell = (TablePositionBase)this.getSelectedCells().get(0);
        int newSelectedIndex = -1;
        if (this.onScrollPageDown != null) {
            newSelectedIndex = this.onScrollPageDown.call(false);
        }
        if (newSelectedIndex == -1) {
            return;
        }
        sm.clearAndSelect(newSelectedIndex, (TableColumnBase<T, ?>)selectedCell.getTableColumn());
    }

    protected void focusFirstRow() {
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        Object tc = this.getFocusedCell() == null ? null : (Object)this.getFocusedCell().getTableColumn();
        fm.focus(0, tc);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    protected void focusLastRow() {
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        Object tc = this.getFocusedCell() == null ? null : (Object)this.getFocusedCell().getTableColumn();
        fm.focus(this.getItemCount() - 1, tc);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    protected void focusPreviousRow() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        if (sm.isCellSelectionEnabled()) {
            fm.focusAboveCell();
        } else {
            fm.focusPrevious();
        }
        if (!this.isShortcutDown || this.getAnchor() == null) {
            this.setAnchor(fm.getFocusedIndex(), null);
        }
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    protected void focusNextRow() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        if (sm.isCellSelectionEnabled()) {
            fm.focusBelowCell();
        } else {
            fm.focusNext();
        }
        if (!this.isShortcutDown || this.getAnchor() == null) {
            this.setAnchor(fm.getFocusedIndex(), null);
        }
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    protected void focusLeftCell() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        fm.focusLeftCell();
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    protected void focusRightCell() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        fm.focusRightCell();
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    protected void focusPageUp() {
        int newFocusIndex = this.onScrollPageUp.call(true);
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        Object tc = this.getFocusedCell() == null ? null : (Object)this.getFocusedCell().getTableColumn();
        fm.focus(newFocusIndex, tc);
    }

    protected void focusPageDown() {
        int newFocusIndex = this.onScrollPageDown.call(true);
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        Object tc = this.getFocusedCell() == null ? null : (Object)this.getFocusedCell().getTableColumn();
        fm.focus(newFocusIndex, tc);
    }

    protected void clearSelection() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        sm.clearSelection();
    }

    protected void clearSelectionOutsideRange(int start, int end, TableColumnBase<T, ?> column) {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        ArrayList indices = new ArrayList(sm.getSelectedIndices());
        this.selectionChanging = true;
        for (int i = 0; i < indices.size(); ++i) {
            int index = (Integer)indices.get(i);
            if (index >= min && index <= max) continue;
            sm.clearSelection(index, column);
        }
        this.selectionChanging = false;
    }

    protected void alsoSelectPrevious() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        if (sm.getSelectionMode() == SelectionMode.SINGLE) {
            this.selectPreviousRow();
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        if (sm.isCellSelectionEnabled()) {
            this.updateCellVerticalSelection(-1, TableViewBehaviorBase$$Lambda$2.lambdaFactory$(this));
        } else if (this.isShiftDown && this.hasAnchor()) {
            this.updateRowSelection(-1);
        } else {
            sm.selectPrevious();
        }
        this.onSelectPreviousRow.run();
    }

    protected void alsoSelectNext() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        if (sm.getSelectionMode() == SelectionMode.SINGLE) {
            this.selectNextRow();
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        if (sm.isCellSelectionEnabled()) {
            this.updateCellVerticalSelection(1, TableViewBehaviorBase$$Lambda$3.lambdaFactory$(this));
        } else if (this.isShiftDown && this.hasAnchor()) {
            this.updateRowSelection(1);
        } else {
            sm.selectNext();
        }
        this.onSelectNextRow.run();
    }

    protected void alsoSelectLeftCell() {
        this.updateCellHorizontalSelection(-1, TableViewBehaviorBase$$Lambda$4.lambdaFactory$(this));
        this.onSelectLeftCell.run();
    }

    protected void alsoSelectRightCell() {
        this.updateCellHorizontalSelection(1, TableViewBehaviorBase$$Lambda$5.lambdaFactory$(this));
        this.onSelectRightCell.run();
    }

    protected void updateRowSelection(int delta) {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null || sm.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int newRow = fm.getFocusedIndex() + delta;
        TablePositionBase anchor = this.getAnchor();
        if (!this.hasAnchor()) {
            this.setAnchor(this.getFocusedCell());
        }
        if (sm.getSelectedIndices().size() > 1) {
            this.clearSelectionOutsideRange(anchor.getRow(), newRow, null);
        }
        if (anchor.getRow() > newRow) {
            sm.selectRange(anchor.getRow(), newRow - 1);
        } else {
            sm.selectRange(anchor.getRow(), newRow + 1);
        }
    }

    protected void updateCellVerticalSelection(int delta, Runnable defaultAction) {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null || sm.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        int focusedCellRow = focusedCell.getRow();
        if (this.isShiftDown && sm.isSelected(focusedCellRow + delta, (TableColumnBase<T, ?>)focusedCell.getTableColumn())) {
            int newFocusOwner = focusedCellRow + delta;
            boolean backtracking = false;
            if (this.selectionHistory.size() >= 2) {
                TablePositionBase secondToLastSelectedCell = this.selectionHistory.get(1);
                boolean bl = backtracking = secondToLastSelectedCell.getRow() == newFocusOwner && secondToLastSelectedCell.getColumn() == focusedCell.getColumn();
            }
            int cellRowToClear = this.selectionPathDeviated ? (backtracking ? focusedCellRow : newFocusOwner) : focusedCellRow;
            sm.clearSelection(cellRowToClear, (TableColumnBase<T, ?>)focusedCell.getTableColumn());
            fm.focus(newFocusOwner, focusedCell.getTableColumn());
        } else if (this.isShiftDown && this.getAnchor() != null && !this.selectionPathDeviated) {
            int newRow = fm.getFocusedIndex() + delta;
            newRow = Math.max(Math.min(this.getItemCount() - 1, newRow), 0);
            int start = Math.min(this.getAnchor().getRow(), newRow);
            int end = Math.max(this.getAnchor().getRow(), newRow);
            if (sm.getSelectedIndices().size() > 1) {
                this.clearSelectionOutsideRange(start, end, (TableColumnBase<T, ?>)focusedCell.getTableColumn());
            }
            for (int _row = start; _row <= end; ++_row) {
                if (sm.isSelected(_row, (TableColumnBase<T, ?>)focusedCell.getTableColumn())) continue;
                sm.select(_row, (TableColumnBase<T, ?>)focusedCell.getTableColumn());
            }
            fm.focus(newRow, focusedCell.getTableColumn());
        } else {
            int focusIndex = fm.getFocusedIndex();
            if (!sm.isSelected(focusIndex, (TableColumnBase<T, ?>)focusedCell.getTableColumn())) {
                sm.select(focusIndex, (TableColumnBase<T, ?>)focusedCell.getTableColumn());
            }
            defaultAction.run();
        }
    }

    protected void updateCellHorizontalSelection(int delta, Runnable defaultAction) {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null || sm.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        if (focusedCell == null || focusedCell.getTableColumn() == null) {
            return;
        }
        boolean atEnd = false;
        TableColumnBase adjacentColumn = this.getColumn((TableColumnBase)focusedCell.getTableColumn(), delta);
        if (adjacentColumn == null) {
            adjacentColumn = focusedCell.getTableColumn();
            atEnd = true;
        }
        int focusedCellRow = focusedCell.getRow();
        if (this.isShiftDown && sm.isSelected(focusedCellRow, adjacentColumn)) {
            if (atEnd) {
                return;
            }
            boolean backtracking = false;
            ObservableList<TablePositionBase> selectedCells = this.getSelectedCells();
            if (selectedCells.size() >= 2) {
                TablePositionBase secondToLastSelectedCell = (TablePositionBase)selectedCells.get(selectedCells.size() - 2);
                boolean bl = backtracking = secondToLastSelectedCell.getRow() == focusedCellRow && secondToLastSelectedCell.getTableColumn().equals(adjacentColumn);
            }
            Object cellColumnToClear = this.selectionPathDeviated ? (backtracking ? focusedCell.getTableColumn() : adjacentColumn) : focusedCell.getTableColumn();
            sm.clearSelection(focusedCellRow, (TableColumnBase<T, ?>)cellColumnToClear);
            fm.focus(focusedCellRow, adjacentColumn);
        } else if (this.isShiftDown && this.getAnchor() != null && !this.selectionPathDeviated) {
            int anchorColumn = this.getAnchor().getColumn();
            int newColumn = this.getVisibleLeafIndex((TableColumnBase)focusedCell.getTableColumn()) + delta;
            newColumn = Math.max(Math.min(this.getVisibleLeafColumns().size() - 1, newColumn), 0);
            int start = Math.min(anchorColumn, newColumn);
            int end = Math.max(anchorColumn, newColumn);
            for (int _col = start; _col <= end; ++_col) {
                sm.select(focusedCell.getRow(), this.getColumn(_col));
            }
            fm.focus(focusedCell.getRow(), this.getColumn(newColumn));
        } else {
            defaultAction.run();
        }
    }

    protected TableColumnBase getColumn(int index) {
        return this.getVisibleLeafColumn(index);
    }

    protected TableColumnBase getColumn(TableColumnBase tc, int delta) {
        return this.getVisibleLeafColumn(this.getVisibleLeafIndex(tc) + delta);
    }

    protected void selectFirstRow() {
        TableSelectionModel sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        ObservableList<TablePositionBase> selection = this.getSelectedCells();
        TableColumnBase<?, ?> selectedColumn = selection.size() == 0 ? null : (TableColumnBase<?, ?>)((TablePositionBase)selection.get(0)).getTableColumn();
        sm.clearAndSelect(0, selectedColumn);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    protected void selectLastRow() {
        TableSelectionModel sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        ObservableList<TablePositionBase> selection = this.getSelectedCells();
        TableColumnBase<?, ?> selectedColumn = selection.size() == 0 ? null : (TableColumnBase<?, ?>)((TablePositionBase)selection.get(0)).getTableColumn();
        sm.clearAndSelect(this.getItemCount() - 1, selectedColumn);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    protected void selectPreviousRow() {
        this.selectCell(-1, 0);
        if (this.onSelectPreviousRow != null) {
            this.onSelectPreviousRow.run();
        }
    }

    protected void selectNextRow() {
        this.selectCell(1, 0);
        if (this.onSelectNextRow != null) {
            this.onSelectNextRow.run();
        }
    }

    protected void selectLeftCell() {
        this.selectCell(0, -1);
        if (this.onSelectLeftCell != null) {
            this.onSelectLeftCell.run();
        }
    }

    protected void selectRightCell() {
        this.selectCell(0, 1);
        if (this.onSelectRightCell != null) {
            this.onSelectRightCell.run();
        }
    }

    protected void selectCell(int rowDiff, int columnDiff) {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        int currentRow = focusedCell.getRow();
        int currentColumn = this.getVisibleLeafIndex((TableColumnBase)focusedCell.getTableColumn());
        if (rowDiff < 0 && currentRow <= 0) {
            return;
        }
        if (rowDiff > 0 && currentRow >= this.getItemCount() - 1) {
            return;
        }
        if (columnDiff < 0 && currentColumn <= 0) {
            return;
        }
        if (columnDiff > 0 && currentColumn >= this.getVisibleLeafColumns().size() - 1) {
            return;
        }
        if (columnDiff > 0 && currentColumn == -1) {
            return;
        }
        Object tc = focusedCell.getTableColumn();
        tc = this.getColumn((TableColumnBase)tc, columnDiff);
        int row = focusedCell.getRow() + rowDiff;
        sm.clearAndSelect(row, (TableColumnBase<T, ?>)tc);
        this.setAnchor(row, (TableColumnBase)tc);
    }

    protected void cancelEdit() {
        this.editCell(-1, null);
    }

    protected void activate() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase cell = this.getFocusedCell();
        sm.select(cell.getRow(), (TableColumnBase<T, ?>)cell.getTableColumn());
        this.setAnchor(cell);
        if (cell.getRow() >= 0) {
            this.editCell(cell.getRow(), (TableColumnBase)cell.getTableColumn());
        }
    }

    protected void selectAllToFocus(boolean setAnchorToFocusIndex) {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        int focusRow = focusedCell.getRow();
        TablePositionBase anchor = this.getAnchor();
        int anchorRow = anchor.getRow();
        sm.clearSelection();
        if (!sm.isCellSelectionEnabled()) {
            int startPos = anchorRow;
            int endPos = anchorRow > focusRow ? focusRow - 1 : focusRow + 1;
            sm.selectRange(startPos, endPos);
        } else {
            sm.selectRange(anchor.getRow(), (TableColumnBase<T, ?>)anchor.getTableColumn(), focusedCell.getRow(), (TableColumnBase<T, ?>)focusedCell.getTableColumn());
        }
        this.setAnchor(setAnchorToFocusIndex ? focusedCell : anchor);
    }

    protected void selectAll() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        sm.selectAll();
    }

    protected void selectAllToFirstRow() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        boolean isSingleSelection = sm.getSelectionMode() == SelectionMode.SINGLE;
        TablePositionBase focusedCell = this.getFocusedCell();
        Object column = this.getFocusedCell().getTableColumn();
        int leadIndex = focusedCell.getRow();
        if (this.isShiftDown) {
            leadIndex = this.getAnchor() == null ? leadIndex : this.getAnchor().getRow();
        }
        sm.clearSelection();
        if (!sm.isCellSelectionEnabled()) {
            if (isSingleSelection) {
                sm.select(0);
            } else {
                sm.selectRange(leadIndex, -1);
            }
            fm.focus(0);
        } else {
            if (isSingleSelection) {
                sm.select(0, (TableColumnBase<T, ?>)column);
            } else {
                sm.selectRange(leadIndex, (TableColumnBase<T, ?>)column, -1, (TableColumnBase<T, ?>)column);
            }
            fm.focus(0, column);
        }
        if (this.isShiftDown) {
            this.setAnchor(leadIndex, (TableColumnBase)column);
        }
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    protected void selectAllToLastRow() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int itemCount = this.getItemCount();
        TablePositionBase focusedCell = this.getFocusedCell();
        Object column = this.getFocusedCell().getTableColumn();
        int leadIndex = focusedCell.getRow();
        if (this.isShiftDown) {
            leadIndex = this.getAnchor() == null ? leadIndex : this.getAnchor().getRow();
        }
        sm.clearSelection();
        if (!sm.isCellSelectionEnabled()) {
            sm.selectRange(leadIndex, itemCount);
        } else {
            sm.selectRange(leadIndex, (TableColumnBase<T, ?>)column, itemCount - 1, (TableColumnBase<T, ?>)column);
        }
        if (this.isShiftDown) {
            this.setAnchor(leadIndex, (TableColumnBase)column);
        }
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    protected void selectAllPageUp() {
        TableColumnBase col;
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int leadIndex = fm.getFocusedIndex();
        TableColumnBase tableColumnBase = col = sm.isCellSelectionEnabled() ? (TableColumnBase)this.getFocusedCell().getTableColumn() : null;
        if (this.isShiftDown) {
            leadIndex = this.getAnchor() == null ? leadIndex : this.getAnchor().getRow();
            this.setAnchor(leadIndex, col);
        }
        int leadSelectedIndex = this.onScrollPageUp.call(false);
        this.selectionChanging = true;
        if (sm.getSelectionMode() == null || sm.getSelectionMode() == SelectionMode.SINGLE) {
            if (sm.isCellSelectionEnabled()) {
                sm.select(leadSelectedIndex, col);
            } else {
                sm.select(leadSelectedIndex);
            }
        } else {
            sm.clearSelection();
            if (sm.isCellSelectionEnabled()) {
                sm.selectRange(leadIndex, col, leadSelectedIndex, col);
            } else {
                int adjust = leadIndex < leadSelectedIndex ? 1 : -1;
                sm.selectRange(leadIndex, leadSelectedIndex + adjust);
            }
        }
        this.selectionChanging = false;
    }

    protected void selectAllPageDown() {
        TableColumnBase col;
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int leadIndex = fm.getFocusedIndex();
        TableColumnBase tableColumnBase = col = sm.isCellSelectionEnabled() ? (TableColumnBase)this.getFocusedCell().getTableColumn() : null;
        if (this.isShiftDown) {
            leadIndex = this.getAnchor() == null ? leadIndex : this.getAnchor().getRow();
            this.setAnchor(leadIndex, col);
        }
        int leadSelectedIndex = this.onScrollPageDown.call(false);
        this.selectionChanging = true;
        if (sm.getSelectionMode() == null || sm.getSelectionMode() == SelectionMode.SINGLE) {
            if (sm.isCellSelectionEnabled()) {
                sm.select(leadSelectedIndex, col);
            } else {
                sm.select(leadSelectedIndex);
            }
        } else {
            sm.clearSelection();
            if (sm.isCellSelectionEnabled()) {
                sm.selectRange(leadIndex, col, leadSelectedIndex, col);
            } else {
                int adjust = leadIndex < leadSelectedIndex ? 1 : -1;
                sm.selectRange(leadIndex, leadSelectedIndex + adjust);
            }
        }
        this.selectionChanging = false;
    }

    protected void toggleFocusOwnerSelection() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        if (sm.isSelected(focusedCell.getRow(), (TableColumnBase<T, ?>)focusedCell.getTableColumn())) {
            sm.clearSelection(focusedCell.getRow(), (TableColumnBase<T, ?>)focusedCell.getTableColumn());
            fm.focus(focusedCell.getRow(), focusedCell.getTableColumn());
        } else {
            sm.select(focusedCell.getRow(), (TableColumnBase<T, ?>)focusedCell.getTableColumn());
        }
        this.setAnchor(focusedCell.getRow(), (TableColumnBase)focusedCell.getTableColumn());
    }

    protected void discontinuousSelectPreviousRow() {
        TableColumnBase<?, ?> col;
        TableSelectionModel sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        if (sm.getSelectionMode() != SelectionMode.MULTIPLE) {
            this.selectPreviousRow();
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int focusIndex = fm.getFocusedIndex();
        int newFocusIndex = focusIndex - 1;
        if (newFocusIndex < 0) {
            return;
        }
        int startIndex = focusIndex;
        TableColumnBase<?, ?> tableColumnBase = col = sm.isCellSelectionEnabled() ? (TableColumnBase<?, ?>)this.getFocusedCell().getTableColumn() : null;
        if (this.isShiftDown) {
            int n = startIndex = this.getAnchor() == null ? focusIndex : this.getAnchor().getRow();
        }
        if (!sm.isCellSelectionEnabled()) {
            sm.selectRange(newFocusIndex, startIndex + 1);
            fm.focus(newFocusIndex);
        } else {
            for (int i = newFocusIndex; i < startIndex + 1; ++i) {
                sm.select(i, col);
            }
            fm.focus(newFocusIndex, col);
        }
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    protected void discontinuousSelectNextRow() {
        TableColumnBase<?, ?> col;
        TableSelectionModel sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        if (sm.getSelectionMode() != SelectionMode.MULTIPLE) {
            this.selectNextRow();
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int focusIndex = fm.getFocusedIndex();
        int newFocusIndex = focusIndex + 1;
        if (newFocusIndex >= this.getItemCount()) {
            return;
        }
        int startIndex = focusIndex;
        TableColumnBase<?, ?> tableColumnBase = col = sm.isCellSelectionEnabled() ? (TableColumnBase<?, ?>)this.getFocusedCell().getTableColumn() : null;
        if (this.isShiftDown) {
            int n = startIndex = this.getAnchor() == null ? focusIndex : this.getAnchor().getRow();
        }
        if (!sm.isCellSelectionEnabled()) {
            sm.selectRange(startIndex, newFocusIndex + 1);
            fm.focus(newFocusIndex);
        } else {
            for (int i = startIndex; i < newFocusIndex + 1; ++i) {
                sm.select(i, col);
            }
            fm.focus(newFocusIndex, col);
        }
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    protected void discontinuousSelectPreviousColumn() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null || !sm.isCellSelectionEnabled()) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TableColumnBase tc = this.getColumn((TableColumnBase)this.getFocusedCell().getTableColumn(), -1);
        sm.select(fm.getFocusedIndex(), tc);
    }

    protected void discontinuousSelectNextColumn() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null || !sm.isCellSelectionEnabled()) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TableColumnBase tc = this.getColumn((TableColumnBase)this.getFocusedCell().getTableColumn(), 1);
        sm.select(fm.getFocusedIndex(), tc);
    }

    protected void discontinuousSelectPageUp() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int anchor = this.hasAnchor() ? this.getAnchor().getRow() : fm.getFocusedIndex();
        int leadSelectedIndex = this.onScrollPageUp.call(false);
        if (!sm.isCellSelectionEnabled()) {
            sm.selectRange(anchor, leadSelectedIndex - 1);
        }
    }

    protected void discontinuousSelectPageDown() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int anchor = this.hasAnchor() ? this.getAnchor().getRow() : fm.getFocusedIndex();
        int leadSelectedIndex = this.onScrollPageDown.call(false);
        if (!sm.isCellSelectionEnabled()) {
            sm.selectRange(anchor, leadSelectedIndex + 1);
        }
    }

    protected void discontinuousSelectAllToFirstRow() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int index = fm.getFocusedIndex();
        if (!sm.isCellSelectionEnabled()) {
            sm.selectRange(0, index);
            fm.focus(0);
        } else {
            for (int i = 0; i < index; ++i) {
                sm.select(i, (TableColumnBase<T, ?>)this.getFocusedCell().getTableColumn());
            }
            fm.focus(0, this.getFocusedCell().getTableColumn());
        }
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    protected void discontinuousSelectAllToLastRow() {
        TableSelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int index = fm.getFocusedIndex() + 1;
        if (!sm.isCellSelectionEnabled()) {
            sm.selectRange(index, this.getItemCount());
        } else {
            for (int i = index; i < this.getItemCount(); ++i) {
                sm.select(i, (TableColumnBase<T, ?>)this.getFocusedCell().getTableColumn());
            }
        }
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    /* synthetic */ void lambda$alsoSelectRightCell$223() {
        this.getSelectionModel().selectRightCell();
    }

    /* synthetic */ void lambda$alsoSelectLeftCell$222() {
        this.getSelectionModel().selectLeftCell();
    }

    /* synthetic */ void lambda$alsoSelectNext$221() {
        this.getSelectionModel().selectBelowCell();
    }

    /* synthetic */ void lambda$alsoSelectPrevious$220() {
        this.getSelectionModel().selectAboveCell();
    }

    /* synthetic */ void lambda$new$219(ListChangeListener.Change c) {
        block0: while (c.next()) {
            if (c.wasReplaced() && TreeTableCellBehavior.hasDefaultAnchor(this.getControl())) {
                TreeTableCellBehavior.removeAnchor(this.getControl());
            }
            if (!c.wasAdded()) continue;
            TableSelectionModel<T> sm = this.getSelectionModel();
            if (sm == null) {
                return;
            }
            TablePositionBase anchor = this.getAnchor();
            boolean cellSelectionEnabled = sm.isCellSelectionEnabled();
            int addedSize = c.getAddedSize();
            List addedSubList = c.getAddedSubList();
            for (TablePositionBase tpb : addedSubList) {
                if (this.selectionHistory.contains(tpb)) continue;
                this.selectionHistory.add(tpb);
            }
            if (addedSize > 0 && !this.hasAnchor()) {
                TablePositionBase tp = (TablePositionBase)addedSubList.get(addedSize - 1);
                this.setAnchor(tp);
            }
            if (anchor == null || !cellSelectionEnabled || this.selectionPathDeviated) continue;
            for (int i = 0; i < addedSize; ++i) {
                TablePositionBase tp = (TablePositionBase)addedSubList.get(i);
                if (anchor.getRow() == -1 || tp.getRow() == anchor.getRow() || tp.getColumn() == anchor.getColumn()) continue;
                this.setSelectionPathDeviated(true);
                continue block0;
            }
        }
    }

    static {
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectFirstRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectLastRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "ScrollUp"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "ScrollDown"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "SelectLeftCell"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "SelectLeftCell"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "SelectRightCell"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "SelectRightCell"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "SelectPreviousRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "SelectPreviousRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "SelectNextRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "SelectNextRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "TraverseLeft"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "TraverseLeft"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "SelectNextRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "SelectNextRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "TraverseUp"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "TraverseUp"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "TraverseDown"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "TraverseDown"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectAllToFirstRow").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectAllToLastRow").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "SelectAllPageUp").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "SelectAllPageDown").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "AlsoSelectPrevious").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "AlsoSelectPrevious").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "AlsoSelectNext").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "AlsoSelectNext").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "SelectAllToFocus").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "SelectAllToFocusAndSetAnchor").shortcut().shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "AlsoSelectLeftCell").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "AlsoSelectLeftCell").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "AlsoSelectRightCell").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "AlsoSelectRightCell").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "FocusPreviousRow").shortcut());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "FocusNextRow").shortcut());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "FocusRightCell").shortcut());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "FocusRightCell").shortcut());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "FocusLeftCell").shortcut());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "FocusLeftCell").shortcut());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").shortcut());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "FocusFirstRow").shortcut());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "FocusLastRow").shortcut());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").shortcut());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").shortcut());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "DiscontinuousSelectPreviousRow").shortcut().shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "DiscontinuousSelectNextRow").shortcut().shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "DiscontinuousSelectPreviousColumn").shortcut().shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "DiscontinuousSelectNextColumn").shortcut().shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "DiscontinuousSelectPageUp").shortcut().shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "DiscontinuousSelectPageDown").shortcut().shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "DiscontinuousSelectAllToFirstRow").shortcut().shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "DiscontinuousSelectAllToLastRow").shortcut().shift());
        if (PlatformUtil.isMac()) {
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl().shortcut());
        } else {
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl());
        }
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ENTER, "Activate"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "Activate"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.F2, "Activate"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, "CancelEdit"));
    }
}

