/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.paint;

import com.sun.javafx.scene.paint.GradientUtils$Parser$$Lambda$1;
import com.sun.javafx.scene.paint.GradientUtils$Parser$$Lambda$2;
import java.util.LinkedList;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;

public class GradientUtils {
    public static String lengthToString(double value, boolean proportional) {
        if (proportional) {
            return value * 100.0 + "%";
        }
        return value + "px";
    }

    public static class Parser {
        private int index;
        private String[] tokens;
        private boolean proportional;
        private boolean proportionalSet = false;

        private String[] splitString(String string, Delimiter delimiter, boolean canRepeat) {
            LinkedList<String> tokenList = new LinkedList<String>();
            StringBuilder token = new StringBuilder();
            char[] input = string.toCharArray();
            block0: for (int i = 0; i < input.length; ++i) {
                char currentChar = input[i];
                if (delimiter.isDelimiter(currentChar)) {
                    if (!canRepeat || token.length() > 0) {
                        tokenList.add(token.toString());
                    }
                    token.setLength(0);
                    continue;
                }
                if (currentChar == '(') {
                    while (i < input.length) {
                        token.append(input[i]);
                        if (input[i] == ')') continue block0;
                        ++i;
                    }
                    continue;
                }
                token.append(input[i]);
            }
            if (!canRepeat || token.length() > 0) {
                tokenList.add(token.toString());
            }
            return tokenList.toArray(new String[tokenList.size()]);
        }

        public Parser(String content) {
            this.tokens = this.splitString(content, GradientUtils$Parser$$Lambda$1.lambdaFactory$(), false);
            this.index = 0;
        }

        public int getSize() {
            return this.tokens.length;
        }

        public void shift() {
            ++this.index;
        }

        public String getCurrentToken() {
            String currentToken = this.tokens[this.index].trim();
            if (currentToken.isEmpty()) {
                throw new IllegalArgumentException("Invalid gradient specification: found empty token.");
            }
            return currentToken;
        }

        public String[] splitCurrentToken() {
            return this.getCurrentToken().split("\\s");
        }

        public static void checkNumberOfArguments(String[] tokens, int count) {
            if (tokens.length < count + 1) {
                throw new IllegalArgumentException("Invalid gradient specification: parameter '" + tokens[0] + "' needs " + count + " argument(s).");
            }
        }

        public static double parseAngle(String value) {
            double angle = 0.0;
            if (value.endsWith("deg")) {
                value = value.substring(0, value.length() - 3);
                angle = Double.parseDouble(value);
            } else if (value.endsWith("grad")) {
                value = value.substring(0, value.length() - 4);
                angle = Double.parseDouble(value);
                angle = angle * 9.0 / 10.0;
            } else if (value.endsWith("rad")) {
                value = value.substring(0, value.length() - 3);
                angle = Double.parseDouble(value);
                angle = angle * 180.0 / Math.PI;
            } else if (value.endsWith("turn")) {
                value = value.substring(0, value.length() - 4);
                angle = Double.parseDouble(value);
                angle *= 360.0;
            } else {
                throw new IllegalArgumentException("Invalid gradient specification:angle must end in deg, rad, grad, or turn");
            }
            return angle;
        }

        public static double parsePercentage(String value) {
            if (!value.endsWith("%")) {
                throw new IllegalArgumentException("Invalid gradient specification: focus-distance must be specified as percentage");
            }
            value = value.substring(0, value.length() - 1);
            double percentage = Double.parseDouble(value) / 100.0;
            return percentage;
        }

        public Point parsePoint(String value) {
            Point p = new Point();
            if (value.endsWith("%")) {
                p.proportional = true;
                value = value.substring(0, value.length() - 1);
            } else if (value.endsWith("px")) {
                value = value.substring(0, value.length() - 2);
            }
            p.value = Double.parseDouble(value);
            if (p.proportional) {
                p.value /= 100.0;
            }
            if (this.proportionalSet && this.proportional != p.proportional) {
                throw new IllegalArgumentException("Invalid gradient specification:cannot mix proportional and non-proportional values");
            }
            this.proportionalSet = true;
            this.proportional = p.proportional;
            return p;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Stop[] parseStops(boolean proportional, double length) {
            int i;
            double offset;
            int stopsCount = this.tokens.length - this.index;
            Color[] colors = new Color[stopsCount];
            double[] offsets = new double[stopsCount];
            Stop[] stops = new Stop[stopsCount];
            for (int i2 = 0; i2 < stopsCount; ++i2) {
                String stopString = this.tokens[i2 + this.index].trim();
                String[] stopTokens = this.splitString(stopString, GradientUtils$Parser$$Lambda$2.lambdaFactory$(), true);
                if (stopTokens.length == 0) {
                    throw new IllegalArgumentException("Invalid gradient specification, empty stop found");
                }
                String currentToken = stopTokens[0];
                offset = -1.0;
                Color c = Color.web(currentToken);
                if (stopTokens.length == 2) {
                    String o = stopTokens[1];
                    if (o.endsWith("%")) {
                        o = o.substring(0, o.length() - 1);
                        offset = Double.parseDouble(o) / 100.0;
                    } else {
                        if (proportional) throw new IllegalArgumentException("Invalid gradient specification, non-proportional stops not permited in proportional gradient: " + o);
                        if (o.endsWith("px")) {
                            o = o.substring(0, o.length() - 2);
                        }
                        offset = Double.parseDouble(o) / length;
                    }
                } else if (stopTokens.length > 2) {
                    throw new IllegalArgumentException("Invalid gradient specification, unexpected content in stop specification: " + stopTokens[2]);
                }
                colors[i2] = c;
                offsets[i2] = offset;
            }
            if (offsets[0] < 0.0) {
                offsets[0] = 0.0;
            }
            if (offsets[offsets.length - 1] < 0.0) {
                offsets[offsets.length - 1] = 1.0;
            }
            double max = offsets[0];
            for (int i3 = 1; i3 < offsets.length; ++i3) {
                if (offsets[i3] < max && offsets[i3] > 0.0) {
                    offsets[i3] = max;
                    continue;
                }
                max = offsets[i3];
            }
            int firstIndex = -1;
            for (i = 1; i < offsets.length; ++i) {
                offset = offsets[i];
                if (offset < 0.0 && firstIndex < 0) {
                    firstIndex = i;
                    continue;
                }
                if (!(offset >= 0.0) || firstIndex <= 0) continue;
                int n = i - firstIndex + 1;
                double part = (offsets[i] - offsets[firstIndex - 1]) / (double)n;
                for (int j = 0; j < n - 1; ++j) {
                    offsets[firstIndex + j] = offsets[firstIndex - 1] + part * (double)(j + 1);
                }
            }
            for (i = 0; i < stops.length; ++i) {
                Stop stop;
                stops[i] = stop = new Stop(offsets[i], colors[i]);
            }
            return stops;
        }

        static /* synthetic */ boolean lambda$parseStops$259(char value) {
            return Character.isWhitespace(value);
        }

        static /* synthetic */ boolean lambda$new$258(char value) {
            return value == ',';
        }

        private static interface Delimiter {
            public boolean isDelimiter(char var1);
        }
    }

    public static class Point {
        public static final Point MIN = new Point(0.0, true);
        public static final Point MAX = new Point(1.0, true);
        public double value;
        public boolean proportional;

        public String toString() {
            return "value = " + this.value + ", proportional = " + this.proportional;
        }

        public Point(double value, boolean proportional) {
            this.value = value;
            this.proportional = proportional;
        }

        public Point() {
        }
    }
}

